/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class FallbackIteratorDataGenerator {
    static CLDRConfig testInfo = ToolConfig.getToolInstance();
    static Map<String, String> specialCanonicalValue = CldrUtility.asMap(new String[][]{{"cel-gaulish", "xcg"}, {"en-GB-oed", "en-GB-x-oed"}, {"i-default", "und"}, {"i-enochian", "x-enochian"}, {"i-mingo", "see"}, {"zh-min", "nan"}});

    public static void main(String[] args) {
        StandardCodes sc = testInfo.getStandardCodes();
        ArrayList<String> decanonicalizeList = new ArrayList<String>();
        System.out.println();
        System.out.println("\t\t\"canonicalize\",\t\t// mechanically generated");
        System.out.println();
        for (String type : sc.getAvailableTypes()) {
            String canonicalizationFormat;
            boolean isLanguage = type.equals("language");
            boolean isLegacy = type.equals("legacy");
            boolean isRegion = type.equals("territory");
            String string = isLegacy ? "\t\t\"%s;%s\"," : (isLanguage ? "\t\t\"%s(-.*)?;%s$1\"," : (canonicalizationFormat = isRegion ? "\t\t\"(.*-)%s(-.*)?;$1%s$2\"," : null));
            if (canonicalizationFormat == null) continue;
            System.out.println("\t\t// " + type);
            for (String code : sc.getAvailableCodes(type)) {
                List<String> data = sc.getFullData(type, code);
                String canonicalValue = data.get(2);
                String special = specialCanonicalValue.get(code);
                if (special != null) {
                    canonicalValue = special;
                }
                if (canonicalValue == null || canonicalValue.length() == 0) {
                    if (!isLegacy) continue;
                    System.out.println("\t\t// Legacy code with no replacement " + code);
                    continue;
                }
                if (canonicalValue.startsWith("deprecated")) {
                    System.out.println("\t\t// skipping " + code + ", deprecated but no replacement");
                    continue;
                }
                System.out.format(canonicalizationFormat, code, canonicalValue);
                if (special != null) {
                    System.out.print("\t\t// Legacy code with special replacement: " + code);
                }
                System.out.println();
                if (isLegacy) continue;
                decanonicalizeList.add(String.format(canonicalizationFormat, canonicalValue, code));
            }
        }
        SupplementalDataInfo supplemental = testInfo.getSupplementalDataInfo();
        for (String lang : supplemental.getLanguagesForTerritoriesPopulationData()) {
            if (!lang.contains("_")) continue;
            System.out.println(lang);
        }
        System.out.println();
        System.out.println("\t\t\"decanonicalize\",\t\t// mechanically generated");
        System.out.println();
        for (String item : decanonicalizeList) {
            System.out.println(item);
        }
    }
}

