/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.ArrayComparator;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class GenerateG2xG2 {
    static CLDRFile english;
    static CLDRFile root;
    static Map<String, String> priorityMap;
    static Map<String, Totals> totalMap;
    static Map<String, List<String>> territory_currency;

    public static void main(String[] args) throws Exception {
        if (GenerateG2xG2.showLocales(-1)) {
            return;
        }
        String sourceLanguage = "G5";
        String targetLanguage = "G5";
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        english = cldrFactory.make("en", true);
        root = cldrFactory.make("root", true);
        StandardCodes sc = StandardCodes.make();
        Map<Organization, Map<String, Level>> type_code_value = sc.getLocaleTypes();
        TreeSet<String> sourceSet = new TreeSet<String>();
        TreeSet<String> targetLanguageSet = new TreeSet<String>();
        targetLanguageSet.add("no");
        GenerateG2xG2.addPriority("G2", "nn");
        GenerateG2xG2.addPriority("G2", "no");
        targetLanguageSet.add("nn");
        TreeSet<String> targetScriptSet = new TreeSet<String>();
        TreeSet<String> targetRegionSet = new TreeSet<String>();
        TreeSet<String> targetTZSet = new TreeSet<String>();
        TreeSet<String> targetCurrencySet = new TreeSet<String>();
        for (Organization type : type_code_value.keySet()) {
            Map<String, Level> code_value = type_code_value.get((Object)type);
            if (!type.equals((Object)Organization.ibm)) continue;
            for (String locale : code_value.keySet()) {
                if (locale.equals("no")) continue;
                String priority = code_value.get(locale).toString();
                ULocale ulocale = new ULocale(locale);
                String language = ulocale.getLanguage();
                String script = ulocale.getScript();
                String territory = ulocale.getCountry();
                if (sourceLanguage.compareTo(priority) >= 0) {
                    if (language.equals("no")) {
                        language = "nn";
                    }
                    locale = new ULocale(language, script).toString();
                    sourceSet.add(locale);
                    GenerateG2xG2.addPriority(priority, locale);
                }
                if (targetLanguage.compareTo(priority) < 0) continue;
                targetLanguageSet.add(language);
                targetScriptSet.add(script);
                targetRegionSet.add(territory);
                GenerateG2xG2.addPriority(priority, language);
                GenerateG2xG2.addPriority(priority, script);
                GenerateG2xG2.addPriority("G4", territory);
            }
        }
        Map<String, List<String>> worldBankInfo = sc.getWorldBankInfo();
        HashSet<String> euCodes = new HashSet<String>(Arrays.asList("AT", "BE", "CY", "CZ", "DK", "EE", "FI", "FR", "DE", "GR", "HU", "IT", "LV", "LT", "LU", "MT", "NL", "PL", "PT", "SI", "ES", "SE", "GB"));
        for (String countryCode : worldBankInfo.keySet()) {
            if (priorityMap.get(countryCode) == null) continue;
            List<String> values = worldBankInfo.get(countryCode);
            double gdp = Double.parseDouble(values.get(1));
            if (gdp >= 1.0E13) {
                GenerateG2xG2.addPriority("G0", countryCode);
                continue;
            }
            if (gdp >= 1.0E12) {
                GenerateG2xG2.addPriority("G1", countryCode);
                continue;
            }
            if (gdp >= 1.0E11) {
                GenerateG2xG2.addPriority("G2", countryCode);
                continue;
            }
            if (!euCodes.contains(countryCode)) continue;
            GenerateG2xG2.addPriority("G3", countryCode);
        }
        Map<String, Set<String>> c2z = sc.getCountryToZoneSet();
        SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance();
        Set<String> mainTimeZones = supplementalDataInfo.getCanonicalTimeZones();
        for (String country : targetRegionSet) {
            String priority = priorityMap.get(country);
            for (String currency : GenerateG2xG2.getCurrency(country)) {
                targetCurrencySet.add(currency);
                GenerateG2xG2.addPriority(priority, currency);
            }
            Set<String> s2 = c2z.get(country);
            if (s2.size() == 1) continue;
            for (String tzid : s2) {
                if (!mainTimeZones.contains(tzid)) continue;
                targetTZSet.add(tzid);
                GenerateG2xG2.addPriority(priority, tzid);
            }
        }
        PrintWriter pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "G2xG2.txt");
        UTF16.StringComparator comp = new UTF16.StringComparator();
        TreeSet<String[]> priority_set = new TreeSet<String[]>(new ArrayComparator(comp, comp, comp));
        for (String code : priorityMap.keySet()) {
            String priority = priorityMap.get(code);
            if (priority == null) continue;
            int type = GenerateG2xG2.getType(code);
            priority_set.add(new String[]{priority, type + "", code});
        }
        String lastPriority = "";
        for (String[] items : priority_set) {
            if (!lastPriority.equals(items[0])) {
                lastPriority = items[0];
                pw.println();
            }
            String typeName = GenerateG2xG2.getTypeName(items[2]);
            pw.println(lastPriority + "\t" + typeName + "\t" + items[2] + "\t(" + GenerateG2xG2.getItemName(english, items[2]) + ")");
        }
        pw.flush();
        for (String sourceLocale : sourceSet) {
            System.out.print(sourceLocale + ", ");
            CLDRFile sourceData = cldrFactory.make(sourceLocale, true);
            pw.println();
            String title = sourceLocale;
            GenerateG2xG2.checkItems(pw, title, sourceData, 0, targetLanguageSet);
            GenerateG2xG2.checkItems(pw, title, sourceData, 1, targetScriptSet);
            GenerateG2xG2.checkItems(pw, title, sourceData, 2, targetRegionSet);
            GenerateG2xG2.checkItems(pw, title, sourceData, 4, targetCurrencySet);
            String v = sourceData.getStringValue("//ldml/characters/exemplarCharacters");
            UnicodeSet exemplars = new UnicodeSet(v);
            if (exemplars.contains(97, 122)) continue;
            GenerateG2xG2.checkItems(pw, title, sourceData, 6, targetTZSet);
        }
        pw.println();
        pw.println("Sizes - incremental");
        pw.println();
        int runningTotalCount = 0;
        int runningMissingCount = 0;
        NumberFormat percent = NumberFormat.getPercentInstance();
        percent.setMinimumFractionDigits(1);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(true);
        nf.setMinimumFractionDigits(0);
        for (String key : totalMap.keySet()) {
            Totals t = totalMap.get(key);
            runningTotalCount = t.totalCount;
            runningMissingCount = t.missingCount;
            pw.println(key.substring(0, 2) + "\t" + key.substring(2) + "\t" + runningMissingCount + "\t" + runningTotalCount + "\t" + percent.format((double)runningMissingCount / (0.0 + (double)runningTotalCount)));
        }
        pw.close();
        System.out.println();
        System.out.println("Done");
    }

    private static boolean showLocales(int choice) throws Exception {
        ULocale desiredDisplayLocale = ULocale.ENGLISH;
        TreeSet testSet = new TreeSet();
        StandardCodes sc = StandardCodes.make();
        Set<String> countries = sc.getGoodAvailableCodes("territory");
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        english = cldrFactory.make("en", true);
        for (String territory : countries) {
            if (territory.charAt(0) < 'A') continue;
            String locale = "haw-" + territory;
            System.out.print(locale + ": " + english.getName(locale) + ", ");
        }
        return true;
    }

    private static void showCollator() throws Exception {
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance(new ULocale("zh"));
        GenerateG2xG2.showExample(col);
        String rules = col.getRules(false);
        rules = rules + "& \u93ca < A <<< a & \u7c3f < B <<< b";
        RuleBasedCollator col2 = new RuleBasedCollator(rules);
        GenerateG2xG2.showExample(col2);
    }

    private static void showExample(RuleBasedCollator col) {
        String samples = "a A b B \u5416 \u93ca \u516b \u7c3f";
        TreeSet<Object> s2 = new TreeSet<Object>(col);
        s2.addAll(Arrays.asList(samples.split(" ")));
        System.out.println(Utility.escape(((Object)s2).toString()));
    }

    static void addPriority(String priority, String code) {
        if (code.length() == 0) {
            return;
        }
        String oldPriority = priorityMap.get(code);
        if (oldPriority == null || priority.compareTo(oldPriority) < 0) {
            priorityMap.put(code, priority);
        }
        System.out.println(code + ": " + priority);
    }

    static void checkItems(PrintWriter pw, String sourceLocale, CLDRFile sourceData, int type, Set<String> targetItemSet) {
        for (String item : targetItemSet) {
            if (item.length() == 0) continue;
            String key = priorityMap.get(sourceLocale) + "" + priorityMap.get(item);
            Totals t = totalMap.get(key);
            if (t == null) {
                t = new Totals();
                totalMap.put(key, t);
            }
            ++t.totalCount;
            String translation = GenerateG2xG2.getItemName(sourceData, type, item);
            String rootName = GenerateG2xG2.getItemName(root, type, item);
            if (!rootName.equals(translation)) continue;
            ++t.missingCount;
            pw.println(priorityMap.get(sourceLocale) + "\t" + sourceLocale + "\t(" + english.getName(sourceLocale) + ": " + sourceData.getName(sourceLocale) + ")\t" + priorityMap.get(item) + "\t" + item + "\t(" + GenerateG2xG2.getItemName(english, type, item) + ")");
        }
    }

    private static String getItemName(CLDRFile data, String item) {
        return GenerateG2xG2.getItemName(data, GenerateG2xG2.getType(item), item);
    }

    private static int getType(String item) {
        int type = 0;
        if (item.indexOf(47) >= 0) {
            type = 6;
        } else if (item.length() == 4) {
            type = 1;
        } else if (item.charAt(0) <= '9') {
            type = 2;
        } else if (item.charAt(0) < 'a') {
            type = item.length() == 3 ? 4 : 2;
        }
        return type;
    }

    private static String getTypeName(String item) {
        switch (GenerateG2xG2.getType(item)) {
            case 0: {
                return "Lang";
            }
            case 6: {
                return "Zone";
            }
            case 1: {
                return "Script";
            }
            case 2: {
                return "Region";
            }
            case 4: {
                return "Curr.";
            }
        }
        return "?";
    }

    private static String getItemName(CLDRFile data, int type, String item) {
        String result;
        if (type == 0) {
            result = data.getName(item);
        } else if (type != 6) {
            result = data.getName(type, item);
        } else {
            String prefix = "//ldml/dates/timeZoneNames/zone[@type=\"" + item + "\"]/exemplarCity";
            result = data.getStringValue(prefix);
        }
        return result == null ? item : result;
    }

    private static List<String> getCurrency(String territory) {
        if (territory_currency == null) {
            territory_currency = new TreeMap<String, List<String>>();
            Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
            CLDRFile supp = cldrFactory.make("supplementalData", false);
            for (String path : supp) {
                if (path.indexOf("/currencyData") < 0 || path.indexOf("/region") < 0) continue;
                XPathParts parts = XPathParts.getFrozenInstance(supp.getFullXPath(path));
                Map<String, String> attributes = parts.getAttributes(parts.size() - 2);
                String iso3166 = attributes.get("iso3166");
                attributes = parts.getAttributes(parts.size() - 1);
                String iso4217 = attributes.get("iso4217");
                String to = attributes.get("to");
                if (to != null) continue;
                List<String> info = territory_currency.get(iso3166);
                if (info == null) {
                    info = new ArrayList<String>();
                    territory_currency.put(iso3166, info);
                }
                info.add(iso4217);
            }
        }
        return territory_currency.get(territory);
    }

    static {
        priorityMap = new TreeMap<String, String>();
        totalMap = new TreeMap<String, Totals>();
        territory_currency = null;
    }

    static class Totals {
        int totalCount;
        int missingCount;

        Totals() {
        }
    }
}

