/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.tool.ConvertLanguageData;
import org.unicode.cldr.tool.DeriveScripts;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Containment;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class GenerateMaximalLocales {
    private static final String TEMP_UNKNOWN_REGION = "XZ";
    private static final String DEBUG_ADD_KEY = "und_Latn_ZA";
    private static final boolean SHOW_ADD = CldrUtility.getProperty("GenerateMaximalLocalesDebug", false);
    private static final boolean SUPPRESS_CHANGES = CldrUtility.getProperty("GenerateMaximalLocalesSuppress", false);
    private static final boolean SHOW_CONTAINERS = false;
    private static OutputStyle OUTPUT_STYLE = OutputStyle.valueOf(CldrUtility.getProperty("OutputStyle", "XML", "XML").toUpperCase());
    private static final String SEPARATOR = OUTPUT_STYLE == OutputStyle.C || OUTPUT_STYLE == OutputStyle.C_ALT ? "\n" : "\t";
    private static final String TAG_SEPARATOR = OUTPUT_STYLE == OutputStyle.C_ALT ? "-" : "_";
    private static final boolean tryDifferent = true;
    private static final File[] list = new File[]{new File(CLDRPaths.MAIN_DIRECTORY), new File(CLDRPaths.SEED_DIRECTORY), new File(CLDRPaths.EXEMPLARS_DIRECTORY)};
    private static Factory factory = SimpleFactory.make(list, ".*");
    private static Factory mainFactory = CLDRConfig.getInstance().getCldrFactory();
    private static SupplementalDataInfo supplementalData = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
    private static StandardCodes standardCodes = StandardCodes.make();
    private static CLDRFile english = factory.make("en", false);
    static Relation<String, String> cldrContainerToLanguages = Relation.of(new HashMap(), HashSet.class);
    private static final List<String> KEEP_TARGETS;
    private static final ImmutableSet<String> deprecatedISONotInLST;
    private static final String[] MAX_ADDITIONS;
    private static final Map<String, String> LANGUAGE_OVERRIDES;
    private static String[][] SpecialScripts;
    private static Map<String, String> localeToScriptCache;
    private static Map<String, String> FALLBACK_SCRIPTS;
    private static int errorCount;
    private static final double MIN_UNOFFICIAL_LANGUAGE_SIZE = 1.0E7;
    private static final double MIN_UNOFFICIAL_LANGUAGE_PROPORTION = 0.2;
    private static final double MIN_UNOFFICIAL_CLDR_LANGUAGE_SIZE = 100000.0;
    private static final double UNOFFICIAL_SCALE_DOWN = 0.2;
    private static NumberFormat percent;
    private static NumberFormat number;
    private static final String[][] ALT_REVERSAL;
    private static String UNKNOWN_SCRIPT;
    private static String UNKNOWN_REGION;

    public static void main(String[] args) throws IOException {
        GenerateMaximalLocales.printDefaultLanguagesAndScripts();
        TreeMap<String, String> toMaximized = new TreeMap<String, String>();
        GenerateMaximalLocales.tryDifferentAlgorithm(toMaximized);
        GenerateMaximalLocales.minimize(toMaximized);
        TreeSet<String> toRemove = new TreeSet<String>();
        TreeMap<String, String> toFix = new TreeMap<String, String>();
        for (Map.Entry entry : toMaximized.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.contains(TEMP_UNKNOWN_REGION)) {
                toRemove.add(key);
                continue;
            }
            if (!value.contains(TEMP_UNKNOWN_REGION)) continue;
            toFix.put(key, value.replace(TEMP_UNKNOWN_REGION, UNKNOWN_REGION));
        }
        for (String key : toRemove) {
            toMaximized.remove(key);
        }
        toMaximized.putAll(toFix);
        Map<String, String> oldLikely = SupplementalDataInfo.getInstance().getLikelySubtags();
        Set<String> changes = GenerateMaximalLocales.compareMapsAndFixNew("*WARNING* Likely Subtags: ", oldLikely, toMaximized, "ms_Arab", "ms_Arab_ID");
        System.out.println(Joiner.on("\n").join(changes));
        if (OUTPUT_STYLE == OutputStyle.C_ALT) {
            GenerateMaximalLocales.doAlt(toMaximized);
        }
        if (SHOW_ADD) {
            System.out.println("/*\n To Maximize:\n If using raw strings, make sure the input language/locale uses the right separator, and has the right casing.\n Remove the script Zzzz and the region ZZ if they occur; change an empty language subtag to 'und'.\n Get the language, region, and script from the cleaned-up tag, plus any variants/extensions\n Try each of the following in order (where the field exists)\n   Lookup language-script-region. If in the table, return the result + variants\n   Lookup language-script. If in the table, return the result (substituting the original region if it exists) + variants\n   Lookup language-region. If in the table, return the result (substituting the original script if it exists) + variants\n   Lookup language. If in the table, return the result (substituting the original region and script if either or both exist) + variants\n\n Example: Input is zh-ZZZZ-SG.\n Normalize to zh-SG. Lookup in table. No match.\n Remove SG, but remember it. Lookup zh, and get the match (zh-Hans-CN). Substitute SG, and return zh-Hans-SG.\n\n To Minimize:\n First get max = maximize(input).\n Then for trial in {language, language-region, language-script}\n     If maximize(trial) == max, then return trial.\n If you don't get a match, return max.\n\n Example: Input is zh-Hant. Maximize to get zh-Hant-TW.\n zh => zh-Hans-CN. No match, so continue.\n zh-TW => zh-Hans-TW. Match, so return zh-TW.\n\n (A variant of this uses {language, language-script, language-region}): that is, tries script before language.\n toMaximal size:\t" + toMaximized.size() + "\n" + "*/");
        }
        GenerateMaximalLocales.printLikelySubtags(toMaximized);
        GenerateMaximalLocales.printDefaultContent(toMaximized);
        System.out.println("\nERRORS:\t" + errorCount + "\n");
    }

    private static void printDefaultLanguagesAndScripts() {
        int minTotalPopulation = 10000000;
        int minTerritoryPopulation = 1000000;
        double minTerritoryPercent = 0.3333333333333333;
        TreeMap<String, Set<RowData>> languageToReason = new TreeMap<String, Set<RowData>>();
        Counter<String> languageToLiteratePopulation = new Counter<String>();
        NumberFormat nf = NumberFormat.getIntegerInstance(ULocale.ENGLISH);
        nf.setGroupingUsed(true);
        LanguageTagParser ltp = new LanguageTagParser();
        LikelySubtags likelySubtags = new LikelySubtags();
        SupplementalDataInfo.OfficialStatus minimalStatus = SupplementalDataInfo.OfficialStatus.official_regional;
        TreeMap<String, String> languages = new TreeMap<String, String>();
        for (String string : standardCodes.getAvailableCodes("language")) {
            String path = CLDRFile.getKey(0, string);
            String result = english.getStringValue(path);
            if (result == null) continue;
            languages.put(string, result);
        }
        for (String string : languages.keySet()) {
            System.out.println(string + "\t" + (String)languages.get(string));
        }
        TreeSet<String> CLDRMainLanguages = new TreeSet<String>(StandardCodes.make().getLocaleCoverageLocales(Organization.cldr));
        for (String territory : supplementalData.getTerritoriesWithPopulationData()) {
            SupplementalDataInfo.PopulationData territoryPop = supplementalData.getPopulationDataForTerritory(territory);
            double territoryPopulation = territoryPop.getLiteratePopulation();
            for (String languageScript : supplementalData.getLanguagesForTerritoryWithPopulationData(territory)) {
                SupplementalDataInfo.PopulationData popData = supplementalData.getLanguageAndTerritoryPopulationData(languageScript, territory);
                ltp.set(languageScript);
                String language = ltp.getLanguage();
                boolean add = false;
                SupplementalDataInfo.OfficialStatus status = popData.getOfficialStatus();
                if (status.compareTo(minimalStatus) >= 0) {
                    add = true;
                }
                long literatePopulation = GenerateMaximalLocales.getWritingPopulation(popData);
                languageToLiteratePopulation.add(language, literatePopulation);
                if (literatePopulation > 1000000L && (double)literatePopulation > 0.3333333333333333 * territoryPopulation) {
                    add = true;
                }
                if (!add && CLDRMainLanguages.contains(language)) {
                    add = true;
                }
                if (!add) continue;
                GenerateMaximalLocales.add(languageToReason, language, territory, status, literatePopulation);
                for (String container : Containment.leafToContainer(territory)) {
                    GenerateMaximalLocales.add(languageToReason, language, container, SupplementalDataInfo.OfficialStatus.unknown, literatePopulation);
                }
            }
        }
        for (String language : languageToLiteratePopulation.keySet()) {
            long totalPop = languageToLiteratePopulation.getCount(language);
            if (totalPop <= 10000000L) continue;
            GenerateMaximalLocales.add(languageToReason, language, "001", SupplementalDataInfo.OfficialStatus.unknown, totalPop);
        }
        GenerateMaximalLocales.add(languageToReason, "und", "001", SupplementalDataInfo.OfficialStatus.unknown, 0L);
        System.out.println("Detailed - Including:\t" + languageToReason.size());
        for (String language : languageToReason.keySet()) {
            Set reasons = (Set)languageToReason.get(language);
            RowData lastReason = (RowData)reasons.iterator().next();
            System.out.append(language).append("\t").append(english.getName(language)).append("\t").append(lastReason.getStatus().toShortString()).append("\t").append(nf.format(languageToLiteratePopulation.getCount(language)));
            for (RowData reason : reasons) {
                String status = reason.getStatus().toShortString();
                System.out.append("\t").append(status).append("-").append(reason.getName()).append("-").append(nf.format(reason.getLiteratePopulation()));
            }
            System.out.append("\n");
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(standardCodes.getGoodAvailableCodes("language"));
        treeSet.removeAll(languageToReason.keySet());
        System.out.println("\nIncluded Languages:\t" + languageToReason.keySet().size());
        GenerateMaximalLocales.showLanguages(languageToReason.keySet(), languageToReason);
        System.out.println("\nExcluded Languages:\t" + treeSet.size());
        GenerateMaximalLocales.showLanguages(treeSet, languageToReason);
    }

    private static long getWritingPopulation(SupplementalDataInfo.PopulationData popData) {
        double writingPopulation = popData.getWritingPopulation();
        if (!Double.isNaN(writingPopulation)) {
            return (long)writingPopulation;
        }
        return (long)popData.getLiteratePopulation();
    }

    private static void showLanguages(Set<String> others, Map<String, Set<RowData>> languageToReason) {
        TreeSet<Object> sorted = new TreeSet<Object>(Collator.getInstance(ULocale.ENGLISH));
        for (String language : others) {
            sorted.add(GenerateMaximalLocales.getLanguageName(language, languageToReason));
        }
        char last = '\u0000';
        for (String string : sorted) {
            char curr = string.charAt(0);
            if (last != curr) {
                System.out.println();
            } else if (last != '\u0000') {
                System.out.print(", ");
            }
            System.out.print(string);
            last = curr;
        }
        System.out.println();
    }

    private static String getLanguageName(String language, Map<String, Set<RowData>> languageToReason) {
        SupplementalDataInfo.OfficialStatus best = SupplementalDataInfo.OfficialStatus.unknown;
        Set<RowData> reasons = languageToReason.get(language);
        if (reasons != null) {
            for (RowData reason : reasons) {
                SupplementalDataInfo.OfficialStatus currentStatus = reason.getStatus();
                if (best.compareTo(currentStatus) >= 0) continue;
                best = currentStatus;
            }
        }
        String status = best.toShortString();
        Iso639Data.Scope scope = Iso639Data.getScope(language);
        if (scope == Iso639Data.Scope.Special) {
            status = "S";
        }
        String languageFormatted = english.getName(language) + " [" + language + "]-" + status;
        return languageFormatted;
    }

    private static void add(Map<String, Set<RowData>> languageToReason, String language, String territoryRaw, SupplementalDataInfo.OfficialStatus status, long population) {
        String territory = english.getName("territory", territoryRaw) + " [" + territoryRaw + "]";
        Set<RowData> set = languageToReason.get(language);
        if (set == null) {
            set = new TreeSet<RowData>();
            languageToReason.put(language, set);
        }
        set.add(new RowData(status, territory, population));
    }

    private static void printDefaultContent(Map<String, String> toMaximized) throws IOException {
        TreeSet<String> defaultLocaleContent = new TreeSet<String>();
        Set<String> available = factory.getAvailable();
        Relation<String, String> toChildren = Relation.of(new TreeMap(), TreeSet.class);
        LanguageTagParser ltp = new LanguageTagParser();
        TreeSet<String> hasScript = new TreeSet<String>();
        for (String locale : available) {
            if (locale.equals("root") || ltp.set(locale).getVariants().size() != 0) continue;
            Iterator parent = LocaleIDParser.getSimpleParent(locale);
            if (ltp.getScript().length() != 0) {
                hasScript.add((String)((Object)parent));
            }
            if (((String)((Object)parent)).equals("root")) continue;
            toChildren.put((String)((Object)parent), locale);
        }
        HashSet<String> suppressScriptLocales = new HashSet<String>(Arrays.asList("bm_ML", "en_US", "ha_NG", "iu_CA", "ms_MY", "mn_MN", "byn_ER", "ff_SN", "dyo_SN", "kk_KZ", "ku_TR", "ky_KG", "ml_IN", "so_SO", "sw_TZ", "wo_SN", "yo_NG", "dje_NE", "blt_VN", "hi_IN", "nv_US", "doi_IN"));
        TreeSet<String> toRemove = new TreeSet<String>();
        for (String locale : hasScript) {
            toRemove.clear();
            Set children = toChildren.getAll(locale);
            for (String child : children) {
                if (ltp.set(child).getScript().length() != 0 || suppressScriptLocales.contains(child)) continue;
                toRemove.add(child);
            }
            if (toRemove.size() == 0) continue;
            System.out.println("\tRemoving:\t" + locale + "\t" + toRemove + "\tfrom\t" + children);
            toChildren.removeAll(locale, (Iterable<String>)toRemove);
        }
        block3: for (String locale : toChildren.keySet()) {
            String maximized = GenerateMaximalLocales.maximize(locale, toMaximized);
            if (maximized == null) {
                if (!SHOW_ADD) continue;
                System.out.println("Missing maximized:\t" + locale);
                continue;
            }
            Set children = toChildren.getAll(locale);
            TreeMap<String, String> debugStuff = new TreeMap<String, String>();
            for (String child : children) {
                String maximizedChild = GenerateMaximalLocales.maximize(child, toMaximized);
                if (maximized.equals(maximizedChild)) {
                    defaultLocaleContent.add(child);
                    continue block3;
                }
                debugStuff.put(child, maximizedChild);
            }
            if (!SHOW_ADD) continue;
            System.out.println("Can't find maximized: " + locale + "=" + maximized + "\tin\t" + debugStuff);
        }
        defaultLocaleContent.remove("und_ZZ");
        GenerateMaximalLocales.showDefaultContentDifferencesAndFix(defaultLocaleContent);
        Log.setLogNoBOM(CLDRPaths.GEN_DIRECTORY + "/supplemental", "supplementalMetadata.xml");
        BufferedReader oldFile = FileUtilities.openUTF8Reader(CLDRPaths.SUPPLEMENTAL_DIRECTORY, "supplementalMetadata.xml");
        CldrUtility.copyUpTo(oldFile, PatternCache.get("\\s*<defaultContent locales=\"\\s*"), Log.getLog(), false);
        String sep = "\n\t\t\t";
        String broken = CldrUtility.breakLines(CldrUtility.join(defaultLocaleContent, " "), sep, PatternCache.get("(\\S)\\S*").matcher(""), 80);
        Log.println("\t\t<defaultContent locales=\"" + broken + "\"");
        Log.println("\t\t/>");
        CldrUtility.copyUpTo(oldFile, PatternCache.get("\\s*/>\\s*(<!--.*)?"), null, true);
        CldrUtility.copyUpTo(oldFile, null, Log.getLog(), true);
        Log.close();
        oldFile.close();
    }

    /*
     * WARNING - void declaration
     */
    private static void tryDifferentAlgorithm(Map<String, String> toMaximized) {
        Comparable script;
        String language;
        Comparable region;
        String region2;
        Row value;
        void var7_31;
        MaxData maxData = new MaxData();
        Set<String> cldrLocales = factory.getAvailable();
        TreeSet<String> otherTerritories = new TreeSet<String>(standardCodes.getGoodAvailableCodes("territory"));
        for (String string : supplementalData.getTerritoriesWithPopulationData()) {
            otherTerritories.remove(string);
            SupplementalDataInfo.PopulationData populationData = supplementalData.getPopulationDataForTerritory(string);
            double d = populationData.getLiteratePopulation();
            double minimalLiteratePopulation = d * 0.2;
            if (minimalLiteratePopulation < 1.0E7) {
                minimalLiteratePopulation = 1.0E7;
            }
            for (String writtenLanguage : supplementalData.getLanguagesForTerritoryWithPopulationData(string)) {
                String script3;
                SupplementalDataInfo.PopulationData data = supplementalData.getLanguageAndTerritoryPopulationData(writtenLanguage, string);
                double literatePopulation = GenerateMaximalLocales.getWritingPopulation(data);
                double order = -literatePopulation;
                if (data.getOfficialStatus() == SupplementalDataInfo.OfficialStatus.unknown) {
                    String locale = writtenLanguage + "_" + string;
                    if (literatePopulation >= minimalLiteratePopulation || !(literatePopulation >= 100000.0) || cldrLocales.contains(locale)) {
                        // empty if block
                    }
                    order *= 0.2;
                    if (SHOW_ADD) {
                        System.out.println("Retaining\t" + writtenLanguage + "\t" + string + "\t" + english.getName(locale) + "\t" + number.format(literatePopulation) + "\t" + percent.format(literatePopulation / d) + (cldrLocales.contains(locale) ? "\tin-CLDR" : ""));
                    }
                }
                String language2 = writtenLanguage;
                int pos = writtenLanguage.indexOf(95);
                if (pos > 0) {
                    language2 = writtenLanguage.substring(0, pos);
                    String script2 = writtenLanguage.substring(pos + 1);
                } else {
                    script3 = GenerateMaximalLocales.getScriptForLocale2(language2);
                }
                maxData.add(language2, script3, string, order);
            }
        }
        LanguageTagParser additionLtp = new LanguageTagParser();
        String[] stringArray = MAX_ADDITIONS;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_31 < n) {
            String addition = stringArray[var7_31];
            additionLtp.set(addition);
            String lan = additionLtp.getLanguage();
            Set<Row.R3<Double, String, String>> key = maxData.languages.get(lan);
            if (key == null) {
                maxData.add(lan, additionLtp.getScript(), additionLtp.getRegion(), 1.0);
            } else {
                boolean bl2 = false;
            }
            ++var7_31;
        }
        for (Map.Entry<String, Collection<String>> entry : DeriveScripts.getLanguageToScript().asMap().entrySet()) {
            String string = entry.getKey();
            Collection<String> values = entry.getValue();
            if (values.size() != 1) continue;
            Set<Row.R3<Double, String, String>> old = maxData.languages.get(string);
            if (maxData.languages.containsKey(string)) continue;
            maxData.add(string, values.iterator().next(), TEMP_UNKNOWN_REGION, 1.0);
        }
        for (String string : otherTerritories) {
            if (string.length() == 3) continue;
            maxData.add("en", "Latn", string, 1.0);
        }
        Map<String, Row.R2<List<String>, String>> map = SupplementalDataInfo.getInstance().getLocaleAliasInfo().get("language");
        for (Map.Entry<String, Row.R2<List<String>, String>> entry : map.entrySet()) {
            Set<Row.R3<Double, String, String>> goodLanguageData;
            List replacements;
            String reason = (String)entry.getValue().get1();
            if ("overlong".equals(reason) || "bibliographic".equals(reason) || "macrolanguage".equals(reason) || (replacements = (List)entry.getValue().get0()) == null) continue;
            String goodLanguage = (String)replacements.get(0);
            String badLanguage = entry.getKey();
            if (badLanguage.contains("_") || deprecatedISONotInLST.contains(badLanguage) || (goodLanguageData = maxData.languages.getAll(goodLanguage)) == null) continue;
            Row.R3<Double, String, String> value2 = goodLanguageData.iterator().next();
            String script4 = (String)value2.get1();
            String region5 = (String)value2.get2();
            maxData.add(badLanguage, script4, region5, 1.0);
            System.out.println("Adding aliases: " + badLanguage + ", " + script4 + ", " + region5 + ", " + reason);
        }
        for (String string : maxData.languages.keySet()) {
            value = maxData.languages.getAll(string).iterator().next();
            Comparable script5 = (Comparable)value.get1();
            Comparable region22 = (Comparable)value.get2();
            GenerateMaximalLocales.add(string, string + "_" + script5 + "_" + region22, toMaximized, "L->SR", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
        }
        for (String string : maxData.languagesToScripts.keySet()) {
            String script23 = maxData.languagesToScripts.get(string).getKeysetSortedByCount(true).iterator().next();
            GenerateMaximalLocales.add(string, string + "_" + script23, toMaximized, "L->S", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
        }
        for (String string : maxData.languagesToRegions.keySet()) {
            region2 = maxData.languagesToRegions.get(string).getKeysetSortedByCount(true).iterator().next();
            GenerateMaximalLocales.add(string, string + "_" + region2, toMaximized, "L->R", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
        }
        for (String string : maxData.scripts.keySet()) {
            value = maxData.scripts.getAll(string).iterator().next();
            Comparable language7 = (Comparable)value.get1();
            region = (Comparable)value.get2();
            GenerateMaximalLocales.add("und_" + string, language7 + "_" + string + "_" + region, toMaximized, "S->LR", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
        }
        for (String string : maxData.scriptsToLanguages.keySet()) {
            language = maxData.scriptsToLanguages.get(string).getKeysetSortedByCount(true).iterator().next();
            GenerateMaximalLocales.add("und_" + string, language + "_" + string, toMaximized, "S->L", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
        }
        for (String string : maxData.scriptsToRegions.keySet()) {
            region2 = maxData.scriptsToRegions.get(string).getKeysetSortedByCount(true).iterator().next();
            GenerateMaximalLocales.add("und_" + string, "und_" + string + "_" + region2, toMaximized, "S->R", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
        }
        for (String string : maxData.regions.keySet()) {
            value = maxData.regions.getAll(string).iterator().next();
            Comparable language8 = (Comparable)value.get1();
            script = (Comparable)value.get2();
            GenerateMaximalLocales.add("und_" + string, language8 + "_" + script + "_" + string, toMaximized, "R->LS", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
        }
        for (String string : maxData.regionsToLanguages.keySet()) {
            language = maxData.regionsToLanguages.get(string).getKeysetSortedByCount(true).iterator().next();
            GenerateMaximalLocales.add("und_" + string, language + "_" + string, toMaximized, "R->L", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
        }
        for (String string : maxData.regionsToScripts.keySet()) {
            String script3 = maxData.regionsToScripts.get(string).getKeysetSortedByCount(true).iterator().next();
            GenerateMaximalLocales.add("und_" + string, "und_" + script3 + "_" + string, toMaximized, "R->S", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
        }
        block15: for (Map.Entry<String, Counter<Row.R2<String, String>>> entry : maxData.containersToLanguage.entrySet()) {
            region2 = entry.getKey();
            if (region2.equals("001")) continue;
            Counter<Row.R2<String, String>> data = entry.getValue();
            Set<Row.R2<String, String>> keysetSortedByCount = data.getKeysetSortedByCount(true);
            Row.R2<String, String> value3 = keysetSortedByCount.iterator().next();
            Comparable language9 = (Comparable)value3.get0();
            Comparable script9 = (Comparable)value3.get1();
            Set<String> skipLanguages = cldrContainerToLanguages.get(region2);
            if (skipLanguages != null && skipLanguages.contains(language9)) {
                GenerateMaximalLocales.add("und_" + region2, language9 + "_" + script9 + "_" + region2, toMaximized, "R*->LS", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
                continue;
            }
            for (Row.R4<Double, String, String, String> e : maxData.containersToLangRegion.get(region2)) {
                Comparable language2 = (Comparable)e.get1();
                Comparable script22 = (Comparable)e.get2();
                if (!language2.equals(language9) || !script22.equals(script9)) continue;
                GenerateMaximalLocales.add("und_" + region2, language9 + "_" + script9 + "_" + (String)e.get3(), toMaximized, "R*->LS", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
                continue block15;
            }
        }
        for (Row.R2<String, String> r2 : maxData.languageScripts.keySet()) {
            value = maxData.languageScripts.getAll(r2).iterator().next();
            Comparable language10 = (Comparable)r2.get0();
            script = (Comparable)r2.get1();
            Comparable region9 = (Comparable)value.get1();
            GenerateMaximalLocales.add(language10 + "_" + script, language10 + "_" + script + "_" + region9, toMaximized, "LS->R", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
        }
        for (Row.R2<String, String> r2 : maxData.scriptRegions.keySet()) {
            value = maxData.scriptRegions.getAll(r2).iterator().next();
            Comparable script10 = (Comparable)r2.get0();
            region = (Comparable)r2.get1();
            Comparable language11 = (Comparable)value.get1();
            GenerateMaximalLocales.add("und_" + script10 + "_" + region, language11 + "_" + script10 + "_" + region, toMaximized, "SR->L", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
        }
        for (Row.R2<String, String> r2 : maxData.languageRegions.keySet()) {
            value = maxData.languageRegions.getAll(r2).iterator().next();
            Comparable language12 = (Comparable)r2.get0();
            region = (Comparable)r2.get1();
            Comparable script11 = (Comparable)value.get1();
            GenerateMaximalLocales.add(language12 + "_" + region, language12 + "_" + script11 + "_" + region, toMaximized, "LR->S", LocaleOverride.REPLACE_EXISTING, SHOW_ADD);
        }
        TreeSet<String> treeSet = new TreeSet<String>(ScriptMetadata.getScripts());
        for (String script3 : treeSet) {
            ScriptMetadata.Info i = ScriptMetadata.getInfo(script3);
            String likelyLanguage = i.likelyLanguage;
            String originCountry = i.originCountry;
            String result = likelyLanguage + "_" + script3 + "_" + originCountry;
            GenerateMaximalLocales.add("und_" + script3, result, toMaximized, "S->LR\u2022", LocaleOverride.KEEP_EXISTING, SHOW_ADD);
            GenerateMaximalLocales.add(likelyLanguage, result, toMaximized, "L->SR\u2022", LocaleOverride.KEEP_EXISTING, SHOW_ADD);
        }
        for (String key : LANGUAGE_OVERRIDES.keySet()) {
            GenerateMaximalLocales.add(key, LANGUAGE_OVERRIDES.get(key), toMaximized, "OVERRIDE", LocaleOverride.REPLACE_EXISTING, true);
        }
    }

    public static String shorten(Object data) {
        String info = data.toString();
        if (info.length() > 255) {
            info = info.substring(0, 127) + "\u2026";
        }
        return info;
    }

    private static void doAlt(Map<String, String> toMaximized) {
        TreeMap<String, String> temp = new TreeMap<String, String>();
        for (String locale : toMaximized.keySet()) {
            String target = toMaximized.get(locale);
            temp.put(GenerateMaximalLocales.toAlt(locale, true), GenerateMaximalLocales.toAlt(target, true));
        }
        toMaximized.clear();
        toMaximized.putAll(temp);
    }

    public static String maximize(String languageTag, Map<String, String> toMaximized) {
        String result;
        LanguageTagParser ltp = new LanguageTagParser();
        ltp.set(languageTag);
        String language = ltp.getLanguage();
        String region = ltp.getRegion();
        String script = ltp.getScript();
        boolean changed = false;
        if (language.equals("")) {
            language = "und";
            ltp.setLanguage("und");
            changed = true;
        }
        if (region.equals(UNKNOWN_SCRIPT)) {
            script = "";
            ltp.setScript("");
            changed = true;
        }
        if (ltp.getRegion().equals(UNKNOWN_REGION)) {
            region = "";
            ltp.setRegion("");
            changed = true;
        }
        if (changed) {
            languageTag = ltp.toString();
        }
        if ((result = toMaximized.get(languageTag)) != null) {
            return result;
        }
        if (region.length() != 0) {
            result = toMaximized.get(ltp.setRegion("").toString());
            if (result != null) {
                return ltp.set(result).setRegion(region).toString();
            }
            ltp.setRegion(region);
        }
        if (script.length() != 0) {
            result = toMaximized.get(ltp.setScript("").toString());
            if (result != null) {
                return ltp.set(result).setScript(script).toString();
            }
            if (region.length() != 0 && (result = toMaximized.get(ltp.setRegion("").toString())) != null) {
                return ltp.set(result).setScript(script).setRegion(region).toString();
            }
        }
        if (!language.equals("und") && script.length() != 0 && region.length() != 0) {
            return languageTag;
        }
        return null;
    }

    public static String minimize(String input, Map<String, String> toMaximized, boolean favorRegion) {
        String[] trials;
        String maximized;
        if (input.equals("nb_Latn_SJ")) {
            System.out.print("");
        }
        if ((maximized = GenerateMaximalLocales.maximize(input, toMaximized)) == null) {
            return null;
        }
        LanguageTagParser ltp = new LanguageTagParser().set(maximized);
        String language = ltp.getLanguage();
        String region = ltp.getRegion();
        String script = ltp.getScript();
        for (String trial : trials = new String[]{language, language + TAG_SEPARATOR + (favorRegion ? region : script), language + TAG_SEPARATOR + (!favorRegion ? region : script)}) {
            String newMaximized = GenerateMaximalLocales.maximize(trial, toMaximized);
            if (!maximized.equals(newMaximized)) continue;
            return trial;
        }
        return maximized;
    }

    private static void add(String key, String value, Map<String, String> toAdd, String kind, LocaleOverride override, boolean showAction) {
        String oldValue;
        if (key.equals(DEBUG_ADD_KEY)) {
            System.out.println("*debug*");
        }
        if ((oldValue = toAdd.get(key)) == null) {
            if (showAction) {
                System.out.println("\tAdding:\t\t" + GenerateMaximalLocales.getName(key) + "\t=>\t" + GenerateMaximalLocales.getName(value) + "\t\t\t\t" + kind);
            }
        } else {
            if (override == LocaleOverride.KEEP_EXISTING || value.equals(oldValue)) {
                return;
            }
            if (showAction) {
                System.out.println("\tReplacing:\t" + GenerateMaximalLocales.getName(key) + "\t=>\t" + GenerateMaximalLocales.getName(value) + "\t, was\t" + GenerateMaximalLocales.getName(oldValue) + "\t\t" + kind);
            }
        }
        toAdd.put(key, value);
    }

    private static String getName(String value) {
        return ConvertLanguageData.getLanguageCodeAndName(value);
    }

    private static void printLikelySubtags(Map<String, String> fluffup) throws IOException {
        PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "/supplemental/likelySubtags" + (OUTPUT_STYLE == OutputStyle.XML ? ".xml" : ".txt"));
        String spacing = OUTPUT_STYLE == OutputStyle.PLAINTEXT ? "\t" : " ";
        String header = OUTPUT_STYLE != OutputStyle.XML ? "const MapToMaximalSubtags default_subtags[] = {" : "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE supplementalData SYSTEM \"../../common/dtd/ldmlSupplemental.dtd\">\n<!--\n" + CldrUtility.getCopyrightString() + "\n" + "-->" + "\n" + "<!--" + "\n" + "Likely subtags data is generated programatically from CLDR's language/territory/population" + "\n" + "data using the GenerateMaximalLocales tool. Under normal circumstances, this file should" + "\n" + "not be patched by hand, as any changes made in that fashion may be lost." + "\n" + "-->" + "\n" + "<supplementalData>" + "\n" + "    <version number=\"$Revision$\"/>" + "\n" + "    <likelySubtags>";
        String footer = OUTPUT_STYLE != OutputStyle.XML ? SEPARATOR + "};" : "    </likelySubtags>\n</supplementalData>";
        out.println(header);
        boolean first = true;
        TreeSet<String> keys = new TreeSet<String>(new LocaleStringComparator());
        keys.addAll(fluffup.keySet());
        for (String printingLocale : keys) {
            String printingTarget = fluffup.get(printingLocale);
            String comment = GenerateMaximalLocales.printingName(printingLocale, spacing) + spacing + "=>" + spacing + GenerateMaximalLocales.printingName(printingTarget, spacing);
            if (OUTPUT_STYLE == OutputStyle.XML) {
                out.println("\t\t<likelySubtag from=\"" + printingLocale + "\" to=\"" + printingTarget + "\"/>" + "\n" + "\t\t<!--" + comment + "-->");
                continue;
            }
            if (first) {
                first = false;
            } else {
                out.print(",");
            }
            if (comment.length() > 70 && SEPARATOR.equals("\n")) {
                comment = GenerateMaximalLocales.printingName(printingLocale, spacing) + SEPARATOR + "    // " + spacing + "=>" + spacing + GenerateMaximalLocales.printingName(printingTarget, spacing);
            }
            out.print("  {" + SEPARATOR + "    // " + comment + SEPARATOR + "    \"" + printingLocale + "\"," + SEPARATOR + "    \"" + printingTarget + "\"" + "\n" + "  }");
        }
        out.println(footer);
        out.close();
    }

    public static String printingName(String locale, String spacing) {
        if (locale == null) {
            return null;
        }
        LanguageTagParser parser = new LanguageTagParser().set(locale);
        String lang = parser.getLanguage();
        String script = parser.getScript();
        String region = parser.getRegion();
        return "{" + spacing + (lang.equals("und") ? "?" : english.getName(0, lang)) + ";" + spacing + (script == null || script.equals("") ? "?" : english.getName(1, script)) + ";" + spacing + (region == null || region.equals("") ? "?" : english.getName(2, region)) + spacing + "}";
    }

    public static String toAlt(String locale, boolean change) {
        if (!change || locale == null) {
            return locale;
        }
        String firstTag = GenerateMaximalLocales.getFirstTag(locale);
        for (String[] pair : ALT_REVERSAL) {
            if (!firstTag.equals(pair[0])) continue;
            locale = pair[1] + locale.substring(pair[1].length());
            break;
        }
        locale = locale.replace("_", "-");
        return locale;
    }

    private static String getFirstTag(String locale) {
        int pos = locale.indexOf(95);
        return pos < 0 ? locale : locale.substring(0, pos);
    }

    public static void minimize(Map<String, String> fluffup) {
        LanguageTagParser parser = new LanguageTagParser();
        LanguageTagParser targetParser = new LanguageTagParser();
        TreeSet<String> removals = new TreeSet<String>();
        block0: while (true) {
            removals.clear();
            for (String locale : fluffup.keySet()) {
                String target = fluffup.get(locale);
                if (targetParser.set(target).getRegion().equals(UNKNOWN_REGION)) {
                    removals.add(locale);
                    if (!SHOW_ADD) continue;
                    System.out.println("Removing:\t" + GenerateMaximalLocales.getName(locale) + "\t=>\t" + GenerateMaximalLocales.getName(target) + "\t\t - Unknown Region in target");
                    continue;
                }
                if (targetParser.getScript().equals(UNKNOWN_SCRIPT)) {
                    removals.add(locale);
                    if (!SHOW_ADD) continue;
                    System.out.println("Removing:\t" + GenerateMaximalLocales.getName(locale) + "\t=>\t" + GenerateMaximalLocales.getName(target) + "\t\t - Unknown Script in target");
                    continue;
                }
                String region = parser.set(locale).getRegion();
                if (region.length() != 0) {
                    if (region.equals(UNKNOWN_REGION)) {
                        removals.add(locale);
                        if (!SHOW_ADD) continue;
                        System.out.println("Removing:\t" + GenerateMaximalLocales.getName(locale) + "\t=>\t" + GenerateMaximalLocales.getName(target) + "\t\t - Unknown Region in source");
                        continue;
                    }
                    parser.setRegion("");
                    String newLocale = parser.toString();
                    String newTarget = fluffup.get(newLocale);
                    if (newTarget != null && target.equals(newTarget = targetParser.set(newTarget).setRegion(region).toString()) && !KEEP_TARGETS.contains(locale)) {
                        removals.add(locale);
                        if (!SHOW_ADD) continue;
                        System.out.println("Removing:\t" + locale + "\t=>\t" + target + "\t\tRedundant with " + newLocale);
                        continue;
                    }
                }
                String script = parser.set(locale).getScript();
                if (locale.equals(DEBUG_ADD_KEY)) {
                    System.out.println("*debug*");
                }
                if (script.length() == 0) continue;
                if (script.equals(UNKNOWN_SCRIPT)) {
                    removals.add(locale);
                    if (!SHOW_ADD) continue;
                    System.out.println("Removing:\t" + locale + "\t=>\t" + target + "\t\t - Unknown Script");
                    continue;
                }
                parser.setScript("");
                String newLocale = parser.toString();
                String newTarget = fluffup.get(newLocale);
                if (newTarget == null || !target.equals(newTarget = targetParser.set(newTarget).setScript(script).toString()) || KEEP_TARGETS.contains(locale)) continue;
                removals.add(locale);
                if (!SHOW_ADD) continue;
                System.out.println("Removing:\t" + locale + "\t=>\t" + target + "\t\tRedundant with " + newLocale);
            }
            if (removals.size() == 0) break;
            Iterator<String> iterator = removals.iterator();
            while (true) {
                String locale;
                if (!iterator.hasNext()) continue block0;
                locale = iterator.next();
                fluffup.remove(locale);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getScriptForLocale2(String locale) {
        String result = localeToScriptCache.get(locale);
        if (result != null) {
            return result;
        }
        if (locale.equals("ky")) {
            boolean bl = false;
        }
        try {
            CLDRFile cldrFile;
            Object scripts;
            Map<SupplementalDataInfo.BasicLanguageData.Type, SupplementalDataInfo.BasicLanguageData> data = supplementalData.getBasicLanguageDataMap(locale);
            if (data != null) {
                for (SupplementalDataInfo.BasicLanguageData datum : data.values()) {
                    boolean isPrimary;
                    scripts = datum.getScripts();
                    boolean bl = isPrimary = datum.getType() == SupplementalDataInfo.BasicLanguageData.Type.primary;
                    if (scripts.size() != 1) {
                        if (scripts.size() <= 1 || !isPrimary) continue;
                        break;
                    }
                    String script = (String)scripts.iterator().next();
                    if (isPrimary) {
                        String string = result = script;
                        return string;
                    }
                    if (result != null) continue;
                    result = script;
                }
                if (result != null) {
                    String string = result;
                    return string;
                }
            }
            try {
                cldrFile = factory.make(locale, true);
            }
            catch (RuntimeException e) {
                String temp;
                result = FALLBACK_SCRIPTS.get(locale);
                if (result == null) {
                    String temp2;
                    System.out.println("***Failed to find script for: " + locale + "\t" + english.getName(locale));
                    result = UNKNOWN_SCRIPT;
                    scripts = result;
                    if (result.equals(UNKNOWN_SCRIPT) && (temp2 = LANGUAGE_OVERRIDES.get(locale)) != null) {
                        result = new LanguageTagParser().set(temp2).getScript();
                        System.out.println("Getting script from LANGUAGE_OVERRIDES for " + locale + " => " + result);
                    }
                    localeToScriptCache.put(locale, result);
                    if (SHOW_ADD) {
                        System.out.println("Script:\t" + locale + "\t" + english.getName(locale) + "\t=>\t" + result + "\t" + english.getName(1, result));
                    }
                    return scripts;
                }
                scripts = result;
                if (result.equals(UNKNOWN_SCRIPT) && (temp = LANGUAGE_OVERRIDES.get(locale)) != null) {
                    result = new LanguageTagParser().set(temp).getScript();
                    System.out.println("Getting script from LANGUAGE_OVERRIDES for " + locale + " => " + result);
                }
                localeToScriptCache.put(locale, result);
                if (SHOW_ADD) {
                    System.out.println("Script:\t" + locale + "\t" + english.getName(locale) + "\t=>\t" + result + "\t" + english.getName(1, result));
                }
                return scripts;
            }
            UnicodeSet exemplars = GenerateMaximalLocales.getExemplarSet(cldrFile, "");
            Set<String> CLDRScripts = GenerateMaximalLocales.getScriptsFromUnicodeSet(exemplars);
            CLDRScripts.remove(UNKNOWN_SCRIPT);
            if (CLDRScripts.size() == 1) {
                String string = result = CLDRScripts.iterator().next();
                return string;
            }
            if (CLDRScripts.size() == 0) {
                System.out.println("**Failed to get script for:\t" + locale);
                String string = result = UNKNOWN_SCRIPT;
                return string;
            }
            System.out.println("**Failed, too many scripts for:\t" + locale + ", " + CLDRScripts);
            String string = result = UNKNOWN_SCRIPT;
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            String temp;
            if (result.equals(UNKNOWN_SCRIPT) && (temp = LANGUAGE_OVERRIDES.get(locale)) != null) {
                result = new LanguageTagParser().set(temp).getScript();
                System.out.println("Getting script from LANGUAGE_OVERRIDES for " + locale + " => " + result);
            }
            localeToScriptCache.put(locale, result);
            if (SHOW_ADD) {
                System.out.println("Script:\t" + locale + "\t" + english.getName(locale) + "\t=>\t" + result + "\t" + english.getName(1, result));
            }
        }
    }

    public static Set<String> getScriptsFromUnicodeSet(UnicodeSet exemplars) {
        BitSet scriptBits = new BitSet();
        boolean show = false;
        UnicodeSetIterator it = new UnicodeSetIterator(exemplars);
        while (it.next()) {
            int cp;
            if (show) {
                System.out.println(Integer.toHexString(it.codepoint));
            }
            if (it.codepoint != UnicodeSetIterator.IS_STRING) {
                scriptBits.set(UScript.getScript(it.codepoint));
                continue;
            }
            for (int i = 0; i < it.string.length(); i += UTF16.getCharCount(cp)) {
                cp = UTF16.charAt(it.string, i);
                scriptBits.set(UScript.getScript(cp));
            }
        }
        scriptBits.clear(0);
        scriptBits.clear(1);
        TreeSet<String> scripts = new TreeSet<String>();
        for (int j = 0; j < scriptBits.size(); ++j) {
            if (!scriptBits.get(j)) continue;
            scripts.add(UScript.getShortName(j));
        }
        return scripts;
    }

    public static UnicodeSet getExemplarSet(CLDRFile cldrfile, String type) {
        String v;
        if (type.length() != 0) {
            type = "[@type=\"" + type + "\"]";
        }
        if ((v = cldrfile.getStringValue("//ldml/characters/exemplarCharacters" + type)) == null) {
            return new UnicodeSet();
        }
        return new UnicodeSet(v);
    }

    static void showDefaultContentDifferencesAndFix(Set<String> defaultLocaleContent) {
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        Map<String, String> oldDefaultContent = SupplementalDataInfo.makeLocaleToDefaultContents(ConvertLanguageData.supplementalData.getDefaultContentLocales(), new TreeMap<String, String>(), errors);
        if (!errors.isEmpty()) {
            System.out.println(Joiner.on("\n").join(errors));
            errors.clear();
        }
        Map<String, String> newDefaultContent = SupplementalDataInfo.makeLocaleToDefaultContents(defaultLocaleContent, new TreeMap<String, String>(), errors);
        if (!errors.isEmpty()) {
            System.out.println("Default Content errors: " + Joiner.on("\n").join(errors));
            errors.clear();
        }
        Set<String> changes = GenerateMaximalLocales.compareMapsAndFixNew("*WARNING* Default Content: ", oldDefaultContent, newDefaultContent, "ar", "ar_001");
        System.out.println(Joiner.on("\n").join(changes));
        defaultLocaleContent.clear();
        defaultLocaleContent.addAll(newDefaultContent.values());
        newDefaultContent = SupplementalDataInfo.makeLocaleToDefaultContents(defaultLocaleContent, new TreeMap<String, String>(), errors);
        if (!errors.isEmpty()) {
            System.out.println("***New Errors: " + Joiner.on("\n").join(errors));
        }
    }

    private static Set<String> compareMapsAndFixNew(String title, Map<String, String> oldContent, Map<String, String> newContent, String ... allowedOverrideValues) {
        HashMap<String, String> allowedOverrideValuesTest = new HashMap<String, String>();
        for (int i = 0; i < allowedOverrideValues.length; i += 2) {
            allowedOverrideValuesTest.put(allowedOverrideValues[i], allowedOverrideValues[i + 1]);
        }
        TreeSet<String> changes = new TreeSet<String>();
        for (String parent : Builder.with(new TreeSet()).addAll((Iterable<String>)newContent.keySet()).addAll((Iterable<String>)oldContent.keySet()).get()) {
            String message;
            String oldValue = oldContent.get(parent);
            String newValue = newContent.get(parent);
            String overrideValue = (String)allowedOverrideValuesTest.get(parent);
            if (overrideValue != null) {
                newContent.put(parent, overrideValue);
                newValue = overrideValue;
            }
            if (CldrUtility.equals(oldValue, newValue)) continue;
            if (oldValue == null) {
                message = "Adding " + ConvertLanguageData.getLanguageCodeAndName(parent) + " => " + ConvertLanguageData.getLanguageCodeAndName(newValue);
                newContent.put(parent, newValue);
            } else if (newValue == null) {
                if (SUPPRESS_CHANGES) {
                    message = "Suppressing removal of " + ConvertLanguageData.getLanguageCodeAndName(parent) + " => " + ConvertLanguageData.getLanguageCodeAndName(oldValue);
                    newContent.put(parent, oldValue);
                } else {
                    message = "Removing " + ConvertLanguageData.getLanguageCodeAndName(parent) + " => " + ConvertLanguageData.getLanguageCodeAndName(oldValue);
                    newContent.remove(oldValue);
                }
            } else if (SUPPRESS_CHANGES) {
                message = "Suppressing change of " + ConvertLanguageData.getLanguageCodeAndName(parent) + " => " + ConvertLanguageData.getLanguageCodeAndName(oldValue) + " to " + ConvertLanguageData.getLanguageCodeAndName(newValue);
                newContent.remove(newValue);
                newContent.put(parent, oldValue);
            } else {
                message = "Changing " + ConvertLanguageData.getLanguageCodeAndName(parent) + " => " + ConvertLanguageData.getLanguageCodeAndName(oldValue) + " to " + ConvertLanguageData.getLanguageCodeAndName(newValue);
                newContent.remove(oldValue);
                newContent.put(parent, newValue);
            }
            changes.add(title + message);
        }
        return changes;
    }

    static {
        for (CLDRLocale locale : ToolConfig.getToolInstance().getCldrFactory().getAvailableCLDRLocales()) {
            String region = locale.getCountry();
            if (region == null || region.isEmpty() || Containment.isLeaf(region)) continue;
            cldrContainerToLanguages.put(region, locale.getLanguage());
        }
        cldrContainerToLanguages.freeze();
        System.out.println("Keep containers " + cldrContainerToLanguages);
        KEEP_TARGETS = Arrays.asList("und_Arab_PK", "und_Latn_ET");
        deprecatedISONotInLST = ImmutableSet.of("scc", "scr");
        MAX_ADDITIONS = new String[]{"bss_Latn_CM", "gez_Ethi_ET", "ken_Latn_CM", "und_Arab_PK", "wa_Latn_BE", "fub_Arab_CM", "fuf_Latn_GN", "kby_Arab_NE", "kdh_Arab_TG", "apd_Arab_TG", "zlm_Latn_TG", "cr_Cans_CA", "hif_Latn_FJ", "gon_Telu_IN", "lzz_Latn_TR", "lif_Deva_NP", "unx_Beng_IN", "unr_Beng_IN", "ttt_Latn_AZ", "pnt_Grek_GR", "tly_Latn_AZ", "tkr_Latn_AZ", "bsq_Bass_LR", "ccp_Cakm_BD", "blt_Tavt_VN", "rhg_Arab_MM", "rhg_Rohg_MM"};
        LANGUAGE_OVERRIDES = CldrUtility.asMap(new String[][]{{"cic", "cic_Latn_US"}, {"cic_Latn", "cic_Latn_US"}, {"eo", "eo_Latn_001"}, {"eo_Latn", "eo_Latn_001"}, {"es", "es_Latn_ES"}, {"es_Latn", "es_Latn_ES"}, {"ff_BF", "ff_Latn_BF"}, {"ff_GM", "ff_Latn_GM"}, {"ff_GH", "ff_Latn_GH"}, {"ff_GW", "ff_Latn_GW"}, {"ff_LR", "ff_Latn_LR"}, {"ff_NE", "ff_Latn_NE"}, {"ff_NG", "ff_Latn_NG"}, {"ff_SL", "ff_Latn_SL"}, {"ff_Adlm", "ff_Adlm_GN"}, {"ia", "ia_Latn_001"}, {"ia_Latn", "ia_Latn_001"}, {"io", "io_Latn_001"}, {"io_Latn", "io_Latn_001"}, {"jbo", "jbo_Latn_001"}, {"jbo_Latn", "jbo_Latn_001"}, {"ku_Arab", "ku_Arab_IQ"}, {"lrc", "lrc_Arab_IR"}, {"lrc_Arab", "lrc_Arab_IR"}, {"man", "man_Latn_GM"}, {"man_Latn", "man_Latn_GM"}, {"mas", "mas_Latn_KE"}, {"mas_Latn", "mas_Latn_KE"}, {"mn", "mn_Cyrl_MN"}, {"mn_Cyrl", "mn_Cyrl_MN"}, {"mro", "mro_Mroo_BD"}, {"mro_BD", "mro_Mroo_BD"}, {"ms_Arab", "ms_Arab_MY"}, {"pap", "pap_Latn_AW"}, {"pap_Latn", "pap_Latn_AW"}, {"prg", "prg_Latn_001"}, {"prg_Latn", "prg_Latn_001"}, {"rif", "rif_Tfng_MA"}, {"rif_Latn", "rif_Latn_MA"}, {"rif_Tfng", "rif_Tfng_MA"}, {"rif_MA", "rif_Tfng_MA"}, {"shi", "shi_Tfng_MA"}, {"shi_Tfng", "shi_Tfng_MA"}, {"shi_MA", "shi_Tfng_MA"}, {"sr_Latn", "sr_Latn_RS"}, {"ss", "ss_Latn_ZA"}, {"ss_Latn", "ss_Latn_ZA"}, {"swc", "swc_Latn_CD"}, {"ti", "ti_Ethi_ET"}, {"ti_Ethi", "ti_Ethi_ET"}, {"und", "en_Latn_US"}, {"und_Adlm", "ff_Adlm_GN"}, {"und_Adlm_GN", "ff_Adlm_GN"}, {"und_Arab", "ar_Arab_EG"}, {"und_Arab_PK", "ur_Arab_PK"}, {"und_Bopo", "zh_Bopo_TW"}, {"und_Deva_FJ", "hif_Deva_FJ"}, {"und_EZ", "de_Latn_EZ"}, {"und_Hani", "zh_Hani_CN"}, {"und_Hani_CN", "zh_Hani_CN"}, {"und_Kana", "ja_Kana_JP"}, {"und_Kana_JP", "ja_Kana_JP"}, {"und_Latn", "en_Latn_US"}, {"und_Latn_ET", "en_Latn_ET"}, {"und_Latn_NE", "ha_Latn_NE"}, {"und_Latn_PH", "fil_Latn_PH"}, {"und_ML", "bm_Latn_ML"}, {"und_Latn_ML", "bm_Latn_ML"}, {"und_MU", "mfe_Latn_MU"}, {"und_NE", "ha_Latn_NE"}, {"und_PH", "fil_Latn_PH"}, {"und_PK", "ur_Arab_PK"}, {"und_SO", "so_Latn_SO"}, {"und_SS", "en_Latn_SS"}, {"und_TK", "tkl_Latn_TK"}, {"und_UN", "en_Latn_UN"}, {"und_005", "pt_Latn_BR"}, {"vo", "vo_Latn_001"}, {"vo_Latn", "vo_Latn_001"}, {"yi", "yi_Hebr_001"}, {"yi_Hebr", "yi_Hebr_001"}, {"yue", "yue_Hant_HK"}, {"yue_Hant", "yue_Hant_HK"}, {"yue_Hans", "yue_Hans_CN"}, {"yue_CN", "yue_Hans_CN"}, {"zh_Hani", "zh_Hani_CN"}, {"zh_Bopo", "zh_Bopo_TW"}, {"ccp", "ccp_Cakm_BD"}, {"ccp_Cakm", "ccp_Cakm_BD"}, {"und_Cakm", "ccp_Cakm_BD"}, {"cu_Glag", "cu_Glag_BG"}, {"sd_Khoj", "sd_Khoj_IN"}, {"lif_Limb", "lif_Limb_IN"}, {"grc_Linb", "grc_Linb_GR"}, {"arc_Nbat", "arc_Nbat_JO"}, {"arc_Palm", "arc_Palm_SY"}, {"pal_Phlp", "pal_Phlp_CN"}, {"en_Shaw", "en_Shaw_GB"}, {"sd_Sind", "sd_Sind_IN"}, {"und_Brai", "fr_Brai_FR"}, {"und_Hanb", "zh_Hanb_TW"}, {"zh_Hanb", "zh_Hanb_TW"}, {"und_Jamo", "ko_Jamo_KR"}, {"mis_Medf", "mis_Medf_NG"}, {"ku_Yezi", "ku_Yezi_GE"}, {"und_EU", "en_Latn_IE"}});
        SpecialScripts = new String[][]{{"zh", "Hans"}, {"yue", "Hant"}, {"chk", "Latn"}, {"fil", "Latn"}, {"ko", "Kore"}, {"ko_KR", "Kore"}, {"pap", "Latn"}, {"pau", "Latn"}, {"su", "Latn"}, {"tet", "Latn"}, {"tk", "Latn"}, {"ty", "Latn"}, {"ja", "Jpan"}, {"und", "Latn"}};
        localeToScriptCache = new TreeMap<String, String>();
        for (String language : standardCodes.getAvailableCodes("language")) {
            Map<String, String> info = standardCodes.getLangData("language", language);
            String string = info.get("Suppress-Script");
            if (string == null) continue;
            localeToScriptCache.put(language, string);
        }
        for (Iterator<Object> iterator : SpecialScripts) {
            localeToScriptCache.put((String)((Object)iterator[0]), (String)((Object)iterator[1]));
        }
        LanguageTagParser additionLtp = new LanguageTagParser();
        TreeMap<String, String> _FALLBACK_SCRIPTS = new TreeMap<String, String>();
        for (String addition : MAX_ADDITIONS) {
            additionLtp.set(addition);
            String lan = additionLtp.getLanguage();
            _FALLBACK_SCRIPTS.put(lan, additionLtp.getScript());
        }
        FALLBACK_SCRIPTS = ImmutableMap.copyOf(_FALLBACK_SCRIPTS);
        percent = NumberFormat.getPercentInstance();
        number = NumberFormat.getIntegerInstance();
        ALT_REVERSAL = new String[][]{{"nb", "no"}, {"no", "nb"}, {"he", "iw"}, {"iw", "he"}};
        UNKNOWN_SCRIPT = "Zzzz";
        UNKNOWN_REGION = "ZZ";
    }

    static enum OutputStyle {
        PLAINTEXT,
        C,
        C_ALT,
        XML;

    }

    static class RowData
    implements Comparable<RowData> {
        SupplementalDataInfo.OfficialStatus os;
        String name;
        Long pop;

        public RowData(SupplementalDataInfo.OfficialStatus os, String name, Long pop) {
            this.os = os;
            this.name = name;
            this.pop = pop;
        }

        public SupplementalDataInfo.OfficialStatus getStatus() {
            return this.os;
        }

        public CharSequence getName() {
            return this.name;
        }

        public Long getLiteratePopulation() {
            return this.pop;
        }

        @Override
        public int compareTo(RowData o) {
            int result = this.os.compareTo(o.os);
            if (result != 0) {
                return -result;
            }
            long result2 = this.pop - o.pop;
            if (result2 != 0L) {
                return result2 < 0L ? 1 : -1;
            }
            return this.name.compareTo(o.name);
        }

        public boolean equals(Object o) {
            return 0 == this.compareTo((RowData)o);
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MaxData {
        Relation<String, Row.R3<Double, String, String>> languages = Relation.of(new TreeMap(), TreeSet.class);
        Map<String, Counter<String>> languagesToScripts = new TreeMap<String, Counter<String>>();
        Map<String, Counter<String>> languagesToRegions = new TreeMap<String, Counter<String>>();
        Relation<String, Row.R3<Double, String, String>> scripts = Relation.of(new TreeMap(), TreeSet.class);
        Map<String, Counter<String>> scriptsToLanguages = new TreeMap<String, Counter<String>>();
        Map<String, Counter<String>> scriptsToRegions = new TreeMap<String, Counter<String>>();
        Relation<String, Row.R3<Double, String, String>> regions = Relation.of(new TreeMap(), TreeSet.class);
        Map<String, Counter<String>> regionsToLanguages = new TreeMap<String, Counter<String>>();
        Map<String, Counter<String>> regionsToScripts = new TreeMap<String, Counter<String>>();
        Map<String, Counter<Row.R2<String, String>>> containersToLanguage = new TreeMap<String, Counter<Row.R2<String, String>>>();
        Relation<String, Row.R4<Double, String, String, String>> containersToLangRegion = Relation.of(new TreeMap(), TreeSet.class);
        Relation<Row.R2<String, String>, Row.R2<Double, String>> languageScripts = Relation.of(new TreeMap(), TreeSet.class);
        Relation<Row.R2<String, String>, Row.R2<Double, String>> scriptRegions = Relation.of(new TreeMap(), TreeSet.class);
        Relation<Row.R2<String, String>, Row.R2<Double, String>> languageRegions = Relation.of(new TreeMap(), TreeSet.class);

        private MaxData() {
        }

        void add(String language, String script, String region, Double order) {
            if (language.equals("cpp")) {
                System.out.println(language + "\t" + script + "\t" + region + "\t" + -order.doubleValue());
            }
            this.languages.put(language, Row.of(order, script, region));
            this.scripts.put(script, Row.of(order, language, region));
            this.regions.put(region, Row.of(order, language, script));
            this.languageScripts.put(Row.of(language, script), Row.of(order, region));
            this.scriptRegions.put(Row.of(script, region), Row.of(order, language));
            this.languageRegions.put(Row.of(language, region), Row.of(order, script));
            Set<String> containerSet = Containment.leafToContainer(region);
            if (containerSet != null) {
                for (String container : containerSet) {
                    this.containersToLangRegion.put(container, Row.of(order, language, script, region));
                    Counter<Row.R2<String, String>> data = this.containersToLanguage.get(container);
                    if (data == null) {
                        data = new Counter();
                        this.containersToLanguage.put(container, data);
                    }
                    data.add(Row.of(language, script), (long)order.doubleValue());
                }
            }
            if (SHOW_ADD) {
                System.out.println("Data:\t" + language + "\t" + script + "\t" + region + "\t" + order);
            }
        }
    }

    static enum LocaleOverride {
        KEEP_EXISTING,
        REPLACE_EXISTING;

    }

    public static class LocaleStringComparator
    implements Comparator<String> {
        LanguageTagParser ltp0 = new LanguageTagParser();
        LanguageTagParser ltp1 = new LanguageTagParser();

        @Override
        public int compare(String arg0, String arg1) {
            this.ltp0.set(arg0);
            this.ltp1.set(arg1);
            String s0 = this.ltp0.getLanguage();
            String s1 = this.ltp1.getLanguage();
            int result = s0.compareTo(s1);
            if (result != 0) {
                return s0.equals("und") ? 1 : (s1.equals("und") ? -1 : result);
            }
            s0 = this.ltp0.getScript();
            result = s0.compareTo(s1 = this.ltp1.getScript());
            if (result != 0) {
                return result;
            }
            s0 = this.ltp0.getRegion();
            result = s0.compareTo(s1 = this.ltp1.getRegion());
            if (result != 0) {
                return result;
            }
            return arg0.compareTo(arg1);
        }
    }
}

