/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.SubdivisionNames;
import org.unicode.cldr.tool.SubdivisionNode;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Validity;

public class GenerateSubdivisions {
    private static final String ISO_COUNTRY_CODES = CLDRPaths.CLDR_PRIVATE_DIRECTORY + "iso_country_codes/";
    static final String ISO_SUBDIVISION_CODES = ISO_COUNTRY_CODES + "iso_country_codes.xml";

    public static void main(String[] args) throws IOException {
        boolean preprocess;
        CLDRConfig.getInstance().getSupplementalDataInfo();
        boolean bl = preprocess = args.length > 0;
        if (preprocess) {
            for (String source : Arrays.asList("2015-05-04_iso_country_code_ALL_xml", "2016-01-13_iso_country_code_ALL_xml", "2016-12-09_iso_country_code_ALL_xml", "2017-02-12_iso_country_code_ALL_xml", "2017-09-15_iso_country_code_ALL_xml", "2018-02-20_iso_country_code_ALL_xml", "2018-09-02_iso_country_code_ALL_xml", "2019-02-26_iso_country_code_ALL_xml", "2020-03-05_iso_country_code_ALL_xml")) {
                SubdivisionNode.SubdivisionSet sdset1 = new SubdivisionNode.SubdivisionSet(CLDRPaths.CLDR_PRIVATE_DIRECTORY + source + "/iso_country_codes.xml");
                PrintWriter pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "subdivision/" + source + ".txt");
                try {
                    sdset1.print(pw);
                }
                finally {
                    if (pw == null) continue;
                    pw.close();
                }
            }
            return;
        }
        SubdivisionNode.SubdivisionSet sdset1 = new SubdivisionNode.SubdivisionSet(ISO_SUBDIVISION_CODES);
        SubdivisionNode.SubDivisionExtractor sdset = new SubdivisionNode.SubDivisionExtractor(sdset1, SubdivisionInfo.VALIDITY_FORMER, SubdivisionInfo.SUBDIVISION_ALIASES_FORMER, SubdivisionInfo.formerRegionToSubdivisions);
        try (PrintWriter pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "subdivision/subdivisions.xml");){
            sdset.printXml(pw);
        }
        pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "subdivision/subdivisionAliases.txt");
        try {
            sdset.printAliases(pw);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "subdivision/en.xml");
        try {
            sdset.printEnglish(pw);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "subdivision/categories.txt");
        try {
            sdset.printSamples(pw);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "subdivision/en.txt");
        try {
            sdset.printEnglishComp(pw);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "subdivision/en-full.txt");
        try {
            sdset.printEnglishCompFull(pw);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "subdivision/missing-mid.txt");
        try {
            sdset.printMissingMIDs(pw);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    static final class SubdivisionInfo {
        static final SupplementalDataInfo SDI_LAST = SupplementalDataInfo.getInstance(CLDRPaths.LAST_RELEASE_DIRECTORY + "common/supplemental/");
        static final Map<String, Row.R2<List<String>, String>> SUBDIVISION_ALIASES_FORMER = SDI_LAST.getLocaleAliasInfo().get("subdivision");
        static final SubdivisionNames SUBDIVISION_NAMES_ENGLISH_FORMER = new SubdivisionNames("en", "main", "subdivisions");
        static final Validity VALIDITY_FORMER = Validity.getInstance(CLDRPaths.LAST_RELEASE_DIRECTORY + "common/validity/");
        static final Relation<String, String> formerRegionToSubdivisions = Relation.of(new HashMap(), TreeSet.class, SubdivisionNode.ROOT_COL);
        static final Multimap<String, String> subdivisionIdToOld;

        SubdivisionInfo() {
        }

        static {
            Map<Validity.Status, Set<String>> oldSubdivisionData = VALIDITY_FORMER.getStatusToCodes(StandardCodes.LstrType.subdivision);
            for (Map.Entry<Validity.Status, Set<String>> e : oldSubdivisionData.entrySet()) {
                Validity.Status status = e.getKey();
                if (status == Validity.Status.unknown) continue;
                for (String sdCode : e.getValue()) {
                    String region = SubdivisionNames.getRegionFromSubdivision(sdCode);
                    formerRegionToSubdivisions.put(region, sdCode);
                }
            }
            formerRegionToSubdivisions.freeze();
            subdivisionIdToOld = HashMultimap.create();
            for (Map.Entry<String, Row.R2<List<String>, String>> entry : SUBDIVISION_ALIASES_FORMER.entrySet()) {
                String oldId = entry.getKey();
                for (String newId : (List)entry.getValue().get0()) {
                    subdivisionIdToOld.put(newId, oldId);
                }
            }
        }
    }
}

