/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.unicode.cldr.util.CLDRTool;

@CLDRTool(alias="main", description="The 'main' class invoked when java -jar or doubleclicking the jar.", hidden="Hidden so as not to list itself", url="http://cldr.unicode.org/tools/")
class Main {
    private static final String CLASS_SUFFIX = ".class";
    private static final String MAIN = "main";
    public static final String TOOLSURL = "http://cldr.unicode.org/tools/";

    Main() {
    }

    public static void main(String[] args) throws Throwable {
        if (args.length == 0) {
            System.out.println("Usage:  [ -l | [class|alias] args ...]");
            System.out.println("Example usage:");
            System.out.println(" (java -jar cldr.jar ) -l          -- prints a list of ALL tool/util/test classes with a 'main()' function.");
            System.out.println(" (java -jar cldr.jar ) org.unicode.cldr.util.XMLValidator  somefile.xml ...");
            System.out.println(" (java -jar cldr.jar ) validate  somefile.xml ...");
            System.out.println("For more info: http://cldr.unicode.org/tools/");
            System.out.println("CLDRFile.GEN_VERSION=38.1");
            System.out.println("(Use the -l option to list hidden/undocumented tools)");
            System.out.println();
            Main.listClasses(false, null);
        } else if (args.length == 1 && args[0].equals("-l")) {
            Main.listClasses(true, null);
        } else {
            String mainClass = args[0];
            String[] args2 = new String[args.length - 1];
            System.arraycopy(args, 1, args2, 0, args2.length);
            Class<?> c = null;
            try {
                c = Class.forName(mainClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c == null) {
                c = Main.listClasses(false, mainClass);
            }
            if (c == null) {
                throw new IllegalArgumentException("Class not found and not an alias: " + mainClass);
            }
            if (c == Main.class) {
                throw new IllegalArgumentException("Cowardly refusing to invoke myself recursively. Stop.");
            }
            Method main = Main.getStaticMain(c);
            System.err.println(">> " + c.getName());
            main.invoke(null, new Object[]{args2});
        }
    }

    public static Class<?> listClasses(boolean showAll, String match) throws IOException, FileNotFoundException {
        JarEntry je;
        JarInputStream jis = Main.getJarInputStream();
        ClassLoader classLoader = Main.class.getClassLoader();
        if (jis == null) {
            return null;
        }
        while ((je = jis.getNextJarEntry()) != null) {
            String name = je.getName();
            if (!Main.inOuterClass(name)) continue;
            String className = Main.filenameToClassName(name);
            try {
                Method method;
                Class<?> c = Class.forName(className, false, classLoader);
                if (match != null && !showAll && !c.isAnnotationPresent(CLDRTool.class) || (method = Main.getStaticMain(c)) == null) continue;
                CLDRTool annotation = c.getAnnotation(CLDRTool.class);
                if (match == null) {
                    if (!showAll && (annotation == null || annotation.hidden().length() != 0)) continue;
                    if (annotation != null) {
                        System.out.println("" + annotation.alias() + " - " + annotation.description());
                        if (annotation.url().length() > 0) {
                            System.out.println("   <" + annotation.url() + ">");
                        } else {
                            System.out.println("   <http://cldr.unicode.org/tools/" + annotation.alias() + ">");
                        }
                        System.out.println(" = " + className);
                        if (annotation.hidden().length() > 0) {
                            System.out.println("   HIDDEN: " + annotation.hidden());
                        }
                        System.out.println();
                        continue;
                    }
                    System.out.print("   " + className);
                    System.out.println(" (no @CLDRTool annotation)");
                    continue;
                }
                if (match.equalsIgnoreCase(className)) {
                    return c;
                }
                if (annotation == null || annotation.alias().length() <= 0 || !match.equalsIgnoreCase(annotation.alias())) continue;
                return c;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public static Method getStaticMain(Class<?> c) throws NoSuchMethodException {
        return c.getMethod(MAIN, String[].class);
    }

    public static String filenameToClassName(String name) {
        return name.substring(0, name.length() - CLASS_SUFFIX.length()).replaceAll("/", ".");
    }

    public static boolean inOuterClass(String name) {
        return name.endsWith(CLASS_SUFFIX) && !name.contains("$");
    }

    public static JarInputStream getJarInputStream() throws IOException, FileNotFoundException {
        URL url = Main.class.getProtectionDomain().getCodeSource().getLocation();
        if (!url.getPath().endsWith(".jar")) {
            System.out.println("(Not inside a .jar file - no listing available.)");
            return null;
        }
        JarInputStream jis = new JarInputStream(new FileInputStream(url.getPath()));
        Object je = null;
        return jis;
    }
}

