/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeFilter;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.TestTransforms;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class CLDRTransforms {
    public static final String TRANSFORM_DIR = CLDRPaths.COMMON_DIRECTORY + "transforms/";
    static final CLDRTransforms SINGLETON = new CLDRTransforms();
    final Set<String> overridden = new HashSet<String>();
    final DependencyOrder dependencyOrder = new DependencyOrder();
    static Transliterator fixup = Transliterator.getInstance("[:Mn:]any-hex/java");
    public static Pattern TRANSFORM_ID_PATTERN = PatternCache.get("(.+)-([^/]+)(/(.*))?");
    private BiMap<String, String> displayNameToId = HashBiMap.create();
    Appendable showProgress;
    Map<String, RuleDirection> idToRules = new TreeMap<String, RuleDirection>();

    public static CLDRTransforms getInstance() {
        return SINGLETON;
    }

    public Appendable getShowProgress() {
        return this.showProgress;
    }

    public CLDRTransforms setShowProgress(Appendable showProgress) {
        this.showProgress = showProgress;
        return this;
    }

    public static void registerCldrTransforms(String dir, String namesMatchingRegex, Appendable showProgress, boolean keepDashTIds) {
        Set<String> ordered;
        List<String> files;
        CLDRTransforms r = CLDRTransforms.getInstance();
        if (dir == null) {
            dir = TRANSFORM_DIR;
        }
        r.showProgress = showProgress;
        if (namesMatchingRegex == null) {
            files = CLDRTransforms.getAvailableIds();
            ordered = r.dependencyOrder.getOrderedItems(files, null, true);
        } else {
            Matcher filter = PatternCache.get(namesMatchingRegex).matcher("");
            r.deregisterIcuTransliterators(filter);
            files = Arrays.asList(new File(TRANSFORM_DIR).list(new RegexFindFilenameFilter(filter)));
            ordered = r.dependencyOrder.getOrderedItems(files, filter, true);
        }
        for (String cldrFileName : ordered) {
            r.registerTransliteratorsFromXML(dir, cldrFileName, files, keepDashTIds);
        }
        Transliterator.registerAny();
    }

    public static List<String> getAvailableIds() {
        return Arrays.asList(new File(TRANSFORM_DIR).list());
    }

    public Set<String> getOverriddenTransliterators() {
        return Collections.unmodifiableSet(this.overridden);
    }

    public Transliterator getInstance(String id) {
        if (!this.overridden.contains(id)) {
            throw new IllegalArgumentException("No overriden transform for " + id);
        }
        return Transliterator.getInstance(id);
    }

    public Transliterator getReverseInstance(String id) {
        Matcher matcher = TRANSFORM_ID_PATTERN.matcher(id);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("**No transform for " + id);
        }
        return this.getInstance(matcher.group(2) + "-" + matcher.group(1) + (matcher.group(4) == null ? "" : "/" + matcher.group(4)));
    }

    public BiMap<String, String> getDisplayNameToId() {
        return this.displayNameToId;
    }

    private void addDisplayNameToId(Map<String, String> ids2, ParsedTransformID directionInfo) {
        this.displayNameToId.put(directionInfo.getDisplayId(), directionInfo.toString());
    }

    public void registerTransliteratorsFromXML(String dir, String cldrFileName, List<String> cantSkip, boolean keepDashTIds) {
        String ruleString;
        ParsedTransformID directionInfo = new ParsedTransformID();
        String cldrFileName2 = cldrFileName + ".xml";
        try {
            ruleString = CLDRTransforms.getIcuRulesFromXmlFile(dir, cldrFileName2, directionInfo);
        }
        catch (RuntimeException e) {
            if (!cantSkip.contains(cldrFileName2)) {
                return;
            }
            throw e;
        }
        String id = directionInfo.getId();
        this.addDisplayNameToId(this.displayNameToId, directionInfo);
        if (directionInfo.getDirection() == Direction.both || directionInfo.getDirection() == Direction.forward) {
            this.internalRegister(id, ruleString, 0);
            for (String alias : directionInfo.getAliases()) {
                if (!keepDashTIds && alias.contains("-t-")) continue;
                Transliterator.registerAlias(alias, id);
            }
        }
        if (directionInfo.getDirection() == Direction.both || directionInfo.getDirection() == Direction.backward) {
            this.internalRegister(id, ruleString, 1);
            for (String alias : directionInfo.getBackwardAliases()) {
                if (!keepDashTIds && alias.contains("-t-")) continue;
                Transliterator.registerAlias(alias, directionInfo.getBackwardId());
            }
        }
    }

    public static String getIcuRulesFromXmlFile(String dir, String cldrFileName, ParsedTransformID directionInfo) {
        MyHandler myHandler = new MyHandler(cldrFileName, directionInfo);
        XMLFileReader xfr = new XMLFileReader().setHandler(myHandler);
        xfr.read(dir + cldrFileName, XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, true);
        return myHandler.getRules();
    }

    private void internalRegister(String id, String ruleString, int direction) {
        if (direction == 1) {
            id = ParsedTransformID.reverse(id);
        }
        this.internalRegisterNoReverseId(id, ruleString, direction);
    }

    private void internalRegisterNoReverseId(String id, String ruleString, int direction) {
        try {
            Transliterator t = Transliterator.createFromRules(id, ruleString, direction);
            this.overridden.add(id);
            Transliterator oldTranslit = null;
            if (this.showProgress != null) {
                try {
                    oldTranslit = Transliterator.getInstance(id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Transliterator.unregister(id);
            Transliterator.registerInstance(t);
            if (this.showProgress != null) {
                this.append("Registered new Transliterator: " + id + (oldTranslit == null ? "" : "\told:\t" + oldTranslit.getID()) + '\n');
                if (id.startsWith("el-")) {
                    TestTransforms.showTransliterator("", t, 999);
                    Transliterator t2 = Transliterator.getInstance(id);
                    TestTransforms.showTransliterator("", t2, 999);
                }
            }
        }
        catch (RuntimeException e) {
            if (this.showProgress != null) {
                e.printStackTrace();
                this.append("Couldn't register new Transliterator: " + id + "\t" + e.getMessage() + '\n');
            }
            throw (IllegalArgumentException)new IllegalArgumentException("Couldn't register new Transliterator: " + id).initCause(e);
        }
    }

    private void append(String string) {
        try {
            if (this.showProgress == null) {
                return;
            }
            this.showProgress.append(string);
            if (this.showProgress instanceof Writer) {
                ((Writer)this.showProgress).flush();
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private void appendln(String s2) {
        this.append(s2 + "\n");
    }

    public void registerFromIcuFormatFiles(String directory) throws IOException {
        String line;
        this.deregisterIcuTransliterators((Matcher)null);
        Matcher getId = PatternCache.get("\\s*(\\S*)\\s*\\{\\s*").matcher("");
        Matcher getSource = PatternCache.get("\\s*(\\S*)\\s*\\{\\s*\\\"(.*)\\\".*").matcher("");
        Matcher translitID = PatternCache.get("([^-]+)-([^/]+)+(?:[/](.+))?").matcher("");
        TreeMap<String, String> fixedIDs = new TreeMap<String, String>();
        TreeSet<String> oddIDs = new TreeSet<String>();
        File dir = new File(directory);
        BufferedReader input = FileUtilities.openUTF8Reader(directory, "root.txt");
        String id2 = null;
        String filename = null;
        LinkedHashMap<String, Object> aliasMap = new LinkedHashMap<String, Object>();
        while ((line = input.readLine()) != null) {
            if ((line = line.trim()).startsWith("\ufeff")) {
                line = line.substring(1);
            }
            if (line.startsWith("TransliteratorNamePattern")) break;
            if (getId.reset(line).matches()) {
                String temp = getId.group(1);
                if (temp.equals("file") || temp.equals("internal")) continue;
                id2 = temp;
                continue;
            }
            if (getSource.reset(line).matches()) {
                String operation = getSource.group(1);
                String source = getSource.group(2);
                if (operation.equals("alias")) {
                    aliasMap.put(id2, source);
                    this.checkIdFix(id2, fixedIDs, oddIDs, translitID);
                    id2 = null;
                    continue;
                }
                if (operation.equals("resource:process(transliterator)")) {
                    filename = source;
                    continue;
                }
                if (operation.equals("direction")) {
                    try {
                        if (id2 == null || filename == null) continue;
                        if (filename.indexOf("InterIndic") < 0 || filename.indexOf("Latin") >= 0) {
                            // empty if block
                        }
                        this.checkIdFix(id2, fixedIDs, oddIDs, translitID);
                        int direction = source.equals("FORWARD") ? 0 : 1;
                        this.registerFromIcuFile(id2, directory, filename, direction);
                        CLDRTransforms.verifyNullFilter("halfwidth-fullwidth");
                        id2 = null;
                        filename = null;
                        continue;
                    }
                    catch (RuntimeException e) {
                        throw (RuntimeException)new IllegalArgumentException("Failed with " + (String)filename + ", " + (String)source).initCause(e);
                    }
                }
                this.append(dir + "root.txt unhandled line:" + line);
                continue;
            }
            String trimmed = line.trim();
            if (trimmed.equals("") || trimmed.equals("}") || trimmed.startsWith("//")) continue;
            throw new IllegalArgumentException("Unhandled:" + line);
        }
        Set<String> rawIds = this.idToRules.keySet();
        Set<String> ordered = this.dependencyOrder.getOrderedItems(rawIds, null, false);
        ordered.retainAll(rawIds);
        for (String id2 : ordered) {
            RuleDirection stuff = this.idToRules.get(id2);
            this.internalRegisterNoReverseId(id2, stuff.ruleString, stuff.direction);
            CLDRTransforms.verifyNullFilter("halfwidth-fullwidth");
        }
        for (String id2 : aliasMap.keySet()) {
            String source = (String)aliasMap.get(id2);
            Transliterator.unregister(id2);
            Transliterator t = Transliterator.createFromRules(id2, "::" + source + ";", 0);
            Transliterator.registerInstance(t);
            this.appendln("Registered new Transliterator Alias: " + id2);
        }
        this.appendln("Fixed IDs");
        for (String id2 : fixedIDs.keySet()) {
            this.appendln("\t" + id2 + "\t" + (String)fixedIDs.get(id2));
        }
        this.appendln("Odd IDs");
        for (String id2 : oddIDs) {
            this.appendln("\t" + id2);
        }
        Transliterator.registerAny();
    }

    private void registerFromIcuFile(String id, String directory, String filename, int direction) {
        if (filename == null) {
            filename = id.replace("-", "_").replace("/", "_") + ".txt";
        }
        String ruleString = CldrUtility.getText(directory, filename);
        this.idToRules.put(id, new RuleDirection(ruleString, direction));
    }

    public void checkIdFix(String id, Map<String, String> fixedIDs, Set<String> oddIDs, Matcher translitID) {
        if (fixedIDs.containsKey(id)) {
            return;
        }
        if (!translitID.reset(id).matches()) {
            this.appendln("Can't fix: " + id);
            fixedIDs.put(id, "?" + id);
            return;
        }
        String source1 = translitID.group(1);
        String target1 = translitID.group(2);
        String variant = translitID.group(3);
        String source = CLDRTransforms.fixID(source1);
        String target = CLDRTransforms.fixID(target1);
        if (!source1.equals(source)) {
            fixedIDs.put(source1, source);
        }
        if (!target1.equals(target)) {
            fixedIDs.put(target1, target);
        }
        if (variant != null) {
            oddIDs.add("variant: " + variant);
        }
    }

    static String fixID(String source) {
        return source;
    }

    public void deregisterIcuTransliterators(Matcher filter) {
        ArrayList<String> rawAvailable = new ArrayList<String>();
        Enumeration<String> en = Transliterator.getAvailableIDs();
        while (en.hasMoreElements()) {
            String id = en.nextElement();
            if (filter != null && !filter.reset(id).matches()) continue;
            rawAvailable.add(id);
        }
        Set<String> available = this.dependencyOrder.getOrderedItems(rawAvailable, filter, false);
        LinkedList<String> reversed = new LinkedList<String>();
        for (String item : available) {
            reversed.add(0, item);
        }
        this.deregisterIcuTransliterators(reversed);
        Enumeration<String> en2 = Transliterator.getAvailableIDs();
        while (en2.hasMoreElements()) {
            String oldId = en2.nextElement();
            this.append("Retaining: " + oldId + "\n");
        }
    }

    public void deregisterIcuTransliterators(Collection<String> available) {
        for (String oldId : available) {
            Transliterator t;
            try {
                t = Transliterator.getInstance(oldId);
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().startsWith("Illegal ID")) continue;
                this.append("Failure with: " + oldId);
                t = Transliterator.getInstance(oldId);
                throw e;
            }
            catch (RuntimeException e) {
                this.append("Failure with: " + oldId);
                t = Transliterator.getInstance(oldId);
                throw e;
            }
            String className = t.getClass().getName();
            if (className.endsWith(".CompoundTransliterator") || className.endsWith(".RuleBasedTransliterator") || className.endsWith(".AnyTransliterator")) {
                this.appendln("REMOVING: " + oldId);
                Transliterator.unregister(oldId);
                continue;
            }
            this.appendln("Retaining: " + oldId + "\t\t" + className);
        }
    }

    public static void verifyNullFilter(String id) {
        Transliterator widen;
        try {
            widen = Transliterator.getInstance(id);
        }
        catch (Exception e) {
            return;
        }
        UnicodeFilter filter = widen.getFilter();
        if (filter != null) {
            throw new IllegalArgumentException(id + " has non-empty filter: " + filter);
        }
    }

    class DependencyOrder {
        Relation<Matcher, String> dependsOn = Relation.of(new LinkedHashMap(), LinkedHashSet.class);

        DependencyOrder() {
            this.addDependency("Latin-(Jamo|Hangul)(/.*)?", "Latin-ConjoiningJamo", "ConjoiningJamo-Latin");
            this.addDependency("(Jamo|Hangul)-Latin(/.*)?", "Latin-ConjoiningJamo", "ConjoiningJamo-Latin");
            this.addDependency("Latin-Han(/.*)", "Han-Spacedhan");
            this.addDependency(".*(Hiragana|Katakana|Han|han).*", "Fullwidth-Halfwidth", "Halfwidth-Fullwidth");
            this.addDependency(".*(Hiragana).*", "Latin-Katakana", "Katakana-Latin");
            this.addInterIndicDependency("Arabic");
            this.addInterIndicDependency("Bengali");
            this.addInterIndicDependency("Devanagari");
            this.addInterIndicDependency("Gujarati");
            this.addInterIndicDependency("Gurmukhi");
            this.addInterIndicDependency("Kannada");
            this.addInterIndicDependency("Malayalam");
            this.addInterIndicDependency("Oriya");
            this.addInterIndicDependency("Tamil");
            this.addInterIndicDependency("Telugu");
            this.addInterIndicDependency("ur");
            this.addDependency(".*Digit.*", "NumericPinyin-Pinyin", "Pinyin-NumericPinyin");
            this.addDependency("Latin-NumericPinyin(/.*)?", "Tone-Digit", "Digit-Tone");
            this.addDependency("NumericPinyin-Latin(/.*)?", "Tone-Digit", "Digit-Tone");
            this.addDependency("am-ar", "am-am_FONIPA", "und_FONIPA-ar");
            this.addDependency("am-chr", "am-am_FONIPA", "und_FONIPA-chr");
            this.addDependency("am-fa", "am-am_FONIPA", "und_FONIPA-fa");
            this.addDependency("ch-am", "ch-ch_FONIPA", "am-am_FONIPA");
            this.addDependency("ch-ar", "ch-ch_FONIPA", "und_FONIPA-ar");
            this.addDependency("ch-chr", "ch-ch_FONIPA", "und_FONIPA-chr");
            this.addDependency("ch-fa", "ch-ch_FONIPA", "und_FONIPA-fa");
            this.addDependency("cs-am", "cs-cs_FONIPA", "am-am_FONIPA");
            this.addDependency("cs-ar", "cs-cs_FONIPA", "und_FONIPA-ar");
            this.addDependency("cs-chr", "cs-cs_FONIPA", "und_FONIPA-chr");
            this.addDependency("cs-fa", "cs-cs_FONIPA", "und_FONIPA-fa");
            this.addDependency("cs-ja", "cs-cs_FONIPA", "cs_FONIPA-ja");
            this.addDependency("cs_FONIPA-ko", "Latin-Hangul");
            this.addDependency("cs-ko", "cs-cs_FONIPA", "cs_FONIPA-ko");
            this.addDependency("de-ASCII", "Any-ASCII");
            this.addDependency("eo-am", "eo-eo_FONIPA", "am-am_FONIPA");
            this.addDependency("eo-ar", "eo-eo_FONIPA", "und_FONIPA-ar");
            this.addDependency("eo-chr", "eo-eo_FONIPA", "und_FONIPA-chr");
            this.addDependency("eo-fa", "eo-eo_FONIPA", "und_FONIPA-fa");
            this.addDependency("es-am", "es-es_FONIPA", "am-am_FONIPA");
            this.addDependency("es-ar", "es-es_FONIPA", "und_FONIPA-ar");
            this.addDependency("es-chr", "es-es_FONIPA", "und_FONIPA-chr");
            this.addDependency("es-fa", "es-es_FONIPA", "und_FONIPA-fa");
            this.addDependency("es_419-am", "es-es_FONIPA", "es_FONIPA-es_419_FONIPA", "am-am_FONIPA");
            this.addDependency("es_419-ar", "es-es_FONIPA", "es_FONIPA-es_419_FONIPA", "und_FONIPA-ar");
            this.addDependency("es_419-chr", "es-es_FONIPA", "es_FONIPA-es_419_FONIPA", "und_FONIPA-chr");
            this.addDependency("es_419-fa", "es-es_FONIPA", "es_FONIPA-es_419_FONIPA", "und_FONIPA-fa");
            this.addDependency("es_419-ja", "es-es_FONIPA", "es_FONIPA-es_419_FONIPA", "es_FONIPA-ja");
            this.addDependency("es-am", "es-es_FONIPA", "es_FONIPA-am");
            this.addDependency("es-ja", "es-es_FONIPA", "es_FONIPA-ja");
            this.addDependency("es-zh", "es-es_FONIPA", "es_FONIPA-zh");
            this.addDependency("Han-Latin-Names", "Han-Latin");
            this.addDependency("hy-am", "hy-hy_FONIPA", "am-am_FONIPA");
            this.addDependency("hy-ar", "hy-hy_FONIPA", "und_FONIPA-ar");
            this.addDependency("hy-chr", "hy-hy_FONIPA", "und_FONIPA-chr");
            this.addDependency("hy-fa", "hy-hy_FONIPA", "und_FONIPA-fa");
            this.addDependency("hy_AREVMDA-am", "hy_AREVMDA-hy_AREVMDA_FONIPA", "am-am_FONIPA");
            this.addDependency("hy_AREVMDA-ar", "hy_AREVMDA-hy_AREVMDA_FONIPA", "und_FONIPA-ar");
            this.addDependency("hy_AREVMDA-chr", "hy_AREVMDA-hy_AREVMDA_FONIPA", "und_FONIPA-chr");
            this.addDependency("hy_AREVMDA-fa", "hy_AREVMDA-hy_AREVMDA_FONIPA", "und_FONIPA-fa");
            this.addDependency("ia-am", "ia-ia_FONIPA", "am-am_FONIPA");
            this.addDependency("ia-ar", "ia-ia_FONIPA", "und_FONIPA-ar");
            this.addDependency("ia-chr", "ia-ia_FONIPA", "und_FONIPA-chr");
            this.addDependency("ia-fa", "ia-ia_FONIPA", "und_FONIPA-fa");
            this.addDependency("kk-am", "kk-kk_FONIPA", "am-am_FONIPA");
            this.addDependency("kk-ar", "kk-kk_FONIPA", "und_FONIPA-ar");
            this.addDependency("kk-chr", "kk-kk_FONIPA", "und_FONIPA-chr");
            this.addDependency("kk-fa", "kk-kk_FONIPA", "und_FONIPA-fa");
            this.addDependency("ky-am", "ky-ky_FONIPA", "am-am_FONIPA");
            this.addDependency("ky-ar", "ky-ky_FONIPA", "und_FONIPA-ar");
            this.addDependency("ky-chr", "ky-ky_FONIPA", "und_FONIPA-chr");
            this.addDependency("ky-fa", "ky-ky_FONIPA", "und_FONIPA-fa");
            this.addDependency("my-am", "my-my_FONIPA", "am-am_FONIPA");
            this.addDependency("my-ar", "my-my_FONIPA", "und_FONIPA-ar");
            this.addDependency("my-chr", "my-my_FONIPA", "und_FONIPA-chr");
            this.addDependency("my-fa", "my-my_FONIPA", "und_FONIPA-fa");
            this.addDependency("pl-am", "pl-pl_FONIPA", "am-am_FONIPA");
            this.addDependency("pl-ar", "pl-pl_FONIPA", "und_FONIPA-ar");
            this.addDependency("pl-chr", "pl-pl_FONIPA", "und_FONIPA-chr");
            this.addDependency("pl-fa", "pl-pl_FONIPA", "und_FONIPA-fa");
            this.addDependency("pl-ja", "pl-pl_FONIPA", "pl_FONIPA-ja");
            this.addDependency("rm_SURSILV-am", "rm_SURSILV-rm_FONIPA_SURSILV", "am-am_FONIPA");
            this.addDependency("rm_SURSILV-ar", "rm_SURSILV-rm_FONIPA_SURSILV", "und_FONIPA-ar");
            this.addDependency("rm_SURSILV-chr", "rm_SURSILV-rm_FONIPA_SURSILV", "und_FONIPA-chr");
            this.addDependency("rm_SURSILV-fa", "rm_SURSILV-rm_FONIPA_SURSILV", "und_FONIPA-fa");
            this.addDependency("ro-am", "ro-ro_FONIPA", "am-am_FONIPA");
            this.addDependency("ro-ar", "ro-ro_FONIPA", "und_FONIPA-ar");
            this.addDependency("ro-chr", "ro-ro_FONIPA", "und_FONIPA-chr");
            this.addDependency("ro-fa", "ro-ro_FONIPA", "und_FONIPA-fa");
            this.addDependency("ro-ja", "ro-ro_FONIPA", "ro_FONIPA-ja");
            this.addDependency("sat-am", "sat_Olck-sat_FONIPA", "am-am_FONIPA");
            this.addDependency("sat-ar", "sat_Olck-sat_FONIPA", "und_FONIPA-ar");
            this.addDependency("sat-chr", "sat_Olck-sat_FONIPA", "und_FONIPA-chr");
            this.addDependency("sat-fa", "sat_Olck-sat_FONIPA", "und_FONIPA-fa");
            this.addDependency("si-am", "si-si_FONIPA", "am-am_FONIPA");
            this.addDependency("si-ar", "si-si_FONIPA", "und_FONIPA-ar");
            this.addDependency("si-chr", "si-si_FONIPA", "und_FONIPA-chr");
            this.addDependency("si-fa", "si-si_FONIPA", "und_FONIPA-fa");
            this.addDependency("sk-am", "sk-sk_FONIPA", "am-am_FONIPA");
            this.addDependency("sk-ar", "sk-sk_FONIPA", "und_FONIPA-ar");
            this.addDependency("sk-chr", "sk-sk_FONIPA", "und_FONIPA-chr");
            this.addDependency("sk-fa", "sk-sk_FONIPA", "und_FONIPA-fa");
            this.addDependency("sk-ja", "sk-sk_FONIPA", "sk_FONIPA-ja");
            this.addDependency("tlh-am", "tlh-tlh_FONIPA", "am-am_FONIPA");
            this.addDependency("tlh-ar", "tlh-tlh_FONIPA", "und_FONIPA-ar");
            this.addDependency("tlh-chr", "tlh-tlh_FONIPA", "und_FONIPA-chr");
            this.addDependency("tlh-fa", "tlh-tlh_FONIPA", "und_FONIPA-fa");
            this.addDependency("xh-am", "xh-xh_FONIPA", "am-am_FONIPA");
            this.addDependency("xh-ar", "xh-xh_FONIPA", "und_FONIPA-ar");
            this.addDependency("xh-chr", "xh-xh_FONIPA", "und_FONIPA-chr");
            this.addDependency("xh-fa", "xh-xh_FONIPA", "und_FONIPA-fa");
            this.addDependency("zu-am", "zu-zu_FONIPA", "am-am_FONIPA");
            this.addDependency("zu-ar", "zu-zu_FONIPA", "und_FONIPA-ar");
            this.addDependency("zu-chr", "zu-zu_FONIPA", "und_FONIPA-chr");
            this.addDependency("zu-fa", "zu-zu_FONIPA", "und_FONIPA-fa");
            this.addDependency("Latin-Bopomofo", "Latin-NumericPinyin");
        }

        private void addInterIndicDependency(String script) {
            this.addPivotDependency(script, "InterIndic");
            if (!script.equals("Arabic")) {
                this.addDependency(script + "-Arabic", script + "-InterIndic", "InterIndic-Arabic");
            }
        }

        private void addPivotDependency(String script, String pivot) {
            this.addDependency(script + "-.*", "Bengali-" + pivot, pivot + "-Bengali");
            this.addDependency(".*-Bengali(/.*)?", pivot + "-Bengali", pivot + "-Bengali");
        }

        private void addDependency(String pattern, String ... whatItDependsOn) {
            this.dependsOn.putAll(PatternCache.get(pattern).matcher(""), Arrays.asList(whatItDependsOn));
        }

        public Set<String> getOrderedItems(Collection<String> rawInput, Matcher filter, boolean hasXmlSuffix) {
            LinkedHashSet<String> input = new LinkedHashSet<String>(rawInput);
            LinkedHashSet<String> ordered = new LinkedHashSet<String>();
            for (String cldrFileName : input) {
                if (hasXmlSuffix && !cldrFileName.endsWith(".xml")) continue;
                if (filter != null && !filter.reset(cldrFileName).find()) {
                    CLDRTransforms.this.append("Skipping " + cldrFileName + "\n");
                    continue;
                }
                this.addDependenciesRecursively(cldrFileName, ordered, hasXmlSuffix);
            }
            CLDRTransforms.this.append("Adding: " + ordered + "\n");
            return ordered;
        }

        private void addDependenciesRecursively(String cldrFileName, Set<String> ordered, boolean hasXmlSuffix) {
            String item = hasXmlSuffix && cldrFileName.endsWith(".xml") ? cldrFileName.substring(0, cldrFileName.length() - 4) : cldrFileName;
            for (Matcher m3 : this.dependsOn.keySet()) {
                if (!m3.reset(item).matches()) continue;
                for (String other : this.dependsOn.getAll(m3)) {
                    String toAdd;
                    String string = toAdd = hasXmlSuffix ? other + ".xml" : other;
                    if (other.equals(item) || ordered.contains(toAdd)) continue;
                    this.addDependenciesRecursively(toAdd, ordered, hasXmlSuffix);
                    CLDRTransforms.this.append("Dependency: Adding: " + toAdd + " before " + item + "\n");
                }
            }
            ordered.add(item);
        }
    }

    public static class RegexFindFilenameFilter
    implements FilenameFilter {
        Matcher matcher;

        public RegexFindFilenameFilter(Matcher filter) {
            this.matcher = filter;
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.matcher.reset(name).find();
        }
    }

    public static class ParsedTransformID {
        public String source = "Any";
        public String target = "Any";
        public String variant;
        protected String[] aliases = new String[0];
        protected String[] backwardAliases = new String[0];
        protected Direction direction = null;
        protected Visibility visibility;
        static final LikelySubtags likely = new LikelySubtags();

        public String getId() {
            return this.getSource() + "-" + this.getTarget() + (this.getVariant() == null ? "" : "/" + this.getVariant());
        }

        public String getDisplayId() {
            return this.getDisplaySource() + "-" + this.getDisplayTarget() + (this.getVariant() == null ? "" : "/" + this.getDisplayVariant());
        }

        private String getDisplayVariant() {
            return this.getVariant();
        }

        private String getDisplayTarget() {
            return this.getDisplaySourceOrTarget(this.getTarget());
        }

        private String getDisplaySource() {
            return this.getDisplaySourceOrTarget(this.getSource());
        }

        private String getDisplaySourceOrTarget(String sourceOrTarget) {
            int uscript = UScript.getCodeFromName(sourceOrTarget);
            if (uscript >= 0) {
                return UScript.getName(uscript);
            }
            if (sourceOrTarget.contains("FONIPA")) {
                return "IPA";
            }
            if (sourceOrTarget.equals("InterIndic")) {
                return "Indic";
            }
            try {
                String name = CLDRConfig.getInstance().getEnglish().getName(sourceOrTarget);
                return name;
            }
            catch (Exception e) {
                return sourceOrTarget;
            }
        }

        public static String getScriptCode(String sourceOrTarget) {
            int uscript = UScript.getCodeFromName(sourceOrTarget);
            if (uscript >= 0) {
                return UScript.getShortName(uscript);
            }
            if (sourceOrTarget.contains("FONIPA")) {
                return "Ipa0";
            }
            if (sourceOrTarget.equals("InterIndic")) {
                return "Ind0";
            }
            try {
                String max = likely.maximize(sourceOrTarget);
                return max == null ? null : new LanguageTagParser().set(max).getScript();
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getBackwardId() {
            return this.getTarget() + "-" + this.getSource() + (this.getVariant() == null ? "" : "/" + this.getVariant());
        }

        public ParsedTransformID set(String source, String target, String variant, Direction direction) {
            this.source = source;
            this.target = target;
            this.variant = variant;
            this.direction = direction;
            return this;
        }

        public ParsedTransformID set(String id) {
            this.variant = null;
            int pos = id.indexOf(45);
            if (pos < 0) {
                this.source = "Any";
                this.target = id;
                return this;
            }
            this.source = id.substring(0, pos);
            int pos2 = id.indexOf(47, pos);
            if (pos2 < 0) {
                this.target = id.substring(pos + 1);
                return this;
            }
            this.target = id.substring(pos + 1, pos2);
            this.variant = id.substring(pos2 + 1);
            return this;
        }

        public ParsedTransformID reverse() {
            String temp = this.source;
            this.source = this.target;
            this.target = temp;
            return this;
        }

        public String getTargetVariant() {
            return this.target + (this.variant == null ? "" : "/" + this.variant);
        }

        public String getSourceVariant() {
            return this.source + (this.variant == null ? "" : "/" + this.variant);
        }

        protected void setDirection(Direction direction) {
            this.direction = direction;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public void setVariant(String variant) {
            this.variant = variant;
        }

        protected String getVariant() {
            return this.variant;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public String getTarget() {
            return this.target;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSource() {
            return this.source;
        }

        public String toString() {
            return this.source + "-" + this.getTargetVariant();
        }

        public static String getId(String source, String target, String variant) {
            String id = source + '-' + target;
            if (variant != null) {
                id = id + "/" + variant;
            }
            return id;
        }

        public static String reverse(String id) {
            return new ParsedTransformID().set(id).getBackwardId();
        }

        public void setAliases(String[] aliases) {
            this.aliases = aliases;
        }

        public String[] getAliases() {
            return this.aliases;
        }

        public void setBackwardAliases(String[] backwardAliases) {
            this.backwardAliases = backwardAliases;
        }

        public String[] getBackwardAliases() {
            return this.backwardAliases;
        }

        protected void setVisibility(String string) {
            this.visibility = Visibility.valueOf(string);
        }

        public Visibility getVisibility() {
            return this.visibility;
        }
    }

    public static enum Direction {
        backward,
        both,
        forward;

    }

    public static class MyHandler
    extends XMLFileReader.SimpleHandler {
        boolean first = true;
        ParsedTransformID directionInfo;
        String cldrFileName;
        StringBuilder rules = new StringBuilder();

        public String getRules() {
            return this.rules.toString();
        }

        public MyHandler(String cldrFileName, ParsedTransformID directionInfo) {
            this.cldrFileName = cldrFileName;
            this.directionInfo = directionInfo;
        }

        @Override
        public void handlePathValue(String path, String value) {
            if (this.first) {
                String backwardAlias;
                if (path.startsWith("//supplementalData/version")) {
                    return;
                }
                if (path.startsWith("//supplementalData/generation")) {
                    return;
                }
                XPathParts parts = XPathParts.getFrozenInstance(path);
                Map<String, String> attributes = parts.findAttributes("transform");
                if (attributes == null) {
                    throw new IllegalArgumentException("Not an XML transform file: " + this.cldrFileName + "\t" + path);
                }
                this.directionInfo.setSource(attributes.get("source"));
                this.directionInfo.setTarget(attributes.get("target"));
                this.directionInfo.setVariant(attributes.get("variant"));
                this.directionInfo.setDirection(Direction.valueOf(attributes.get("direction").toLowerCase(Locale.ENGLISH)));
                String alias = attributes.get("alias");
                if (alias != null) {
                    this.directionInfo.setAliases(alias.trim().split("\\s+"));
                }
                if ((backwardAlias = attributes.get("backwardAlias")) != null) {
                    this.directionInfo.setBackwardAliases(backwardAlias.trim().split("\\s+"));
                }
                this.directionInfo.setVisibility(attributes.get("visibility"));
                this.first = false;
            }
            if (path.indexOf("/comment") < 0) {
                if (path.indexOf("/tRule") >= 0) {
                    value = fixup.transliterate(value);
                    this.rules.append(value).append("\n");
                } else {
                    throw new IllegalArgumentException("Unknown element: " + path + "\t " + value);
                }
            }
        }
    }

    private class RuleDirection {
        String ruleString;
        int direction;

        public RuleDirection(String ruleString, int direction) {
            this.ruleString = ruleString;
            this.direction = direction;
        }
    }

    public static enum Visibility {
        external,
        internal;

    }
}

