/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Map;

public class FileCopier {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndReplace(Reader rdr, Map<String, String> replacements, Writer out) throws IOException {
        if (replacements == null || replacements.isEmpty()) {
            FileCopier.copy(rdr, out);
            return;
        }
        PrintWriter pw = new PrintWriter(out);
        try (BufferedReader br = new BufferedReader(rdr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                for (String key : replacements.keySet()) {
                    if (!line.contains(key)) continue;
                    line = line.replaceAll(key, replacements.get(key));
                }
                pw.println(line);
            }
        }
        finally {
            pw.flush();
        }
    }

    public static void copyAndReplace(Class<?> cls, String srcFile, Charset charSet, Map<String, String> replacements, Writer out) throws IOException {
        FileCopier.copyAndReplace((Reader)new InputStreamReader(cls.getResourceAsStream(srcFile), charSet), replacements, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader rdr, Writer wr) throws IOException {
        PrintWriter pw = new PrintWriter(wr);
        try (BufferedReader br = new BufferedReader(rdr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                pw.println(line);
            }
        }
        finally {
            wr.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndReplace(Reader rdr, Writer wr, Map<String, String> replacements) throws IOException {
        if (replacements == null || replacements.isEmpty()) {
            FileCopier.copy(rdr, wr);
            return;
        }
        PrintWriter pw = new PrintWriter(wr);
        try (BufferedReader br = new BufferedReader(rdr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                for (String key : replacements.keySet()) {
                    if (!line.contains(key)) continue;
                    line = line.replaceAll(key, replacements.get(key));
                }
                pw.println(line);
            }
        }
        finally {
            pw.flush();
        }
    }

    public static void copy(Class<?> cls, String sourceFile, String targetDirectory, String newName) throws IOException {
        try (InputStream is = cls.getResourceAsStream(sourceFile);
             FileWriter wr = new FileWriter(Paths.get(targetDirectory, newName).toFile());){
            FileCopier.copy(new InputStreamReader(is), wr);
        }
    }

    public static void copy(Class<?> cls, String sourceFile, Writer out) throws IOException {
        FileCopier.copy(new InputStreamReader(cls.getResourceAsStream(sourceFile), Charset.forName("UTF-8")), out);
    }

    public static void copy(Class<?> cls, String sourceFile, Charset charset, Writer out) throws IOException {
        FileCopier.copy(new InputStreamReader(cls.getResourceAsStream(sourceFile), charset), out);
    }

    public static void copy(Class<?> cls, String sourceFile, String targetDirectory) throws IOException {
        FileCopier.copy(cls, sourceFile, targetDirectory, sourceFile);
    }

    public static void ensureDirectoryExists(String targetDirectory) {
        File targetDir = new File(targetDirectory);
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
    }

    public static void copyAndReplace(Class<?> cls, String srcFile, String destDir, String destFile, Map<String, String> replacements) throws IOException {
        FileCopier.copyAndReplace((Reader)new InputStreamReader(cls.getResourceAsStream(srcFile)), replacements, new FileWriter(Paths.get(destDir, destFile).toFile()));
    }
}

