/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.XPathTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LDMLUtilities {
    public static final int XML = 0;
    public static final int TXT = 1;
    private static final boolean DEBUG = false;
    private static boolean seenElementsOtherThanIdentity = false;

    public static Document getFullyResolvedLDML(String sourceDir, String locale, boolean ignoreRoot, boolean ignoreUnavailable, boolean ignoreIfNoneAvailable, boolean ignoreDraft) {
        return LDMLUtilities.getFullyResolvedLDML(sourceDir, locale, ignoreRoot, ignoreUnavailable, ignoreIfNoneAvailable, ignoreDraft, null);
    }

    private static Document getFullyResolvedLDML(String sourceDir, String locale, boolean ignoreRoot, boolean ignoreUnavailable, boolean ignoreIfNoneAvailable, boolean ignoreDraft, Map<String, String> stack) {
        Document full;
        block10: {
            full = null;
            if (stack != null) {
                String key = "SRC:" + sourceDir + File.separator + locale + ".xml";
                if (stack.get(key) != null) {
                    System.err.println("Found circular aliases! " + key);
                    System.exit(-1);
                }
                stack.put(key, "");
            }
            try {
                full = LDMLUtilities.parse(sourceDir + File.separator + "root.xml", ignoreRoot);
            }
            catch (RuntimeException ex) {
                if (ignoreRoot) break block10;
                throw ex;
            }
        }
        int index = locale.indexOf(".xml");
        if (index > -1) {
            locale = locale.substring(0, index);
        }
        if (locale.equals("root")) {
            full = LDMLUtilities.resolveAliases(full, sourceDir, locale, ignoreDraft, stack);
            return full;
        }
        String[] constituents = locale.split("_");
        String loc = null;
        boolean isAvailable = false;
        for (int i = 0; i < constituents.length; ++i) {
            loc = loc == null ? constituents[i] : loc + "_" + constituents[i];
            Document doc = null;
            String fileName = sourceDir + File.separator + loc + ".xml";
            File file = new File(fileName);
            if (file.exists()) {
                isAvailable = true;
                doc = LDMLUtilities.parseAndResolveAlias(fileName, loc, ignoreUnavailable);
                if (full == null) {
                    full = doc;
                    continue;
                }
                StringBuffer xpath = new StringBuffer();
                LDMLUtilities.mergeLDMLDocuments(full, (Node)doc, xpath, loc, sourceDir, ignoreDraft, false);
                continue;
            }
            if (ignoreUnavailable) continue;
            throw new RuntimeException("Could not find: " + fileName);
        }
        if (ignoreIfNoneAvailable && !isAvailable) {
            return null;
        }
        locale = LDMLUtilities.getLocaleName(full);
        full = LDMLUtilities.resolveAliases(full, sourceDir, locale, ignoreDraft, stack);
        return full;
    }

    public static String getLocaleName(Document doc) {
        String variant;
        String terr;
        String script;
        Node ln = LDMLUtilities.getNode(doc, "//ldml/identity/language");
        Node tn = LDMLUtilities.getNode(doc, "//ldml/identity/territory");
        Node sn = LDMLUtilities.getNode(doc, "//ldml/identity/script");
        Node vn = LDMLUtilities.getNode(doc, "//ldml/identity/variant");
        StringBuffer locName = new StringBuffer();
        String lang = LDMLUtilities.getAttributeValue(ln, "type");
        if (lang == null) {
            throw new IllegalArgumentException("Did not get any value for language node from identity.");
        }
        locName.append(lang);
        if (sn != null && (script = LDMLUtilities.getAttributeValue(sn, "type")) != null) {
            locName.append("_");
            locName.append(script);
        }
        if (tn != null && (terr = LDMLUtilities.getAttributeValue(tn, "type")) != null) {
            locName.append("_");
            locName.append(terr);
        }
        if (vn != null && (variant = LDMLUtilities.getAttributeValue(vn, "type")) != null && tn != null) {
            locName.append("_");
            locName.append(variant);
        }
        return locName.toString();
    }

    @Deprecated
    public static String convertXPath2ICU(Node alias, Node namespaceNode, StringBuffer fullPath) throws TransformerException {
        StringBuilder sb = new StringBuilder(fullPath.toString());
        return LDMLUtilities.convertXPath2ICU(alias, namespaceNode, sb);
    }

    public static String convertXPath2ICU(Node alias, Node namespaceNode, StringBuilder fullPath) throws TransformerException {
        Node context = alias.getParentNode();
        StringBuffer icu = new StringBuffer();
        String source = LDMLUtilities.getAttributeValue(alias, "source");
        String xpath = LDMLUtilities.getAttributeValue(alias, "path");
        if (namespaceNode == null) {
            LDMLUtilities.XPathAPI_eval(context, fullPath.toString());
            if (xpath != null) {
                LDMLUtilities.XPathAPI_eval(context, xpath);
            }
        } else {
            LDMLUtilities.XPathAPI_eval(context, fullPath.toString(), namespaceNode);
            if (xpath != null) {
                LDMLUtilities.XPathAPI_eval(context, xpath, namespaceNode);
            }
        }
        if (source.equals("locale")) {
            icu.append("/");
            icu.append(source.toUpperCase());
        } else {
            icu.append(source);
        }
        if (xpath != null) {
            StringBuilder resolved = XPathTokenizer.relativeToAbsolute(xpath, fullPath);
            LDMLUtilities.XPathAPI_eval(context, fullPath.toString());
            XPathTokenizer tokenizer = new XPathTokenizer(resolved.toString());
            String token = tokenizer.nextToken();
            while (token != null) {
                if (!token.equals("ldml")) {
                    String equiv = LDMLUtilities.getICUEquivalent(token);
                    if (equiv == null) {
                        throw new IllegalArgumentException("Could not find ICU equivalent for token: " + token);
                    }
                    if (equiv.length() > 0) {
                        icu.append("/");
                        icu.append(equiv);
                    }
                }
                token = tokenizer.nextToken();
            }
        }
        return icu.toString();
    }

    public static String convertXPath2ICU(String source, String xpath, String basePath, String fullPath) throws TransformerException {
        StringBuffer icu = new StringBuffer();
        if (source.equals("locale")) {
            icu.append("/");
            icu.append(source.toUpperCase());
        } else {
            icu.append(source);
        }
        if (xpath != null) {
            StringBuilder fullPathBuffer = new StringBuilder(fullPath);
            StringBuilder resolved = XPathTokenizer.relativeToAbsolute(xpath, fullPathBuffer);
            XPathTokenizer tokenizer = new XPathTokenizer(resolved);
            String token = tokenizer.nextToken();
            while (token != null) {
                if (!token.equals("ldml")) {
                    String equiv = LDMLUtilities.getICUEquivalent(token);
                    if (equiv == null) {
                        throw new IllegalArgumentException("Could not find ICU equivalent for token: " + token);
                    }
                    if (equiv.length() > 0) {
                        icu.append("/");
                        icu.append(equiv);
                    }
                }
                token = tokenizer.nextToken();
            }
        }
        return icu.toString();
    }

    public static String getDayIndexAsString(String type) {
        if (type.equals("sun")) {
            return "0";
        }
        if (type.equals("mon")) {
            return "1";
        }
        if (type.equals("tue")) {
            return "2";
        }
        if (type.equals("wed")) {
            return "3";
        }
        if (type.equals("thu")) {
            return "4";
        }
        if (type.equals("fri")) {
            return "5";
        }
        if (type.equals("sat")) {
            return "6";
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public static String getMonthIndexAsString(String type) {
        return Integer.toString(Integer.parseInt(type) - 1);
    }

    private static String getICUEquivalent(String token) {
        int index = 0;
        if (token.indexOf("localeDisplayNames") > -1) {
            return "";
        }
        if (token.indexOf("languages") > -1) {
            return "Languages";
        }
        if (token.indexOf("language") > -1) {
            return LDMLUtilities.getAttributeValue(token, "type");
        }
        if (token.indexOf("territories") > -1) {
            return "Countries";
        }
        if (token.indexOf("territory") > -1) {
            return LDMLUtilities.getAttributeValue(token, "type");
        }
        if (token.indexOf("scripts") > -1) {
            return "Scripts";
        }
        if (token.indexOf("script") > -1) {
            return LDMLUtilities.getAttributeValue(token, "type");
        }
        if (token.indexOf("variants") > -1) {
            return "Variants";
        }
        if (token.indexOf("variant") > -1) {
            return LDMLUtilities.getAttributeValue(token, "type");
        }
        if (token.indexOf("keys") > -1) {
            return "Keys";
        }
        if (token.indexOf("key") > -1) {
            return LDMLUtilities.getAttributeValue(token, "type");
        }
        if (token.indexOf("types") > -1) {
            return "Types";
        }
        index = token.indexOf("type");
        if (index > -1 && token.charAt(index - 1) != '@') {
            String type = LDMLUtilities.getAttributeValue(token, "type");
            String key = LDMLUtilities.getAttributeValue(token, "key");
            return type + "/" + key;
        }
        if (token.indexOf("layout") > -1) {
            return "Layout";
        }
        if (token.indexOf("orientation") <= -1) {
            if (token.indexOf("contextTransforms") > -1) {
                return "contextTransforms";
            }
            if (token.indexOf("contextTransformUsage") > -1) {
                return LDMLUtilities.getAttributeValue(token, "type");
            }
            if (token.indexOf("characters") > -1) {
                return "";
            }
            if (token.indexOf("exemplarCharacters") > -1) {
                return "ExemplarCharacters";
            }
            if (token.indexOf("measurement") > -1) {
                return "";
            }
            if (token.indexOf("measurementSystem") > -1) {
                return "MeasurementSystem";
            }
            if (token.indexOf("paperSize") > -1) {
                return "PaperSize";
            }
            if (token.indexOf("height") > -1) {
                return "0";
            }
            if (token.indexOf("width") > -1) {
                return "1";
            }
            if (token.indexOf("dates") > -1) {
                return "";
            }
            if (token.indexOf("localizedPatternChars") > -1) {
                return "localPatternCharacters";
            }
            if (token.indexOf("calendars") > -1) {
                return "calendar";
            }
            if (token.indexOf("default") > -1) {
                return "default";
            }
            if (token.indexOf("calendar") > -1) {
                return LDMLUtilities.getAttributeValue(token, "type");
            }
            if (token.indexOf("eras") > -1) {
                return "eras";
            }
            if (token.indexOf("eraAbbr") > -1) {
                return "abbreviated";
            }
            if (token.indexOf("era") > -1) {
                return LDMLUtilities.getAttributeValue(token, "type");
            }
            if (token.indexOf("numbers") <= -1) {
                if (token.indexOf("symbols") > -1) {
                    return "NumberElements";
                }
                if (token.indexOf("dateFormats") <= -1 && token.indexOf("dateFormatLength") <= -1 && token.indexOf("dateFormat") <= -1 && token.indexOf("timeFormats") <= -1 && token.indexOf("timeFormatLength") <= -1 && token.indexOf("timeFormat") <= -1) {
                    if (token.indexOf("dateTimeFormats") > -1) {
                        return "DateTimePatterns";
                    }
                    if (token.indexOf("intervalFormats") > -1) {
                        return "intervalFormats";
                    }
                    if (token.indexOf("dateTimeFormatLength") <= -1 && token.indexOf("dateTimeFormat") <= -1 && token.indexOf("intervalFormats") <= -1) {
                        if (token.indexOf("cyclicNameSets") > -1) {
                            return "cyclicNameSets";
                        }
                        if (token.indexOf("cyclicNameSet") > -1) {
                            return LDMLUtilities.getAttributeValue(token, "type");
                        }
                        if (token.indexOf("cyclicNameContext") > -1) {
                            return LDMLUtilities.getAttributeValue(token, "type");
                        }
                        if (token.indexOf("cyclicNameWidth") > -1) {
                            return LDMLUtilities.getAttributeValue(token, "type");
                        }
                        if (token.indexOf("cyclicName") > -1) {
                            String valStr = LDMLUtilities.getAttributeValue(token, "type");
                            return LDMLUtilities.getMonthIndexAsString(valStr);
                        }
                        if (token.indexOf("months") > -1) {
                            return "monthNames";
                        }
                        if (token.indexOf("monthPatterns") > -1) {
                            return "monthPatterns";
                        }
                        if (token.indexOf("monthPatternContext") > -1) {
                            return LDMLUtilities.getAttributeValue(token, "type");
                        }
                        if (token.indexOf("monthPatternWidth") > -1) {
                            return LDMLUtilities.getAttributeValue(token, "type");
                        }
                        if (token.indexOf("monthPattern") > -1) {
                            return LDMLUtilities.getAttributeValue(token, "type");
                        }
                        if (token.indexOf("monthContext") > -1) {
                            return LDMLUtilities.getAttributeValue(token, "type");
                        }
                        if (token.indexOf("monthWidth") > -1) {
                            return LDMLUtilities.getAttributeValue(token, "type");
                        }
                        if (token.indexOf("month") > -1) {
                            String valStr = LDMLUtilities.getAttributeValue(token, "type");
                            return LDMLUtilities.getMonthIndexAsString(valStr);
                        }
                        if (token.indexOf("dayPeriods") > -1) {
                            return "dayPeriods";
                        }
                        if (token.indexOf("days") > -1) {
                            return "dayNames";
                        }
                        if (token.indexOf("dayContext") > -1) {
                            return LDMLUtilities.getAttributeValue(token, "type");
                        }
                        if (token.indexOf("dayWidth") > -1) {
                            return LDMLUtilities.getAttributeValue(token, "type");
                        }
                        if (token.indexOf("day") > -1) {
                            String dayName = LDMLUtilities.getAttributeValue(token, "type");
                            return LDMLUtilities.getDayIndexAsString(dayName);
                        }
                        if (token.indexOf("quarterWidth") > -1) {
                            return LDMLUtilities.getAttributeValue(token, "type");
                        }
                        if (token.indexOf("quarterContext") > -1) {
                            return LDMLUtilities.getAttributeValue(token, "type");
                        }
                        if (token.indexOf("quarters") > -1) {
                            return "quarters";
                        }
                        if (token.indexOf("quarter") > -1) {
                            String valStr = LDMLUtilities.getAttributeValue(token, "type");
                            return LDMLUtilities.getMonthIndexAsString(valStr);
                        }
                        if (token.indexOf("collations") > -1) {
                            return "collations";
                        }
                        if (token.indexOf("collation") > -1) {
                            return LDMLUtilities.getAttributeValue(token, "type");
                        }
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unknown Xpath fragment: " + token);
    }

    private static String getAttributeValue(String token, String attrib) {
        int valStart;
        int attribStart = token.indexOf(attrib);
        int valEnd = token.indexOf(64, valStart = token.indexOf(61, attribStart) + 1);
        valEnd = valEnd < 0 ? valStart + (token.length() - valStart - 1) : token.length() - 1;
        String value = token.substring(valStart, valEnd);
        int s2 = value.indexOf(39);
        if (s2 > -1) {
            int e = value.lastIndexOf(39);
            return value.substring(++s2, e);
        }
        s2 = value.indexOf(34);
        if (s2 > -1) {
            int e = value.lastIndexOf(34);
            return value.substring(++s2, e);
        }
        return value;
    }

    @Deprecated
    public static Node mergeLDMLDocuments(Document source, Node override, StringBuffer xpath, String thisName, String sourceDir, boolean ignoreDraft, boolean ignoreVersion) {
        StringBuilder sb = new StringBuilder(xpath.toString());
        return LDMLUtilities.mergeLDMLDocuments(source, override, sb, thisName, sourceDir, ignoreDraft, ignoreVersion);
    }

    public static Node mergeLDMLDocuments(Document source, Node override, StringBuilder xpath, String thisName, String sourceDir, boolean ignoreDraft, boolean ignoreVersion) {
        if (source == null) {
            return override;
        }
        if (xpath.length() == 0) {
            xpath.append("/");
        }
        Node child = override.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 1) {
                child = child.getNextSibling();
                continue;
            }
            String childName = child.getNodeName();
            int savedLength = xpath.length();
            xpath.append("/");
            xpath.append(childName);
            LDMLUtilities.appendXPathAttribute(child, xpath, false, false);
            Node nodeInSource = null;
            nodeInSource = childName.indexOf(":") > -1 ? LDMLUtilities.getNode(source, xpath.toString(), child) : LDMLUtilities.getNode(source, xpath.toString());
            Node parentNodeInSource = null;
            if (nodeInSource == null) {
                String parentXpath = xpath.substring(0, savedLength);
                parentNodeInSource = childName.indexOf(":") > -1 ? LDMLUtilities.getNode(source, parentXpath, child) : LDMLUtilities.getNode(source, parentXpath);
                if (parentNodeInSource == null) {
                    throw new RuntimeException("Internal Error");
                }
                Node childToImport = source.importNode(child, true);
                parentNodeInSource.appendChild(childToImport);
            } else if (childName.equals("identity")) {
                if (!ignoreVersion) {
                    parentNodeInSource = nodeInSource.getParentNode();
                    Node childToImport = source.importNode(child, true);
                    parentNodeInSource.replaceChild(childToImport, nodeInSource);
                }
            } else if (childName.equals("collation")) {
                parentNodeInSource = nodeInSource.getParentNode();
                Node childToImport = source.importNode(child, true);
                parentNodeInSource.replaceChild(childToImport, nodeInSource);
                String val = LDMLUtilities.getAttributeValue(child.getParentNode(), "validSubLocales");
                NamedNodeMap map = parentNodeInSource.getAttributes();
                Node vs = map.getNamedItem("validSubLocales");
                vs.setNodeValue(val);
            } else {
                boolean childElementNodes = LDMLUtilities.areChildrenElementNodes(child);
                boolean sourceElementNodes = LDMLUtilities.areChildrenElementNodes(nodeInSource);
                if (childElementNodes && sourceElementNodes) {
                    LDMLUtilities.mergeLDMLDocuments(source, child, xpath, thisName, sourceDir, ignoreDraft, ignoreVersion);
                } else {
                    parentNodeInSource = nodeInSource.getParentNode();
                    Node childToImport = source.importNode(child, true);
                    parentNodeInSource.replaceChild(childToImport, nodeInSource);
                }
            }
            xpath.delete(savedLength, xpath.length());
            child = child.getNextSibling();
        }
        return source;
    }

    private static Node[] getNodeArray(Document doc, String tagName) {
        NodeList list = doc.getElementsByTagName(tagName);
        Node[] array = new Node[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            array[i] = list.item(i);
        }
        return array;
    }

    public static String getAbsoluteXPath(Node node, String type) {
        StringBuffer xpath = new StringBuffer();
        StringBuffer xpathFragment = new StringBuffer();
        if ((node = node.getParentNode()) == null) {
            throw new IllegalArgumentException("Alias node's parent is null!");
        }
        xpath.append(node.getNodeName());
        if (type != null) {
            xpath.append("[@type='" + type + "']");
        }
        Node parent = node;
        while ((parent = parent.getParentNode()) != null) {
            xpathFragment.setLength(0);
            xpathFragment.append(parent.getNodeName());
            if (parent.getNodeType() == 9) continue;
            LDMLUtilities.appendXPathAttribute(parent, xpathFragment);
            xpath.insert(0, "/");
            xpath.insert(0, xpathFragment);
        }
        xpath.insert(0, "//");
        return xpath.toString();
    }

    private static Node[] mergeNodeLists(Object[] n1, Object[] n2) {
        int i;
        StringBuffer xp1 = new StringBuffer();
        StringBuffer xp2 = new StringBuffer();
        int l1 = xp1.length();
        int l2 = xp2.length();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (n2 == null || n2.length == 0) {
            Node[] na = new Node[n1.length];
            for (int i2 = 0; i2 < n1.length; ++i2) {
                na[i2] = (Node)n1[i2];
            }
            return na;
        }
        for (i = 0; i < n1.length; ++i) {
            xp1.append(((Node)n1[i]).getNodeName());
            LDMLUtilities.appendXPathAttribute((Node)n1[i], xp1);
            map.put(xp1.toString(), n1[i]);
            xp1.setLength(l1);
        }
        for (i = 0; i < n2.length; ++i) {
            xp2.append(((Node)n2[i]).getNodeName());
            LDMLUtilities.appendXPathAttribute((Node)n2[i], xp2);
            map.put(xp2.toString(), n2[i]);
            xp2.setLength(l2);
        }
        Object[] arr = map.values().toArray();
        Node[] na = new Node[arr.length];
        for (int i3 = 0; i3 < arr.length; ++i3) {
            na[i3] = (Node)arr[i3];
        }
        return na;
    }

    public static Document resolveAliases(Document fullyResolvedDoc, String sourceDir, String thisLocale, boolean ignoreDraft, Map<String, String> stack) {
        Node[] array = LDMLUtilities.getNodeArray(fullyResolvedDoc, "alias");
        Node[] replacementList = null;
        Node parent = null;
        String source = null;
        String path = null;
        String type = null;
        for (int i = 0; i < array.length; ++i) {
            String key;
            Node node = array[i];
            stack = new HashMap<String, String>();
            if (node == null) {
                System.err.println("list.item(" + i + ") returned null!. The list reports it's length as: " + array.length);
                continue;
            }
            parent = node.getParentNode();
            source = LDMLUtilities.getAttributeValue(node, "source");
            path = LDMLUtilities.getAttributeValue(node, "path");
            type = LDMLUtilities.getAttributeValue(parent, "type");
            if (parent.getParentNode() == null) continue;
            if (source != null && path == null) {
                path = LDMLUtilities.getAbsoluteXPath(node, type);
            }
            if (stack.get(key = "SRC:" + thisLocale + ";XPATH:" + LDMLUtilities.getAbsoluteXPath(node, type)) != null) {
                throw new IllegalStateException("Found circular aliases! " + key);
            }
            stack.put(key, "");
            if (source.equals("locale")) {
                Object[] aliasList = LDMLUtilities.getChildNodeListAsArray(LDMLUtilities.getNode(parent, path), false);
                Object[] childList = LDMLUtilities.getChildNodeListAsArray(parent, true);
                replacementList = LDMLUtilities.mergeNodeLists(aliasList, childList);
            } else if (source != null && !source.equals(thisLocale)) {
                if (path.indexOf("..") > 0) {
                    throw new IllegalArgumentException("Cannot parse relative xpath: " + path + " in locale: " + source + " from source locale: " + thisLocale);
                }
                Document newDoc = LDMLUtilities.getFullyResolvedLDML(sourceDir, source, false, true, false, ignoreDraft, stack);
                replacementList = LDMLUtilities.getNodeListAsArray(newDoc, path);
            } else {
                replacementList = LDMLUtilities.getNodeListAsArray(parent, path);
            }
            if (replacementList != null) {
                Node childToImport;
                parent.removeChild(node);
                int listLen = replacementList.length;
                if (listLen > 1) {
                    if (path != null && path.equals("//ldml/*")) {
                        Node[] identity = LDMLUtilities.getNodeArray(fullyResolvedDoc, "identical");
                        for (int j = 0; j < identity.length; ++j) {
                            parent.removeChild(node);
                        }
                    } else {
                        LDMLUtilities.removeChildNodes(parent);
                    }
                    for (int j = 0; j < listLen; ++j) {
                        Node child = replacementList[j];
                        childToImport = fullyResolvedDoc.importNode(child, true);
                        parent.appendChild(childToImport);
                    }
                    continue;
                }
                Node replacement = replacementList[0];
                LDMLUtilities.removeChildNodes(parent);
                for (Node child = replacement.getFirstChild(); child != null; child = child.getNextSibling()) {
                    childToImport = fullyResolvedDoc.importNode(child, true);
                    parent.appendChild(childToImport);
                }
                continue;
            }
            throw new IllegalArgumentException("Could not find node for xpath: " + path + " in locale: " + source + " from source locale: " + thisLocale);
        }
        return fullyResolvedDoc;
    }

    private static void removeChildNodes(Node parent) {
        Node[] children = LDMLUtilities.toNodeArray(parent.getChildNodes());
        for (int j = 0; j < children.length; ++j) {
            parent.removeChild(children[j]);
        }
    }

    public boolean isParentDraft(Document fullyResolved, String xpath) {
        Node parentNode;
        Node node = LDMLUtilities.getNode(fullyResolved, xpath);
        while ((parentNode = node.getParentNode()) != null) {
            String draft = LDMLUtilities.getAttributeValue(parentNode, "draft");
            if (draft == null) continue;
            return draft.equals("true") || draft.equals("provisional") || draft.equals("unconfirmed");
        }
        return false;
    }

    public static boolean isNodeDraft(Node node) {
        String draft = LDMLUtilities.getAttributeValue(node, "draft");
        if (draft != null) {
            return draft.equals("true") || draft.equals("provisional") || draft.equals("unconfirmed");
        }
        return false;
    }

    public static boolean isDraft(Node fullyResolved, StringBuffer xpath) {
        String draft = null;
        for (Node current = LDMLUtilities.getNode(fullyResolved, xpath.toString()); current != null && current.getNodeType() == 1; current = current.getParentNode()) {
            draft = LDMLUtilities.getAttributeValue(current, "draft");
            if (draft == null) continue;
            return draft.equals("true") || draft.equals("provisional") || draft.equals("unconfirmed");
        }
        return false;
    }

    public static boolean isSiblingDraft(Node root) {
        String draft = null;
        for (Node current = root; current != null && current.getNodeType() == 1; current = current.getNextSibling()) {
            draft = LDMLUtilities.getAttributeValue(current, "draft");
            if (draft == null) continue;
            return draft.equals("true") || draft.equals("provisional") || draft.equals("unconfirmed");
        }
        return false;
    }

    public static void appendAllAttributes(Node node, StringBuffer xpath) {
        NamedNodeMap attr = node.getAttributes();
        int len = attr.getLength();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                Node item = attr.item(i);
                xpath.append("[@");
                xpath.append(item.getNodeName());
                xpath.append("='");
                xpath.append(item.getNodeValue());
                xpath.append("']");
            }
        }
    }

    private static boolean areChildNodesElements(Node node) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    private static boolean areSiblingsOfNodeElements(Node node) {
        NodeList list = node.getParentNode().getChildNodes();
        int count = 0;
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (item.getNodeType() == 1) {
                ++count;
            }
            if (count <= 1) continue;
            return true;
        }
        return false;
    }

    public static boolean isLocaleAlias(Document doc) {
        return LDMLUtilities.getAliasNode(doc) != null;
    }

    private static Node getAliasNode(Document doc) {
        NodeList elements = doc.getElementsByTagName("identity");
        if (elements.getLength() == 1) {
            Node id;
            Node sib = id = elements.item(0);
            while ((sib = sib.getNextSibling()) != null) {
                if (sib.getNodeType() != 1 || !sib.getNodeName().equals("alias")) continue;
                return sib;
            }
        } else {
            System.out.println("Error: elements returned more than 1 identity element!");
        }
        return null;
    }

    public static final boolean isLocaleDraft(Node node) {
        boolean isDraft = true;
        if (LDMLUtilities.isNodeDraft(node)) {
            return true;
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String name = child.getNodeName();
            if (name.equals("ldml") && LDMLUtilities.isNodeDraft(child)) {
                return true;
            }
            if (name.equals("identity")) {
                seenElementsOtherThanIdentity = LDMLUtilities.areSiblingsOfNodeElements(child);
                continue;
            }
            if (child.hasChildNodes() && LDMLUtilities.areChildNodesElements(child)) {
                isDraft = LDMLUtilities.isLocaleDraft(child);
            } else if (!LDMLUtilities.isNodeDraft(child)) {
                isDraft = false;
            }
            if (!isDraft) break;
        }
        if (!seenElementsOtherThanIdentity) {
            return false;
        }
        return isDraft;
    }

    @Deprecated
    public static final void appendXPathAttribute(Node node, StringBuffer xpath) {
        LDMLUtilities.appendXPathAttribute(node, xpath, false, false);
    }

    @Deprecated
    public static void appendXPathAttribute(Node node, StringBuffer xpath, boolean ignoreAlt, boolean ignoreDraft) {
        StringBuilder sb = new StringBuilder(xpath.toString());
        LDMLUtilities.appendXPathAttribute(node, sb, ignoreAlt, ignoreDraft);
    }

    public static final void appendXPathAttribute(Node node, StringBuilder xpath) {
        LDMLUtilities.appendXPathAttribute(node, xpath, false, false);
    }

    public static void appendXPathAttribute(Node node, StringBuilder xpath, boolean ignoreAlt, boolean ignoreDraft) {
        boolean terminate = false;
        String val = LDMLUtilities.getAttributeValue(node, "type");
        String and = "][";
        boolean isStart = true;
        String name = node.getNodeName();
        if (!(val == null || name.equals("default") || name.equals("measurementSystem") || val.equals("standard") && name.equals("pattern"))) {
            if (isStart) {
                xpath.append("[");
                isStart = false;
            }
            xpath.append("@type='");
            xpath.append(val);
            xpath.append("'");
            terminate = true;
        }
        if (!ignoreAlt && (val = LDMLUtilities.getAttributeValue(node, "alt")) != null) {
            if (isStart) {
                xpath.append("[");
                isStart = false;
            } else {
                xpath.append(and);
            }
            xpath.append("@alt='");
            xpath.append(val);
            xpath.append("'");
            terminate = true;
        }
        if (!ignoreDraft && (val = LDMLUtilities.getAttributeValue(node, "draft")) != null && !name.equals("ldml")) {
            if (isStart) {
                xpath.append("[");
                isStart = false;
            } else {
                xpath.append(and);
            }
            xpath.append("@draft='");
            xpath.append(val);
            xpath.append("'");
            terminate = true;
        }
        if ((val = LDMLUtilities.getAttributeValue(node, "key")) != null) {
            if (isStart) {
                xpath.append("[");
                isStart = false;
            } else {
                xpath.append(and);
            }
            xpath.append("@key='");
            xpath.append(val);
            xpath.append("'");
            terminate = true;
        }
        if ((val = LDMLUtilities.getAttributeValue(node, "registry")) != null) {
            if (isStart) {
                xpath.append("[");
                isStart = false;
            } else {
                xpath.append(and);
            }
            xpath.append("@registry='");
            xpath.append(val);
            xpath.append("'");
            terminate = true;
        }
        if ((val = LDMLUtilities.getAttributeValue(node, "id")) != null) {
            if (isStart) {
                xpath.append("[");
                isStart = false;
            } else {
                xpath.append(and);
            }
            xpath.append("@id='");
            xpath.append(val);
            xpath.append("'");
            terminate = true;
        }
        if (terminate) {
            xpath.append("]");
        }
    }

    public static boolean areChildrenElementNodes(Node node) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static Node[] getNodeListAsArray(Node doc, String xpath) {
        try {
            NodeList list = LDMLUtilities.XPathAPI_selectNodeList(doc, xpath);
            int length = list.getLength();
            if (length > 0) {
                Node[] array = new Node[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = list.item(i);
                }
                return array;
            }
            return null;
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Object[] getChildNodeListAsArray(Node parent, boolean exceptAlias) {
        NodeList list = parent.getChildNodes();
        int length = list.getLength();
        ArrayList<Node> al = new ArrayList<Node>();
        for (int i = 0; i < length; ++i) {
            Node item = list.item(i);
            if (item.getNodeType() != 1 || exceptAlias && item.getNodeName().equals("alias")) continue;
            al.add(item);
        }
        return al.toArray();
    }

    public static Node[] toNodeArray(NodeList list) {
        int length = list.getLength();
        if (length > 0) {
            Node[] array = new Node[length];
            for (int i = 0; i < length; ++i) {
                array[i] = list.item(i);
            }
            return array;
        }
        return null;
    }

    public static Node[] getElementsByTagName(Document doc, String tagName) {
        try {
            NodeList list = doc.getElementsByTagName(tagName);
            int length = list.getLength();
            if (length > 0) {
                Node[] array = new Node[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = list.item(i);
                }
                return array;
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static NodeList getNodeList(Document doc, String xpath) {
        try {
            return LDMLUtilities.XPathAPI_selectNodeList(doc, xpath);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final boolean isAlternate(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node attr = attributes.getNamedItem("alt");
        return attr != null;
    }

    private static final Node getNonAltNodeIfPossible(NodeList list) {
        Node node = null;
        for (int i = 0; i < list.getLength(); ++i) {
            node = list.item(i);
            if (LDMLUtilities.isAlternate(node)) continue;
            return node;
        }
        if (list.getLength() > 0) {
            return list.item(0);
        }
        return null;
    }

    public static Node getNonAltNodeLike(Node parent, Node child) {
        StringBuffer childXpath = new StringBuffer(child.getNodeName());
        LDMLUtilities.appendXPathAttribute(child, childXpath, true, true);
        String childXPathString = childXpath.toString();
        for (Node other = parent.getFirstChild(); other != null; other = other.getNextSibling()) {
            if (other.getNodeType() != 1 || other == child) continue;
            StringBuffer otherXpath = new StringBuffer(other.getNodeName());
            LDMLUtilities.appendXPathAttribute(other, otherXpath);
            if (!childXPathString.equals(otherXpath.toString())) continue;
            return other;
        }
        return null;
    }

    public static Node getNode(Document doc, String xpath, Node namespaceNode) {
        try {
            NodeList nl = LDMLUtilities.XPathAPI_selectNodeList(doc, xpath, namespaceNode);
            int len = nl.getLength();
            if (len > 1) {
                throw new IllegalArgumentException("The XPATH returned more than 1 node!. Check XPATH: " + xpath);
            }
            if (len == 0) {
                return null;
            }
            return nl.item(0);
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static Node getNode(Node context, String resToFetch, Node namespaceNode) {
        try {
            NodeList nl = LDMLUtilities.XPathAPI_selectNodeList(context, "./" + resToFetch, namespaceNode);
            int len = nl.getLength();
            if (len > 1) {
                throw new IllegalArgumentException("The XPATH returned more than 1 node!. Check XPATH: " + resToFetch);
            }
            if (len == 0) {
                return null;
            }
            return nl.item(0);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Node getNode(Node node, String xpath) {
        try {
            NodeList nl = LDMLUtilities.XPathAPI_selectNodeList(node, xpath);
            int len = nl.getLength();
            if (len > 1) {
                Node best = LDMLUtilities.getNonAltNodeIfPossible(nl);
                if (best != null) {
                    return best;
                }
                String all = "";
                for (int i = 0; i < len; ++i) {
                    all = all + ", " + nl.item(i);
                }
                throw new IllegalArgumentException("The XPATH returned more than 1 node!. Check XPATH: " + xpath + " = " + all);
            }
            if (len == 0) {
                return null;
            }
            return nl.item(0);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Node getNode(Node node, String xpath, boolean preferDraft, boolean preferAlt) {
        try {
            NodeList nl = LDMLUtilities.XPathAPI_selectNodeList(node, xpath);
            return LDMLUtilities.getNode(nl, xpath, preferDraft, preferAlt);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Node getVettedNode(NodeList list, StringBuffer xpath, boolean ignoreDraft) {
        Node node = null;
        for (int i = 0; i < list.getLength(); ++i) {
            node = list.item(i);
            if (LDMLUtilities.isDraft(node, xpath) && !ignoreDraft || LDMLUtilities.isAlternate(node)) continue;
            return node;
        }
        return null;
    }

    public static Node getVettedNode(Document fullyResolvedDoc, Node parent, String childName, StringBuffer xpath, boolean ignoreDraft) {
        NodeList list = LDMLUtilities.getNodeList(parent, childName, fullyResolvedDoc, xpath.toString());
        int oldLength = xpath.length();
        Node ret = null;
        if (list != null && list.getLength() > 0) {
            xpath.append("/");
            xpath.append(childName);
            ret = LDMLUtilities.getVettedNode(list, xpath, ignoreDraft);
        }
        xpath.setLength(oldLength);
        return ret;
    }

    public static Node getNode(NodeList nl, String xpath, boolean preferDraft, boolean preferAlt) {
        int len = nl.getLength();
        if (len > 1) {
            Node best = null;
            for (int i = 0; i < len; ++i) {
                Node current = nl.item(i);
                if (!preferDraft && !preferAlt) {
                    if (LDMLUtilities.isNodeDraft(current) || LDMLUtilities.isAlternate(current)) continue;
                    best = current;
                    break;
                }
                if (preferDraft && !preferAlt) {
                    if (!LDMLUtilities.isNodeDraft(current) || LDMLUtilities.isAlternate(current)) continue;
                    best = current;
                    break;
                }
                if (!preferDraft && preferAlt) {
                    if (LDMLUtilities.isNodeDraft(current) || !LDMLUtilities.isAlternate(current)) continue;
                    best = current;
                    break;
                }
                if (!LDMLUtilities.isNodeDraft(current) && !LDMLUtilities.isAlternate(current)) continue;
                best = current;
                break;
            }
            if (best == null && preferDraft) {
                best = LDMLUtilities.getVettedNode(nl, new StringBuffer(xpath), false);
            }
            if (best != null) {
                return best;
            }
            String all = "";
            for (int i = 0; i < len; ++i) {
                all = all + ", " + nl.item(i);
            }
            throw new IllegalArgumentException("The XPATH returned more than 1 node!. Check XPATH: " + xpath + " = " + all);
        }
        if (len == 0) {
            return null;
        }
        return nl.item(0);
    }

    public static Node getNode(Node context, String resToFetch, Document fullyResolved, String xpath) {
        String ctx = "./" + resToFetch;
        Node node = LDMLUtilities.getNode(context, ctx);
        if (node == null && fullyResolved != null) {
            String path = xpath + "/" + resToFetch;
            node = LDMLUtilities.getNode(fullyResolved, path);
        }
        return node;
    }

    public static NodeList getChildNodes(Node context, String resToFetch) {
        String ctx = "./" + resToFetch;
        NodeList list = LDMLUtilities.getNodeList(context, ctx);
        return list;
    }

    public static NodeList getNodeList(Document doc, String xpath, Node namespaceNode) {
        try {
            NodeList nl = LDMLUtilities.XPathAPI_selectNodeList(doc, xpath, namespaceNode);
            if (nl.getLength() == 0) {
                return null;
            }
            return nl;
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static NodeList getNodeList(Node node, String xpath) {
        try {
            NodeList nl = LDMLUtilities.XPathAPI_selectNodeList(node, xpath);
            int len = nl.getLength();
            if (len == 0) {
                return null;
            }
            return nl;
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static NodeList getNodeList(Node context, String resToFetch, Document fullyResolved, String xpath) {
        String ctx = "./" + resToFetch;
        NodeList list = LDMLUtilities.getNodeList(context, ctx);
        if ((list == null || list.getLength() > 0) && fullyResolved != null) {
            String path = xpath + "/" + resToFetch;
            list = LDMLUtilities.getNodeList(fullyResolved, path);
        }
        return list;
    }

    public static Node getAttributeNode(Node sNode, String attribName) {
        NamedNodeMap attrs = sNode.getAttributes();
        if (attrs != null) {
            return attrs.getNamedItem(attribName);
        }
        return null;
    }

    public static String getAttributeValue(Node sNode, String attribName) {
        Node attr;
        String value = null;
        NamedNodeMap attrs = sNode.getAttributes();
        if (attrs != null && (attr = attrs.getNamedItem(attribName)) != null) {
            value = attr.getNodeValue();
        }
        return value;
    }

    public static void setAttributeValue(Node sNode, String attribName, String val) {
        Node attr = sNode.getAttributes().getNamedItem(attribName);
        if (attr != null) {
            attr.setNodeValue(val);
        } else {
            attr = sNode.getOwnerDocument().createAttribute(attribName);
            attr.setNodeValue(val);
            sNode.getAttributes().setNamedItem(attr);
        }
    }

    public static String getNodeValue(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue();
        }
        return null;
    }

    public static Document parseAndResolveAlias(String filename, String locale, boolean ignoreError) throws RuntimeException {
        String docURI = LDMLUtilities.filenameToURL(filename);
        Document doc = LDMLUtilities.parse(new InputSource(docURI), filename, ignoreError);
        NodeList elements = doc.getElementsByTagName("identity");
        if (elements.getLength() == 1) {
            Node id;
            Node sib = id = elements.item(0);
            while ((sib = sib.getNextSibling()) != null) {
                if (sib.getNodeType() != 1 || !sib.getNodeName().equals("alias")) continue;
                LDMLUtilities.resolveAliases(doc, filename.substring(0, filename.lastIndexOf(File.separator) + 1), locale, false, null);
            }
        } else {
            System.out.println("Error: elements returned more than 1 identity element!");
        }
        return doc;
    }

    public static Document parse(String filename, boolean ignoreError) throws RuntimeException {
        String docURI = LDMLUtilities.filenameToURL(filename);
        return LDMLUtilities.parse(new InputSource(docURI), filename, ignoreError);
    }

    public static Document parseAndResolveAliases(String locale, String sourceDir, boolean ignoreError, boolean ignoreDraft) {
        try {
            Document full = LDMLUtilities.parse(sourceDir + File.separator + locale, ignoreError);
            if (full != null) {
                full = LDMLUtilities.resolveAliases(full, sourceDir, locale, ignoreDraft, null);
            }
            return full;
        }
        catch (Exception ex) {
            if (!ignoreError) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
            return null;
        }
    }

    private static ErrorHandler getNullErrorHandler(final String filename2, final boolean ignoreError) {
        ErrorHandler nullHandler = new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
                int col = e.getColumnNumber();
                String msg = filename2 + ":" + e.getLineNumber() + (col >= 0 ? ":" + col : "") + ": WARNING: " + e.getMessage();
                System.err.println(msg);
                if (!ignoreError) {
                    throw new RuntimeException(msg);
                }
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                int col = e.getColumnNumber();
                String msg = filename2 + ":" + e.getLineNumber() + (col >= 0 ? ":" + col : "") + ": ERROR: " + e.getMessage();
                System.err.println(msg);
                if (!ignoreError) {
                    throw new RuntimeException(msg);
                }
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }
        };
        return nullHandler;
    }

    public static Document newDocument() {
        return LDMLUtilities.newDocumentBuilder(false).newDocument();
    }

    private static DocumentBuilder newDocumentBuilder(boolean validating) {
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(true);
            dfactory.setValidating(validating);
            dfactory.setIgnoringComments(false);
            dfactory.setExpandEntityReferences(true);
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            return docBuilder;
        }
        catch (Throwable se) {
            System.err.println(": ERROR : trying to create documentBuilder: " + se.getMessage());
            se.printStackTrace();
            throw new RuntimeException(se);
        }
    }

    public static Document parse(InputSource docSrc, String filename, boolean ignoreError) {
        Document doc;
        block2: {
            doc = null;
            try {
                DocumentBuilder docBuilder = LDMLUtilities.newDocumentBuilder(true);
                docBuilder.setErrorHandler(LDMLUtilities.getNullErrorHandler(filename, ignoreError));
                doc = docBuilder.parse(docSrc);
            }
            catch (Throwable se) {
                System.err.println(filename + ": ERROR :" + se.getMessage());
                se.printStackTrace();
                if (ignoreError) break block2;
                throw new RuntimeException(se);
            }
        }
        return doc;
    }

    public static String filenameToURL(String filename) {
        if (null == filename) {
            return null;
        }
        if (filename.startsWith("file:") || filename.startsWith("http:") || filename.startsWith("ftp:") || filename.startsWith("gopher:") || filename.startsWith("mailto:") || filename.startsWith("news:") || filename.startsWith("telnet:")) {
            return filename;
        }
        File f = new File(filename);
        String tmp = PathUtilities.getNormalizedPathString(f);
        if (File.separatorChar == '\\') {
            tmp = tmp.replace('\\', '/');
        }
        if (tmp.startsWith("/")) {
            return "file://" + tmp;
        }
        return "file:///" + tmp;
    }

    public static void printDOMTree(Node node, PrintWriter out, String docType, String copyright) throws IOException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            out.print("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            if (copyright != null) {
                out.print(copyright);
            }
            if (docType != null) {
                out.print(docType);
            }
            transformer.transform(new DOMSource(node), new StreamResult(out));
        }
        catch (TransformerException te) {
            throw new IOException(te.getMessage());
        }
    }

    public static String getFullPath(int fileType, String fName, String dir) {
        String str = null;
        int lastIndex1 = fName.lastIndexOf(File.separator, fName.length()) + 1;
        int lastIndex2 = fName.lastIndexOf(46, fName.length());
        if (fileType == 1) {
            if (lastIndex2 == -1) {
                fName = fName.trim() + ".txt";
            } else if (!fName.substring(lastIndex2).equalsIgnoreCase(".txt")) {
                fName = fName.substring(lastIndex1, lastIndex2) + ".txt";
            }
            str = dir != null && fName != null ? dir + "/" + fName.trim() : System.getProperty("user.dir") + "/" + fName.trim();
        } else if (fileType == 0) {
            if (lastIndex2 == -1) {
                fName = fName.trim() + ".xml";
            } else if (!fName.substring(lastIndex2).equalsIgnoreCase(".xml") && fName.substring(lastIndex2).equalsIgnoreCase(".xlf")) {
                fName = fName.substring(lastIndex1, lastIndex2) + ".xml";
            }
            str = dir != null && fName != null ? dir + "/" + fName : (lastIndex1 > 0 ? fName : System.getProperty("user.dir") + "/" + fName);
        } else {
            System.err.println("Invalid file type.");
            System.exit(-1);
        }
        return str;
    }

    public static String[] parseAlt(String alt) {
        String[] ret = new String[2];
        if (alt == null) {
            ret[0] = null;
            ret[1] = null;
        } else {
            int l = alt.indexOf("proposed");
            if (l == -1) {
                ret[0] = alt;
                ret[1] = null;
            } else if (l == 0) {
                ret[0] = null;
                ret[1] = alt;
            } else {
                if (alt.charAt(l - 1) != '-') {
                    throw new InternalError("Expected '-' before proposed in " + alt);
                }
                ret[0] = alt.substring(0, l - 1);
                ret[1] = alt.substring(l);
                if (ret[0].length() == 0) {
                    ret[0] = null;
                }
                if (ret[1].length() == 0) {
                    ret[1] = null;
                }
            }
        }
        return ret;
    }

    public static String formatAlt(String altType, String proposedType) {
        if (!(altType != null && altType.length() != 0 || proposedType != null && proposedType.length() != 0)) {
            return null;
        }
        if (proposedType == null || proposedType.length() == 0) {
            return altType;
        }
        if (!proposedType.startsWith("proposed")) {
            throw new InternalError("proposedType must begin with proposed");
        }
        if (altType == null || altType.length() == 0) {
            return proposedType;
        }
        return altType + "-" + proposedType;
    }

    private static NodeList XPathAPI_selectNodeList(Node node, String xpath) throws TransformerException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        LDMLUtilities.setNamespace(xPath, xpath);
        try {
            XPathExpression xPathExpression = xPath.compile(xpath);
            return (NodeList)xPathExpression.evaluate(node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new TransformerException("Exception in XPathAPI_selectNodeList: " + xpath, e);
        }
    }

    private static NodeList XPathAPI_selectNodeList(Document doc, String xpath, Node namespaceNode) throws TransformerException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        LDMLUtilities.setNamespace(xPath, xpath);
        try {
            XPathExpression xPathExpression = xPath.compile(xpath);
            return (NodeList)xPathExpression.evaluate(doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new TransformerException("Exception in XPathAPI_selectNodeList: " + xpath, e);
        }
    }

    private static NodeList XPathAPI_selectNodeList(Node context, String xpath, Node namespaceNode) throws TransformerException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        LDMLUtilities.setNamespace(xPath, xpath);
        try {
            XPathExpression xPathExpression = xPath.compile(xpath);
            return (NodeList)xPathExpression.evaluate(context, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new TransformerException("Exception in XPathAPI_selectNodeList: " + xpath, e);
        }
    }

    private static void XPathAPI_eval(Node context, String string, Node namespaceNode) throws TransformerException {
        LDMLUtilities.XPathAPI_selectNodeList(context, string, namespaceNode);
    }

    private static void XPathAPI_eval(Node context, String string) throws TransformerException {
        LDMLUtilities.XPathAPI_selectNodeList(context, string);
    }

    private static void setNamespace(XPath xpath, String string) {
        if (string.contains("special/icu:")) {
            xpath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    if (prefix.equals("icu")) {
                        return "http://www.icu-project.org";
                    }
                    return null;
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return null;
                }

                @Override
                public Iterator<String> getPrefixes(String namespaceURI) {
                    return null;
                }
            });
        }
    }
}

