/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import org.unicode.cldr.util.StandardCodes;

public enum Level {
    UNDETERMINED(0, "none", 0),
    CORE(10, "G4", 100),
    BASIC(40, "G3", 80),
    MODERATE(60, "G2", 70),
    MODERN(80, "G1", 50),
    COMPREHENSIVE(100, "G0", 2);

    public static final Set<Level> CORE_TO_MODERN;
    @Deprecated
    public static final Level POSIX;
    @Deprecated
    public static final Level MINIMAL;
    @Deprecated
    public static final Level OPTIONAL;
    private final byte level;
    private final String altName;
    private final int value;
    private static final Level[] VALUES;
    static final StandardCodes sc;

    public int getValue() {
        return this.value;
    }

    private Level(int i, String altName, int value) {
        this.level = (byte)i;
        this.altName = altName;
        this.value = value;
    }

    public static Level get(String name) {
        try {
            return Level.valueOf(name.toUpperCase(Locale.ENGLISH));
        }
        catch (RuntimeException e) {
            for (Level level : VALUES) {
                if (!name.equalsIgnoreCase(level.altName)) continue;
                return level;
            }
            if (name.equalsIgnoreCase("POSIX")) {
                return POSIX;
            }
            if (name.equalsIgnoreCase("MINIMAL")) {
                return MINIMAL;
            }
            if (name.equalsIgnoreCase("OPTIONAL")) {
                return OPTIONAL;
            }
            return UNDETERMINED;
        }
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static int getDefaultWeight(String organization, String desiredLocale) {
        Level level = sc.getLocaleCoverageLevel(organization, desiredLocale);
        if (level.compareTo(MODERATE) >= 0) {
            return 4;
        }
        return 1;
    }

    public byte getLevel() {
        return this.level;
    }

    public static Level fromLevel(int level) {
        for (Level result : Level.values()) {
            if (level != result.level) continue;
            return result;
        }
        if (level == 20) {
            return POSIX;
        }
        if (level == 30) {
            return MINIMAL;
        }
        if (level == 101) {
            return OPTIONAL;
        }
        throw new IllegalArgumentException(String.valueOf(level));
    }

    public static Level fromString(String source) {
        return Level.get(source);
    }

    static {
        CORE_TO_MODERN = ImmutableSet.of(CORE, BASIC, MODERATE, MODERN);
        POSIX = BASIC;
        MINIMAL = BASIC;
        OPTIONAL = COMPREHENSIVE;
        VALUES = Level.values();
        sc = StandardCodes.make();
    }
}

