/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import org.unicode.cldr.draft.FileUtilities;

public class Log {
    private static PrintWriter log;

    public static void logln(int test, String message) {
        if (log != null && test != 0) {
            log.println(message);
        }
    }

    public static void logln(boolean test, String message) {
        if (log != null && test) {
            log.println(message);
        }
    }

    public static void logln(Object message) {
        if (log != null) {
            log.println(message);
        }
    }

    public static PrintWriter getLog() {
        return log;
    }

    public static void setLog(PrintWriter newlog) {
        log = newlog;
    }

    public static void close() {
        if (log != null) {
            log.close();
        }
    }

    public static void setLog(String dir, String file) throws IOException {
        log = FileUtilities.openUTF8Writer(dir, file);
        log.print('\ufeff');
    }

    public static void setLog(String file) throws IOException {
        log = FileUtilities.openUTF8Writer(null, file);
        log.print('\ufeff');
    }

    public static void setLogNoBOM(String file) throws IOException {
        log = FileUtilities.openUTF8Writer(null, file);
    }

    public static void setLogNoBOM(String dir, String file) throws IOException {
        log = FileUtilities.openUTF8Writer(dir, file);
    }

    public static void println() {
        log.println();
    }

    public static void println(String string) {
        log.println(string);
    }

    public static void print(String string) {
        log.print(string);
    }

    public static void formatln(String format, Object ... args) {
        String value = String.format(Locale.ENGLISH, format, args);
        if (value.length() <= 80) {
            log.println(value);
            return;
        }
        int commentLocation = value.lastIndexOf("//");
        String comment = "";
        if (commentLocation > 0) {
            comment = value.substring(commentLocation);
            value = value.substring(0, commentLocation);
        }
        while (value.length() > 80) {
            int lastSpace = value.lastIndexOf(32, 80);
            if (lastSpace == -1) {
                log.println(value);
                break;
            }
            log.println(value.substring(0, lastSpace));
            value = value.substring(lastSpace);
        }
        if (value.length() + comment.length() < 79) {
            log.println(value + " " + comment);
            return;
        }
        log.println(value);
        log.println("    " + comment);
    }
}

