/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.lang.CharSequences;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.UTF16;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.unicode.cldr.util.CldrUtility;

public final class With<V>
implements Iterable<V>,
Iterator<V> {
    List<Iterator<V>> iterators = new ArrayList<Iterator<V>>();
    int current;

    @Override
    public Iterator<V> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        while (this.current < this.iterators.size()) {
            if (this.iterators.get(this.current).hasNext()) {
                return true;
            }
            ++this.current;
        }
        return false;
    }

    @Override
    public V next() {
        return this.iterators.get(this.current).next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public List<V> toList() {
        return this.toCollection(new ArrayList());
    }

    public <C extends Collection<V>> C toCollection(C output) {
        while (this.hasNext()) {
            output.add(this.next());
        }
        return output;
    }

    public <C extends Collection<V>> C toUnmodifiableCollection(C output) {
        while (this.hasNext()) {
            output.add(this.next());
        }
        return CldrUtility.protectCollection(output);
    }

    public <W, C extends Collection<W>> C toCollection(Transform<V, W> filter, C output) {
        while (this.hasNext()) {
            W transformedItem = filter.transform(this.next());
            if (transformedItem == null) continue;
            output.add(transformedItem);
        }
        return output;
    }

    public <W, C extends Collection<W>> C toUnmodifiableCollection(Transform<V, W> filter, C output) {
        return CldrUtility.protectCollection(this.toCollection(filter, output));
    }

    public static <V> V[] array(V ... values) {
        return values;
    }

    public static int[] codePointArray(CharSequence source) {
        return CharSequences.codePoints(source);
    }

    public static String fromCodePoint(int ... codePoints) {
        switch (codePoints.length) {
            case 0: {
                return "";
            }
            case 1: {
                return String.valueOf(Character.toChars(codePoints[0]));
            }
        }
        StringBuilder b = new StringBuilder();
        for (int cp : codePoints) {
            b.appendCodePoint(cp);
        }
        return b.toString();
    }

    public static With<CharSequence> codePoints(CharSequence ... charSequences) {
        return new With().andCodePoints(charSequences);
    }

    @SafeVarargs
    public static <V> With<V> in(Iterator<V> ... iterators) {
        return new With<V>().and(iterators);
    }

    public static <V> With<V> in(Iterable<V> ... iterables) {
        return new With<V>().and(iterables);
    }

    public static <V> With<V> in(V ... items) {
        return new With<V>().and(items);
    }

    public static <T> Iterable<T> in(SimpleIterator<T> ... sources) {
        return new With<T>().and(sources);
    }

    private With() {
    }

    public With<V> and(Iterator<V> ... iterators) {
        for (Iterator<V> iterator : iterators) {
            this.iterators.add(iterator);
        }
        return this;
    }

    public With<V> and(V ... items) {
        return this.and(new Iterable[]{Arrays.asList(items)});
    }

    public With<V> and(Iterable<V> ... iterables) {
        for (Iterable<V> iterable : iterables) {
            this.iterators.add(iterable.iterator());
        }
        return this;
    }

    public With<V> and(SimpleIterator<V> ... iterators) {
        for (SimpleIterator<V> iterator : iterators) {
            this.iterators.add(new ToIterator<V>(iterator));
        }
        return this;
    }

    public With<V> andCodePoints(CharSequence ... sources) {
        for (CharSequence charSequence : sources) {
            this.iterators.add(new ToIterator<CharSequence>(new CharSequenceSimpleIterator(charSequence)));
        }
        return this;
    }

    public static <T> Iterator<T> toIterator(SimpleIterator<T> simple) {
        return new ToIterator<T>(simple);
    }

    public static <T> Iterable<T> toIterable(SimpleIterator<T> simple) {
        return new ToIterator<T>(simple);
    }

    public static <T> ToSimpleIterator<T> toSimpleIterator(Iterator<T> iterator) {
        return new ToSimpleIterator<T>(iterator);
    }

    public static interface SimpleIterator<T> {
        public T next();
    }

    private static class ToIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private final SimpleIterator<T> simpleIterator;
        private T current;

        public ToIterator(SimpleIterator<T> simpleIterator) {
            this.simpleIterator = simpleIterator;
            this.current = simpleIterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            T result = this.current;
            this.current = this.simpleIterator.next();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }

    private static class CharSequenceSimpleIterator
    implements SimpleIterator<CharSequence> {
        private int position;
        private CharSequence source;

        public CharSequenceSimpleIterator(CharSequence source) {
            this.source = source;
        }

        @Override
        public CharSequence next() {
            if (this.position >= this.source.length()) {
                return null;
            }
            int codePoint = Character.codePointAt(this.source, this.position);
            this.position += Character.charCount(codePoint);
            return UTF16.valueOf(codePoint);
        }
    }

    public static class ToSimpleIterator<T>
    implements SimpleIterator<T> {
        private final Iterator<T> iterator;

        public ToSimpleIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public T next() {
            return this.iterator.hasNext() ? (T)this.iterator.next() : null;
        }
    }
}

