/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.PluralRules;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;

@Deprecated
public class FixedDecimal
extends Number
implements Comparable<FixedDecimal>,
PluralRules.IFixedDecimal {
    private static final long serialVersionUID = -4756200506571685661L;
    final double source;
    final int visibleDecimalDigitCount;
    final int visibleDecimalDigitCountWithoutTrailingZeros;
    final long decimalDigits;
    final long decimalDigitsWithoutTrailingZeros;
    final long integerValue;
    final boolean hasIntegerValue;
    final boolean isNegative;
    final int exponent;
    private final int baseFactor;
    static final long MAX = 1000000000000000000L;
    private static final long MAX_INTEGER_PART = 1000000000L;

    @Deprecated
    public double getSource() {
        return this.source;
    }

    @Deprecated
    public int getVisibleDecimalDigitCount() {
        return this.visibleDecimalDigitCount;
    }

    @Deprecated
    public int getVisibleDecimalDigitCountWithoutTrailingZeros() {
        return this.visibleDecimalDigitCountWithoutTrailingZeros;
    }

    @Deprecated
    public long getDecimalDigits() {
        return this.decimalDigits;
    }

    @Deprecated
    public long getDecimalDigitsWithoutTrailingZeros() {
        return this.decimalDigitsWithoutTrailingZeros;
    }

    @Deprecated
    public long getIntegerValue() {
        return this.integerValue;
    }

    @Deprecated
    public boolean isHasIntegerValue() {
        return this.hasIntegerValue;
    }

    @Deprecated
    public boolean isNegative() {
        return this.isNegative;
    }

    @Deprecated
    public int getBaseFactor() {
        return this.baseFactor;
    }

    @Deprecated
    public FixedDecimal(double n, int v, long f, int e) {
        this.isNegative = n < 0.0;
        this.source = this.isNegative ? -n : n;
        this.visibleDecimalDigitCount = v;
        this.decimalDigits = f;
        this.integerValue = n > 1.0E18 ? 1000000000000000000L : (long)n;
        this.exponent = e;
        boolean bl = this.hasIntegerValue = this.source == (double)this.integerValue;
        if (f == 0L) {
            this.decimalDigitsWithoutTrailingZeros = 0L;
            this.visibleDecimalDigitCountWithoutTrailingZeros = 0;
        } else {
            long fdwtz = f;
            int trimmedCount = v;
            while (fdwtz % 10L == 0L) {
                fdwtz /= 10L;
                --trimmedCount;
            }
            this.decimalDigitsWithoutTrailingZeros = fdwtz;
            this.visibleDecimalDigitCountWithoutTrailingZeros = trimmedCount;
        }
        this.baseFactor = (int)Math.pow(10.0, v);
    }

    @Deprecated
    public FixedDecimal(double n, int v, long f) {
        this(n, v, f, 0);
    }

    @Deprecated
    public static FixedDecimal createWithExponent(double n, int v, int e) {
        return new FixedDecimal(n, v, FixedDecimal.getFractionalDigits(n, v), e);
    }

    @Deprecated
    public FixedDecimal(double n, int v) {
        this(n, v, FixedDecimal.getFractionalDigits(n, v));
    }

    private static int getFractionalDigits(double n, int v) {
        if (v == 0) {
            return 0;
        }
        if (n < 0.0) {
            n = -n;
        }
        int baseFactor = (int)Math.pow(10.0, v);
        long scaled = Math.round(n * (double)baseFactor);
        return (int)(scaled % (long)baseFactor);
    }

    @Deprecated
    public FixedDecimal(double n) {
        this(n, FixedDecimal.decimals(n));
    }

    @Deprecated
    public FixedDecimal(long n) {
        this(n, 0);
    }

    @Deprecated
    public static int decimals(double n) {
        String exponentStr;
        int exponent;
        int numFractionDigits;
        int ePos;
        int expNumPos;
        if (Double.isInfinite(n) || Double.isNaN(n)) {
            return 0;
        }
        if (n < 0.0) {
            n = -n;
        }
        if (n == Math.floor(n)) {
            return 0;
        }
        if (n < 1.0E9) {
            long temp = (long)(n * 1000000.0) % 1000000L;
            int mask = 10;
            for (int digits = 6; digits > 0; --digits) {
                if (temp % (long)mask != 0L) {
                    return digits;
                }
                mask *= 10;
            }
            return 0;
        }
        String buf = String.format(Locale.ENGLISH, "%1.15e", n);
        if (buf.charAt(expNumPos = (ePos = buf.lastIndexOf(101)) + 1) == '+') {
            ++expNumPos;
        }
        if ((numFractionDigits = ePos - 2 - (exponent = Integer.parseInt(exponentStr = buf.substring(expNumPos)))) < 0) {
            return 0;
        }
        int i = ePos - 1;
        while (numFractionDigits > 0 && buf.charAt(i) == '0') {
            --numFractionDigits;
            --i;
        }
        return numFractionDigits;
    }

    @Deprecated
    private FixedDecimal(FixedDecimal other) {
        this.source = other.source;
        this.visibleDecimalDigitCount = other.visibleDecimalDigitCount;
        this.visibleDecimalDigitCountWithoutTrailingZeros = other.visibleDecimalDigitCountWithoutTrailingZeros;
        this.decimalDigits = other.decimalDigits;
        this.decimalDigitsWithoutTrailingZeros = other.decimalDigitsWithoutTrailingZeros;
        this.integerValue = other.integerValue;
        this.hasIntegerValue = other.hasIntegerValue;
        this.isNegative = other.isNegative;
        this.exponent = other.exponent;
        this.baseFactor = other.baseFactor;
    }

    @Deprecated
    public FixedDecimal(String n) {
        this(FixedDecimal.parseDecimalSampleRangeNumString(n));
    }

    public static FixedDecimal parseDecimalSampleRangeNumString(String num) {
        int exponent = 0;
        String fractionStr = num;
        if (num.contains("e")) {
            int ePos = num.lastIndexOf(101);
            int expNumPos = ePos + 1;
            String exponentStr = num.substring(expNumPos);
            exponent = Integer.parseInt(exponentStr);
            fractionStr = num.substring(0, ePos);
            if (exponent != 0) {
                int decimalPos = fractionStr.indexOf(46);
                int decimalCount = 0;
                String integerPart = fractionStr;
                String fractionPart = "";
                if (decimalPos >= 0) {
                    decimalCount = fractionStr.length() - decimalPos - 1;
                    integerPart = fractionStr.substring(0, decimalPos);
                    fractionPart = fractionStr.substring(decimalPos + 1);
                }
                fractionStr = decimalCount == exponent ? integerPart + fractionPart : (decimalCount > exponent ? integerPart + fractionPart.substring(0, exponent) + "." + fractionPart.substring(exponent) : integerPart + FixedDecimal.padEnd(fractionPart, exponent, '0'));
            }
        }
        double n = Double.parseDouble(fractionStr);
        int v = FixedDecimal.getVisibleFractionCount(fractionStr);
        return new FixedDecimal(n, v, FixedDecimal.getFractionalDigits(n, v), exponent);
    }

    private static String padEnd(String string, int minLength, char c) {
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static int getVisibleFractionCount(String value) {
        int decimalPos = (value = value.trim()).indexOf(46) + 1;
        if (decimalPos == 0) {
            return 0;
        }
        return value.length() - decimalPos;
    }

    @Override
    @Deprecated
    public double getPluralOperand(PluralRules.Operand operand) {
        switch (operand) {
            case n: {
                return this.source;
            }
            case i: {
                return this.integerValue;
            }
            case f: {
                return this.decimalDigits;
            }
            case t: {
                return this.decimalDigitsWithoutTrailingZeros;
            }
            case v: {
                return this.visibleDecimalDigitCount;
            }
            case w: {
                return this.visibleDecimalDigitCountWithoutTrailingZeros;
            }
            case e: {
                return this.exponent;
            }
        }
        return this.source;
    }

    @Deprecated
    public static PluralRules.Operand getOperand(String t) {
        return PluralRules.Operand.valueOf(t);
    }

    @Override
    @Deprecated
    public int compareTo(FixedDecimal other) {
        if (this.exponent != other.exponent) {
            return this.exponent < other.exponent ? -1 : 1;
        }
        if (this.integerValue != other.integerValue) {
            return this.integerValue < other.integerValue ? -1 : 1;
        }
        if (this.source != other.source) {
            return this.source < other.source ? -1 : 1;
        }
        if (this.visibleDecimalDigitCount != other.visibleDecimalDigitCount) {
            return this.visibleDecimalDigitCount < other.visibleDecimalDigitCount ? -1 : 1;
        }
        long diff = this.decimalDigits - other.decimalDigits;
        if (diff != 0L) {
            return diff < 0L ? -1 : 1;
        }
        return 0;
    }

    @Deprecated
    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof FixedDecimal)) {
            return false;
        }
        FixedDecimal other = (FixedDecimal)arg0;
        return this.source == other.source && this.visibleDecimalDigitCount == other.visibleDecimalDigitCount && this.decimalDigits == other.decimalDigits && this.exponent == other.exponent;
    }

    @Deprecated
    public int hashCode() {
        return (int)(this.decimalDigits + (long)(37 * (this.visibleDecimalDigitCount + (int)(37.0 * this.source))));
    }

    public static String toSampleString(PluralRules.IFixedDecimal source) {
        double n = source.getPluralOperand(PluralRules.Operand.n);
        int exponent = (int)source.getPluralOperand(PluralRules.Operand.e);
        int visibleDecimalDigitCount = (int)source.getPluralOperand(PluralRules.Operand.v);
        if (exponent == 0) {
            return String.format(Locale.ROOT, "%." + visibleDecimalDigitCount + "f", n);
        }
        int fixedV = visibleDecimalDigitCount + exponent;
        String baseString = String.format(Locale.ROOT, "%." + fixedV + "f", n / Math.pow(10.0, exponent));
        if (visibleDecimalDigitCount == 0) {
            for (int i = visibleDecimalDigitCount; i < fixedV && baseString.endsWith("0"); ++i) {
                baseString = baseString.substring(0, baseString.length() - 1);
            }
            if (baseString.endsWith(".")) {
                baseString = baseString.substring(0, baseString.length() - 1);
            }
        }
        return baseString + "e" + exponent;
    }

    @Deprecated
    public String toString() {
        return FixedDecimal.toSampleString(this);
    }

    @Deprecated
    public boolean hasIntegerValue() {
        return this.hasIntegerValue;
    }

    @Override
    @Deprecated
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    @Deprecated
    public long longValue() {
        if (this.exponent == 0) {
            return this.integerValue;
        }
        return (long)(Math.pow(10.0, this.exponent) * (double)this.integerValue);
    }

    @Override
    @Deprecated
    public float floatValue() {
        return (float)(this.source * Math.pow(10.0, this.exponent));
    }

    @Override
    @Deprecated
    public double doubleValue() {
        return this.isNegative ? -this.source : this.source;
    }

    @Deprecated
    public long getShiftedValue() {
        return this.integerValue * (long)this.baseFactor + this.decimalDigits;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }

    @Override
    @Deprecated
    public boolean isNaN() {
        return Double.isNaN(this.source);
    }

    @Override
    @Deprecated
    public boolean isInfinite() {
        return Double.isInfinite(this.source);
    }

    public int getExponent() {
        return this.exponent;
    }
}

