/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.unicode.cldr.draft.keyboard.KeyboardId;

public final class KeyboardIdMap {
    private final ImmutableMultimap<String, KeyboardId> nameToKeyboardId;
    private final Set<String> coveredNames;
    private static final Splitter LINE_SPLITTER = Splitter.on("\n").omitEmptyStrings();
    private static final Splitter COMMA_SPLITTER = Splitter.on(",");
    private static final Splitter DASH_SPLITTER = Splitter.on("-").omitEmptyStrings();

    private KeyboardIdMap(ImmutableMultimap<String, KeyboardId> nameToKeyboardId) {
        this.nameToKeyboardId = Preconditions.checkNotNull(nameToKeyboardId);
        this.coveredNames = Sets.newHashSet();
    }

    public static KeyboardIdMap fromCsv(String csv, KeyboardId.Platform platform) {
        Preconditions.checkArgument(!csv.isEmpty());
        List<String> lines = LINE_SPLITTER.splitToList(csv);
        Preconditions.checkArgument(lines.get(0).equals("name,locale,attributes"), "Missing csv headers");
        ImmutableMultimap.Builder<String, KeyboardId> builder = ImmutableMultimap.builder();
        for (String line : Iterables.skip(lines, 1)) {
            int closingQuote = line.startsWith("\"") ? line.indexOf("\"", 1) : 0;
            List<String> components = COMMA_SPLITTER.splitToList(line.substring(closingQuote));
            String name = closingQuote != 0 ? line.substring(1, closingQuote) : components.get(0);
            ULocale locale = ULocale.forLanguageTag(components.get(1));
            ImmutableList<String> attributes = ImmutableList.copyOf(DASH_SPLITTER.splitToList(components.get(2)));
            builder.put(name, KeyboardId.of(locale, platform, attributes));
        }
        return new KeyboardIdMap(builder.build());
    }

    public static KeyboardIdMap fromResource(Class<?> clazz, String fileName, KeyboardId.Platform platform) {
        try {
            String csv = Resources.toString(Resources.getResource(clazz, fileName), Charsets.UTF_8);
            return KeyboardIdMap.fromCsv(csv, platform);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ImmutableCollection<KeyboardId> getKeyboardId(String name) {
        this.coveredNames.add(name);
        Collection ids = this.nameToKeyboardId.get((Object)name);
        Preconditions.checkArgument(((AbstractCollection)ids).size() > 0, "No keyboard id for %s [%s]", (Object)name, this.nameToKeyboardId);
        return ids;
    }

    public Set<String> unmatchedIds() {
        return Sets.difference(this.nameToKeyboardId.keySet(), this.coveredNames);
    }
}

