/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.util.ULocale;
import java.util.EnumSet;
import org.unicode.cldr.draft.keyboard.CharacterMap;
import org.unicode.cldr.draft.keyboard.IsoLayoutPosition;
import org.unicode.cldr.draft.keyboard.KeyMap;
import org.unicode.cldr.draft.keyboard.Keyboard;
import org.unicode.cldr.draft.keyboard.KeyboardId;
import org.unicode.cldr.draft.keyboard.ModifierKey;
import org.unicode.cldr.draft.keyboard.ModifierKeyCombination;
import org.unicode.cldr.draft.keyboard.ModifierKeyCombinationSet;
import org.unicode.cldr.draft.keyboard.Transform;

public class KeyboardTest
extends TestFmwk {
    private Keyboard keyboard = KeyboardTest.createKeyboard();

    private static Keyboard createKeyboard() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of());
        ModifierKeyCombinationSet combinationSet1 = ModifierKeyCombinationSet.of(ImmutableSet.of(combination1));
        CharacterMap characterMap1 = CharacterMap.of(IsoLayoutPosition.E02, "\u011b");
        CharacterMap characterMap2 = CharacterMap.of(IsoLayoutPosition.E03, "\u0161", ImmutableList.of("\u00e7 %"));
        CharacterMap characterMap3 = CharacterMap.of(IsoLayoutPosition.D10, "\u00a8");
        KeyMap keyMap1 = KeyMap.of(combinationSet1, ImmutableSet.of(characterMap1, characterMap2, characterMap3));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.OPTION));
        ModifierKeyCombination combination3 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.OPTION, ModifierKey.SHIFT), ImmutableSet.of(ModifierKey.CAPSLOCK));
        ModifierKeyCombinationSet combinationSet2 = ModifierKeyCombinationSet.of(ImmutableSet.of(combination2, combination3));
        CharacterMap characterMap4 = CharacterMap.of(IsoLayoutPosition.C01, "\u00e4");
        CharacterMap characterMap5 = CharacterMap.of(IsoLayoutPosition.C03, "\u00df", ImmutableList.of("\u00d0"));
        CharacterMap characterMap6 = CharacterMap.of(IsoLayoutPosition.C10, "\u0302");
        KeyMap keyMap2 = KeyMap.of(combinationSet2, ImmutableSet.of(characterMap4, characterMap5, characterMap6));
        ImmutableSortedSet<Transform> transforms = ImmutableSortedSet.of(Transform.of("\u00a8\u00df", "\ud800\ude80"), Transform.of("\u00a8\u0161", "s"), Transform.of("\u0302\u00df", "\u0305a"));
        return Keyboard.of(KeyboardId.fromString("cs-t-k0-osx-qwerty"), ImmutableList.of("Czech-QWERTY"), ImmutableSortedSet.of(keyMap1, keyMap2), transforms);
    }

    public void testKeyboardId() {
        KeyboardId id = this.keyboard.keyboardId();
        KeyboardId testId = KeyboardId.of(ULocale.forLanguageTag("cs"), KeyboardId.Platform.OSX, ImmutableList.of("qwerty"));
        this.assertEquals("", testId, id);
    }

    public void testNames() {
        ImmutableList<String> names = this.keyboard.names();
        this.assertEquals("", ImmutableList.of("Czech-QWERTY"), names);
    }

    public void testKeyMaps() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of());
        ModifierKeyCombinationSet combinationSet1 = ModifierKeyCombinationSet.of(ImmutableSet.of(combination1));
        CharacterMap characterMap1 = CharacterMap.of(IsoLayoutPosition.E02, "\u011b");
        CharacterMap characterMap2 = CharacterMap.of(IsoLayoutPosition.E03, "\u0161", ImmutableList.of("\u00e7 %"));
        CharacterMap characterMap3 = CharacterMap.of(IsoLayoutPosition.D10, "\u00a8");
        KeyMap keyMap1 = KeyMap.of(combinationSet1, ImmutableSet.of(characterMap1, characterMap2, characterMap3));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.OPTION));
        ModifierKeyCombination combination3 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.OPTION, ModifierKey.SHIFT), ImmutableSet.of(ModifierKey.CAPSLOCK));
        ModifierKeyCombinationSet combinationSet2 = ModifierKeyCombinationSet.of(ImmutableSet.of(combination2, combination3));
        CharacterMap characterMap4 = CharacterMap.of(IsoLayoutPosition.C01, "\u00e4");
        CharacterMap characterMap5 = CharacterMap.of(IsoLayoutPosition.C03, "\u00df", ImmutableList.of("\u00d0"));
        CharacterMap characterMap6 = CharacterMap.of(IsoLayoutPosition.C10, "\u0302");
        KeyMap keyMap2 = KeyMap.of(combinationSet2, ImmutableSet.of(characterMap4, characterMap5, characterMap6));
        this.assertEquals("", ImmutableSet.of(keyMap1, keyMap2), this.keyboard.keyMaps());
    }

    public void testTransforms() {
        ImmutableSet<Transform> transforms = ImmutableSet.of(Transform.of("\u00a8\u00df", "\ud800\ude80"), Transform.of("\u00a8\u0161", "s"), Transform.of("\u0302\u00df", "\u0305a"));
        this.assertEquals("", transforms, this.keyboard.transforms());
    }

    public void testEqualsTrue() {
        KeyboardId id = KeyboardId.of(ULocale.forLanguageTag("cs"), KeyboardId.Platform.OSX, ImmutableList.of("qwerty"));
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of());
        ModifierKeyCombinationSet combinationSet1 = ModifierKeyCombinationSet.of(ImmutableSet.of(combination1));
        CharacterMap characterMap1 = CharacterMap.of(IsoLayoutPosition.E02, "\u011b");
        CharacterMap characterMap2 = CharacterMap.of(IsoLayoutPosition.E03, "\u0161", ImmutableList.of("\u00e7 %"));
        CharacterMap characterMap3 = CharacterMap.of(IsoLayoutPosition.D10, "\u00a8");
        KeyMap keyMap1 = KeyMap.of(combinationSet1, ImmutableSet.of(characterMap1, characterMap2, characterMap3));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.OPTION));
        ModifierKeyCombination combination3 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.OPTION, ModifierKey.SHIFT), ImmutableSet.of(ModifierKey.CAPSLOCK));
        ModifierKeyCombinationSet combinationSet2 = ModifierKeyCombinationSet.of(ImmutableSet.of(combination2, combination3));
        CharacterMap characterMap4 = CharacterMap.of(IsoLayoutPosition.C01, "\u00e4");
        CharacterMap characterMap5 = CharacterMap.of(IsoLayoutPosition.C03, "\u00df", ImmutableList.of("\u00d0"));
        CharacterMap characterMap6 = CharacterMap.of(IsoLayoutPosition.C10, "\u0302");
        KeyMap keyMap2 = KeyMap.of(combinationSet2, ImmutableSet.of(characterMap4, characterMap5, characterMap6));
        ImmutableSortedSet<Transform> transforms = ImmutableSortedSet.of(Transform.of("\u00a8\u00df", "\ud800\ude80"), Transform.of("\u00a8\u0161", "s"), Transform.of("\u0302\u00df", "\u0305a"));
        Keyboard keyboard2 = Keyboard.of(id, ImmutableList.of("Czech-QWERTY"), ImmutableSortedSet.of(keyMap1, keyMap2), transforms);
        this.assertTrue("", this.keyboard.equals(keyboard2));
        this.assertEquals("", keyboard2.hashCode(), this.keyboard.hashCode());
    }

    public void testEqualsFalse() {
        KeyboardId id = KeyboardId.of(ULocale.forLanguageTag("cs"), KeyboardId.Platform.OSX, ImmutableList.of("qwerty"));
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(EnumSet.noneOf(ModifierKey.class));
        ModifierKeyCombinationSet combinationSet1 = ModifierKeyCombinationSet.of(ImmutableSet.of(combination1));
        CharacterMap characterMap1 = CharacterMap.of(IsoLayoutPosition.E02, "\u011b");
        CharacterMap characterMap2 = CharacterMap.of(IsoLayoutPosition.E03, "\u0161", ImmutableList.of("\u00e7 %"));
        KeyMap keyMap1 = KeyMap.of(combinationSet1, ImmutableSet.of(characterMap1, characterMap2));
        ImmutableSortedSet<Transform> emptyTransforms = ImmutableSortedSet.of();
        Keyboard keyboard2 = Keyboard.of(id, ImmutableList.of("Czech-QWERTY"), ImmutableSortedSet.of(keyMap1), emptyTransforms);
        this.assertFalse("", this.keyboard.equals(keyboard2));
        this.assertNotSame("", keyboard2.hashCode(), this.keyboard.hashCode());
    }
}

