/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard.test;

import com.google.common.collect.ImmutableList;
import com.ibm.icu.dev.test.TestFmwk;
import org.unicode.cldr.draft.keyboard.ModifierKey;

public class ModifierKeyTest
extends TestFmwk {
    public void testFromString() {
        ModifierKey key = ModifierKey.fromString("shiftL");
        this.assertEquals("", (Object)ModifierKey.SHIFT_LEFT, (Object)key);
    }

    public void testFromStringInvalid() {
        try {
            ModifierKey.fromString("bla");
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testModifierKey() {
        ModifierKey key = ModifierKey.COMMAND;
        this.assertEquals("", (Object)ModifierKey.COMMAND, (Object)key.sibling());
        this.assertEquals("", (Object)ModifierKey.COMMAND, (Object)key.parent());
        this.assertEquals("", ImmutableList.of(), key.children());
    }

    public void testChildModifierKey() {
        ModifierKey key = ModifierKey.CONTROL_RIGHT;
        this.assertEquals("", (Object)ModifierKey.CONTROL_LEFT, (Object)key.sibling());
        this.assertEquals("", (Object)ModifierKey.CONTROL, (Object)key.parent());
        this.assertEquals("", ImmutableList.of(), key.children());
    }

    public void testParentModifierKey() {
        ModifierKey key = ModifierKey.ALT;
        this.assertEquals("", (Object)ModifierKey.ALT, (Object)key.sibling());
        this.assertEquals("", (Object)ModifierKey.ALT, (Object)key.parent());
        this.assertEquals("", ImmutableList.of(ModifierKey.ALT_LEFT, ModifierKey.ALT_RIGHT), key.children());
    }
}

