/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.UnicodeSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.PatternCache;

public class CheckQuotes
extends CheckCLDR {
    private static final Pattern ASCII_QUOTES = PatternCache.get("['\"]");
    private static final Pattern UNITS = PatternCache.get("//ldml/units/.*");
    private static final Pattern DELIMITERS = PatternCache.get("//ldml/delimiters/.*");
    private static final UnicodeSet VALID_DELIMITERS = new UnicodeSet().add(8216, 8218).add(8220, 8222).add(12300, 12303).add(8249, 8250).add(171).add(187);

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (value == null) {
            return this;
        }
        if (UNITS.matcher(path).matches()) {
            Matcher matcher = ASCII_QUOTES.matcher(value);
            CheckCLDR.CheckStatus.Type type = CheckCLDR.CheckStatus.warningType;
            if (this.getCldrFileToCheck().getLocaleID().equals("en")) {
                type = CheckCLDR.CheckStatus.errorType;
            }
            if (matcher.find()) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(type).setSubtype(CheckCLDR.CheckStatus.Subtype.asciiQuotesNotAllowed).setMessage("Use of ASCII quote marks (' \") is discouraged. Use primes for units (\u2032 \u2033) and curly quotes for text (\u2018 \u2019 \u201c \u201d \u2026)"));
            }
        }
        if (DELIMITERS.matcher(path).matches() && !VALID_DELIMITERS.contains(value)) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidDelimiter).setMessage("Invalid delimiter. See https://sites.google.com/site/cldr/translation/characters for a list of valid delimiters."));
        }
        return this;
    }
}

