/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.XPathParts;

public class FlexibleDateTime {
    static final boolean DEBUG = false;
    static final boolean SHOW_MATCHING = false;
    static final boolean SHOW2 = false;
    static final boolean SHOW_OO = false;
    static final String SEPARATOR = "\n\t";
    public static PrintWriter log;
    static Date TEST_DATE;
    static Comparator<Collection<String>> VariableFieldComparator;
    public static UnicodeSet allowedDateTimeCharacters;

    public static void main(String[] args) throws IOException {
    }

    public static boolean isGregorianPattern(String path) {
        if (path.indexOf("Formats") < 0) {
            return false;
        }
        XPathParts parts = XPathParts.getFrozenInstance(path);
        if (parts.size() < 8 || !parts.getElement(7).equals("pattern")) {
            return false;
        }
        return parts.containsAttributeValue("type", "gregorian");
    }

    public static void add(DateTimePatternGenerator generator, Collection<String> list) {
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            generator.addPattern(it.next(), false, null);
        }
    }

    static Collection<String> getOOData(Factory cldrFactory, String locale) {
        ArrayList<String> result = new ArrayList<String>();
        OOConverter ooConverter = new OOConverter();
        CLDRFile item = cldrFactory.make(locale, false);
        for (String xpath : item) {
            if (!FlexibleDateTime.isGregorianPattern(xpath)) continue;
            XPathParts parts = XPathParts.getFrozenInstance(xpath);
            String fourthElement = parts.getElement(4);
            boolean isDate = fourthElement.equals("dateFormats");
            boolean isTime = fourthElement.equals("timeFormats");
            String value = item.getWinningValue(xpath);
            if (isDate || isTime) {
                String pattern = value;
                String oldPattern = pattern;
                if (oldPattern.indexOf(91) >= 0) {
                    log.println(locale + "\tSkipping [:\t" + xpath + "\t" + value);
                    continue;
                }
                try {
                    pattern = isDate ? ooConverter.convertOODate(pattern, locale) : ooConverter.convertOOTime(pattern, locale);
                }
                catch (RuntimeException e1) {
                    log.println(locale + "\tSkipping unknown char:\t" + xpath + "\t" + value);
                    continue;
                }
                try {
                    SimpleDateFormat d = new SimpleDateFormat(pattern);
                    result.add(d.toPattern());
                }
                catch (Exception exception) {}
                continue;
            }
            log.println(locale + "\tSkipping datetime:\t" + xpath + "\t" + value);
        }
        return result;
    }

    static {
        TEST_DATE = new Date(104, 8, 13, 23, 58, 59);
        VariableFieldComparator = new Comparator<Collection<String>>(){

            @Override
            public int compare(Collection<String> a, Collection<String> b) {
                if (a.size() != b.size()) {
                    if (a.size() < b.size()) {
                        return 1;
                    }
                    return -1;
                }
                Iterator<String> itb = b.iterator();
                for (String aa : a) {
                    String bb;
                    int result = -aa.compareTo(bb = itb.next());
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        };
        allowedDateTimeCharacters = new UnicodeSet("[A a c D d E e F G g h H K k L m M q Q s S u v W w Y y z Z]");
    }

    static class OOConverter {
        DateTimePatternGenerator.FormatParser fp = new DateTimePatternGenerator.FormatParser();

        OOConverter() {
        }

        public String convertOODate(String source, String locale) {
            if (source.length() == 0) {
                return "";
            }
            source = source.replace('\"', '\'');
            StringBuffer buffer = new StringBuffer();
            this.fp.set(source);
            for (Object item : this.fp.getItems()) {
                if (item instanceof DateTimePatternGenerator.VariableField) {
                    buffer.append(this.handleOODate(item.toString(), locale));
                    continue;
                }
                buffer.append(item);
            }
            return buffer.toString();
        }

        private String handleOODate(String string, String locale) {
            if (locale.startsWith("de")) {
                if (string.startsWith("T")) {
                    string = string.replace('T', 'D');
                }
                if (string.startsWith("J")) {
                    string = string.replace('J', 'Y');
                }
            } else if (locale.startsWith("nl")) {
                if (string.startsWith("J")) {
                    string = string.replace('J', 'Y');
                }
            } else if (locale.startsWith("fi")) {
                if (string.startsWith("K")) {
                    string = string.replace('K', 'M');
                }
                if (string.startsWith("V")) {
                    string = string.replace('V', 'Y');
                }
                if (string.startsWith("P")) {
                    string = string.replace('P', 'D');
                }
            } else if (locale.startsWith("fr")) {
                if (string.startsWith("J")) {
                    string = string.replace('J', 'D');
                }
                if (string.startsWith("A")) {
                    string = string.replace('A', 'Y');
                }
            } else if (locale.startsWith("es") || locale.startsWith("pt")) {
                if (string.startsWith("A")) {
                    string = string.replace('A', 'Y');
                }
            } else if (locale.startsWith("it")) {
                if (string.startsWith("A")) {
                    string = string.replace('A', 'Y');
                }
                if (string.startsWith("G")) {
                    string = string.replace('G', 'D');
                }
            }
            if (string.startsWith("A")) {
                string = string.replace('A', 'y');
            } else if (string.startsWith("Y") || string.startsWith("W") || string.equals("D") || string.equals("DD")) {
                string = string.toLowerCase();
            } else if (string.equals("DDD") || string.equals("NN")) {
                string = "EEE";
            } else if (string.equals("DDDD") || string.equals("NNN")) {
                string = "EEEE";
            } else {
                if (string.equals("NNNN")) {
                    return "EEEE, ";
                }
                if (string.equals("G")) {
                    string = "G";
                } else if (string.equals("GG")) {
                    string = "G";
                } else if (string.equals("GGG")) {
                    string = "G";
                } else if (string.equals("E")) {
                    string = "y";
                } else if (string.equals("EE") || string.equals("R")) {
                    string = "yy";
                } else if (string.equals("RR")) {
                    string = "Gyy";
                }
            }
            if (!allowedDateTimeCharacters.containsAll(string)) {
                throw new IllegalArgumentException("bad char in: " + string);
            }
            return string;
        }

        public String convertOOTime(String source, String locale) {
            if (source.length() == 0) {
                return "";
            }
            int isAM = (source = source.replace('\"', '\'')).indexOf("AM/PM");
            if (isAM >= 0) {
                source = source.substring(0, isAM) + "a" + source.substring(isAM + 5);
            }
            StringBuffer buffer = new StringBuffer();
            this.fp.set(source);
            for (Object item : this.fp.getItems()) {
                if (item instanceof DateTimePatternGenerator.VariableField) {
                    buffer.append(this.handleOOTime(item.toString(), isAM >= 0));
                    continue;
                }
                buffer.append(item);
            }
            return buffer.toString();
        }

        private String handleOOTime(String string, boolean isAM) {
            char c = string.charAt(0);
            switch (c) {
                case 'H': 
                case 'T': 
                case 'U': 
                case 'h': 
                case 't': 
                case 'u': {
                    string = string.replace(c, isAM ? (char)'h' : 'H');
                    break;
                }
                case 'M': 
                case 'S': {
                    string = string.toLowerCase();
                    break;
                }
                case '0': {
                    string = string.replace('0', 'S');
                }
            }
            if (!allowedDateTimeCharacters.containsAll(string)) {
                throw new IllegalArgumentException("bad char in: " + string);
            }
            return string;
        }
    }

    static class DeprecatedCodeFixer {
        Map<String, String> languageAlias = new HashMap<String, String>();
        Map<String, String> territoryAlias = new HashMap<String, String>();
        LocaleIDParser lip;

        DeprecatedCodeFixer() {
            Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
            CLDRFile supp = cldrFactory.make("supplementalData", false);
            Iterator<String> it = supp.iterator("//supplementalData/metadata/alias/");
            while (it.hasNext()) {
                String path = it.next();
                XPathParts parts = XPathParts.getFrozenInstance(supp.getFullXPath(path));
                String type = parts.getAttributeValue(3, "type");
                String replacement = parts.getAttributeValue(3, "replacement");
                if (parts.getElement(3).equals("languageAlias")) {
                    this.languageAlias.put(type, replacement);
                    continue;
                }
                if (parts.getElement(3).equals("territoryAlias")) {
                    this.territoryAlias.put(type, replacement);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected type: " + path);
            }
            this.territoryAlias.put("CB", "029");
            this.languageAlias.put("no", "nb");
            this.lip = new LocaleIDParser();
        }

        String fixLocale(String locale) {
            this.lip.set(locale);
            String territory = this.lip.getRegion();
            String replacement = this.territoryAlias.get(territory);
            if (replacement != null) {
                this.lip.setRegion(replacement);
            }
            locale = this.lip.toString();
            for (String old : this.languageAlias.keySet()) {
                if (!locale.startsWith(old)) continue;
                if (locale.length() == old.length()) {
                    locale = this.languageAlias.get(old);
                    break;
                }
                if (locale.charAt(old.length()) != '_') continue;
                locale = this.languageAlias.get(old) + locale.substring(old.length());
                break;
            }
            return locale;
        }
    }

    static class LocaleIDFixer {
        LocaleIDParser lip = new LocaleIDParser();
        static final Set<String> mainLocales = new HashSet<String>(Arrays.asList("ar_EG", "bn_IN", "de_DE", "en_US", "es_ES", "fr_FR", "it_IT", "nl_NL", "pt_BR", "sv_SE", "zh_TW"));
        DeprecatedCodeFixer dcf = new DeprecatedCodeFixer();

        LocaleIDFixer() {
        }

        Map<String, String> fixLocales(Collection<String> available, Map<String, String> result) {
            HashMap<String, HashSet<String>> language_locales = new HashMap<String, HashSet<String>>();
            for (String locale : available) {
                String fixedLocale = this.dcf.fixLocale(locale);
                result.put(locale, fixedLocale);
                String language = this.lip.set(fixedLocale).getLanguageScript();
                HashSet<String> locales = (HashSet<String>)language_locales.get(language);
                if (locales == null) {
                    locales = new HashSet<String>();
                    language_locales.put(language, locales);
                }
                locales.add(locale);
            }
            for (String language : language_locales.keySet()) {
                Set locales = (Set)language_locales.get(language);
                if (locales.size() == 1) {
                    result.put((String)locales.iterator().next(), language);
                    continue;
                }
                HashSet<String> intersect = new HashSet<String>(mainLocales);
                intersect.retainAll(locales);
                if (intersect.size() == 1) {
                    result.put((String)intersect.iterator().next(), language);
                    continue;
                }
                if (locales.contains("zh_CN")) {
                    result.put("zh_CN", "zh");
                    continue;
                }
                throw new IllegalArgumentException("Need parent locale: " + locales);
            }
            return result;
        }
    }
}

