/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.util.Output;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CoverageInfo;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexFileParser;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XPathParts;

public class FilterFactory
extends Factory {
    private Factory rawFactory;
    private String organization;
    private boolean modifyValues;
    private List<Modifier> modifiers = new ArrayList<Modifier>();
    private Pattern XPATH_PATTERN = PatternCache.get("/(/\\w++(\\[@\\w++=\"[^\"()%\\\\]+\"])*)++");
    private static final Option.Options options = new Option.Options("Filters CLDR XML files according to orgnizational coverage levels and an input file of replacement values/xpaths.").add("org", Character.valueOf('o'), ".*", Organization.cldr.name(), "The organization that the filtering is for. If set, also removes duplicate paths.").add("locales", Character.valueOf('l'), ".*", ".*", "A regular expression indicating the locales to be filtered");

    private FilterFactory(Factory rawFactory, String organization, boolean modifyValues) {
        this.rawFactory = rawFactory;
        this.organization = organization;
        this.setSupplementalDirectory(rawFactory.getSupplementalDirectory());
        this.modifyValues = modifyValues;
    }

    public static FilterFactory load(Factory rawFactory, String organization, boolean usesAltValue) {
        FilterFactory filterFactory = new FilterFactory(rawFactory, organization, usesAltValue);
        filterFactory.loadModifiers("dataModifiers.txt");
        return filterFactory;
    }

    @Override
    public File[] getSourceDirectories() {
        return this.rawFactory.getSourceDirectories();
    }

    @Override
    public List<File> getSourceDirectoriesForLocale(String localeID) {
        return this.rawFactory.getSourceDirectoriesForLocale(localeID);
    }

    @Override
    protected CLDRFile handleMake(String localeID, boolean resolved, CLDRFile.DraftStatus minimalDraftStatus) {
        if (resolved) {
            return new CLDRFile(this.makeResolvingSource(localeID, minimalDraftStatus));
        }
        return this.filterCldrFile(localeID, minimalDraftStatus);
    }

    private CLDRFile filterCldrFile(String localeID, CLDRFile.DraftStatus minimalDraftStatus) {
        CLDRFile rawFile = this.rawFactory.make(localeID, false, minimalDraftStatus).cloneAsThawed();
        this.filterAltValues(rawFile);
        this.filterCoverage(rawFile);
        this.removeRedundantPaths(rawFile);
        return rawFile;
    }

    private void filterAltValues(CLDRFile rawFile) {
        if (!this.modifyValues) {
            return;
        }
        for (Modifier modifier : this.modifiers) {
            if ((modifier = modifier.filterLocale(rawFile.getLocaleID())).isEmpty()) continue;
            modifier.modifyFile(rawFile);
        }
    }

    private void filterCoverage(CLDRFile rawFile) {
        if (this.organization == null) {
            return;
        }
        byte minLevel = StandardCodes.make().getLocaleCoverageLevel(this.organization, rawFile.getLocaleID()).getLevel();
        CoverageInfo covInfo = CLDRConfig.getInstance().getCoverageInfo();
        for (String xpath : rawFile) {
            int level = covInfo.getCoverageValue(xpath, rawFile.getLocaleID());
            if (level <= minLevel) continue;
            rawFile.remove(xpath);
        }
    }

    private void removeRedundantPaths(CLDRFile rawFile) {
        if (this.organization == null || rawFile.getLocaleID().equals("root")) {
            return;
        }
        String parent = LocaleIDParser.getParent(rawFile.getLocaleID());
        CLDRFile resolvedParent = this.rawFactory.make(parent, true);
        ArrayList<String> duplicatePaths = new ArrayList<String>();
        for (String xpath : rawFile) {
            String parentValue;
            String sourceLocale;
            XPathParts parts;
            String count;
            if (xpath.startsWith("//ldml/identity")) continue;
            String value = rawFile.getStringValue(xpath);
            if (xpath.contains("[@count=") && !(count = (parts = XPathParts.getFrozenInstance(xpath)).getAttributeValue(-1, "count")).equals("other")) {
                parts = parts.cloneAsThawed();
                parts.setAttribute(-1, "count", "other");
                String otherPath = parts.toString();
                if (value.equals(rawFile.getStringValue(otherPath))) {
                    duplicatePaths.add(xpath);
                    continue;
                }
            }
            if ((sourceLocale = resolvedParent.getSourceLocaleID(xpath, null)).equals("code-fallback") || !value.equals(parentValue = resolvedParent.getStringValue(xpath))) continue;
            duplicatePaths.add(xpath);
        }
        for (String xpath : duplicatePaths) {
            rawFile.remove(xpath);
        }
    }

    @Override
    public CLDRFile.DraftStatus getMinimalDraftStatus() {
        return this.rawFactory.getMinimalDraftStatus();
    }

    @Override
    protected Set<String> handleGetAvailable() {
        return this.rawFactory.getAvailable();
    }

    private void loadModifiers(String filename) {
        if (!this.modifyValues) {
            return;
        }
        final PathModifier pathModifier = new PathModifier();
        final PathRegexModifier pathRegexModifier = new PathRegexModifier();
        final ValueModifier valueModifier = new ValueModifier();
        RegexFileParser fileParser = new RegexFileParser();
        fileParser.setLineParser(new RegexFileParser.RegexLineParser(){

            @Override
            public void parse(String line) {
                String[] contents = line.split("\\s*+;\\s*+");
                ModificationType filterType = ModificationType.valueOf(contents[0]);
                String oldValue = contents[1];
                String newValue = contents[2];
                HashMap<String, String> options = new HashMap<String, String>();
                for (int i = 3; i < contents.length; ++i) {
                    String rawLine = contents[i];
                    int pos = rawLine.indexOf(61);
                    if (pos < 0) {
                        throw new IllegalArgumentException("Invalid option: " + rawLine);
                    }
                    String optionType = rawLine.substring(0, pos).trim();
                    options.put(optionType, rawLine.substring(pos + 1).trim());
                }
                switch (filterType) {
                    case xpath: {
                        if (FilterFactory.this.isValidXPath(oldValue)) {
                            pathModifier.addModifierEntry(new ModifierEntry(oldValue, newValue, options));
                            break;
                        }
                        pathRegexModifier.addModifierEntry(new ModifierEntry(FilterFactory.this.fixXPathRegex(oldValue), newValue, options));
                        break;
                    }
                    case value: {
                        String xpath = (String)options.get("xpath");
                        if (xpath != null && !FilterFactory.this.isValidXPath(xpath)) {
                            options.put("xpath", FilterFactory.this.fixXPathRegex(xpath));
                        }
                        valueModifier.addModifierEntry(new ModifierEntry(oldValue, newValue, options));
                    }
                }
            }
        });
        fileParser.parse(FilterFactory.class, filename);
        this.modifiers.add(pathModifier);
        this.modifiers.add(pathRegexModifier);
        this.modifiers.add(valueModifier);
    }

    private boolean isValidXPath(String path) {
        return this.XPATH_PATTERN.matcher(path).matches();
    }

    private String fixXPathRegex(String path) {
        return '^' + path.replace("[@", "\\[@");
    }

    public static void main(String[] args) throws Exception {
        options.parse(args, true);
        Factory rawFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, options.get("locales").getValue());
        String org = options.get("org").getValue();
        FilterFactory filterFactory = FilterFactory.load(rawFactory, org, true);
        String outputDir = CLDRPaths.GEN_DIRECTORY + "/filter";
        for (String locale : rawFactory.getAvailable()) {
            PrintWriter out = FileUtilities.openUTF8Writer(outputDir, locale + ".xml");
            try {
                filterFactory.make(locale, false).write(out);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    private abstract class Modifier {
        protected List<ModifierEntry> entries = new ArrayList<ModifierEntry>();

        private Modifier() {
        }

        public abstract void modifyFile(CLDRFile var1);

        public abstract Modifier filterLocale(String var1);

        protected List<ModifierEntry> getModifiersForLocale(String locale) {
            ArrayList<ModifierEntry> newFilters = new ArrayList<ModifierEntry>();
            for (ModifierEntry filter : this.entries) {
                if (!filter.localeMatches(locale)) continue;
                newFilters.add(filter);
            }
            return newFilters;
        }

        public void addModifierEntry(ModifierEntry entry) {
            this.entries.add(entry);
        }

        public boolean isEmpty() {
            return this.entries.size() == 0;
        }
    }

    private class PathModifier
    extends Modifier {
        private PathModifier() {
        }

        @Override
        public void modifyFile(CLDRFile file) {
            for (ModifierEntry entry : this.entries) {
                String oldPath = entry.oldValue;
                String value = file.getStringValue(oldPath);
                if (value == null) continue;
                String newPath = entry.newValue;
                file.add(newPath, value);
                file.remove(oldPath);
            }
        }

        @Override
        public Modifier filterLocale(String locale) {
            PathModifier newModifier = new PathModifier();
            newModifier.entries = this.getModifiersForLocale(locale);
            return newModifier;
        }
    }

    private class PathRegexModifier
    extends Modifier {
        private RegexLookup<String> xpathLookup = new RegexLookup();

        private PathRegexModifier() {
        }

        @Override
        public void addModifierEntry(ModifierEntry entry) {
            super.addModifierEntry(entry);
            this.xpathLookup.add(entry.oldValue, entry.newValue);
        }

        @Override
        public void modifyFile(CLDRFile file) {
            if (this.xpathLookup.size() > 0) {
                Output<String[]> arguments = new Output<String[]>();
                for (String xpath : file) {
                    String newValue = this.xpathLookup.get(xpath, null, arguments, null, null);
                    if (newValue == null) continue;
                    String newPath = RegexLookup.replace(newValue, (String[])arguments.value);
                    String value = file.getStringValue(xpath);
                    file.add(newPath, value);
                    file.remove(xpath);
                }
            }
        }

        @Override
        public Modifier filterLocale(String locale) {
            PathRegexModifier newModifier = new PathRegexModifier();
            newModifier.entries = this.getModifiersForLocale(locale);
            for (ModifierEntry entry : newModifier.entries) {
                newModifier.xpathLookup.add(entry.oldValue, entry.newValue);
            }
            return newModifier;
        }
    }

    private class ValueModifier
    extends Modifier {
        private ValueModifier() {
        }

        @Override
        public void modifyFile(CLDRFile file) {
            for (ModifierEntry entry : this.entries) {
                String filteringPath = entry.options.get("xpath");
                if (filteringPath != null && FilterFactory.this.isValidXPath(filteringPath)) {
                    String value = file.getStringValue(filteringPath);
                    if (value == null) continue;
                    value = value.replaceAll(entry.oldValue, entry.newValue);
                    file.add(filteringPath, value);
                    continue;
                }
                Iterator<String> iterator = file.iterator();
                if (filteringPath != null) {
                    Matcher matcher = PatternCache.get(filteringPath).matcher("");
                    iterator = file.iterator(matcher);
                }
                while (iterator.hasNext()) {
                    String xpath = iterator.next();
                    String originalValue = file.getStringValue(xpath);
                    String value = originalValue.replaceAll(entry.oldValue, entry.newValue);
                    if (value.equals(originalValue)) continue;
                    file.add(xpath, value);
                }
            }
        }

        @Override
        public Modifier filterLocale(String locale) {
            ValueModifier newModifier = new ValueModifier();
            newModifier.entries = this.getModifiersForLocale(locale);
            return newModifier;
        }
    }

    private class ModifierEntry {
        String oldValue;
        String newValue;
        Map<String, String> options;

        public ModifierEntry(String oldValue, String newValue, Map<String, String> options) {
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.options = options;
        }

        public boolean localeMatches(String locale) {
            String pattern = this.options.get("locale");
            return pattern == null ? true : locale.matches(pattern);
        }
    }

    private static enum ModificationType {
        xpath,
        value;

    }
}

