/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Containment;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.Validity;

public class GenerateLanguageContainment {
    private static final boolean ONLY_LIVING = false;
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    static final Splitter TAB = Splitter.on('\t').trimResults();
    static final CLDRFile ENGLISH = CONFIG.getEnglish();
    static final String relDir = "../util/data/languages/";
    static final Map<String, Row.R2<List<String>, String>> ALIAS_MAP = CONFIG.getSupplementalDataInfo().getLocaleAliasInfo().get("language");
    static final Map<String, String> entityToLabel = GenerateLanguageContainment.loadTsvPairsUnique(GenerateLanguageContainment.class, "../util/data/languages/entityToLabel.tsv", null, null, null);
    static final Function<String, String> NAME = code -> code.equals("mul") ? "root" : ENGLISH.getName((String)code) + " (" + code + ")";
    static final Map<String, String> entityToCode = GenerateLanguageContainment.loadTsvPairsUnique(GenerateLanguageContainment.class, "../util/data/languages/entityToCode.tsv", code -> {
        Row.R2<List<String>, String> v = ALIAS_MAP.get(code = code.replace("\"", ""));
        String result = v == null ? code : (String)((List)v.get0()).get(0);
        result = result.contains("_") ? code : result;
        return result;
    }, null, NAME);
    static final Multimap<String, String> codeToEntity = ImmutableMultimap.copyOf(Multimaps.invertFrom(Multimaps.forMap(entityToCode), LinkedHashMultimap.create()));
    static final Multimap<String, String> childToParent = GenerateLanguageContainment.loadTsvPairs(GenerateLanguageContainment.class, "../util/data/languages/childToParent.tsv", code -> GenerateLanguageContainment.getEntityName(code), code -> GenerateLanguageContainment.getEntityName(code));
    static final Set<String> COLLECTIONS;
    static final Multimap<String, String> EXTRA_PARENT_CHILDREN;
    static final Multimap<String, String> REMOVE_PARENT_CHILDREN;

    public static void main(String[] args) {
        for (String check : Arrays.asList("sw", "km", "ksh", "wae", "kea", "mfe", "th", "lo")) {
            System.out.println("Checking " + ENGLISH.getName(check) + "[" + check + "]");
            Collection<String> entities = codeToEntity.get(check);
            if (entities.isEmpty()) {
                System.out.println("no code for " + check + ": " + entities);
                continue;
            }
            for (String string : entities) {
                Set<List<String>> ancestors = GenerateLanguageContainment.getAllAncestors(string);
                GenerateLanguageContainment.showEntityLists(string + " parents ", ancestors);
                System.out.println();
            }
        }
        Map<Validity.Status, Set<String>> table = Validity.getInstance().getStatusToCodes(StandardCodes.LstrType.language);
        TreeMultimap _parentToChild = TreeMultimap.create();
        TreeSet missing = new TreeSet(table.get((Object)Validity.Status.regular));
        _parentToChild.put("mul", "und");
        for (String string : table.get((Object)Validity.Status.regular)) {
            Collection<String> entities;
            if (string.compareTo("hdz") > 0) {
                boolean ancestors = false;
            }
            if ((entities = codeToEntity.get(string)).isEmpty()) continue;
            for (String entity : entities) {
                if (childToParent.get(entity).isEmpty()) continue;
                Set<Set<String>> chains = GenerateLanguageContainment.getAncestors(entity);
                if (chains.size() > 1) {
                    boolean bl = false;
                }
                for (Set<String> chain : chains) {
                    String last = null;
                    for (String link : chain) {
                        if (last != null) {
                            _parentToChild.put(link, last);
                        }
                        last = link;
                    }
                }
            }
        }
        for (Map.Entry entry : REMOVE_PARENT_CHILDREN.asMap().entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (Collection)entry.getValue()) {
                if (value.equals("*")) {
                    _parentToChild.removeAll(key);
                    continue;
                }
                _parentToChild.remove(key, value);
            }
        }
        _parentToChild.putAll(EXTRA_PARENT_CHILDREN);
        for (String string : Iso639Data.getAvailable()) {
            Iso639Data.Type type = Iso639Data.getType(string);
            if (type != Iso639Data.Type.Constructed) continue;
            _parentToChild.put("art", string);
        }
        ImmutableMultimap<String, String> parentToChild = ImmutableMultimap.copyOf(_parentToChild);
        ImmutableMultimap<String, String> immutableMultimap = ImmutableMultimap.copyOf(Multimaps.invertFrom(parentToChild, TreeMultimap.create()));
        System.out.println("Checking he\t" + Containment.getAllDirected(immutableMultimap, "he"));
        PrintWriter out = new PrintWriter(System.out);
        GenerateLanguageContainment.print(out, parentToChild, new ArrayList<String>(Arrays.asList("mul")));
        System.out.println(out);
        SimpleXMLSource xmlSource = new SimpleXMLSource("languageGroup");
        xmlSource.setNonInheriting(true);
        CLDRFile newFile = new CLDRFile(xmlSource);
        newFile.setDtdType(DtdType.supplementalData);
        newFile.add("//" + (Object)((Object)DtdType.supplementalData) + "/version[@number='$Revision$']", "");
        GenerateLanguageContainment.printXML(newFile, parentToChild);
        try (PrintWriter outFile = FileUtilities.openUTF8Writer(CLDRPaths.SUPPLEMENTAL_DIRECTORY, "languageGroup.xml");){
            newFile.write(outFile);
        }
        catch (IOException e1) {
            throw new ICUUncheckedIOException("Can't write to languageGroup.xml", e1);
        }
    }

    private static void showEntityLists(String title, Set<List<String>> ancestors) {
        ancestors.forEach(new Consumer<List<String>>(){

            @Override
            public void accept(List<String> item) {
                item.forEach(new Consumer<String>(){

                    @Override
                    public void accept(String t) {
                        System.out.println(t + "\t" + entityToCode.get(t) + "\t" + entityToLabel.get(t));
                    }
                });
                System.out.println();
            }
        });
    }

    private static void printXML(CLDRFile newFile, Multimap<String, String> parentToChild) {
        GenerateLanguageContainment.printXML(newFile, parentToChild, "mul");
    }

    private static void printXML(CLDRFile newFile, Multimap<String, String> parentToChild, String base) {
        Collection<String> children = parentToChild.get(base);
        if (children.isEmpty()) {
            return;
        }
        if (!base.equals("und")) {
            newFile.add("//" + (Object)((Object)DtdType.supplementalData) + "/languageGroups/languageGroup[@parent=\"" + base + "\"]", Joiner.on(" ").join(children));
        }
        for (String child : children) {
            GenerateLanguageContainment.printXML(newFile, parentToChild, child);
        }
    }

    private static void print(Writer out, Multimap<String, String> parentToChild, List<String> line) {
        String current = line.get(line.size() - 1);
        Collection<String> children = parentToChild.get(current);
        if (children.isEmpty()) {
            try {
                String sep = "";
                for (String item : line) {
                    out.append(sep).append(NAME.apply(item));
                    sep = " > ";
                }
                out.append('\n');
                out.flush();
            }
            catch (IOException iOException) {}
        } else {
            for (String child : children) {
                line.add(child);
                GenerateLanguageContainment.print(out, parentToChild, line);
                line.remove(line.size() - 1);
            }
        }
    }

    private static Set<Set<String>> getAncestors(String leaf) {
        Set<List<String>> items = Containment.getAllDirected(childToParent, leaf);
        LinkedHashSet<Set<String>> itemsFixed = new LinkedHashSet<Set<String>>();
        block0: for (List<String> item : items) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (String string : item) {
                boolean changed;
                String code = entityToCode.get(string);
                if (code == null) continue;
                if (!linkedHashSet.isEmpty() && !COLLECTIONS.contains(code)) {
                    if (code.equals("zh")) {
                        code = "zhx";
                    } else {
                        GenerateLanguageContainment.log("Skipping inheritance from\t" + linkedHashSet + "\t" + code + "\tfrom\t" + items);
                        continue;
                    }
                }
                if (changed = linkedHashSet.add(code)) continue;
                GenerateLanguageContainment.log("Cycle in\t" + linkedHashSet + "\tfrom\t" + items);
                continue block0;
            }
            if (linkedHashSet.size() <= 1) continue;
            linkedHashSet.add("mul");
            itemsFixed.add(linkedHashSet);
        }
        if (itemsFixed.size() > 1) {
            HashSet<Set> removals = new HashSet<Set>();
            for (Set set : itemsFixed) {
                for (Set set2 : itemsFixed) {
                    if (!set.containsAll(set2) || set2.containsAll(set)) continue;
                    removals.add(set2);
                }
            }
            itemsFixed.removeAll(removals);
        }
        return itemsFixed;
    }

    private static void log(String string) {
        System.out.println(string);
    }

    private static String getBest(Collection<String> parents) {
        for (String parent : parents) {
            Iso639Data.Type type;
            String code = entityToCode.get(parent);
            if (code == null || (type = Iso639Data.getType(code)) != Iso639Data.Type.Living) continue;
            return parent;
        }
        return parents.iterator().next();
    }

    private static String getEntityName(String key) {
        String name;
        String code = entityToCode.get(key);
        if (code != null) {
            try {
                name = NAME.apply(code);
                if (name != null) {
                    return name;
                }
            }
            catch (Exception name2) {
                // empty catch block
            }
        }
        if ((name = entityToLabel.get(key)) != null) {
            return name;
        }
        int last = key.lastIndexOf(47);
        return key.substring(last + 1, key.length() - 1);
    }

    private static Multimap<String, String> loadTsvPairs(Class<?> class1, String file, Function<String, String> keyMapper, Function<String, String> valueMapper) {
        String rel = FileUtilities.getRelativeFileName(class1, file);
        System.out.println(rel);
        ImmutableMultimap.Builder<String, String> _keyToValues = ImmutableMultimap.builder();
        for (String line : FileUtilities.in(class1, file)) {
            if (line.startsWith("?") || line.isEmpty()) continue;
            List<String> parts = TAB.splitToList(line);
            String key = parts.get(0);
            String value = parts.get(1);
            _keyToValues.put(key, value);
        }
        ImmutableMultimap<String, String> result = _keyToValues.build();
        GenerateLanguageContainment.showDups(file, result, keyMapper, valueMapper);
        return result;
    }

    private static Map<String, String> loadTsvPairsUnique(Class<?> class1, String file, Function<String, String> fixValue, Function<String, String> keyMapper, Function<String, String> valueMapper) {
        String rel = FileUtilities.getRelativeFileName(class1, file);
        System.out.println(rel);
        TreeMap<String, String> _keyToValue = new TreeMap();
        TreeMultimap<String, String> _keyToValues = TreeMultimap.create();
        for (String line : FileUtilities.in(class1, file)) {
            if (line.startsWith("?") || line.isEmpty()) continue;
            List<String> parts = TAB.splitToList(line);
            String key = parts.get(0);
            String value = parts.get(1);
            if (fixValue != null) {
                value = fixValue.apply(value);
            }
            _keyToValues.put(key, value);
            String oldValue = (String)_keyToValue.get(key);
            if (oldValue != null && !oldValue.equals("kxm")) continue;
            _keyToValue.put(key, value);
        }
        _keyToValue = ImmutableMap.copyOf(_keyToValue);
        GenerateLanguageContainment.showDups(file, _keyToValues, keyMapper, valueMapper);
        return _keyToValue;
    }

    private static void showDups(String file, Multimap<String, String> _keyToValues, Function<String, String> keyMapper, Function<String, String> valueMapper) {
        for (Map.Entry<String, Collection<String>> entry : _keyToValues.asMap().entrySet()) {
            Collection<String> valueSet = entry.getValue();
            if (valueSet.size() <= 1) continue;
            String key = entry.getKey();
            String string = key = keyMapper == null ? key : keyMapper.apply(key);
            if (valueMapper != null) {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                valueSet.stream().map(valueMapper).forEach(x -> result.add((String)x));
                valueSet = result;
            }
            GenerateLanguageContainment.log(file + "\tMultiple values: " + key + "\t" + valueSet);
        }
    }

    static Set<List<String>> getAllAncestors(String lang) {
        return Containment.getAllDirected(childToParent, lang);
    }

    static {
        Map<String, Map<StandardCodes.LstrField, String>> languages = StandardCodes.getEnumLstreg().get((Object)StandardCodes.LstrType.language);
        ImmutableSet.Builder _collections = ImmutableSet.builder();
        for (Map.Entry<String, Map<StandardCodes.LstrField, String>> e : languages.entrySet()) {
            String scope = e.getValue().get((Object)StandardCodes.LstrField.Scope);
            if (scope == null || !"Collection".equalsIgnoreCase(scope)) continue;
            _collections.add(e.getKey());
        }
        COLLECTIONS = _collections.build();
        EXTRA_PARENT_CHILDREN = ImmutableMultimap.builder().put("mul", "art").put("gmw", "ksh").put("gmw", "wae").put("mul", "tai").put("tai", "th").put("tai", "lo").put("roa", "cpf").put("roa", "cpp").put("ber", "zgh").put("sdv", "saq").put("sw", "swc").put("alv", "agq").put("bnt", "asa").put("bnt", "bez").put("bnt", "cgg").put("bnt", "ebu").put("bnt", "ksb").put("bnt", "lag").put("bnt", "rof").put("bnt", "sbp").put("ngb", "sg").put("alv", "ngb").put("bnt", "jmc").put("bnt", "mer").put("bnt", "mgh").put("bnt", "nmg").put("bnt", "rwk").put("bnt", "seh").put("bnt", "vun").put("bnt", "xog").put("alv", "yav").put("son", "khq").put("euq", "eu").put("mul", "euq").put("mul", "jpx").put("jpx", "ja").put("ira", "lrc").put("grk", "el").put("grk", "grc").put("grk", "gmy").build();
        REMOVE_PARENT_CHILDREN = ImmutableMultimap.builder().put("mul", "und").put("mul", "crp").put("crp", "*").put("sit", "zh").put("inc", "rmg").put("sla", "cu").put("ine", "gmy").put("ine", "el").put("ine", "grc").build();
    }

    static class Tree {
        Set<String> leaves = new LinkedHashSet<String>();

        Tree() {
        }

        void add(List<String> chain) {
            Collections.reverse(chain);
        }
    }
}

