/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.PatternCache;

public enum DtdType {
    ldml("common/dtd/ldml.dtd", null, null, "main", "annotations", "annotationsDerived", "casing", "collation", "rbnf", "segments", "subdivisions"),
    ldmlICU("common/dtd/ldmlICU.dtd", ldml),
    supplementalData("common/dtd/ldmlSupplemental.dtd", null, null, "supplemental", "transforms", "validity"),
    ldmlBCP47("common/dtd/ldmlBCP47.dtd", "1.7.2", null, "bcp47"),
    keyboard("keyboards/dtd/ldmlKeyboard.dtd", "22.1", null, "../keyboards"),
    platform("keyboards/dtd/ldmlPlatform.dtd", "22.1", null, "../keyboards");

    public static final Set<DtdType> STANDARD_SET;
    static Pattern FIRST_ELEMENT;
    public final String dtdPath;
    public final DtdType rootType;
    public final String firstVersion;
    public final Set<String> directories;

    private DtdType(String dtdPath) {
        this(dtdPath, null, null, new String[0]);
    }

    private DtdType(String dtdPath, DtdType realType) {
        this(dtdPath, null, realType, new String[0]);
    }

    private DtdType(String dtdPath, String firstVersion, DtdType realType, String ... directories) {
        this.dtdPath = dtdPath;
        this.rootType = realType == null ? this : realType;
        this.firstVersion = firstVersion;
        this.directories = ImmutableSet.copyOf(directories);
    }

    public static DtdType fromPath(String elementOrPath) {
        Matcher m3 = FIRST_ELEMENT.matcher(elementOrPath);
        m3.lookingAt();
        return DtdType.valueOf(m3.group(1));
    }

    public String header(Class<?> generatedBy) {
        String gline = "";
        if (generatedBy != null) {
            gline = "\n\tGENERATED DATA \u2014 do not manually update!\n\t\tGenerated by tool:\t" + generatedBy.getSimpleName() + "\n";
            for (Annotation annotation : generatedBy.getAnnotations()) {
                if (!(annotation instanceof CLDRTool)) continue;
                gline = gline + "\t\tTool documented on:\t" + ((CLDRTool)annotation).url() + "\n";
                break;
            }
        }
        return "<?xml version='1.0' encoding='UTF-8' ?>\n<!DOCTYPE " + (Object)((Object)this) + " SYSTEM '../../" + this.dtdPath + "'>\n<!--\n\t\u00a9 1991-2017 Unicode, Inc.\n\tUnicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.\n\tFor terms of use, see http://www.unicode.org/copyright.html.\n\tCLDR data files are interpreted according to the LDML specification (http://unicode.org/reports/tr35/).\n" + gline + " -->\n<" + (Object)((Object)this) + ">\n";
    }

    static {
        STANDARD_SET = ImmutableSet.of(ldmlBCP47, supplementalData, ldml, keyboard, platform);
        FIRST_ELEMENT = PatternCache.get("//([^/\\[]*)");
    }
}

