/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;

public abstract class IntMap<T> {
    public static final Comparator<String> LONGEST_FIRST_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return a.length() > b.length() ? -1 : (a.length() < b.length() ? 1 : a.compareTo(b));
        }
    };
    private static final int OBJECT_OVERHEAD = 16;
    private static final int POINTER_OVERHEAD = 16;
    private static final int STRING_OVERHEAD = 32;

    public abstract T get(int var1);

    public abstract Map<T, Integer> getValueMap(Map<T, Integer> var1);

    public Map<T, Integer> getValueMap() {
        return this.getValueMap(new HashMap());
    }

    public abstract int approximateStorage();

    public String toString() {
        return this.getValueMap().toString();
    }

    public static class CompactStringIntMapFactory
    implements IntMapFactory<String> {
        public CompactStringIntMap make(Collection<String> values) {
            TreeSet<String> sorted = new TreeSet<String>(LONGEST_FIRST_COMPARATOR);
            sorted.addAll(values);
            StringBuilder data = new StringBuilder();
            int[] intToValue = new int[sorted.size()];
            int count = 0;
            for (String string : sorted) {
                if (string.length() > 255) {
                    throw new IllegalArgumentException("String too large: CompactStringIntMapFactory only handles strings up to 255 in length");
                }
                int position = data.indexOf(string);
                if (position < 0) {
                    position = data.length();
                    data.append(string);
                }
                intToValue[count++] = position << 8 | string.length();
            }
            return new CompactStringIntMap(data.toString(), intToValue);
        }
    }

    public static class CompactStringIntMap
    extends IntMap<String> {
        private final String data;
        private final int[] intToValue;

        private CompactStringIntMap(String data, int[] intToValue) {
            this.data = data;
            this.intToValue = intToValue;
        }

        @Override
        public String get(int index) {
            int packedIndex = this.intToValue[index];
            int len = packedIndex & 0xFF;
            int dataIndex = packedIndex >>> 8;
            return this.data.substring(dataIndex, dataIndex + len);
        }

        @Override
        public Map<String, Integer> getValueMap(Map<String, Integer> output) {
            for (int i = 0; i < this.intToValue.length; ++i) {
                output.put(this.get(i), i);
            }
            return output;
        }

        @Override
        public int approximateStorage() {
            int size = 48;
            size += this.data.length() * 2 + 32;
            return size += 4 * this.intToValue.length;
        }
    }

    public static class BasicIntMapFactory<T>
    implements IntMapFactory<T> {
        @Override
        public BasicIntMap<T> make(Collection<T> values) {
            return new BasicIntMap(new ArrayList<T>(new HashSet<T>(values)).toArray());
        }
    }

    public static class BasicIntMap<T>
    extends IntMap<T> {
        private final T[] intToValue;

        private BasicIntMap(T[] intToValue) {
            this.intToValue = intToValue;
        }

        @Override
        public T get(int index) {
            return this.intToValue[index];
        }

        @Override
        public Map<T, Integer> getValueMap(Map<T, Integer> output) {
            for (int i = 0; i < this.intToValue.length; ++i) {
                output.put(this.intToValue[i], i);
            }
            return output;
        }

        @Override
        public int approximateStorage() {
            int size = 16;
            for (T item : this.intToValue) {
                size += 4;
                size += item.toString().length() * 2 + 32;
            }
            return size;
        }
    }

    public static interface IntMapFactory<T> {
        public IntMap<T> make(Collection<T> var1);
    }
}

