/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.BufferedReader;
import java.util.Iterator;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.FileReaders;
import org.unicode.cldr.util.With;

public class RegexFileParser {
    private RegexLineParser lineParser;
    private VariableProcessor varProcessor = DEFAULT_VARIABLE_PROCESSOR;
    private static final VariableProcessor DEFAULT_VARIABLE_PROCESSOR = new VariableProcessor(){
        CldrUtility.VariableReplacer variables = new CldrUtility.VariableReplacer();

        @Override
        public void add(String variableName, String value) {
            this.variables.add(variableName, value);
        }

        @Override
        public String replace(String str) {
            return this.variables.replace(str);
        }
    };

    public void setLineParser(RegexLineParser lineParser) {
        this.lineParser = lineParser;
    }

    public void setVariableProcessor(VariableProcessor varProcessor) {
        this.varProcessor = varProcessor;
    }

    public void parse(Class<?> baseClass, String filename) {
        BufferedReader reader = FileReaders.openFile(baseClass, filename);
        Iterable<String> rlsi = With.toIterable(new FileReaders.ReadLineSimpleIterator(reader));
        this.parseStrings(filename, rlsi);
    }

    public void parseStrings(String source, Iterable<String> rlsi) {
        String line = null;
        int lineNumber = 0;
        try {
            Iterator<String> iterator = rlsi.iterator();
            while (iterator.hasNext()) {
                String lineItem;
                line = lineItem = iterator.next();
                ++lineNumber;
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                if (line.charAt(0) == '%') {
                    int pos = line.indexOf("=");
                    if (pos < 0) {
                        throw new IllegalArgumentException("Failed to read variable in " + source + "\t\t(" + lineNumber + ") " + line);
                    }
                    String varName = line.substring(0, pos).trim();
                    String varValue = line.substring(pos + 1).trim();
                    this.varProcessor.add(varName, varValue);
                    continue;
                }
                if (line.contains("%")) {
                    line = this.varProcessor.replace(line);
                }
                this.lineParser.parse(line);
            }
        }
        catch (Exception e) {
            System.err.println("Error reading " + source + " at line " + lineNumber + ": " + line);
            e.printStackTrace();
        }
    }

    public static interface VariableProcessor {
        public void add(String var1, String var2);

        public String replace(String var1);
    }

    public static interface RegexLineParser {
        public void parse(String var1);
    }
}

