/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetSpanner;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.Validity;

public class Units {
    private static final UnicodeSet WHITESPACE = new UnicodeSet("[:whitespace:]").freeze();
    public static Pattern NO_SPACE_PREFIX = Pattern.compile("\\}\ue235?\\p{L}|\\p{L}\ue234?\\{");
    static final UnicodeSetSpanner SPACE_SPANNER = new UnicodeSetSpanner(WHITESPACE);
    public static final Map<String, String> CORE_TO_TYPE;
    public static final Multimap<String, String> TYPE_TO_CORE;
    public static final BiMap<String, String> LONG_TO_SHORT;

    public static String combinePattern(String unitFormat, String compoundPattern, boolean lowercaseUnitIfNoSpaceInCompound) {
        Object[] parameters;
        String modUnit = (String)SPACE_SPANNER.trim(unitFormat.replace("{0}", ""));
        String modFormat = unitFormat.replace(modUnit, MessageFormat.format(compoundPattern, parameters = new String[]{modUnit}));
        if (modFormat.equals(unitFormat)) {
            Object[] parameters1 = new String[]{unitFormat};
            modFormat = MessageFormat.format(compoundPattern, parameters1);
        }
        if (lowercaseUnitIfNoSpaceInCompound && NO_SPACE_PREFIX.matcher(compoundPattern).find()) {
            modFormat = modFormat.replace(modUnit, modUnit.toLowerCase(Locale.ENGLISH));
        }
        return modFormat;
    }

    public static String getShort(String longUnit) {
        return (String)LONG_TO_SHORT.get(longUnit);
    }

    static {
        Set<String> VALID_UNITS = Validity.getInstance().getStatusToCodes(StandardCodes.LstrType.unit).get((Object)Validity.Status.regular);
        TreeMap<String, String> coreToType = new TreeMap<String, String>();
        TreeMultimap<String, String> typeToCore = TreeMultimap.create();
        TreeMap<String, String> longToShort = new TreeMap<String, String>();
        for (String s2 : VALID_UNITS) {
            int dashPos = s2.indexOf(45);
            String unitType = s2.substring(0, dashPos);
            String coreUnit = s2.substring(dashPos + 1);
            longToShort.put(s2, coreUnit);
            coreToType.put(coreUnit, unitType);
            typeToCore.put(unitType, coreUnit);
        }
        CORE_TO_TYPE = ImmutableMap.copyOf(coreToType);
        TYPE_TO_CORE = ImmutableMultimap.copyOf(typeToCore);
        LONG_TO_SHORT = ImmutableBiMap.copyOf(longToShort);
    }
}

