/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.CountryCodeConverter;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.FileReaders;
import org.unicode.cldr.util.SupplementalDataInfo;

public class Unlocode {
    private static final Charset LATIN1 = Charset.forName("ISO8859-1");
    static Map<String, LocodeData> locodeToData = new HashMap<String, LocodeData>();
    static Relation<String, LocodeData> nameToLocodeData = Relation.of(new HashMap(), HashSet.class);
    static Map<String, Iso3166_2Data> iso3166_2Data = new HashMap<String, Iso3166_2Data>();
    static Relation<String, String> ERRORS = Relation.of(new TreeMap(), TreeSet.class);
    static final Set<String> noncountries;
    static final Transform<String, String> REMOVE_ACCENTS;

    public static void loadIso() throws IOException {
        String line;
        BufferedReader br = FileReaders.openFile(CldrUtility.class, "data/external/subdivisionData.txt", CldrUtility.UTF8);
        while ((line = br.readLine()) != null) {
            int hash = line.indexOf(35);
            if (hash >= 0) {
                line = line.substring(0, hash);
            }
            if (line.trim().isEmpty()) continue;
            String[] list = line.split("\t");
            String locode = list[SubdivisionFields.Code_3166_2.ordinal()].trim();
            if (locode.endsWith("*")) {
                locode = locode.substring(0, locode.length() - 1);
            }
            String bestName = list[SubdivisionFields.Subdivision_name.ordinal()].trim();
            Unlocode.putCheckingDuplicate(iso3166_2Data, locode, new Iso3166_2Data(bestName));
        }
        br.close();
    }

    public static void load(int file) throws IOException {
        String line;
        BufferedReader br = FileReaders.openFile(CldrUtility.class, "data/external/2013-1_UNLOCODE_CodeListPart" + file + ".csv", LATIN1);
        ChainedMap.M3 nameToAlternate = ChainedMap.of(new TreeMap(), new TreeMap(), Boolean.class);
        Output<String> tempOutput = new Output<String>();
        String oldCountryCode = null;
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            String[] list = CldrUtility.splitCommaSeparated(line);
            String change = list[0];
            String locSuffix = list[2];
            if (change.equals("X")) continue;
            String countryCode = list[1];
            if (!countryCode.equals(oldCountryCode)) {
                nameToAlternate.clear();
                oldCountryCode = countryCode;
            }
            String name = list[3];
            String name2 = list[4];
            if (change.equals("=")) {
                String[] names = name.split("\\s*=\\s*");
                if (names.length != 2) {
                    throw new IllegalArgumentException();
                }
                nameToAlternate.put(names[1], names[0], Boolean.TRUE);
                if (name.equals(name2)) continue;
                names = name2.split("\\s*=\\s*");
                if (names.length != 2) {
                    throw new IllegalArgumentException();
                }
                nameToAlternate.put(names[1], names[0], Boolean.TRUE);
                continue;
            }
            if (locSuffix.isEmpty()) {
                if (name.startsWith(".")) continue;
                continue;
            }
            name = Unlocode.removeParens(name, tempOutput);
            String name3 = (String)tempOutput.value;
            name2 = Unlocode.removeParens(name2, tempOutput);
            String name4 = (String)tempOutput.value;
            String subdivision = list[5];
            if (!subdivision.isEmpty() && Unlocode.getIso3166_2Data(subdivision = countryCode + "-" + subdivision) == null) {
                ERRORS.put(subdivision, "Missing subdivision " + subdivision + " on line " + line);
            }
            String latLong = list[10];
            float latN = 0.0f;
            float longE = 0.0f;
            if (!latLong.isEmpty()) {
                String[] latlong = latLong.split(" ");
                latN = Unlocode.parse(latlong[0]);
                longE = Unlocode.parse(latlong[1]);
            }
            String locode = countryCode + locSuffix;
            LocodeData locodeData = new LocodeData(locode, name, subdivision, latN, longE);
            Unlocode.putCheckingDuplicate(locodeToData, locode, locodeData);
            Map alternates = nameToAlternate.get(name);
            if (alternates != null) {
                for (String alt : alternates.keySet()) {
                    Unlocode.putCheckingDuplicate(locodeToData, locode, new LocodeData(locode, alt, subdivision, latN, longE));
                }
            }
            if (!name2.equals(name)) {
                Unlocode.putCheckingDuplicate(locodeToData, locode, new LocodeData(locode, name2, subdivision, latN, longE));
                alternates = nameToAlternate.get(name2);
                if (alternates != null) {
                    for (String alt : alternates.keySet()) {
                        Unlocode.putCheckingDuplicate(locodeToData, locode, new LocodeData(locode, alt, subdivision, latN, longE));
                    }
                }
            }
            if (name3 != null) {
                Unlocode.putCheckingDuplicate(locodeToData, locode, new LocodeData(locode, name3, subdivision, latN, longE));
            }
            if (name4 == null || name4.equals(name3)) continue;
            Unlocode.putCheckingDuplicate(locodeToData, locode, new LocodeData(locode, name4, subdivision, latN, longE));
        }
        br.close();
    }

    public static String removeParens(String name, Output<String> tempOutput) {
        int paren = name.indexOf("(");
        tempOutput.value = null;
        if (paren > 0) {
            String temp;
            int paren2 = name.indexOf(")", paren);
            if (paren2 < 0) {
                paren2 = name.length();
            }
            if ((temp = name.substring(paren + 1, paren2)).startsWith("ex ")) {
                tempOutput.value = temp.substring(3);
            }
            name = paren2 == name.length() ? name.substring(0, paren).trim() : (name.substring(0, paren) + name.substring(paren2 + 1)).replace("  ", " ").trim();
        }
        return name;
    }

    public static <K, V extends Mergeable<V>> void putCheckingDuplicate(Map<K, V> map, K key, V value) {
        Mergeable old = (Mergeable)map.get(key);
        if (old != null && !old.equals(value)) {
            try {
                map.put(key, old.merge(value));
            }
            catch (Exception e) {
                ERRORS.put(key.toString(), "Can't merge records: " + key + "\t" + e.getMessage());
            }
        } else {
            map.put(key, value);
        }
    }

    public static LocodeData getLocodeData(String unlocode) {
        return locodeToData.get(unlocode);
    }

    public static Set<Map.Entry<String, LocodeData>> entrySet() {
        return locodeToData.entrySet();
    }

    public static Set<String> getAvailable() {
        return locodeToData.keySet();
    }

    public static Iso3166_2Data getIso3166_2Data(String unlocode) {
        return iso3166_2Data.get(unlocode);
    }

    public static Set<Map.Entry<String, Iso3166_2Data>> isoEntrySet() {
        return iso3166_2Data.entrySet();
    }

    public static Set<String> getAvailableIso3166_2() {
        return iso3166_2Data.keySet();
    }

    public static Relation<String, String> getLoadErrors() {
        return ERRORS;
    }

    private static float parse(String string) {
        int len = string.length();
        char dir = string.charAt(len - 1);
        int result0 = Integer.parseInt(string.substring(0, len - 1));
        float fract = (float)(result0 % 100) / 60.0f;
        fract = (float)((int)(fract * 100.0f + 0.5f)) / 100.0f;
        float result = (float)(result0 / 100) + fract;
        return dir == 'N' || dir == 'E' ? result : -result;
    }

    public static void main(String[] args) throws IOException {
        Relation<String, LocodeData> countryNameToCities = Relation.of(new TreeMap(), TreeSet.class);
        TreeSet<String> errors = new TreeSet<String>();
        Unlocode.loadCitiesCapitals(countryNameToCities, errors);
        Unlocode.loadCitiesOver1M(countryNameToCities, errors);
        SupplementalDataInfo supp = ToolConfig.getToolInstance().getSupplementalDataInfo();
        TreeSet<String> missing = new TreeSet<String>(supp.getBcp47Keys().get("tz"));
        TreeSet<String> already = new TreeSet<String>();
        for (Map.Entry<String, LocodeData> entry : countryNameToCities.keyValueSet()) {
            String countryName = entry.getKey();
            LocodeData item = entry.getValue();
            String firstName = item.names.iterator().next();
            LinkedHashSet<String> remainingNames = new LinkedHashSet<String>(item.names);
            remainingNames.remove(firstName);
            String lowerLocode = item.locode.toLowerCase(Locale.ENGLISH);
            String info = countryName + "\t" + (remainingNames.isEmpty() ? "" : remainingNames) + "\t" + (item.subdivision.isEmpty() ? "" : "(" + item.subdivision + ")");
            if (missing.contains(lowerLocode)) {
                missing.remove(lowerLocode);
                already.add(lowerLocode);
                continue;
            }
            System.out.println("<location type=\"" + lowerLocode + "\">" + firstName + "</location>\t<!--" + info + "-->");
        }
        System.out.println();
        System.out.println(Joiner.on("\n").join(errors));
        System.out.println();
        Unlocode.showLocodes("In exemplars already:", already);
        System.out.println();
        Unlocode.showLocodes("In exemplars but not new cities:", missing);
        System.out.println();
        for (Map.Entry<String, Object> entry : ERRORS.keyValuesSet()) {
            System.out.println(entry.getKey() + "\t" + entry.getValue());
        }
    }

    public static void showLocodes(String title, Set<String> already) {
        TreeSet<String> noData = new TreeSet<String>();
        TreeSet<String> noData2 = new TreeSet<String>();
        for (String locode : already) {
            String upperLocode = locode.toUpperCase(Locale.ENGLISH);
            String countryName = ULocale.getDisplayCountry("und-" + upperLocode.substring(0, 2), ULocale.ENGLISH);
            LocodeData data = locodeToData.get(upperLocode);
            if (data == null) {
                if (locode.length() == 5) {
                    noData.add(locode);
                    continue;
                }
                noData2.add(locode);
                continue;
            }
            System.out.println(title + "\t" + countryName + "\t" + data);
        }
        System.out.println("* No locode data, len 5:\t" + noData);
        System.out.println("* No locode data:\t" + noData2);
    }

    public static int loadCitiesOver1M(Relation<String, LocodeData> countryNameToCities, Set<String> errors2) throws IOException {
        String line;
        int i = 1;
        BufferedReader br = FileReaders.openFile(CldrUtility.class, "data/external/Cities-Over1M.txt");
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] parts = line.split("\t");
            String cityName = parts[2];
            String subdivision = null;
            int bracket = cityName.indexOf(91);
            if (bracket > 0) {
                try {
                    subdivision = cityName.substring(bracket + 1, cityName.indexOf(93));
                    cityName = cityName.substring(0, bracket);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(cityName);
                }
            }
            String countryName = parts[3];
            Unlocode.add(countryName, subdivision, cityName, countryNameToCities, errors2);
        }
        br.close();
        return i;
    }

    public static int loadCitiesCapitals(Relation<String, LocodeData> countryNameToCities, Set<String> errors2) throws IOException {
        String line;
        int i = 1;
        BufferedReader br = FileReaders.openFile(CldrUtility.class, "data/external/Cities-CountryCapitals.txt");
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] parts = line.split(" *\t *");
            String cityName = parts[0];
            String countryName = parts[1];
            Unlocode.add(countryName, null, cityName, countryNameToCities, errors2);
        }
        br.close();
        return i;
    }

    static void add(String countryName, String subdivision, String cityName, Relation<String, LocodeData> countryNameToCities, Set<String> errors2) {
        String cityName2;
        String countryCode = CountryCodeConverter.getCodeFromName(countryName, false);
        if (countryCode == null) {
            if (noncountries.contains(countryName)) {
                return;
            }
            errors2.add("**Couldn't find country " + countryName);
        }
        countryName = ULocale.getDisplayCountry("und-" + countryCode, ULocale.ENGLISH);
        Set<LocodeData> locodeDatas = nameToLocodeData.get(cityName);
        if (locodeDatas == null && !cityName.equals(cityName2 = REMOVE_ACCENTS.transform(cityName))) {
            locodeDatas = nameToLocodeData.get(cityName2);
        }
        if (locodeDatas == null) {
            errors2.add("** No matching record for\t" + countryName + "\t" + countryCode + "\t" + cityName);
        } else {
            LinkedHashSet<LocodeData> rem = new LinkedHashSet<LocodeData>();
            for (LocodeData x : locodeDatas) {
                if (!x.locode.startsWith(countryCode)) continue;
                if (x.subdivision.equals(subdivision)) {
                    rem.clear();
                    rem.add(x);
                    break;
                }
                rem.add(x);
            }
            if (rem.size() == 0) {
                errors2.add("** No matching country record for\t" + countryName + "\t" + countryCode + "\t" + cityName + "\t" + locodeDatas);
            } else if (rem.size() != 1) {
                errors2.add("** Multiple matching country records for\t" + countryName + "\t" + countryCode + "\t" + cityName + "\t" + rem);
            } else {
                LocodeData locodeData = (LocodeData)rem.iterator().next();
                countryNameToCities.put(countryName, locodeData);
            }
        }
    }

    static {
        try {
            Unlocode.loadIso();
            iso3166_2Data = Collections.unmodifiableMap(iso3166_2Data);
            Unlocode.load(1);
            Unlocode.load(2);
            Unlocode.load(3);
            try {
                String line;
                BufferedReader br = FileReaders.openFile(CldrUtility.class, "data/external/alternate_locode_name.txt");
                while ((line = br.readLine()) != null) {
                    int hash = line.indexOf(35);
                    if (hash >= 0) {
                        line = line.substring(0, hash);
                    }
                    if ((line = line.trim()).isEmpty()) continue;
                    if (line.equals("EOF")) break;
                    String[] parts = line.split("\\s*;\\s*");
                    String locode = parts[0].replace(" ", "");
                    if (locode.length() != 5) {
                        throw new IllegalArgumentException(line);
                    }
                    String alternateName = parts[1];
                    LocodeData locodeData = locodeToData.get(locode);
                    Unlocode.putCheckingDuplicate(locodeToData, locode, new LocodeData(locode, alternateName, locodeData.subdivision, locodeData.north, locodeData.east));
                }
                br.close();
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
            for (LocodeData s2 : locodeToData.values()) {
                for (String name : s2.names) {
                    nameToLocodeData.put(name, s2);
                }
            }
            nameToLocodeData.freeze();
            locodeToData = Collections.unmodifiableMap(locodeToData);
            ERRORS.freeze();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        noncountries = new HashSet<String>(Arrays.asList("United States Virgin Islands", "Akrotiri and Dhekelia", "Easter Island", "Somaliland", "Northern Cyprus", "Nagorno-Karabakh Republic", "Abkhazia", "Transnistria", "South Ossetia"));
        REMOVE_ACCENTS = Transliterator.getInstance("nfd;[:mn:]remove");
    }

    static enum SubdivisionFields {
        Subdivision_category,
        Code_3166_2,
        Subdivision_name,
        Language_code,
        Romanization_system,
        Parent_subdivision;

    }

    public static class Iso3166_2Data
    implements Mergeable<Iso3166_2Data> {
        public final Set<String> names;

        public Iso3166_2Data(String ... name) {
            this(Arrays.asList(name));
        }

        public Iso3166_2Data(Collection<String> names) {
            this.names = Collections.unmodifiableSet(new LinkedHashSet<String>(names));
        }

        public String toString() {
            return this.names.toString();
        }

        public boolean equals(Object obj) {
            return this.names.equals(obj);
        }

        public int hashCode() {
            return this.names.hashCode();
        }

        @Override
        public Iso3166_2Data merge(Iso3166_2Data b) {
            LinkedHashSet<String> set = new LinkedHashSet<String>(this.names);
            set.addAll(b.names);
            return new Iso3166_2Data(set);
        }
    }

    public static interface Mergeable<T> {
        public T merge(T var1);
    }

    public static class LocodeData
    implements Mergeable<LocodeData>,
    Comparable<LocodeData> {
        public final String locode;
        public final Set<String> names;
        public final String subdivision;
        public final float north;
        public final float east;

        public LocodeData(String locode, String name, String subdivision, float north, float east) {
            this(locode, Arrays.asList(name), subdivision, north, east);
        }

        public LocodeData(String locode, Collection<String> names, String subdivision, float north, float east) {
            this.locode = locode;
            this.names = Collections.unmodifiableSet(new LinkedHashSet<String>(names));
            this.subdivision = subdivision;
            this.north = north;
            this.east = east;
        }

        public String toString() {
            return this.names + ", " + this.locode + ", " + this.subdivision + ", " + this.north + ", " + this.east;
        }

        @Override
        public int compareTo(LocodeData o) {
            return this.locode.compareTo(o.locode);
        }

        public boolean equals(Object obj) {
            LocodeData other = (LocodeData)obj;
            return this.locode.equals(other.locode);
        }

        public int hashCode() {
            return this.locode.hashCode();
        }

        @Override
        public LocodeData merge(LocodeData other) {
            if (this.locode.equals(other.locode) && this.subdivision.equals(other.subdivision) && this.north == other.north && this.east == other.east) {
                LinkedHashSet<String> set = new LinkedHashSet<String>(this.names);
                set.addAll(other.names);
                return new LocodeData(this.locode, set, this.subdivision, this.north, this.east);
            }
            throw new IllegalArgumentException("Can't merge " + this + " with " + other);
        }
    }
}

