/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.XEquivalenceClass;

public class VariantFolder {
    private AlternateFetcher alternateFetcher;
    public static XEquivalenceClass.SetMaker mySetMaker = new XEquivalenceClass.SetMaker(){
        Comparator c = new UTF16.StringComparator(true, false, 0);
        Comparator bestIsLowest = new Comparator(){

            public int compare(Object o1, Object o2) {
                int len2;
                boolean canonical2;
                boolean casefold2;
                String s1 = o1.toString();
                String s2 = o2.toString();
                boolean casefold1 = UCharacter.foldCase(s1, true).equals(s1);
                if (casefold1 != (casefold2 = UCharacter.foldCase(s2, true).equals(s2))) {
                    return casefold1 ? -1 : 1;
                }
                boolean canonical1 = Normalizer.isNormalized(s1, Normalizer.COMPOSE, 0);
                if (canonical1 != (canonical2 = Normalizer.isNormalized(s2, Normalizer.COMPOSE, 0))) {
                    return canonical1 ? -1 : 1;
                }
                int len1 = s1.codePointCount(0, s1.length());
                if (len1 != (len2 = s2.codePointCount(0, s2.length()))) {
                    return len1 - len2;
                }
                return c.compare(s1, s2);
            }
        };

        public Set make() {
            return new TreeSet(this.bestIsLowest);
        }
    };
    public static final UnicodeSet NORMAL_CHARS = new UnicodeSet("[^[:c:]]");

    public VariantFolder(AlternateFetcher alternateFetcher) {
        this.alternateFetcher = alternateFetcher;
    }

    public Set<String> getClosure(String source) {
        int i;
        int stringLength = source.length();
        if (stringLength == 0) {
            HashSet<String> result = new HashSet<String>();
            result.add(source);
            return result;
        }
        Set[][] combos = new Set[stringLength][];
        for (i = 0; i < stringLength; ++i) {
            combos[i] = new Set[stringLength - i];
        }
        for (i = 0; i < stringLength; ++i) {
            combos[0][i] = this.alternateFetcher.getAlternates(source.substring(i, i + 1), new HashSet<String>());
        }
        for (int level = 1; level < stringLength; ++level) {
            for (int start = 0; start < stringLength - level; ++start) {
                int limit = start + level + 1;
                HashSet<String> hashSet = new HashSet<String>();
                combos[level][start] = hashSet;
                HashSet<String> current = hashSet;
                current.addAll(this.alternateFetcher.getAlternates(source.substring(start, limit), new HashSet<String>()));
                for (int breakPoint = start + 1; breakPoint < limit; ++breakPoint) {
                    this.addCrossProduct(combos[breakPoint - start - 1][start], combos[limit - breakPoint - 1][breakPoint], current);
                }
            }
        }
        return combos[combos.length - 1][0];
    }

    private void addCrossProduct(Collection<String> source1, Collection<String> source2, Collection<String> output) {
        for (String x : source1) {
            for (String y : source2) {
                output.add(x + y);
            }
        }
    }

    public UnicodeSet getClosure(UnicodeSet input) {
        UnicodeSet result = new UnicodeSet();
        UnicodeSetIterator it = new UnicodeSetIterator(input);
        while (it.next()) {
            Set<String> temp = this.getClosure(it.getString());
            for (String s2 : temp) {
                result.add(s2);
            }
        }
        return result;
    }

    public String reduce(String s2) {
        Set<String> temp = this.getClosure(s2);
        return temp.iterator().next();
    }

    public UnicodeSet reduce(UnicodeSet input) {
        UnicodeSet result = new UnicodeSet();
        UnicodeSetIterator it = new UnicodeSetIterator(input);
        while (it.next()) {
            String reduce = this.reduce(it.getString());
            result.add(reduce);
        }
        return result;
    }

    public static interface AlternateFetcher {
        public Set<String> getAlternates(String var1, Set<String> var2);
    }

    public static class CaseVariantFolder
    implements AlternateFetcher {
        private static final UnicodeSet NORMAL_CHARS = new UnicodeSet("[^[:c:]]");
        static XEquivalenceClass equivalents = new XEquivalenceClass("none", mySetMaker);

        @Override
        public Set<String> getAlternates(String item, Set<String> output) {
            output.add(item);
            return equivalents.getEquivalences(item);
        }

        static {
            UnicodeSetIterator it = new UnicodeSetIterator(NORMAL_CHARS);
            while (it.next()) {
                String item = it.getString();
                equivalents.add(item, UCharacter.toLowerCase(item));
                equivalents.add(item, UCharacter.toUpperCase(item));
                equivalents.add(item, UCharacter.foldCase(item, true));
                equivalents.add(item, UCharacter.toTitleCase(ULocale.ROOT, item, null));
            }
        }
    }

    public static class CanonicalFolder
    implements AlternateFetcher {
        static XEquivalenceClass equivalents = new XEquivalenceClass("none", mySetMaker);

        @Override
        public Set<String> getAlternates(String item, Set<String> output) {
            output.add(item);
            return equivalents.getEquivalences(item);
        }

        static {
            UnicodeSetIterator it = new UnicodeSetIterator(NORMAL_CHARS);
            while (it.next()) {
                String item = it.getString();
                equivalents.add(item, Normalizer.decompose(item, false));
                equivalents.add(item, Normalizer.compose(item, false));
            }
        }
    }

    public static class CompatibilityFolder
    implements AlternateFetcher {
        private static final UnicodeSet NORMAL_CHARS = new UnicodeSet("[^[:c:]]");
        static XEquivalenceClass equivalents = new XEquivalenceClass("none", mySetMaker);

        @Override
        public Set<String> getAlternates(String item, Set<String> output) {
            output.add(item);
            return equivalents.getEquivalences(item);
        }

        static {
            UnicodeSetIterator it = new UnicodeSetIterator(NORMAL_CHARS);
            while (it.next()) {
                String item = it.getString();
                equivalents.add(item, Normalizer.decompose(item, true));
                equivalents.add(item, Normalizer.compose(item, true));
            }
        }
    }
}

