/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.PathUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@CLDRTool(alias="validate", description="Check XML files for validity")
public class XMLValidator {
    public static boolean quiet = false;
    public static boolean parseonly = false;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("No files specified. Validation failed. Use --help for help.");
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-q") || args[i].equals("--quiet")) {
                quiet = true;
                continue;
            }
            if (args[i].equals("--help")) {
                XMLValidator.usage();
                return;
            }
            if (args[i].equals("--parseonly")) {
                System.err.println("# DTD Validation is disabled. Will only check for well formed XML.");
                parseonly = true;
                continue;
            }
            File f = new File(args[i]);
            if (f.isDirectory()) {
                XMLValidator.parseDirectory(f);
                continue;
            }
            if (!quiet) {
                System.out.println("Processing file " + args[i]);
            }
            new fileParserThread(args[i]).run();
        }
        if (parseonly) {
            System.err.println("# DTD Validation is disabled. Only checked for well formed XML.");
        }
    }

    private static void parseDirectory(File f) throws IOException {
        for (File s2 : f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                if (arg1.startsWith(".")) {
                    return false;
                }
                File n = new File(arg0, arg1);
                if (n.isDirectory()) {
                    try {
                        XMLValidator.parseDirectory(n);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.err.println("Error " + e.toString() + " parsing " + arg0.getPath());
                    }
                    return false;
                }
                return arg1.endsWith(".xml");
            }
        })) {
            if (!quiet) {
                System.out.println("Processing file " + s2.getPath());
            }
            new fileParserThread(PathUtilities.getNormalizedPathString(s2)).run();
        }
    }

    private static void usage() {
        System.err.println("usage:  " + XMLValidator.class.getName() + " [ -q ] [ --help ] [ --parseonly ] file ...");
        System.err.println("usage:  " + XMLValidator.class.getName() + " [ -q ] [ --help ] [ --parseonly ] directory ...");
    }

    public static String filenameToURL(String filename) {
        if (null == filename) {
            return null;
        }
        if (filename.startsWith("file:") || filename.startsWith("http:") || filename.startsWith("ftp:") || filename.startsWith("gopher:") || filename.startsWith("mailto:") || filename.startsWith("news:") || filename.startsWith("telnet:")) {
            return filename;
        }
        File f = new File(filename);
        String tmp = PathUtilities.getNormalizedPathString(f);
        if (File.separatorChar == '\\') {
            tmp = tmp.replace('\\', '/');
        }
        if (tmp.startsWith("/")) {
            return "file://" + tmp;
        }
        return "file:///" + tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Document parse(InputSource docSrc, String filename) {
        Document doc;
        block18: {
            try (FileInputStream fis2 = null;){
                fis2 = new FileInputStream(filename);
                byte[] bytes = new byte[3];
                if (fis2.read(bytes) == 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                    System.err.println(filename + ": ERROR: contains UTF-8 BOM (shouldn't happen in CLDR XML files)");
                }
            }
            catch (IOException fis2) {
                // empty catch block
            }
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            if (!parseonly) {
                dfactory.setNamespaceAware(true);
                dfactory.setValidating(true);
            }
            final String filename2 = filename;
            ErrorHandler nullHandler = new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    System.err.println(filename2 + ": Warning: " + e.getMessage());
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    int col = e.getColumnNumber();
                    System.err.println(filename2 + ":" + e.getLineNumber() + (col >= 0 ? ":" + col : "") + ": ERROR: Element " + e.getPublicId() + " is not valid because " + e.getMessage());
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    System.err.println(filename2 + ": ERROR ");
                    throw e;
                }
            };
            doc = null;
            try {
                DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
                docBuilder.setErrorHandler(nullHandler);
                doc = docBuilder.parse(docSrc);
            }
            catch (Throwable se) {
                if (se instanceof SAXParseException) {
                    SAXParseException pe = (SAXParseException)se;
                    int col = pe.getColumnNumber();
                    System.err.println(filename + ":" + pe.getLineNumber() + (col >= 0 ? ":" + col : "") + ": ERROR:" + se.toString());
                } else {
                    System.err.println(filename + ": ERROR:" + se.toString());
                }
                try {
                    throw new RuntimeException(filename + ": XMLComparator not HTML parser!");
                }
                catch (Exception e) {
                    if (filename == null) break block18;
                    try {
                        String tmp;
                        FileReader fr = new FileReader(filename);
                        BufferedReader br = new BufferedReader(fr);
                        StringBuffer buffer = new StringBuffer();
                        while ((tmp = br.readLine()) != null) {
                            buffer.append(tmp);
                            buffer.append("\n");
                        }
                        br.close();
                        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
                        doc = docBuilder.newDocument();
                        Element outElem = doc.createElement("out");
                        Text textNode = doc.createTextNode(buffer.toString());
                        outElem.appendChild(textNode);
                        doc.appendChild(outElem);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return doc;
    }

    public static class fileParserThread
    extends Thread {
        String filename;

        fileParserThread(String _filename) {
            this.filename = _filename;
        }

        @Override
        public void run() {
            String docURI = XMLValidator.filenameToURL(this.filename);
            XMLValidator.parse(new InputSource(docURI), this.filename);
        }
    }
}

