/*
 * Decompiled with CFR 0.152.
 */
package com.google.myanmartools;

import java.util.regex.Pattern;

class Rule {
    Pattern pattern;
    String substitution;
    boolean matchOnStart = false;
    int revisitPosition = -1;
    String info = "";
    String contextBefore = "";
    String contextAfter = "";

    Rule(String patternString, String substitutionString) {
        this.pattern = Pattern.compile("^" + patternString);
        this.substitution = substitutionString;
    }

    Rule setInfo(String ruleInfo) {
        this.info = ruleInfo;
        return this;
    }

    Rule setMatchOnStart() {
        this.matchOnStart = true;
        return this;
    }

    Rule setRevisitPosition(int newPos) {
        this.revisitPosition = newPos;
        return this;
    }

    Rule setBeforeContext(String before) {
        this.contextBefore = before;
        return this;
    }

    Rule setAfterContext(String after) {
        this.contextAfter = after;
        return this;
    }

    String printRule() {
        String result = "    R " + this.info + " p: " + this.pattern + " s: " + this.substitution;
        if (this.matchOnStart) {
            result = result + " matchOnStart=True ";
        }
        if (this.revisitPosition >= 0) {
            result = result + " revisitPosition= " + this.revisitPosition;
        }
        if (this.matchOnStart) {
            result = result + " matchOnStart = true";
        }
        if (!"".equals(this.contextBefore)) {
            result = result + " contextAfter = " + this.contextBefore;
        }
        if (!"".equals(this.contextAfter)) {
            result = result + " contextAfter = " + this.contextAfter;
        }
        return result + "\n";
    }
}

