/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.SetComparator;

public class KeyboardModifierSet {
    static final SetComparator<Modifier> SINGLETON_COMPARATOR = new SetComparator();
    private final String input;
    private final Set<Set<Modifier>> variants;

    private KeyboardModifierSet(String input, Set<EnumSet<Modifier>> variants) {
        this.input = input;
        TreeSet<Modifier> safe = new TreeSet<Modifier>(SINGLETON_COMPARATOR);
        for (EnumSet<Modifier> item : variants) {
            safe.add((Modifier)((Object)Collections.unmodifiableSet(item)));
        }
        this.variants = safe;
    }

    public Set<Set<Modifier>> getVariants() {
        return this.variants;
    }

    public boolean contains(EnumSet<Modifier> combination) {
        return this.variants.contains(combination);
    }

    public String getInput() {
        return this.input;
    }

    public String toString() {
        return this.input + " => " + this.variants;
    }

    public boolean equals(Object arg0) {
        return arg0 == null ? false : this.variants.equals(((KeyboardModifierSet)arg0).variants);
    }

    public int hashCode() {
        return this.variants.hashCode();
    }

    public static KeyboardModifierSet parseSet(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Input string cannot be null");
        }
        String[] modifierSetInputs = input.trim().split(" ");
        HashSet<EnumSet<Modifier>> variants = new HashSet<EnumSet<Modifier>>();
        for (String modifierSetInput : modifierSetInputs) {
            variants.addAll(KeyboardModifierSet.parseSingleSet(modifierSetInput));
        }
        return new KeyboardModifierSet(input, variants);
    }

    private static Set<EnumSet<Modifier>> parseSingleSet(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Input string cannot be null");
        }
        if (input.contains(" ")) {
            throw new IllegalArgumentException("Input string contains more than one combination");
        }
        String[] modifiers = input.trim().split("\\+");
        ArrayList<EnumSet<Modifier>> variants = new ArrayList<EnumSet<Modifier>>();
        variants.add(EnumSet.noneOf(Modifier.class));
        if (input.isEmpty()) {
            return new HashSet<EnumSet<Modifier>>(variants);
        }
        for (String modifier : modifiers) {
            ArrayList<EnumSet<Modifier>> newVariants;
            String modifierElementString = modifier.replace("?", "");
            if (ModifierParent.isParentModifier(modifierElementString)) {
                ModifierParent parentModifier = ModifierParent.valueOf(modifierElementString);
                newVariants = new HashSet();
                for (EnumSet enumSet : variants) {
                    EnumSet<Modifier> leftVariant = EnumSet.copyOf(enumSet);
                    leftVariant.add(parentModifier.leftChild);
                    newVariants.add(leftVariant);
                    EnumSet<Modifier> rightVariant = EnumSet.copyOf(enumSet);
                    rightVariant.add(parentModifier.rightChild);
                    newVariants.add(rightVariant);
                    if (modifier.contains("?")) {
                        EnumSet<Modifier> bothChildrenVariant = EnumSet.copyOf(enumSet);
                        bothChildrenVariant.add(parentModifier.rightChild);
                        bothChildrenVariant.add(parentModifier.leftChild);
                        newVariants.add(bothChildrenVariant);
                        continue;
                    }
                    enumSet.add(parentModifier.rightChild);
                    enumSet.add(parentModifier.leftChild);
                }
                variants.addAll(newVariants);
                continue;
            }
            Modifier modifierElement = Modifier.valueOf(modifierElementString);
            if (!modifier.contains("?")) {
                for (EnumSet enumSet : variants) {
                    enumSet.add(modifierElement);
                }
                continue;
            }
            newVariants = new ArrayList<EnumSet<Modifier>>();
            for (EnumSet enumSet : variants) {
                EnumSet<Modifier> newVariant = EnumSet.copyOf(enumSet);
                newVariant.add(modifierElement);
                newVariants.add(newVariant);
            }
            variants.addAll(newVariants);
        }
        return new HashSet<EnumSet<Modifier>>(variants);
    }

    public boolean containsSome(KeyboardModifierSet keyMapModifiers) {
        for (Set<Modifier> item : keyMapModifiers.variants) {
            if (!this.variants.contains(item)) continue;
            return true;
        }
        return false;
    }

    public String getShortInput() {
        int pos = this.input.indexOf(32);
        if (pos < 0) {
            return this.input;
        }
        return this.input.substring(0, pos) + "\u2026";
    }

    private static enum ModifierParent {
        ctrl(Modifier.ctrlL, Modifier.ctrlR),
        alt(Modifier.altL, Modifier.altR),
        opt(Modifier.optL, Modifier.optR),
        shift(Modifier.shiftL, Modifier.shiftR);

        private final Modifier leftChild;
        private final Modifier rightChild;

        private ModifierParent(Modifier leftChild, Modifier rightChild) {
            this.leftChild = leftChild;
            this.rightChild = rightChild;
        }

        private static boolean isParentModifier(String modifier) {
            try {
                ModifierParent.valueOf(modifier);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }

    public static enum Modifier {
        cmd,
        ctrlL,
        ctrlR,
        caps,
        altL,
        altR,
        optL,
        optR,
        shiftL,
        shiftR;

    }
}

