/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard.test;

import com.ibm.icu.dev.test.TestFmwk;
import org.unicode.cldr.draft.keyboard.IsoLayoutPosition;
import org.unicode.cldr.draft.keyboard.KeycodeMap;

public class KeycodeMapTest
extends TestFmwk {
    public void testGetIsoLayoutPosition() {
        String csv = "keycode,iso\n50,E03\n80,D10\n4,B00";
        KeycodeMap mapping = KeycodeMap.fromCsv(csv);
        this.assertEquals("", (Object)IsoLayoutPosition.E03, (Object)mapping.getIsoLayoutPosition(50));
    }

    public void testGetIsoLayoutPositionForMissingValue() {
        String csv = "keycode,iso\n50,E03\n80,D10\n4,B00";
        KeycodeMap mapping = KeycodeMap.fromCsv(csv);
        try {
            mapping.getIsoLayoutPosition(100);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFromCsvMissingHeaders() {
        String csv = "50,E03\n4,B00";
        try {
            KeycodeMap.fromCsv(csv);
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

