/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.util.ULocale;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Timer;

public class CoverageLevel2 {
    private static final boolean DEBUG_LOOKUP = false;
    private RegexLookup<Level> lookup = null;
    final LocaleSpecificInfo myInfo = new LocaleSpecificInfo();

    private CoverageLevel2(SupplementalDataInfo sdi, String locale) {
        this.myInfo.targetLanguage = new LanguageTagParser().set(locale).getLanguage();
        this.myInfo.cvi = sdi.getCoverageVariableInfo(this.myInfo.targetLanguage);
        this.lookup = sdi.getCoverageLookup();
    }

    @Deprecated
    public static CoverageLevel2 getInstance(String locale) {
        return new CoverageLevel2(SupplementalDataInfo.getInstance(), locale);
    }

    public static CoverageLevel2 getInstance(SupplementalDataInfo sdi, String locale) {
        return new CoverageLevel2(sdi, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Level getLevel(String path) {
        if (path == null) {
            return Level.UNDETERMINED;
        }
        RegexLookup<Level> regexLookup = this.lookup;
        synchronized (regexLookup) {
            Level result = this.lookup.get(path, this.myInfo, null);
            return result == null ? Level.COMPREHENSIVE : result;
        }
    }

    public int getIntLevel(String path) {
        return this.getLevel(path).getLevel();
    }

    public static void main(String[] args) {
        CoverageLevel2 cv2 = CoverageLevel2.getInstance("de");
        ULocale uloc = new ULocale("de");
        CLDRConfig testInfo = ToolConfig.getToolInstance();
        SupplementalDataInfo supplementalDataInfo2 = testInfo.getSupplementalDataInfo();
        CLDRFile englishPaths1 = testInfo.getEnglish();
        Set englishPaths = Builder.with(new TreeSet()).addAll(englishPaths1).get();
        Timer timer = new Timer();
        timer.start();
        for (String path : englishPaths) {
            int n = supplementalDataInfo2.getCoverageValueOld(path, uloc);
        }
        long oldTime = timer.getDuration();
        System.out.println(timer.toString(1L));
        timer.start();
        for (String path : englishPaths) {
            int n = cv2.getIntLevel(path);
        }
        System.out.println(timer.toString(1L, oldTime));
        for (String path : englishPaths) {
            int oldLevel;
            int newLevel = cv2.getIntLevel(path);
            if (newLevel == (oldLevel = supplementalDataInfo2.getCoverageValueOld(path, uloc))) continue;
            newLevel = cv2.getIntLevel(path);
            System.out.println(oldLevel + "\t" + newLevel + "\t" + path);
        }
    }

    public static class MyRegexFinder
    extends RegexLookup.RegexFinder {
        private final SetMatchType additionalMatch;
        private final SupplementalDataInfo.CoverageLevelInfo ci;

        public MyRegexFinder(String pattern, String additionalMatch, SupplementalDataInfo.CoverageLevelInfo ci) {
            super(pattern);
            this.additionalMatch = additionalMatch == null ? null : SetMatchType.valueOf(additionalMatch.substring(2, additionalMatch.length() - 1).replace('-', '_'));
            this.ci = ci;
        }

        @Override
        public boolean find(String item, Object context, RegexLookup.Finder.Info info) {
            LocaleSpecificInfo localeSpecificInfo = (LocaleSpecificInfo)context;
            boolean lstOK = false;
            if (this.ci.inLanguage == null && this.ci.inScriptSet == null && this.ci.inTerritorySet == null) {
                lstOK = true;
            } else if (this.ci.inLanguage != null && this.ci.inLanguage.matcher(localeSpecificInfo.targetLanguage).matches()) {
                lstOK = true;
            } else if (this.ci.inScriptSet != null && !Collections.disjoint(this.ci.inScriptSet, localeSpecificInfo.cvi.targetScripts)) {
                lstOK = true;
            } else if (this.ci.inTerritorySet != null && !Collections.disjoint(this.ci.inTerritorySet, localeSpecificInfo.cvi.targetTerritories)) {
                lstOK = true;
            }
            if (!lstOK) {
                return false;
            }
            boolean result = super.find(item, context, info);
            if (!result) {
                return false;
            }
            if (this.additionalMatch != null) {
                String groupMatch = info.value[1];
                switch (this.additionalMatch) {
                    case Target_Language: {
                        return localeSpecificInfo.targetLanguage.equals(groupMatch);
                    }
                    case Target_Scripts: {
                        return localeSpecificInfo.cvi.targetScripts.contains(groupMatch);
                    }
                    case Target_Territories: {
                        return localeSpecificInfo.cvi.targetTerritories.contains(groupMatch);
                    }
                    case Target_TimeZones: {
                        return localeSpecificInfo.cvi.targetTimeZones.contains(groupMatch);
                    }
                    case Target_Currencies: {
                        return localeSpecificInfo.cvi.targetCurrencies.contains(groupMatch);
                    }
                    case Target_Plurals: {
                        return groupMatch == null || groupMatch.length() == 0 || localeSpecificInfo.cvi.targetPlurals.contains(groupMatch);
                    }
                    case Calendar_List: {
                        return localeSpecificInfo.cvi.calendars.contains(groupMatch);
                    }
                }
            }
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    }

    private static class LocaleSpecificInfo {
        SupplementalDataInfo.CoverageVariableInfo cvi;
        String targetLanguage;

        private LocaleSpecificInfo() {
        }
    }

    static enum SetMatchType {
        Target_Language,
        Target_Scripts,
        Target_Territories,
        Target_TimeZones,
        Target_Currencies,
        Target_Plurals,
        Calendar_List;

    }
}

