/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.Transform;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Differ;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XMLFileReader;

public class TestMetadata {
    public static void main(String[] args) {
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        CLDRFile metadata = cldrFactory.make("supplementalMetadata", false);
        TestMetadata.testZones(metadata);
        System.out.println("Done");
    }

    private static void sublistCheck(Set<LinkedHashSet<String>> elementOrderingLists, List<String> elementOrder) {
        for (LinkedHashSet<String> sublist : elementOrderingLists) {
            int lastPosition = -1;
            for (String item : sublist) {
                int position = elementOrder.indexOf(item);
                if (position > lastPosition) continue;
                System.out.println("ERROR: elements out of order for: " + item + " in " + sublist);
                return;
            }
            System.out.println("Elements in order for: " + sublist);
        }
    }

    private static boolean showSetDifferences(String name1, Collection<String> set1, String name2, Collection<String> set2) {
        boolean hasDifference = false;
        TreeSet<String> temp = new TreeSet<String>();
        temp.addAll(set1);
        temp.removeAll(set2);
        if (temp.size() != 0) {
            System.out.println(name1 + " minus " + name2 + ":\t" + temp);
            hasDifference |= true;
        }
        temp.clear();
        temp.addAll(set2);
        temp.removeAll(set1);
        if (temp.size() != 0) {
            System.out.println(name2 + " minus " + name1 + ":\t" + temp);
            hasDifference |= true;
        }
        return hasDifference;
    }

    private static void getElementsAndAttributes(String fileWithDTD, Collection<String> elements, Collection<String> attributes, Collection<LinkedHashSet<String>> elementOrderingLists) {
        XMLFileReader xfr = new XMLFileReader().setHandler(new MyHandler(elements, attributes, elementOrderingLists));
        xfr.read(fileWithDTD, -1, true);
    }

    public static <T> String showDifference(Iterable<T> a, Iterable<T> b, String separator) {
        return TestMetadata.showDifference(a, b, separator, new ToString(), new ToString());
    }

    public static <T> String showDifference(Iterable<T> a, Iterable<T> b, String separator, Transform<T, String> aDisplay, Transform<T, String> bDisplay) {
        boolean done;
        Differ<T> differ = new Differ<T>(300, 10);
        StringBuilder out = new StringBuilder();
        Iterator<T> ai = a.iterator();
        Iterator<T> bi = b.iterator();
        boolean first = true;
        do {
            int i;
            done = true;
            if (ai.hasNext()) {
                differ.addA(ai.next());
                done = false;
            }
            if (bi.hasNext()) {
                differ.addB(bi.next());
                done = false;
            }
            differ.checkMatch(done);
            if (differ.getACount() == 0 && differ.getBCount() == 0) continue;
            if (first) {
                first = false;
            } else {
                out.append(separator);
            }
            out.append("...");
            out.append(separator).append(aDisplay.transform(differ.getA(-1)));
            if (differ.getACount() != 0) {
                for (i = 0; i < differ.getACount(); ++i) {
                    out.append(separator).append('-');
                    out.append(aDisplay.transform(differ.getA(i)));
                }
            }
            if (differ.getBCount() != 0) {
                for (i = 0; i < differ.getBCount(); ++i) {
                    out.append(separator).append('+');
                    out.append(bDisplay.transform(differ.getB(i)));
                }
            }
            out.append(separator).append(aDisplay.transform(differ.getA(differ.getACount())));
        } while (!done);
        return out.toString();
    }

    private static void testZones(CLDRFile metadata) {
        String zoneList = null;
        for (String key : metadata) {
            if (key.indexOf("\"$tzid\"") < 0) continue;
            zoneList = metadata.getStringValue(key);
            break;
        }
        String[] zones = zoneList.split("\\s+");
        TreeSet<String> metaZoneSet = new TreeSet<String>();
        metaZoneSet.addAll(Arrays.asList(zones));
        StandardCodes sc = StandardCodes.make();
        Map<String, List<String>> new_oldZones = sc.getZoneData();
        TreeSet<String> stdZoneSet = new TreeSet<String>();
        stdZoneSet.addAll(new_oldZones.keySet());
        if (metaZoneSet.equals(stdZoneSet)) {
            System.out.println("Zone Set is up-to-date");
        } else {
            TreeSet<String> diff = new TreeSet<String>();
            diff.addAll(metaZoneSet);
            diff.removeAll(stdZoneSet);
            System.out.println("Meta Zones - Std Zones: " + diff);
            diff.clear();
            diff.addAll(stdZoneSet);
            diff.removeAll(metaZoneSet);
            System.out.println("Std Zones - Meta Zones: " + diff);
            System.out.println("Meta Zones: " + metaZoneSet);
            System.out.println("Std Zones: " + stdZoneSet);
        }
    }

    static class MyHandler
    extends XMLFileReader.SimpleHandler {
        Collection<String> elements;
        Collection<String> attributes;
        Collection<LinkedHashSet<String>> elementOrderingLists;

        public MyHandler(Collection<String> elements, Collection<String> attributes, Collection<LinkedHashSet<String>> elementOrderingLists) {
            this.elements = elements;
            this.attributes = attributes;
            this.elementOrderingLists = elementOrderingLists;
        }

        @Override
        public void handleAttributeDecl(String eName, String aName, String type, String mode, String value) {
            this.attributes.add(aName);
        }

        @Override
        public void handleElementDecl(String name, String model) {
            this.elements.add(name);
            LinkedHashSet<String> ordering = new LinkedHashSet<String>(Arrays.asList(model.split("[^-_a-zA-Z0-9]+")));
            ordering.remove("");
            ordering.remove("PCDATA");
            ordering.remove("EMPTY");
            if (ordering.size() <= 1 || this.elementOrderingLists.add(ordering)) {
                // empty if block
            }
        }
    }

    private static class ToString<T>
    implements Transform<T, String> {
        private ToString() {
        }

        @Override
        public String transform(T source) {
            return source == null ? "<null>" : source.toString();
        }
    }
}

