/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;

public class CompareEn {
    static Factory mainFactory = CLDRConfig.getInstance().getCldrFactory();
    static Factory annotationsFactory = CLDRConfig.getInstance().getAnnotationsFactory();
    private static boolean VERBOSE = false;

    public static void main(String[] args) throws IOException {
        MyOptions.parse(args, true);
        VERBOSE = MyOptions.verbose.option.doesOccur();
        if (MyOptions.uplevel.option.doesOccur()) {
            CompareEn.uplevelEnGB();
        } else {
            CompareEn.writeComparison();
        }
    }

    private static void uplevelEnGB() throws IOException {
        System.out.println("Copying values from en_GB to en_001");
        for (Factory factory : Arrays.asList(mainFactory, annotationsFactory)) {
            String outDir = factory.getSourceDirectory();
            CLDRFile en_001 = factory.make("en_001", false);
            CLDRFile en_001R = factory.make("en_001", true);
            CLDRFile en_001Out = en_001.cloneAsThawed();
            CLDRFile en_GB = factory.make("en_GB", false);
            CLDRFile en_GBR = factory.make("en_GB", true);
            TreeSet paths = new TreeSet();
            en_GB.forEach(paths::add);
            for (String path : paths) {
                if (path.startsWith("//ldml/identity")) continue;
                if (path.startsWith("//ldml/dates/timeZoneNames/") && path.contains("/short/")) {
                    if (!VERBOSE) continue;
                    System.out.println("Skipping\t" + path);
                    continue;
                }
                String valueGBR = en_GBR.getStringValue(path);
                if (valueGBR == null || CldrUtility.INHERITANCE_MARKER.equals(valueGBR)) continue;
                String value001R = en_001R.getStringValue(path);
                if (CldrUtility.INHERITANCE_MARKER.equals(value001R)) {
                    value001R = null;
                }
                if (Objects.equals(valueGBR, value001R)) continue;
                String fullPath = en_GBR.getFullXPath(path);
                if (VERBOSE) {
                    System.out.println("Changing \u00ab" + value001R + "\u00bb to \u00ab" + valueGBR + "\u00bb in\t" + path);
                }
                en_001Out.add(fullPath, valueGBR);
            }
            PrintWriter out = FileUtilities.openUTF8Writer(outDir, "en_001.xml");
            Throwable throwable = null;
            try {
                en_001Out.write(out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private static void writeComparison() throws IOException {
        System.out.println("Writing to: " + CLDRPaths.GEN_DIRECTORY + "comparisonen.txt");
        try (PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "comparison", "en.txt");){
            out.println("From CompareEn.java");
            out.println("Proposed Disposition\ten\ten_001\ten_GB\tPath");
            for (Factory factory : Arrays.asList(mainFactory, annotationsFactory)) {
                CLDRFile en = factory.make("en", false);
                CLDRFile en_001 = factory.make("en_001", false);
                CLDRFile en_GB = factory.make("en_GB", false);
                CLDRFile enR = factory.make("en", true);
                CLDRFile en_001R = factory.make("en_001", true);
                CLDRFile en_GBR = factory.make("en_GB", true);
                TreeSet paths = new TreeSet();
                en_GB.forEach(paths::add);
                en_001.forEach(paths::add);
                for (String path : paths) {
                    String valueGBR;
                    if (path.startsWith("//ldml/identity")) continue;
                    String value001R = en_001R.getStringValue(path);
                    if (CldrUtility.INHERITANCE_MARKER.equals(value001R)) {
                        value001R = null;
                    }
                    if (CldrUtility.INHERITANCE_MARKER.equals(valueGBR = en_GBR.getStringValue(path))) {
                        valueGBR = null;
                    }
                    String valueR = enR.getStringValue(path);
                    if (Objects.equals(value001R, valueGBR)) continue;
                    out.println("\t" + valueR + "\t" + en_001.getStringValue(path) + "\t" + en_GB.getStringValue(path) + "\t" + path);
                }
            }
        }
    }

    static enum MyOptions {
        uplevel(new Option.Params().setHelp("move elements from en_GB into en_oo1")),
        verbose(new Option.Params().setHelp("verbose output"));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args, boolean showArguments) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

