/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.math.DoubleMath;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.tool.AddPopulationData;
import org.unicode.cldr.tool.CountryCodeConverter;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.LanguageTagCanonicalizer;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SpreadSheet;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.Validity;
import org.unicode.cldr.util.XPathParts;

public class ConvertLanguageData {
    private static final boolean DEBUG = false;
    private static final List<String> defaultOverrides = Arrays.asList("es_ES".split("\\s+"));
    public static final boolean SHOW_DIFF = false;
    private static final boolean ALLOW_SMALL_NUMBERS = true;
    static final Comparator<String> GENERAL_COLLATOR = new GeneralCollator();
    static final Comparator<String> INVERSE_GENERAL = new InverseComparator<String>(GENERAL_COLLATOR);
    private static StandardCodes sc = StandardCodes.make();
    static final double populationFactor = 1.0;
    static final double gdpFactor = 1.0;
    static final int BAD_COUNTRY_NAME = 0;
    static final int COUNTRY_CODE = 1;
    static final int COUNTRY_POPULATION = 2;
    static final int COUNTRY_LITERACY = 3;
    static final int COUNTRY_GDP = 4;
    static final int OFFICIAL_STATUS = 5;
    static final int BAD_LANGUAGE_NAME = 6;
    static final int LANGUAGE_CODE = 7;
    static final int LANGUAGE_POPULATION = 8;
    static final int LANGUAGE_LITERACY = 9;
    static final int COMMENT = 10;
    static final int NOTES = 11;
    static final Map<String, CodeAndPopulation> languageToMaxCountry = new TreeMap<String, CodeAndPopulation>();
    static final Map<String, CodeAndPopulation> languageToMaxScript = new TreeMap<String, CodeAndPopulation>();
    private static final double NON_OFFICIAL_WEIGHT = 0.4;
    private static final boolean SHOW_OLD_DEFAULT_CONTENTS = false;
    private static final ImmutableSet<String> scriptAssumedLocales = ImmutableSet.of("bm_ML", "ha_GH", "ha_NE", "ha_NG", "kk_KZ", "ks_IN", new String[]{"ky_KG", "mn_MN", "ms_BN", "ms_MY", "ms_SG", "tk_TM", "tzm_MA", "ug_CN"});
    static Set<String> skipLocales = new HashSet<String>(Arrays.asList("sh sh_BA sh_CS sh_YU characters supplementalData supplementalData-old supplementalData-old2 supplementalData-old3 supplementalMetadata root".split("\\s")));
    static Map<String, String> defaultContent = new TreeMap<String, String>();
    static Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
    static CLDRFile english = cldrFactory.make("en", true);
    static SupplementalDataInfo supplementalData = SupplementalDataInfo.getInstance(CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY);
    static References references = new References();
    static Comparator<Iterable> firstElementComparator = new Comparator<Iterable>(){

        @Override
        public int compare(Iterable o1, Iterable o2) {
            int result = ((Comparable)o1.iterator().next()).compareTo(o2.iterator().next());
            assert (result != 0);
            return result;
        }
    };
    static Set<String> languagesNeeded = new TreeSet<String>(Arrays.asList("ab ba bh bi bo fj fy gd ha ht ik iu ks ku ky lg mi na no rm sa sd sg si sm sn su tg tk to tw vo yi za lb dv chr syr kha sco gv".split("\\s")));
    static Relation<String, SupplementalDataInfo.BasicLanguageData> language2BasicLanguageData = Relation.of(new TreeMap(), TreeSet.class);
    static Map<String, Relation<SupplementalDataInfo.BasicLanguageData.Type, String>> language_status_scripts;
    static Map<Pair<String, String>, String> language_script_references;
    static final Map<String, Map<String, Row.R2<List<String>, String>>> LOCALE_ALIAS_INFO;
    static Validity VALIDITY;
    static NumberFormat nf;
    static NumberFormat nf_no_comma;
    static NumberFormat pf;
    static final LanguageTagCanonicalizer languageTagCanonicalizer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ParseException {
        BufferedReader oldFile = null;
        try {
            Log.setLogNoBOM(CLDRPaths.GEN_DIRECTORY + "/supplemental", "supplementalData.xml");
            oldFile = FileUtilities.openUTF8Reader(CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY, "supplementalData.xml");
            CldrUtility.copyUpTo(oldFile, PatternCache.get("\\s*<languageData>\\s*"), Log.getLog(), false);
            Set<String> available = cldrFactory.getAvailable();
            Set<String> cldrParents = ConvertLanguageData.getCldrParents(available);
            ArrayList<String> failures = new ArrayList<String>();
            TreeMap<String, RowData> localeToRowData = new TreeMap<String, RowData>();
            Set<RowData> sortedInput = ConvertLanguageData.getExcelData(failures, localeToRowData);
            TreeSet localesWithData = new TreeSet(localeToRowData.keySet());
            for (Object locale : localeToRowData.keySet()) {
                String parent;
                while ((parent = LocaleIDParser.getParent((String)locale)) != null) {
                    localesWithData.add(parent);
                    locale = parent;
                }
            }
            LanguageTagParser languageTagParser = new LanguageTagParser();
            for (String localeRaw : available) {
                CLDRFile locFile;
                String locale = languageTagCanonicalizer.transform(localeRaw);
                if (localesWithData.contains(locale) || (locFile = cldrFactory.make(localeRaw, false)).isAliasedAtTopLevel() || scriptAssumedLocales.contains(locale)) continue;
                languageTagParser.set(locale);
                if (languageTagParser.getVariants().size() != 0) continue;
                String withoutScript = languageTagParser.setScript("").toString();
                if (!localesWithData.contains(withoutScript)) {
                    String region = new LanguageTagParser().set(locale).getRegion();
                    if (!StandardCodes.isCountry(region)) continue;
                    BadItem.ERROR.show("missing language/population data for CLDR locale", locale + " = " + ConvertLanguageData.getLanguageCodeAndName(locale), new String[0]);
                    continue;
                }
                ImmutableSet<String> OKExceptions = ImmutableSet.of("sr_Cyrl_ME", "zh_Hans_HK", "zh_Hans_MO");
                if (OKExceptions.contains(locale)) continue;
                BadItem.ERROR.show("missing language/population data for CLDR locale", locale + " = " + ConvertLanguageData.getLanguageCodeAndName(locale) + " but have data for " + ConvertLanguageData.getLanguageCodeAndName(withoutScript), new String[0]);
            }
            ConvertLanguageData.addLanguageScriptData();
            ConvertLanguageData.getLanguage2Scripts(sortedInput);
            ConvertLanguageData.writeNewBasicData2(sortedInput);
            ConvertLanguageData.writeTerritoryLanguageData(failures, sortedInput);
            ConvertLanguageData.checkBasicData(localeToRowData);
            TreeSet<String> defaultLocaleContent = new TreeSet<String>();
            ConvertLanguageData.showDefaults(cldrParents, nf, defaultContent, localeToRowData, defaultLocaleContent);
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String override : defaultOverrides) {
                String replacement = ConvertLanguageData.getReplacement(override, defaultLocaleContent);
                if (replacement == null) continue;
                toRemove.add(replacement);
            }
            defaultLocaleContent.removeAll(toRemove);
            defaultLocaleContent.addAll(defaultOverrides);
            ConvertLanguageData.showFailures(failures);
            CldrUtility.copyUpTo(oldFile, PatternCache.get("\\s*</territoryInfo>\\s*"), null, false);
            CldrUtility.copyUpTo(oldFile, PatternCache.get("\\s*<references>\\s*"), Log.getLog(), false);
            references.printReferences();
            CldrUtility.copyUpTo(oldFile, PatternCache.get("\\s*</references>\\s*"), null, false);
            CldrUtility.copyUpTo(oldFile, null, Log.getLog(), false);
            Log.close();
            oldFile.close();
            Log.setLogNoBOM(CLDRPaths.GEN_DIRECTORY + "/supplemental", "language_script_raw.txt");
            ConvertLanguageData.getLanguageScriptSpreadsheet(Log.getLog());
            Log.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (oldFile != null) {
                oldFile.close();
            }
            System.out.println("DONE");
        }
    }

    public static String getLanguageCodeAndName(String code) {
        if (code == null) {
            return null;
        }
        return english.getName(code) + " [" + code + "]";
    }

    private static String getReplacement(String oldDefault, Set<String> defaultLocaleContent) {
        String parent = LocaleIDParser.getParent(oldDefault);
        for (String replacement : defaultLocaleContent) {
            if (!replacement.startsWith(parent) || !parent.equals(LocaleIDParser.getParent(replacement))) continue;
            return replacement;
        }
        return null;
    }

    private static void getLanguageScriptSpreadsheet(PrintWriter out) {
        out.println("#Lcode\tLanguageName\tStatus\tScode\tScriptName\tReferences");
        Pair<String, String> languageScript = new Pair<String, String>("", "");
        for (String language : language_status_scripts.keySet()) {
            Relation<SupplementalDataInfo.BasicLanguageData.Type, String> status_scripts = language_status_scripts.get(language);
            for (SupplementalDataInfo.BasicLanguageData.Type status : status_scripts.keySet()) {
                for (String script : status_scripts.getAll((Object)status)) {
                    String reference = language_script_references.get(languageScript.setFirst(language).setSecond(script));
                    out.println(language + "\t" + ConvertLanguageData.getLanguageName(language) + "\t" + (Object)((Object)status) + "\t" + script + "\t" + ConvertLanguageData.getDisplayScript(script) + (reference == null ? "" : "\t" + reference));
                }
            }
        }
    }

    private static void writeNewBasicData2(Set<RowData> sortedInput) {
        double cutoff = 0.2;
        LanguageTagParser ltp = new LanguageTagParser();
        TreeMap<String, Relation<SupplementalDataInfo.BasicLanguageData.Type, String>> language_status_territories = new TreeMap<String, Relation<SupplementalDataInfo.BasicLanguageData.Type, String>>();
        for (RowData rowData : sortedInput) {
            if (rowData.countryCode.equals("ZZ")) continue;
            ltp.set(rowData.languageCode);
            String languageCode = ltp.getLanguage();
            Relation<SupplementalDataInfo.BasicLanguageData.Type, String> status_territories = (Relation<SupplementalDataInfo.BasicLanguageData.Type, String>)language_status_territories.get(languageCode);
            if (status_territories == null) {
                status_territories = Relation.of(new TreeMap(), TreeSet.class);
                language_status_territories.put(languageCode, status_territories);
            }
            if (rowData.officialStatus.isMajor()) {
                status_territories.put(SupplementalDataInfo.BasicLanguageData.Type.primary, rowData.countryCode);
                continue;
            }
            if (!rowData.officialStatus.isOfficial() && !(rowData.getLanguagePopulation() >= cutoff * rowData.countryPopulation) && !(rowData.getLanguagePopulation() >= 1000000.0)) continue;
            status_territories.put(SupplementalDataInfo.BasicLanguageData.Type.secondary, rowData.countryCode);
        }
        TreeSet allLanguages = new TreeSet(language_status_territories.keySet());
        allLanguages.addAll(language_status_scripts.keySet());
        LinkedHashSet<String> warnings = new LinkedHashSet<String>();
        Log.println("\t<languageData>");
        for (String languageSubtag : allLanguages) {
            Relation<SupplementalDataInfo.BasicLanguageData.Type, String> status_scripts = language_status_scripts.get(languageSubtag);
            Relation status_territories = (Relation)language_status_territories.get(languageSubtag);
            Map<SupplementalDataInfo.BasicLanguageData.Type, SupplementalDataInfo.BasicLanguageData> oldData = supplementalData.getBasicLanguageDataMap(languageSubtag);
            if (oldData == null) {
                oldData = Collections.emptyMap();
            }
            EnumMap<SupplementalDataInfo.BasicLanguageData.Type, SupplementalDataInfo.BasicLanguageData> newData = new EnumMap<SupplementalDataInfo.BasicLanguageData.Type, SupplementalDataInfo.BasicLanguageData>(SupplementalDataInfo.BasicLanguageData.Type.class);
            for (SupplementalDataInfo.BasicLanguageData.Type status : SupplementalDataInfo.BasicLanguageData.Type.values()) {
                Set<String> territories;
                Set<String> scripts = status_scripts == null ? null : status_scripts.getAll((Object)status);
                Set<String> set = territories = status_territories == null ? null : status_territories.getAll((Object)status);
                if (scripts == null && territories == null) continue;
                SupplementalDataInfo.BasicLanguageData bld = new SupplementalDataInfo.BasicLanguageData();
                bld.setTerritories(territories);
                bld.setScripts(scripts);
                bld.setType(status);
                bld.freeze();
                newData.put(status, bld);
            }
            if (!CldrUtility.equals(oldData.entrySet(), newData.entrySet())) {
                for (String problem : ConvertLanguageData.compare(oldData, newData)) {
                    warnings.add(BadItem.DETAIL.toString("changing <languageData>", languageSubtag + "\t" + ConvertLanguageData.english.getName(languageSubtag), new String[]{problem}));
                }
            }
            for (SupplementalDataInfo.BasicLanguageData bld : newData.values()) {
                Set<String> scripts = bld.getScripts();
                Set<String> territories = bld.getTerritories();
                SupplementalDataInfo.BasicLanguageData.Type status = bld.getType();
                Log.println("\t\t<language type=\"" + languageSubtag + "\"" + (scripts.isEmpty() ? "" : " scripts=\"" + CldrUtility.join(scripts, " ") + "\"") + (territories.isEmpty() ? "" : " territories=\"" + CldrUtility.join(territories, " ") + "\"") + (status == SupplementalDataInfo.BasicLanguageData.Type.primary ? "" : " alt=\"secondary\"") + "/>");
            }
        }
        Log.println("\t</languageData>");
        for (String s2 : warnings) {
            if (!s2.contains("!")) continue;
            System.out.println(s2);
        }
        for (String s2 : warnings) {
            if (s2.contains("!")) continue;
            System.out.println(s2);
        }
    }

    private static List<String> compare(Map<SupplementalDataInfo.BasicLanguageData.Type, SupplementalDataInfo.BasicLanguageData> oldData, Map<SupplementalDataInfo.BasicLanguageData.Type, SupplementalDataInfo.BasicLanguageData> newData) {
        Map<String, SupplementalDataInfo.BasicLanguageData.Type> oldDataToType = ConvertLanguageData.getDataToType(oldData.values(), true);
        Map<String, SupplementalDataInfo.BasicLanguageData.Type> newDataToType = ConvertLanguageData.getDataToType(newData.values(), true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder temp = new StringBuilder();
        for (String s2 : Builder.with(new LinkedHashSet()).addAll((Iterable<String>)oldDataToType.keySet()).addAll((Iterable<String>)newDataToType.keySet()).get()) {
            SupplementalDataInfo.BasicLanguageData.Type newValue;
            SupplementalDataInfo.BasicLanguageData.Type oldValue = oldDataToType.get(s2);
            if (CldrUtility.equals((Object)oldValue, (Object)(newValue = newDataToType.get(s2)))) continue;
            temp.setLength(0);
            temp.append("[").append(s2).append(":").append(english.getName(s2.length() == 4 ? "script" : "region", s2)).append("] ");
            if (oldValue == null) {
                temp.append(" added as ").append((Object)newValue);
            } else if (newValue == null) {
                temp.append(" REMOVED!");
            } else if (oldValue == SupplementalDataInfo.BasicLanguageData.Type.primary) {
                temp.append(" DOWNGRADED TO! ").append((Object)newValue);
            } else {
                temp.append(" upgraded to ").append((Object)newValue);
            }
            result.add(temp.toString());
        }
        result.add(newData.toString());
        return result;
    }

    private static Map<String, SupplementalDataInfo.BasicLanguageData.Type> getDataToType(Collection<SupplementalDataInfo.BasicLanguageData> collection, boolean script) {
        TreeMap<String, SupplementalDataInfo.BasicLanguageData.Type> result = new TreeMap<String, SupplementalDataInfo.BasicLanguageData.Type>();
        for (SupplementalDataInfo.BasicLanguageData i : collection) {
            for (String s2 : i.getScripts()) {
                result.put(s2, i.getType());
            }
            for (String s2 : i.getTerritories()) {
                result.put(s2, i.getType());
            }
        }
        return result;
    }

    private static void checkBasicData(Map<String, RowData> localeToRowData) {
        Relation<String, String> languageToScripts = Relation.of(new TreeMap(), TreeSet.class);
        for (String languageSubtag : language2BasicLanguageData.keySet()) {
            for (SupplementalDataInfo.BasicLanguageData item : language2BasicLanguageData.getAll(languageSubtag)) {
                languageToScripts.putAll(StandardCodes.fixLanguageTag(languageSubtag), item.getScripts());
            }
        }
        TreeSet<String> primaryCombos = new TreeSet<String>();
        TreeSet<String> basicCombos = new TreeSet<String>();
        for (String languageSubtag : language2BasicLanguageData.keySet()) {
            for (SupplementalDataInfo.BasicLanguageData basicLanguageData : language2BasicLanguageData.getAll(languageSubtag)) {
                TreeSet<String> treeSet = new TreeSet<String>();
                treeSet.addAll(basicLanguageData.getScripts());
                languageToScripts.putAll(StandardCodes.fixLanguageTag(languageSubtag), treeSet);
                if (treeSet.size() == 0) {
                    treeSet.add("Zzzz");
                }
                TreeSet<String> territories = new TreeSet<String>();
                territories.addAll(basicLanguageData.getTerritories());
                if (territories.size() == 0) {
                    territories.add("ZZ");
                    continue;
                }
                for (String script : treeSet) {
                    for (String territory : territories) {
                        String locale = StandardCodes.fixLanguageTag(languageSubtag) + (territories.equals("ZZ") ? "" : "_" + territory);
                        if (basicLanguageData.getType() != SupplementalDataInfo.BasicLanguageData.Type.secondary) {
                            primaryCombos.add(locale);
                        }
                        basicCombos.add(locale);
                    }
                }
            }
        }
        TreeSet<String> populationOver20 = new TreeSet<String>();
        TreeSet<String> population = new TreeSet<String>();
        LanguageTagParser ltp = new LanguageTagParser();
        for (String string : localeToRowData.keySet()) {
            ltp.set(string);
            String locale = ltp.getLanguage() + (ltp.getRegion().length() == 0 ? "" : "_" + ltp.getRegion());
            population.add(locale);
            RowData rowData = localeToRowData.get(string);
            if (rowData.getLanguagePopulation() / rowData.countryPopulation >= 0.2) {
                populationOver20.add(locale);
                continue;
            }
            SupplementalDataInfo.PopulationData popData = supplementalData.getLanguageAndTerritoryPopulationData(ltp.getLanguageScript(), ltp.getRegion());
            if (popData == null || !popData.getOfficialStatus().isOfficial()) continue;
            populationOver20.add(locale);
        }
        TreeSet treeSet = new TreeSet(primaryCombos);
        treeSet.removeAll(population);
        for (String locale : treeSet) {
            ltp.set(locale);
            String region = ltp.getRegion();
            String language = ltp.getLanguage();
            if (!sc.isModernLanguage(language)) continue;
            SupplementalDataInfo.PopulationData popData = supplementalData.getPopulationDataForTerritory(region);
            BadItem.WARNING.show("In Basic Data but not Population > 20%", ConvertLanguageData.getDisplayCountry(region) + "\t" + region + "\t\"" + ConvertLanguageData.formatNumber(popData.getPopulation(), 0, false) + "\"\t\"" + ConvertLanguageData.formatPercent(popData.getLiteratePopulation() / popData.getPopulation(), 0, false) + "\"\t\"" + ConvertLanguageData.formatPercent(popData.getGdp(), 0, false) + "\"\t\t" + ConvertLanguageData.getLanguageName(language) + "\t" + language + "\t" + -1 + "\t\"" + ConvertLanguageData.formatPercent(popData.getLiteratePopulation() / popData.getPopulation(), 0, false) + "\"", new String[0]);
        }
        TreeSet treeSet2 = new TreeSet(populationOver20);
        treeSet2.removeAll(basicCombos);
        Iterator it = treeSet2.iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            if (!locale.endsWith("_ZZ")) continue;
            it.remove();
        }
        for (String locale : treeSet2) {
            BadItem.WARNING.show("In Population>20% but not Basic Data", locale + " " + ConvertLanguageData.getLanguageName(locale), localeToRowData.get(locale).toString());
        }
    }

    private static <K, V> void putUnique(Map<K, V> map, K key, V value) {
        V oldValue = map.get(key);
        if (oldValue != null && !oldValue.equals(value)) {
            throw new IllegalArgumentException("Duplicate value for <" + key + ">: <" + oldValue + ">, <" + value + ">");
        }
        map.put(key, value);
    }

    private static <K, W> void putAll(Map<K, Set<W>> map, K key, Set<W> values) {
        Set<W> oldValue = map.get(key);
        if (oldValue == null) {
            map.put(key, values);
        } else {
            oldValue.addAll(values);
        }
    }

    public static String getExcelQuote(String comment) {
        return comment == null || comment.length() == 0 ? "" : (comment.contains(",") ? '\"' + comment + '\"' : (comment.contains("\"") ? '\"' + comment.replace("\"", "\"\"") + '\"' : comment));
    }

    public static String getCountryCodeAndName(String code) {
        if (code == null) {
            return null;
        }
        return english.getName(2, code) + " [" + code + "]";
    }

    private static void writeTerritoryLanguageData(List<String> failures, Set<RowData> sortedInput) {
        String lastCountryCode = "";
        boolean first = true;
        LanguageTagParser ltp = new LanguageTagParser();
        Log.println(" <!-- See http://unicode.org/cldr/data/diff/supplemental/territory_language_information.html for more information on territoryInfo. -->");
        Log.println("\t<territoryInfo>");
        for (RowData row : sortedInput) {
            double languagePopulationRaw;
            double countryPopulationRaw;
            String countryCode = row.countryCode;
            double countryPopulation = countryPopulationRaw = row.countryPopulation;
            double languageLiteracy = row.languageLiteracy;
            double countryLiteracy = row.countryLiteracy;
            double countryGDPRaw = row.countryGdp;
            long countryGDP = Math.round(countryGDPRaw / 1.0);
            String languageCode = row.languageCode;
            double languagePopulation = languagePopulationRaw = row.getLanguagePopulation();
            double languagePopulationPercent = languagePopulation / countryPopulation;
            if (!countryCode.equals(lastCountryCode)) {
                if (first) {
                    first = false;
                } else {
                    Log.println("\t\t</territory>");
                }
                Log.print("\t\t<territory type=\"" + countryCode + "\" gdp=\"" + ConvertLanguageData.formatNumber(countryGDP, 4, true) + "\" literacyPercent=\"" + ConvertLanguageData.formatPercent(countryLiteracy, 3, true) + "\" population=\"" + ConvertLanguageData.formatNumber(countryPopulation, 6, true) + "\">");
                lastCountryCode = countryCode;
                Log.println("\t<!--" + ConvertLanguageData.getDisplayCountry(countryCode) + "-->");
            }
            if (languageCode.length() != 0 && languagePopulationPercent > 0.0) {
                String baseLanguage;
                ConvertLanguageData.addBestRegion(languageCode, countryCode, languagePopulationRaw);
                String baseScriptLanguage = ltp.set(languageCode).getLanguageScript();
                if (!baseScriptLanguage.equals(languageCode)) {
                    ConvertLanguageData.addBestRegion(baseScriptLanguage, countryCode, languagePopulationRaw);
                }
                if (!(baseLanguage = ltp.set(baseScriptLanguage).getLanguage()).equals(baseScriptLanguage)) {
                    ConvertLanguageData.addBestRegion(baseLanguage, countryCode, languagePopulationRaw);
                    ConvertLanguageData.addBestScript(baseLanguage, ltp.set(languageCode).getScript(), languagePopulationRaw);
                }
                if (languageLiteracy != countryLiteracy) {
                    boolean bl = false;
                }
                Log.print("\t\t\t<languagePopulation type=\"" + languageCode + "\"" + (DoubleMath.fuzzyCompare(languageLiteracy, countryLiteracy, 1.0E-4) == 0 ? "" : (DoubleMath.fuzzyCompare(languageLiteracy, 0.05, 1.0E-4) == 0 ? " writingPercent=\"" : " literacyPercent=\"") + ConvertLanguageData.formatPercent(languageLiteracy, 2, true) + "\"") + " populationPercent=\"" + ConvertLanguageData.formatPercent(languagePopulationPercent, 2, true) + "\"" + (row.officialStatus.isOfficial() ? " officialStatus=\"" + (Object)((Object)row.officialStatus) + "\"" : "") + ConvertLanguageData.references.addReference(row.notes) + "/>");
                Log.println("\t<!--" + ConvertLanguageData.getLanguageName(languageCode) + "-->");
                continue;
            }
            if (row.countryCode.equals("ZZ")) continue;
            failures.add(BadItem.ERROR.toString("too few speakers: suspect line", languageCode, new String[]{row.toString(true)}));
        }
        Log.println("\t\t</territory>");
        Log.println("\t</territoryInfo>");
    }

    private static String getDisplayCountry(String countryCode) {
        String result = ConvertLanguageData.getULocaleCountryName(countryCode);
        if (!result.equals(countryCode)) {
            return result;
        }
        result = sc.getData("territory", countryCode);
        if (result != null) {
            return result;
        }
        return countryCode;
    }

    private static String getDisplayScript(String scriptCode) {
        String result = ConvertLanguageData.getULocaleScriptName(scriptCode);
        if (!result.equals(scriptCode)) {
            return result;
        }
        result = sc.getData("territory", scriptCode);
        if (result != null) {
            return result;
        }
        return scriptCode;
    }

    private static String getLanguageName(String languageCode) {
        String result = ConvertLanguageData.getULocaleLocaleName(languageCode);
        if (!result.equals(languageCode)) {
            return result;
        }
        Set<String> names = Iso639Data.getNames(languageCode);
        if (names != null && names.size() != 0) {
            return names.iterator().next();
        }
        return languageCode;
    }

    private static Set<RowData> getExcelData(List<String> failures, Map<String, RowData> localeToRowData) throws IOException {
        RowData x;
        LanguageTagParser ltp = new LanguageTagParser();
        String dir = CLDRPaths.GEN_DIRECTORY + "supplemental/";
        String ricksFile = "country_language_population_raw.txt";
        System.out.println("\n# Problems in country_language_population_raw.txt\n");
        List<List<String>> input = SpreadSheet.convert(CldrUtility.getUTF8Data("country_language_population_raw.txt"));
        Set<String> languages = languagesNeeded;
        TreeSet<String> territories = new TreeSet<String>(sc.getGoodAvailableCodes("territory"));
        territories.removeAll(supplementalData.getContainers());
        territories.remove("EU");
        territories.remove("QO");
        TreeSet<String> countriesNotFound = new TreeSet<String>((Collection<String>)territories);
        TreeSet<SupplementalDataInfo.OfficialStatus> statusFound = new TreeSet<SupplementalDataInfo.OfficialStatus>();
        TreeSet<String> countriesWithoutOfficial = new TreeSet<String>((Collection<String>)territories);
        countriesWithoutOfficial.remove("ZZ");
        HashMap<String, Row.R2<String, Double>> countryToLargestOfficialLanguage = new HashMap<String, Row.R2<String, Double>>();
        TreeSet<String> languagesNotFound = new TreeSet<String>(languages);
        TreeSet<RowData> sortedInput = new TreeSet<RowData>();
        int count = 0;
        for (List<String> list : input) {
            if (++count == 1 || list.size() <= 4) {
                failures.add(ConvertLanguageData.join(list, "\t") + "\tShort row");
                continue;
            }
            try {
                String locale;
                x = new RowData(list);
                if (x.officialStatus.isOfficial()) {
                    Row.R2 largestOffical = (Row.R2)countryToLargestOfficialLanguage.get(x.countryCode);
                    if (largestOffical == null) {
                        countryToLargestOfficialLanguage.put(x.countryCode, Row.of(x.languageCode, x.languagePopulation));
                    } else if ((Double)largestOffical.get1() < x.languagePopulation) {
                        largestOffical.set0(x.languageCode);
                        largestOffical.set1(x.languagePopulation);
                    }
                }
                if (x.officialStatus.isMajor() || x.countryPopulation < 1000.0) {
                    countriesWithoutOfficial.remove(x.countryCode);
                }
                if (!ConvertLanguageData.checkCode(StandardCodes.LstrType.region, x.countryCode, list)) continue;
                statusFound.add(x.officialStatus);
                countriesNotFound.remove(x.countryCode);
                languagesNotFound.remove(x.languageCode);
                if (x.languageCode.contains("_")) {
                    ltp.set(x.languageCode);
                    languagesNotFound.remove(ltp.getLanguage());
                    if (!ConvertLanguageData.checkCode(StandardCodes.LstrType.language, ltp.getLanguage(), list) || !ConvertLanguageData.checkCode(StandardCodes.LstrType.script, ltp.getScript(), list)) continue;
                }
                if (localeToRowData.get(locale = x.languageCode + "_" + x.countryCode) != null) {
                    BadItem.ERROR.show("duplicate data", x.languageCode + " with " + x.countryCode, list);
                }
                localeToRowData.put(locale, x);
                sortedInput.add(x);
            }
            catch (ParseException e) {
                failures.add(ConvertLanguageData.join(list, "\t") + "\t" + e.getMessage() + "\t" + ConvertLanguageData.join(Arrays.asList(e.getStackTrace()), ";\t"));
            }
            catch (RuntimeException e) {
                throw (RuntimeException)new IllegalArgumentException("Failure on line " + count + ")\t" + list).initCause(e);
            }
        }
        for (String string : countriesNotFound) {
            x = new RowData(string, "und");
            sortedInput.add(x);
        }
        for (String string : languagesNotFound) {
            x = new RowData("ZZ", string);
            sortedInput.add(x);
        }
        for (RowData rowData : sortedInput) {
            Row.R2 largestOffical;
            if (!rowData.officialStatus.isOfficial() && (largestOffical = (Row.R2)countryToLargestOfficialLanguage.get(rowData.countryCode)) != null && (Double)largestOffical.get1() < rowData.languagePopulation) {
                BadItem.WARNING.show("language population > all official languages", ConvertLanguageData.getLanguageCodeAndName((String)largestOffical.get0()), rowData.toString(true));
            }
            if (!countriesWithoutOfficial.contains(rowData.countryCode)) continue;
            BadItem.ERROR.show("missing official language", rowData.getCountryName() + "\t" + rowData.countryCode, rowData.toString(true));
            countriesWithoutOfficial.remove(rowData.countryCode);
        }
        PrintWriter log = FileUtilities.openUTF8Writer(dir, "country_language_population_raw.txt");
        log.println("*\tCName\tCCode\tCPopulation\tCLiteracy\tCGdp\tOfficialStatus\tLanguage\tLCode\tLPopulation\tWritingPop\tReferences\tNotes");
        RickComparator rickComparator = new RickComparator();
        TreeSet<RowData> rickSorted = new TreeSet<RowData>(rickComparator);
        rickSorted.addAll(sortedInput);
        for (RowData row : rickSorted) {
            String langLit = row.getLanguageLiteracyString();
            String countryLit = row.getCountryLiteracyString();
            log.println(row.getCountryName() + "\t" + row.countryCode + "\t" + row.getCountryPopulationString() + "\t" + countryLit + "\t" + row.getCountryGdpString() + "\t" + (row.officialStatus == SupplementalDataInfo.OfficialStatus.unknown ? "" : row.officialStatus) + "\t" + row.getRickLanguageName() + "\t" + row.getRickLanguageCode() + "\t" + row.getLanguagePopulationString() + "\t" + (langLit.equals(countryLit) ? "" : langLit) + "\t" + ConvertLanguageData.getExcelQuote(row.comment) + "\t" + ConvertLanguageData.getExcelQuote(row.notes));
        }
        log.close();
        return sortedInput;
    }

    private static Set<String> getCldrParents(Set<String> available) {
        LanguageTagParser ltp2 = new LanguageTagParser();
        TreeSet<String> cldrParents = new TreeSet<String>();
        for (String locale : available) {
            if (skipLocales.contains(locale)) continue;
            try {
                ltp2.set(locale);
            }
            catch (RuntimeException e) {
                System.out.println("Skipping CLDR file: " + locale);
                continue;
            }
            String locale2 = ltp2.getLanguageScript();
            if (locale2.equals("sh")) continue;
            cldrParents.add(locale2);
            languageToMaxCountry.put(locale2, null);
        }
        return cldrParents;
    }

    private static void showFailures(List<String> failures) {
        if (failures.size() <= 1) {
            return;
        }
        System.out.println();
        System.out.println("Failures in Output");
        System.out.println();
        System.out.println(RowData.toStringHeader());
        for (String failure : failures) {
            System.out.println(failure);
        }
    }

    public static String getProcessedParent(String localeCode) {
        if (localeCode == null || localeCode.equals("root")) {
            return null;
        }
        int pos = localeCode.lastIndexOf(95);
        if (pos < 0) {
            return "root";
        }
        LanguageTagParser ltp = new LanguageTagParser();
        String script = ltp.set(localeCode).getScript();
        if (script.length() == 0) {
            return ConvertLanguageData.getFullyResolved(localeCode);
        }
        return localeCode.substring(0, pos);
    }

    private static String getFullyResolved(String languageCode) {
        String script;
        String result = defaultContent.get(languageCode);
        if (result != null) {
            return result;
        }
        int pos = languageCode.length() + 1;
        do {
            if ((pos = languageCode.lastIndexOf(95, pos - 1)) >= 0) continue;
            return "***" + languageCode;
        } while ((result = defaultContent.get(languageCode.substring(0, pos))) == null);
        LanguageTagParser ltp = new LanguageTagParser().set(languageCode);
        LanguageTagParser ltp2 = new LanguageTagParser().set(result);
        String region = ltp.getRegion();
        if (region.length() == 0) {
            ltp.setRegion(ltp2.getRegion());
        }
        if ((script = ltp.getScript()).length() == 0) {
            ltp.setScript(ltp2.getScript());
        }
        return ltp.toString();
    }

    private static void showDefaults(Set<String> cldrParents, NumberFormat nf, Map<String, String> defaultContent, Map<String, RowData> localeToRowData, Set<String> defaultLocaleContent) {
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        TreeSet<String> locales = new TreeSet<String>(cldrFactory.getAvailable());
        LocaleIDParser lidp = new LocaleIDParser();
        for (String string : localeToRowData.keySet()) {
            String baseLanguage = lidp.set(string).getLanguage();
            if (!locales.contains(baseLanguage) || locales.contains(string)) continue;
            locales.add(string);
        }
        TreeSet<String> toAdd = new TreeSet<String>();
        while (true) {
            for (String locale : locales) {
                String newguy = LocaleIDParser.getParent(locale);
                if (newguy == null || locales.contains(newguy) || toAdd.contains(newguy)) continue;
                toAdd.add(newguy);
            }
            if (toAdd.size() == 0) break;
            locales.addAll(toAdd);
            toAdd.clear();
        }
        TreeSet<Iterable> treeSet = new TreeSet<Iterable>(firstElementComparator);
        TreeSet<String> needsADoin = new TreeSet<String>((Collection<String>)locales);
        TreeSet<String> deprecatedLanguages = new TreeSet<String>();
        deprecatedLanguages.add("sh");
        TreeSet<String> deprecatedRegions = new TreeSet<String>();
        deprecatedRegions.add("YU");
        deprecatedRegions.add("CS");
        deprecatedRegions.add("ZZ");
        TreeSet<String> skippingItems = new TreeSet<String>();
        TreeSet<String> hasAScript = new TreeSet<String>();
        for (String string : locales) {
            Set<LocaleIDParser.Level> levels;
            lidp.set(string);
            if (lidp.getScript().length() != 0) {
                hasAScript.add(lidp.getLanguage());
            }
            if (!(levels = lidp.getLevels()).contains((Object)LocaleIDParser.Level.Variants) && (levels.contains((Object)LocaleIDParser.Level.Script) || levels.contains((Object)LocaleIDParser.Level.Region)) && !deprecatedLanguages.contains(lidp.getLanguage()) && !deprecatedRegions.contains(lidp.getRegion())) continue;
            needsADoin.remove(string);
            skippingItems.add(string);
        }
        TreeMap<String, Double> scriptLocaleToLanguageLiteratePopulation = new TreeMap<String, Double>();
        for (String locale : new TreeSet<String>((Collection<String>)needsADoin)) {
            if (!needsADoin.contains(locale)) continue;
            lidp.set(locale);
            Set<LocaleIDParser.Level> level = lidp.getLevels();
            if (!level.contains((Object)LocaleIDParser.Level.Script) && hasAScript.contains(lidp.getLanguage())) {
                needsADoin.remove(locale);
                skippingItems.add(locale);
                continue;
            }
            Set<String> set = lidp.getSiblings(needsADoin);
            if (level.contains((Object)LocaleIDParser.Level.Script) && level.contains((Object)LocaleIDParser.Level.Region)) {
                double languageLiteratePopulation = 0.0;
                for (String localeID2 : set) {
                    RowData rowData = localeToRowData.get(localeID2);
                    if (rowData == null) continue;
                    languageLiteratePopulation += rowData.getLanguageLiteratePopulation(0.4);
                }
                String parentID = LocaleIDParser.getParent(locale);
                scriptLocaleToLanguageLiteratePopulation.put(parentID, languageLiteratePopulation);
            }
            try {
                treeSet.add(set);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            needsADoin.removeAll(set);
        }
        if (needsADoin.size() != 0) {
            // empty if block
        }
        TreeSet treeSet2 = new TreeSet();
        TreeSet<String> missingData = new TreeSet<String>();
        for (Set set : treeSet) {
            if (false & set.size() == 1) {
                treeSet2.add(set.iterator().next());
                continue;
            }
            double best = Double.NEGATIVE_INFINITY;
            String bestLocale = "???";
            TreeSet<Pair<Double, String>> data = new TreeSet<Pair<Double, String>>();
            LanguageTagParser ltp = new LanguageTagParser();
            for (String string : set) {
                RowData rowData = localeToRowData.get(string);
                double languageLiteratePopulation = -1.0;
                if (rowData != null) {
                    languageLiteratePopulation = rowData.getLanguageLiteratePopulation(0.4);
                } else {
                    Double d = (Double)scriptLocaleToLanguageLiteratePopulation.get(string);
                    if (d != null) {
                        languageLiteratePopulation = d;
                    } else {
                        String region = ltp.set(string).getRegion();
                        if (region.isEmpty() || StandardCodes.isCountry(region)) {
                            missingData.add(string);
                        }
                    }
                }
                data.add(new Pair<Double, String>(languageLiteratePopulation, string));
                if (!(best < languageLiteratePopulation)) continue;
                best = languageLiteratePopulation;
                bestLocale = string;
            }
            for (Pair pair : data) {
            }
            if (bestLocale.startsWith("en_")) {
                defaultLocaleContent.add("en_US");
                continue;
            }
            defaultLocaleContent.add(bestLocale);
        }
        for (String string : treeSet2) {
            BadItem.WARNING.show("skipping Singletons", string, new String[0]);
        }
        for (String string : missingData) {
            BadItem.WARNING.show("Missing Data", string, new String[0]);
        }
    }

    private static Object getSuppressScript(String languageCode) {
        return null;
    }

    public static String join(Collection c, String separator) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (Object x : c) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(x);
        }
        return result.toString();
    }

    private static void addBestRegion(String languageCode, String countryCode, double languagePopulationRaw) {
        ConvertLanguageData.addBest(languageCode, languagePopulationRaw, countryCode, languageToMaxCountry);
    }

    private static void addBestScript(String languageCode, String scriptCode, double languagePopulationRaw) {
        ConvertLanguageData.addBest(languageCode, languagePopulationRaw, scriptCode, languageToMaxScript);
    }

    private static void addBest(String languageCode, double languagePopulationRaw, String code, Map<String, CodeAndPopulation> languageToMaxCode) {
        if (languageCode.length() == 0) {
            throw new IllegalArgumentException();
        }
        CodeAndPopulation best = languageToMaxCode.get(languageCode);
        if (best == null) {
            best = new CodeAndPopulation();
            languageToMaxCode.put(languageCode, best);
        } else if (best.population >= languagePopulationRaw) {
            return;
        }
        best.population = languagePopulationRaw;
        best.code = code;
    }

    static void generateIso639_2Data() {
        for (String languageSubtag : sc.getAvailableCodes("language")) {
            String alpha3 = Iso639Data.toAlpha3(languageSubtag);
            Iso639Data.Type type = Iso639Data.getType(languageSubtag);
            Iso639Data.Scope scope = Iso639Data.getScope(languageSubtag);
            if (type == null && alpha3 == null && scope == null) continue;
            Log.println("\t\t<languageCode type=\"" + languageSubtag + "\"" + (alpha3 == null ? "" : " iso639Alpha3=\"" + alpha3 + "\"") + (type == null ? "" : " iso639Type=\"" + (Object)((Object)type) + "\"") + (scope == null ? "" : " iso639Scope=\"" + (Object)((Object)scope) + "\"") + "/>");
        }
    }

    static void getLanguage2Scripts(Set<RowData> sortedInput) throws IOException {
        Set<String> primaryScripts;
        language_status_scripts = new TreeMap<String, Relation<SupplementalDataInfo.BasicLanguageData.Type, String>>();
        List<List<String>> input = SpreadSheet.convert(CldrUtility.getUTF8Data("language_script_raw.txt"));
        System.out.println("\n# Problems in language_script_raw.txt\n");
        for (List<String> row : input) {
            try {
                String language;
                if (row.size() == 0 || (language = row.get(0).trim()).length() == 0 || language.startsWith("#")) continue;
                SupplementalDataInfo.BasicLanguageData.Type status = SupplementalDataInfo.BasicLanguageData.Type.valueOf(row.get(2));
                String scripts = row.get(3);
                if (!ConvertLanguageData.checkCode(StandardCodes.LstrType.language, language, row)) continue;
                for (String script : scripts.split("\\s+")) {
                    String reference;
                    if (!ConvertLanguageData.checkCode(StandardCodes.LstrType.script, script, row)) continue;
                    ScriptMetadata.Info scriptInfo = ScriptMetadata.getInfo(script);
                    if (scriptInfo == null) {
                        BadItem.ERROR.toString("illegal script; must be represented in Unicode, remove line or fix", script, row);
                        continue;
                    }
                    ScriptMetadata.IdUsage idUsage = scriptInfo.idUsage;
                    if (status == SupplementalDataInfo.BasicLanguageData.Type.primary && idUsage != ScriptMetadata.IdUsage.RECOMMENDED) {
                        if (idUsage == ScriptMetadata.IdUsage.ASPIRATIONAL || idUsage == ScriptMetadata.IdUsage.LIMITED_USE) {
                            BadItem.WARNING.toString("Script has unexpected usage; make secondary if a Recommended script is used widely for the langauge", (Object)((Object)idUsage) + ", " + script + "=" + ConvertLanguageData.getULocaleScriptName(script), row);
                        } else {
                            BadItem.ERROR.toString("Script is not modern; make secondary", (Object)((Object)idUsage) + ", " + script + "=" + ConvertLanguageData.getULocaleScriptName(script), row);
                            status = SupplementalDataInfo.BasicLanguageData.Type.secondary;
                        }
                    }
                    if (LOCALE_ALIAS_INFO.get("language").containsKey(language)) {
                        BadItem.ERROR.toString("Remove/Change deprecated language", language + " " + ConvertLanguageData.getLanguageName(language) + "; " + ConvertLanguageData.LOCALE_ALIAS_INFO.get("language").get(language), row);
                        continue;
                    }
                    if (status == SupplementalDataInfo.BasicLanguageData.Type.primary && !sc.isModernLanguage(language)) {
                        BadItem.ERROR.toString("Should be secondary, language is not modern", language + " " + ConvertLanguageData.getLanguageName(language), row);
                        status = SupplementalDataInfo.BasicLanguageData.Type.secondary;
                    }
                    ConvertLanguageData.addLanguage2Script(language, status, script);
                    if (row.size() <= 5 || (reference = row.get(5)) == null || reference.length() != 0) continue;
                    language_script_references.put(new Pair<String, String>(language, script), reference);
                }
            }
            catch (RuntimeException e) {
                System.err.println(row);
                throw e;
            }
        }
        for (String language : sc.getGoodAvailableCodes("language")) {
            String suppressScript;
            Map<String, String> registryData;
            if (supplementalData.getDeprecatedInfo("language", language) != null || (registryData = sc.getLangData("language", language)) == null || (suppressScript = registryData.get("Suppress-Script")) == null || ScriptMetadata.getInfo(suppressScript) == null) continue;
            Relation<SupplementalDataInfo.BasicLanguageData.Type, String> status_scripts = language_status_scripts.get(language);
            if (status_scripts == null) {
                System.out.println("Missing Suppress-Script: " + language + "\tSuppress-Script:\t" + suppressScript);
            } else if (!status_scripts.values().contains(suppressScript)) {
                System.out.println("Missing Suppress-Script: " + language + "\tSuppress-Script:\t" + suppressScript + "\tall:\t" + status_scripts.values());
            } else {
                Set<String> primaryScripts2 = status_scripts.getAll((Object)SupplementalDataInfo.BasicLanguageData.Type.primary);
                if (primaryScripts2 != null && !primaryScripts2.contains(suppressScript)) {
                    System.out.println("Suppress-Script is not in primary: " + language + "\tSuppress-Script:\t" + suppressScript + "\tprimary:\t" + primaryScripts2);
                }
            }
            ConvertLanguageData.addLanguage2Script(language, SupplementalDataInfo.BasicLanguageData.Type.primary, suppressScript);
        }
        for (String language : language_status_scripts.keySet()) {
            Relation<SupplementalDataInfo.BasicLanguageData.Type, String> status_scripts = language_status_scripts.get(language);
            Set<String> secondaryScripts = status_scripts.getAll((Object)SupplementalDataInfo.BasicLanguageData.Type.secondary);
            if (secondaryScripts == null) continue;
            primaryScripts = status_scripts.getAll((Object)SupplementalDataInfo.BasicLanguageData.Type.primary);
            if (primaryScripts == null) {
                if (!sc.isModernLanguage(language)) continue;
                BadItem.ERROR.show("modern language without primary script, might need to edit moribund_languages.txt", language + " " + ConvertLanguageData.getLanguageName(language), new String[0]);
                continue;
            }
            status_scripts.removeAll(SupplementalDataInfo.BasicLanguageData.Type.secondary, (Iterable<String>)primaryScripts);
        }
        TreeSet<String> livingLanguagesWithTerritories = new TreeSet<String>();
        for (RowData rowData : sortedInput) {
            String language = rowData.languageCode;
            if (!sc.isModernLanguage(language) || Iso639Data.getSource(language) == Iso639Data.Source.ISO_639_3) continue;
            livingLanguagesWithTerritories.add(language);
        }
        for (String language : livingLanguagesWithTerritories) {
            Relation<SupplementalDataInfo.BasicLanguageData.Type, String> status_scripts = language_status_scripts.get(language);
            if (status_scripts != null && (primaryScripts = status_scripts.getAll((Object)SupplementalDataInfo.BasicLanguageData.Type.primary)) != null && primaryScripts.size() > 0 || language.equals("tw")) continue;
            BadItem.WARNING.show("ISO 639-1/2 language in language-territory list without primary script", language + "\t" + ConvertLanguageData.getLanguageName(language), new String[0]);
        }
    }

    private static boolean checkScript(String script) {
        return false;
    }

    private static boolean checkCode(StandardCodes.LstrType type, String code, List<String> sourceLine) {
        Validity.Status validity = VALIDITY.getCodeToStatus(type).get(code);
        if (validity == Validity.Status.regular) {
            return true;
        }
        if (validity == Validity.Status.unknown && type == StandardCodes.LstrType.region) {
            return true;
        }
        BadItem.ERROR.show("Illegitimate Code", (Object)((Object)type) + ": " + code + " = " + (Object)((Object)validity), sourceLine);
        return false;
    }

    private static void addLanguage2Script(String language, SupplementalDataInfo.BasicLanguageData.Type type, String script) {
        Relation<SupplementalDataInfo.BasicLanguageData.Type, String> status_scripts = language_status_scripts.get(language);
        if (status_scripts == null) {
            status_scripts = Relation.of(new TreeMap(), TreeSet.class);
            language_status_scripts.put(language, status_scripts);
        }
        status_scripts.put(type, script);
    }

    static void addLanguageScriptData() throws IOException {
        String line;
        Set<String> langRegistryCodes = sc.getGoodAvailableCodes("language");
        BufferedReader in = CldrUtility.getUTF8Data("extraLanguagesAndScripts.txt");
        while ((line = in.readLine()) != null) {
            String name3;
            Map<String, String> name2;
            Set<String> names;
            String[] parts = line.split("\\t");
            String alpha3 = parts[0];
            String languageSubtag = Iso639Data.fromAlpha3(alpha3 = ConvertLanguageData.stripBrackets(alpha3));
            if (languageSubtag == null) {
                if (langRegistryCodes.contains(alpha3)) {
                    languageSubtag = alpha3;
                } else {
                    BadItem.WARNING.show("Language subtag not found on line", alpha3, line);
                    continue;
                }
            }
            if ((names = Iso639Data.getNames(languageSubtag)) == null && (name2 = sc.getLangData("language", languageSubtag)) != null && (name3 = name2.get("Description")) != null) {
                names = new TreeSet<String>();
                names.add(name3);
            }
            Set<String> fullScriptList = sc.getGoodAvailableCodes("script");
            String[] scriptList = parts[2].split("[;,]\\s*");
            TreeSet<String> scripts = new TreeSet<String>();
            TreeSet<String> scriptsAlt = new TreeSet<String>();
            for (String script : scriptList) {
                if (script.length() == 0) continue;
                boolean alt = false;
                if (script.endsWith("*")) {
                    alt = true;
                    script = script.substring(0, script.length() - 1);
                }
                if (!fullScriptList.contains(script = ConvertLanguageData.stripBrackets(script))) {
                    System.out.println("Script <" + script + "> for <" + languageSubtag + "> not found in " + fullScriptList);
                    continue;
                }
                if (alt) {
                    scriptsAlt.add(script);
                    continue;
                }
                scripts.add(script);
            }
            TreeSet<String> territories = new TreeSet<String>();
            if (parts.length > 4) {
                String[] territoryList;
                for (String territoryName : territoryList = parts[4].split("\\s*[;,-]\\s*")) {
                    if (territoryName.equals("ISO/DIS 639") || territoryName.equals("3")) continue;
                    String territoryCode = CountryCodeConverter.getCodeFromName(territoryName, true);
                    if (territoryCode == null) {
                        BadItem.ERROR.show("no name found for territory", "<" + territoryName + ">", languageSubtag);
                        continue;
                    }
                    territories.add(territoryCode);
                }
            }
            if (scripts.size() != 0) {
                language2BasicLanguageData.put(languageSubtag, new SupplementalDataInfo.BasicLanguageData().setType(SupplementalDataInfo.BasicLanguageData.Type.secondary).setScripts(scripts).setTerritories(territories));
            }
            if (scriptsAlt.size() == 0) continue;
            language2BasicLanguageData.put(languageSubtag, new SupplementalDataInfo.BasicLanguageData().setType(SupplementalDataInfo.BasicLanguageData.Type.secondary).setScripts(scriptsAlt).setTerritories(territories));
        }
        in.close();
        for (String languageSubtag : supplementalData.getBasicLanguageDataLanguages()) {
            Set<SupplementalDataInfo.BasicLanguageData> otherData = supplementalData.getBasicLanguageData(languageSubtag);
            language2BasicLanguageData.putAll(languageSubtag, otherData);
        }
    }

    private static void showBasicLanguageData(String languageSubtag, Relation<String, String> primaryCombos, Set<String> suppressEmptyScripts, SupplementalDataInfo.BasicLanguageData.Type type) {
        TreeSet<String> scriptsWithSameTerritories = new TreeSet<String>();
        Set<String> lastTerritories = Collections.emptySet();
        for (String script : primaryCombos.keySet()) {
            Set<String> territories = primaryCombos.getAll(script);
            if (lastTerritories != Collections.EMPTY_SET) {
                if (lastTerritories.equals(territories)) {
                    scriptsWithSameTerritories.add(script);
                } else {
                    ConvertLanguageData.showBasicLanguageData2(languageSubtag, scriptsWithSameTerritories, suppressEmptyScripts, lastTerritories, type);
                    scriptsWithSameTerritories.clear();
                }
            }
            lastTerritories = territories;
            scriptsWithSameTerritories.add(script);
        }
        ConvertLanguageData.showBasicLanguageData2(languageSubtag, scriptsWithSameTerritories, suppressEmptyScripts, lastTerritories, type);
    }

    private static void showBasicLanguageData2(String languageSubtag, Set<String> scripts, Set<String> suppressEmptyScripts, Set<String> territories, SupplementalDataInfo.BasicLanguageData.Type type) {
        scripts.remove("Zzzz");
        territories.remove("ZZ");
        if (territories.size() == 0 && suppressEmptyScripts != null) {
            scripts.removeAll(suppressEmptyScripts);
        }
        if (scripts.size() == 0 && territories.size() == 0) {
            return;
        }
        Log.println("\t\t<language type=\"" + languageSubtag + "\"" + (scripts.size() == 0 ? "" : " scripts=\"" + CldrUtility.join(scripts, " ") + "\"") + (territories.size() == 0 ? "" : " territories=\"" + CldrUtility.join(territories, " ") + "\"") + (type == SupplementalDataInfo.BasicLanguageData.Type.primary ? "" : " alt=\"" + (Object)((Object)type) + "\"") + "/>");
    }

    private static String stripBrackets(String alpha3) {
        if (alpha3.startsWith("[") && alpha3.endsWith("]")) {
            alpha3 = alpha3.substring(1, alpha3.length() - 1);
        }
        return alpha3;
    }

    public static String formatNumber(double original, int roundDigits, boolean xml) {
        double d = original;
        if (roundDigits != 0) {
            d = CldrUtility.roundToDecimals(original, roundDigits);
        }
        if (Double.isNaN(d)) {
            d = CldrUtility.roundToDecimals(original, roundDigits);
            throw new IllegalArgumentException("Double is NaN");
        }
        if (xml) {
            return nf_no_comma.format(d);
        }
        return nf.format(d);
    }

    public static String formatPercent(double d, int roundDigits, boolean xml) {
        if (roundDigits != 0) {
            d = CldrUtility.roundToDecimals(d, roundDigits);
        }
        if (xml) {
            nf_no_comma.setMaximumFractionDigits(roundDigits + 2);
            return nf_no_comma.format(d * 100.0);
        }
        pf.setMaximumFractionDigits(roundDigits + 2);
        return pf.format(d);
    }

    private static String fixLanguageCode(String languageCodeRaw, List<String> row) {
        Row.R2<List<String>, String> replacement;
        String languageCode = languageTagCanonicalizer.transform(languageCodeRaw);
        int bar = languageCode.indexOf(95);
        String script = "";
        if (bar >= 0) {
            script = languageCode.substring(bar);
            languageCode = languageCode.substring(0, bar);
        }
        if ((replacement = supplementalData.getLocaleAliasInfo().get("language").get(languageCode)) != null) {
            String replacementCode = (String)((List)replacement.get0()).get(0);
            BadItem.ERROR.show("deprecated language code", languageCode + " => " + replacementCode, row);
            languageCode = replacementCode;
        }
        if (!sc.getAvailableCodes("language").contains(languageCode)) {
            BadItem.ERROR.show("bad language code", languageCode, row);
        }
        return languageCode + script;
    }

    private static String fixCountryCode(String countryCode, List<String> row) {
        Row.R2<List<String>, String> replacement = supplementalData.getLocaleAliasInfo().get("territory").get(countryCode);
        if (replacement != null) {
            String replacementCode = (String)((List)replacement.get0()).get(0);
            BadItem.ERROR.show("deprecated territory code", countryCode + " => " + replacementCode, row);
            countryCode = replacementCode;
        }
        if (!sc.getAvailableCodes("territory").contains(countryCode)) {
            BadItem.ERROR.show("bad territory code", countryCode, row);
        }
        return countryCode;
    }

    private static String getULocaleLocaleName(String languageCode) {
        return english.getName(languageCode, true);
    }

    private static String getULocaleScriptName(String scriptCode) {
        return english.getName(1, scriptCode);
    }

    private static String getULocaleCountryName(String countryCode) {
        return english.getName(2, countryCode);
    }

    static /* synthetic */ StandardCodes access$700() {
        return sc;
    }

    static {
        language_script_references = new TreeMap<Pair<String, String>, String>();
        LOCALE_ALIAS_INFO = SupplementalDataInfo.getInstance().getLocaleAliasInfo();
        VALIDITY = Validity.getInstance();
        nf = NumberFormat.getInstance(ULocale.ENGLISH);
        nf_no_comma = NumberFormat.getInstance(ULocale.ENGLISH);
        nf_no_comma.setGroupingUsed(false);
        pf = NumberFormat.getPercentInstance(ULocale.ENGLISH);
        languageTagCanonicalizer = new LanguageTagCanonicalizer();
    }

    static enum BadItem {
        ERROR,
        WARNING,
        DETAIL;


        void show(String problem, String details, String ... items) {
            System.out.println(this.toString(problem, details, items));
        }

        void show(String problem, String details, List<String> row) {
            System.out.println(this.toString(problem, details, row));
        }

        private String toString(String problem, String details, String ... items) {
            return this.toString(problem, details, Arrays.asList(items));
        }

        private String toString(String problem, String details, List<String> row) {
            return "* " + (Object)((Object)this) + " *\t" + problem + ":\t" + details + (row != null && row.size() > 0 ? "\t" + Joiner.on("\t").join(row) : "");
        }
    }

    public static class InverseComparator<T>
    implements Comparator<T> {
        private Comparator<T> other;

        public InverseComparator() {
            this.other = null;
        }

        public InverseComparator(Comparator<T> other) {
            this.other = other;
        }

        @Override
        public int compare(T a, T b) {
            return this.other == null ? ((Comparable)b).compareTo(a) : this.other.compare(b, a);
        }
    }

    public static class GeneralCollator
    implements Comparator<String> {
        static UTF16.StringComparator cpCompare = new UTF16.StringComparator(true, false, 0);
        static RuleBasedCollator UCA = (RuleBasedCollator)Collator.getInstance(ULocale.ROOT);

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            int result = UCA.compare(s1, s2);
            if (result != 0) {
                return result;
            }
            return cpCompare.compare(s1, s2);
        }

        static {
            UCA.setNumericCollation(true);
        }
    }

    static class CodeAndPopulation {
        String code = null;
        double population = Double.NaN;

        CodeAndPopulation() {
        }

        public String toString() {
            return "{" + this.code + "," + this.population + "}";
        }
    }

    static class References {
        Map<String, Pair<String, String>> Rxxx_to_reference = new TreeMap<String, Pair<String, String>>();
        Map<Pair<String, String>, String> reference_to_Rxxx = new TreeMap<Pair<String, String>, String>();
        Map<String, Pair<String, String>> Rxxx_to_oldReferences = supplementalData.getReferences();
        Map<Pair<String, String>, String> oldReferences_to_Rxxx = new TreeMap<Pair<String, String>, String>();
        Matcher URI;
        static int referenceStart = 1000;

        References() {
            for (String Rxxx : this.Rxxx_to_oldReferences.keySet()) {
                this.oldReferences_to_Rxxx.put(this.Rxxx_to_oldReferences.get(Rxxx), Rxxx);
            }
            this.URI = PatternCache.get("([a-z]+\\://[\\S]+)\\s?(.*)").matcher("");
        }

        private String addReference(String rawReferenceText) {
            if (rawReferenceText == null || rawReferenceText.length() == 0) {
                return "";
            }
            Object p = this.URI.reset(rawReferenceText).matches() ? new Pair<String, String>(this.URI.group(1), this.URI.group(2) == null || this.URI.group(2).length() == 0 ? "[missing]" : this.URI.group(2)).freeze() : new Pair<Object, String>(null, rawReferenceText).freeze();
            String Rxxx = this.reference_to_Rxxx.get(p);
            if (Rxxx == null) {
                Rxxx = this.oldReferences_to_Rxxx.get(p);
                if (Rxxx != null) {
                    p = this.Rxxx_to_oldReferences.get(Rxxx);
                } else {
                    while (this.Rxxx_to_reference.get(Rxxx = "R" + referenceStart++) != null || this.Rxxx_to_oldReferences.get(Rxxx) != null) {
                    }
                }
                this.reference_to_Rxxx.put((Pair<String, String>)p, Rxxx);
                this.Rxxx_to_reference.put(Rxxx, (Pair<String, String>)p);
            }
            return " references=\"" + Rxxx + "\"";
        }

        String getReferenceHTML(String Rxxx) {
            Pair<String, String> p = this.Rxxx_to_reference.get(Rxxx);
            String uri = p.getFirst();
            String value = p.getSecond();
            uri = uri == null ? "" : " uri=\"" + TransliteratorUtilities.toHTML.transliterate(uri) + "\"";
            value = value == null ? "[missing]" : TransliteratorUtilities.toHTML.transliterate(value);
            return "\t\t<reference type=\"" + Rxxx + "\"" + uri + ">" + value + "</reference>";
        }

        void printReferences() {
            Log.println("\t<references>");
            for (String Rxxx : this.Rxxx_to_reference.keySet()) {
                Log.println(this.getReferenceHTML(Rxxx));
            }
            Log.println("\t</references>");
        }
    }

    static class RickComparator
    implements Comparator<RowData> {
        RickComparator() {
        }

        @Override
        public int compare(RowData me, RowData that) {
            int result = GENERAL_COLLATOR.compare(me.getCountryName(), that.getCountryName());
            if (0 != result) {
                return result;
            }
            result = GENERAL_COLLATOR.compare(me.getRickLanguageName(), that.getRickLanguageName());
            if (0 != result) {
                return result;
            }
            return me.compareTo(that);
        }
    }

    static class RowData
    implements Comparable<Object> {
        private final String countryCode;
        private final double countryGdp;
        private final double countryLiteracy;
        private final double countryPopulation;
        private final String languageCode;
        private final SupplementalDataInfo.OfficialStatus officialStatus;
        private final double languagePopulation;
        private final double languageLiteracy;
        private final String comment;
        private final String notes;
        private final String badLanguageName;
        private final boolean relativeLanguagePopulation;
        private static final Set<String> doneCountries = new HashSet<String>();
        private static final Set<String> countryCodes = ConvertLanguageData.access$700().getGoodAvailableCodes("territory");
        static boolean MARK_OUTPUT = false;
        static Map<String, String> oldToFixed = new HashMap<String, String>();

        public RowData(String country, String language) {
            this.countryCode = country;
            this.languageCode = language;
            this.comment = "";
            this.notes = "";
            language = "";
            country = "";
            this.badLanguageName = "";
            this.officialStatus = SupplementalDataInfo.OfficialStatus.unknown;
            this.countryGdp = this.roundToPartsPer(AddPopulationData.getGdp(this.countryCode), 1000.0);
            this.countryLiteracy = AddPopulationData.getLiteracy(this.countryCode) / 100.0;
            this.countryPopulation = AddPopulationData.getPopulation(this.countryCode);
            this.languageLiteracy = Double.NaN;
            this.languagePopulation = Double.NaN;
            this.relativeLanguagePopulation = false;
        }

        RowData(List<String> row) throws ParseException {
            double languageLiteracy1;
            this.countryCode = ConvertLanguageData.fixCountryCode(row.get(1), row);
            if (!countryCodes.contains(this.countryCode)) {
                System.err.println("WRONG COUNTRY CODE: " + row);
            }
            double countryPopulation1 = this.parseDecimal(row.get(2));
            double countryLiteracy1 = this.parsePercent(row.get(3), countryPopulation1);
            this.countryGdp = this.roundToPartsPer(AddPopulationData.getGdp(this.countryCode), 1000.0);
            this.countryLiteracy = AddPopulationData.getLiteracy(this.countryCode) / 100.0;
            this.countryPopulation = AddPopulationData.getPopulation(this.countryCode);
            String officialStatusString = row.get(5).trim().replace(' ', '_');
            if (officialStatusString.equals("national")) {
                officialStatusString = "official";
            } else if (officialStatusString.equals("regional_official")) {
                officialStatusString = "official_regional";
            } else if (officialStatusString.length() == 0 || officialStatusString.equals("uninhabited")) {
                officialStatusString = "unknown";
            }
            try {
                this.officialStatus = SupplementalDataInfo.OfficialStatus.valueOf(officialStatusString);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Can't interpret offical-status: " + officialStatusString);
            }
            String languageCode1 = row.get(7);
            if (languageCode1.startsWith("*") || languageCode1.startsWith("\u00a7")) {
                languageCode1 = languageCode1.substring(1);
            }
            this.languageCode = ConvertLanguageData.fixLanguageCode(languageCode1, row);
            if (!doneCountries.contains(this.countryCode)) {
                doneCountries.add(this.countryCode);
            }
            double languagePopulation1 = this.parsePercent(row.get(8), countryPopulation1) * countryPopulation1;
            if (this.officialStatus.isMajor() && languagePopulation1 * 100.0 < this.countryPopulation && languagePopulation1 < 1000000.0) {
                BadItem.WARNING.show("official language has population < 1% of country & < 1,000,000", this.languageCode + ", " + Math.round(languagePopulation1), row);
            }
            if (languagePopulation1 < 0.999) {
                BadItem.WARNING.show("suspect language population, < 1", this.languageCode + ", " + Math.round(languagePopulation1), row);
            }
            if (languagePopulation1 > 10000.0) {
                this.relativeLanguagePopulation = true;
                languagePopulation1 = languagePopulation1 * this.countryPopulation / countryPopulation1;
            } else {
                this.relativeLanguagePopulation = false;
            }
            if (RowData.isApproximatelyGreater(languagePopulation1, this.countryPopulation, 1.0E-4)) {
                BadItem.ERROR.show("language population > country population", Math.round(languagePopulation1) + " > " + this.countryPopulation, row);
            }
            this.languagePopulation = languagePopulation1 < this.countryPopulation ? languagePopulation1 : this.countryPopulation;
            String stringLanguageLiteracy = row.size() <= 9 ? "" : row.get(9);
            double d = languageLiteracy1 = stringLanguageLiteracy.length() == 0 ? this.countryLiteracy : this.parsePercent(stringLanguageLiteracy, this.languagePopulation);
            if (RowData.isApproximatelyEqual(languageLiteracy1, countryLiteracy1, 0.001)) {
                languageLiteracy1 = this.countryLiteracy;
            }
            this.languageLiteracy = languageLiteracy1;
            this.comment = row.size() > 10 ? row.get(10) : "";
            this.notes = row.size() > 11 ? row.get(11) : "";
            this.badLanguageName = row.get(6);
        }

        private void showDiff(double a, double new_a, double maxRelativeDiff, boolean showLang) {
            double diff = new_a / a - 1.0;
            if (Math.abs(diff) > maxRelativeDiff) {
                System.out.println(ConvertLanguageData.formatPercent(diff, 0, false) + "\t" + this.countryCode + "\t" + ConvertLanguageData.getDisplayCountry(this.countryCode) + (showLang ? "\t" + this.languageCode + "\t" + ConvertLanguageData.getLanguageName(this.languageCode) : "") + "\t" + ConvertLanguageData.formatNumber(a, 0, false) + "\t=>\t" + ConvertLanguageData.formatNumber(new_a, 0, false));
            }
        }

        private double roundToPartsPer(double a, double whole) {
            double log10 = Math.log10(a / whole);
            long digitsFound = (long)log10;
            long factor = (long)Math.pow(10.0, digitsFound);
            double rounded = Math.round(a / (double)factor);
            double result = rounded * (double)factor;
            return result;
        }

        private static boolean isApproximatelyEqual(double a, double b, double epsilon) {
            return a == b || Math.abs(a - b) < epsilon;
        }

        private static boolean isApproximatelyGreater(double a, double b, double epsilon) {
            return a > b + epsilon;
        }

        double parseDecimal(String numericRepresentation) throws ParseException {
            Number result = nf.parse(numericRepresentation);
            return result.doubleValue();
        }

        double parsePercent(String numericRepresentation, double baseValue) throws ParseException {
            double result;
            if (numericRepresentation.contains("%")) {
                Number result0 = pf.parse(numericRepresentation);
                result = result0.doubleValue();
            } else {
                Number result0 = nf.parse(numericRepresentation);
                result = result0.doubleValue() / baseValue;
            }
            return result;
        }

        public double getLanguageLiteratePopulation() {
            return this.languageLiteracy * this.languagePopulation;
        }

        public double getLanguageLiteratePopulation(double weightIfNotOfficial) {
            double result = this.languageLiteracy * this.languagePopulation;
            if (!this.officialStatus.isMajor()) {
                result *= weightIfNotOfficial;
            }
            return result;
        }

        @Override
        public int compareTo(Object o) {
            RowData that = (RowData)o;
            int result = GENERAL_COLLATOR.compare(this.countryCode, that.countryCode);
            if (0 != result) {
                return result;
            }
            if (this.languagePopulation > that.languagePopulation) {
                return -1;
            }
            if (this.languagePopulation < that.languagePopulation) {
                return 1;
            }
            result = GENERAL_COLLATOR.compare(this.languageCode, that.languageCode);
            if (0 != result) {
                return result;
            }
            return 0;
        }

        public static String toStringHeader() {
            return "countryCode\tcountryPopulation\tcountryGdp\tcountryLiteracy\tlanguagePopulation\tlanguageCode\twritingPopulation";
        }

        public String toString() {
            return this.countryCode + "\t" + this.countryPopulation + "\t" + this.countryGdp + "\t" + this.countryLiteracy + "\t" + this.languagePopulation + "\t" + this.languageCode + "\t" + this.languageLiteracy;
        }

        public String toString(boolean b) {
            return "region:\t" + ConvertLanguageData.getCountryCodeAndName(this.countryCode) + "\tpop:\t" + this.countryPopulation + "\tgdp:\t" + this.countryGdp + "\tlit:\t" + this.countryLiteracy + "\tlang:\t" + ConvertLanguageData.getLanguageCodeAndName(this.languageCode) + "\tpop:\t" + this.languagePopulation + "\tlit:\t" + this.languageLiteracy;
        }

        public String getRickLanguageCode() {
            if (this.languageCode.contains("_")) {
                return this.languageCode;
            }
            Iso639Data.Source source = Iso639Data.getSource(this.languageCode);
            if (source == null) {
                return "\u00a7" + this.languageCode;
            }
            if (MARK_OUTPUT && source == Iso639Data.Source.ISO_639_3) {
                return "*" + this.languageCode;
            }
            return this.languageCode;
        }

        public String getRickLanguageName() {
            String cldrResult = ConvertLanguageData.getExcelQuote(english.getName(this.languageCode, true));
            return cldrResult;
        }

        public String getRickLanguageName2() {
            String result = new ULocale(this.languageCode).getDisplayName();
            if (!result.equals(this.languageCode)) {
                return ConvertLanguageData.getExcelQuote(result);
            }
            Set<String> names = Iso639Data.getNames(this.languageCode);
            if (names != null && names.size() != 0) {
                if (MARK_OUTPUT) {
                    return ConvertLanguageData.getExcelQuote("*" + names.iterator().next());
                }
                return ConvertLanguageData.getExcelQuote(names.iterator().next());
            }
            return ConvertLanguageData.getExcelQuote("\u00a7" + this.badLanguageName);
        }

        public String getCountryName() {
            return ConvertLanguageData.getExcelQuote(ConvertLanguageData.getDisplayCountry(this.countryCode));
        }

        public String getCountryGdpString() {
            return ConvertLanguageData.getExcelQuote(ConvertLanguageData.formatNumber(this.countryGdp, 0, false));
        }

        public String getCountryLiteracyString() {
            return ConvertLanguageData.formatPercent(this.countryLiteracy, 2, false);
        }

        public String getCountryPopulationString() {
            return ConvertLanguageData.getExcelQuote(ConvertLanguageData.formatNumber(this.countryPopulation, 0, false));
        }

        public String getLanguageLiteracyString() {
            return ConvertLanguageData.formatPercent(this.languageLiteracy, 2, false);
        }

        public String getLanguagePopulationString() {
            try {
                double percent = this.languagePopulation / this.countryPopulation;
                return ConvertLanguageData.getExcelQuote(this.relativeLanguagePopulation && percent > 0.03 && this.languagePopulation > 10000.0 ? ConvertLanguageData.formatPercent(percent, 2, false) : ConvertLanguageData.formatNumber(this.languagePopulation, 3, false));
            }
            catch (IllegalArgumentException e) {
                return "NaN";
            }
        }

        private double getLanguagePopulation() {
            return this.languagePopulation;
        }
    }

    static class LanguageInfo {
        static LanguageInfo INSTANCE = new LanguageInfo();
        Map<String, Set<String>> languageToScripts = new TreeMap<String, Set<String>>();
        Map<String, Set<String>> languageToRegions = new TreeMap<String, Set<String>>();
        Map<String, XPathParts.Comments> languageToComments = new TreeMap<String, XPathParts.Comments>();
        Map<String, Set<String>> languageToScriptsAlt = new TreeMap<String, Set<String>>();
        Map<String, Set<String>> languageToRegionsAlt = new TreeMap<String, Set<String>>();
        Map<String, XPathParts.Comments> languageToCommentsAlt = new TreeMap<String, XPathParts.Comments>();

        private LanguageInfo() {
            cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
            CLDRFile supplemental = cldrFactory.make("supplementalData", true);
            Iterator<String> it = supplemental.iterator("//supplementalData/languageData/language");
            while (it.hasNext()) {
                List<String> regions;
                String xpath = it.next();
                XPathParts parts = XPathParts.getFrozenInstance(xpath);
                Map<String, String> x = parts.getAttributes(-1);
                boolean alt = x.containsKey("alt");
                String lang = x.get("type");
                List<String> scripts = this.getAttributeList(x, "scripts");
                if (scripts != null) {
                    if (alt) {
                        ConvertLanguageData.putAll(this.languageToScriptsAlt, lang, new LinkedHashSet<String>(scripts));
                    } else {
                        ConvertLanguageData.putAll(this.languageToScripts, lang, new LinkedHashSet<String>(scripts));
                    }
                }
                if ((regions = this.getAttributeList(x, "territories")) == null) continue;
                if (alt) {
                    ConvertLanguageData.putAll(this.languageToRegionsAlt, lang, new LinkedHashSet<String>(regions));
                    continue;
                }
                ConvertLanguageData.putAll(this.languageToRegions, lang, new LinkedHashSet<String>(regions));
            }
        }

        private List<String> getAttributeList(Map<String, String> x, String attribute) {
            List<String> scripts = null;
            String scriptString = x.get(attribute);
            if (scriptString != null) {
                scripts = Arrays.asList(scriptString.split("\\s+"));
            }
            return scripts;
        }
    }
}

