/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRTool;

public class Option {
    private final String tag;
    private final Character flag;
    private final Pattern match;
    private final String defaultArgument;
    private final String helpString;
    private boolean doesOccur;
    private String value;
    static final String PAD = "                    ";
    static final Options myOptions = new Options().add("file", ".*", "Filter the information based on file name, using a regex argument").add("path", (Object)".*", "default-path", "Filter the information based on path name, using a regex argument").add("content", ".*", "Filter the information based on content name, using a regex argument").add("gorp", null, null, "Gorp").add("enum", Test.class, null, "enum check").add("regex", (Object)"a*", null, "Gorp");

    public void clear() {
        this.doesOccur = false;
        this.value = null;
    }

    public String getTag() {
        return this.tag;
    }

    public Pattern getMatch() {
        return this.match;
    }

    public String getHelpString() {
        return this.helpString;
    }

    public String getValue() {
        return this.value;
    }

    public String getExplicitValue() {
        return this.doesOccur ? this.value : null;
    }

    public boolean doesOccur() {
        return this.doesOccur;
    }

    public Option(Enum<?> optionEnumValue, String argumentPattern, String defaultArgument, String helpText) {
        this(optionEnumValue, optionEnumValue.name(), Character.valueOf(optionEnumValue.name().charAt(0)), Pattern.compile(argumentPattern), defaultArgument, helpText);
    }

    public Option(Enum<?> enumOption, String tag, Character flag, Object argumentPatternIn, String defaultArgument, String helpString) {
        Pattern argumentPattern = Option.getPattern(argumentPatternIn);
        if (defaultArgument != null && argumentPattern != null && !argumentPattern.matcher(defaultArgument).matches()) {
            throw new IllegalArgumentException("Default argument doesn't match pattern: " + defaultArgument + ", " + argumentPattern);
        }
        this.match = argumentPattern;
        this.helpString = helpString;
        this.tag = tag;
        this.flag = flag;
        this.defaultArgument = defaultArgument;
    }

    public Option(Enum<?> optionEnumValue, Params optionList) {
        this(optionEnumValue, optionEnumValue.name(), Character.valueOf(optionList.flag != '\u0000' ? optionList.flag : optionEnumValue.name().charAt(0)), optionList.match, optionList.defaultArgument, optionList.helpString);
    }

    private static Pattern getPattern(Object match) {
        if (match == null) {
            return null;
        }
        if (match instanceof Pattern) {
            return (Pattern)match;
        }
        if (match instanceof String) {
            return Pattern.compile((String)match);
        }
        if (match instanceof Class) {
            try {
                Object[] valuesMethod = (Enum[])((Class)match).getMethod("values", new Class[0]).invoke(null, new Object[0]);
                return Pattern.compile(Joiner.on("|").join(valuesMethod));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException(match.toString());
    }

    public String toString() {
        return "-" + this.flag + " (" + this.tag + ")" + PAD.substring(Math.min(this.tag.length(), PAD.length())) + (this.match == null ? "no-arg" : "match: " + this.match.pattern()) + (this.defaultArgument == null ? "" : " \tdefault=" + this.defaultArgument) + " \t" + this.helpString;
    }

    public MatchResult matches(String inputValue) {
        if (this.doesOccur) {
            System.err.println("#Duplicate argument: '" + this.tag);
            return this.match == null ? MatchResult.noValueError : MatchResult.valueError;
        }
        this.doesOccur = true;
        if (inputValue == null) {
            inputValue = this.defaultArgument;
        }
        if (this.match == null) {
            return MatchResult.noValue;
        }
        if (inputValue != null && this.match.matcher(inputValue).matches()) {
            this.value = inputValue;
            return MatchResult.value;
        }
        System.err.println("#The flag '" + this.tag + "' has the parameter '" + inputValue + "', which must match " + this.match.pattern());
        return MatchResult.valueError;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = "foo -fen.xml -c a* --path bar -g b -r aaa -e B".split("\\s+");
        }
        myOptions.parse(args, true);
        for (Option option : myOptions) {
            System.out.println("#" + option.getTag() + "\t" + option.doesOccur() + "\t" + option.getValue() + "\t" + option.getHelpString());
        }
        Option option = myOptions.get("file");
        System.out.println("\n#" + option.doesOccur() + "\t" + option.getValue() + "\t" + option);
    }

    private static String getCLDRToolDescription(Class<?> forClass) {
        CLDRTool cldrTool = forClass.getAnnotation(CLDRTool.class);
        if (cldrTool != null) {
            return cldrTool.description();
        }
        return "(no @CLDRTool annotation)";
    }

    public String getDefaultArgument() {
        return this.defaultArgument;
    }

    private static enum Test {
        A,
        B,
        C;

    }

    public static class Options
    implements Iterable<Option> {
        private String mainMessage;
        final Map<String, Option> stringToValues = new LinkedHashMap<String, Option>();
        final Map<Enum<?>, Option> enumToValues = new LinkedHashMap();
        final Map<Character, Option> charToValues = new LinkedHashMap<Character, Option>();
        final Set<String> results = new LinkedHashSet<String>();
        final Option help;

        public Options(String mainMessage) {
            this.add("help", null, "Provide the list of possible options");
            this.help = this.charToValues.values().iterator().next();
            this.mainMessage = (mainMessage.isEmpty() ? "" : mainMessage + "\n") + "Here are the options:\n";
        }

        public Options() {
            this("");
        }

        public Options(Class<?> forClass) {
            this(forClass.getSimpleName() + ": " + Option.getCLDRToolDescription(forClass));
        }

        public Options add(String string, String helpText) {
            return this.add(string, Character.valueOf(string.charAt(0)), null, null, helpText);
        }

        public Options add(String string, String argumentPattern, String helpText) {
            return this.add(string, Character.valueOf(string.charAt(0)), argumentPattern, null, helpText);
        }

        public Options add(String string, Object argumentPattern, String defaultArgument, String helpText) {
            return this.add(string, Character.valueOf(string.charAt(0)), argumentPattern, defaultArgument, helpText);
        }

        public Option add(Enum<?> optionEnumValue, Object argumentPattern, String defaultArgument, String helpText) {
            this.add(optionEnumValue, optionEnumValue.name(), Character.valueOf(optionEnumValue.name().charAt(0)), argumentPattern, defaultArgument, helpText);
            return this.get(optionEnumValue.name());
        }

        public Options add(String string, Character flag, Object argumentPattern, String defaultArgument, String helpText) {
            return this.add(null, string, flag, argumentPattern, defaultArgument, helpText);
        }

        public Options add(Enum<?> optionEnumValue, String string, Character flag, Object argumentPattern, String defaultArgument, String helpText) {
            Option option = new Option(optionEnumValue, string, flag, argumentPattern, defaultArgument, helpText);
            return this.add(optionEnumValue, option);
        }

        public Options add(Enum<?> optionEnumValue, Option option) {
            if (this.stringToValues.containsKey(option.tag)) {
                throw new IllegalArgumentException("Duplicate tag <" + option.tag + "> with " + this.stringToValues.get(option.tag));
            }
            if (this.charToValues.containsKey(option.flag)) {
                throw new IllegalArgumentException("Duplicate tag <" + option.tag + ", " + option.flag + "> with " + this.charToValues.get(option.flag));
            }
            this.stringToValues.put(option.tag, option);
            this.charToValues.put(option.flag, option);
            if (optionEnumValue != null) {
                this.enumToValues.put(optionEnumValue, option);
            }
            return this;
        }

        public Set<String> parse(Enum<?> enumOption, String[] args, boolean showArguments) {
            return this.parse(args, showArguments);
        }

        public Set<String> parse(String[] args, boolean showArguments) {
            this.results.clear();
            for (Option option : this.charToValues.values()) {
                option.clear();
            }
            int errorCount = 0;
            boolean needHelp = false;
            for (int i = 0; i < args.length; ++i) {
                Option option;
                String arg = args[i];
                if (!arg.startsWith("-")) {
                    this.results.add(arg);
                    continue;
                }
                boolean isStringOption = arg.startsWith("--");
                String value = null;
                if (isStringOption) {
                    int equalsPos = (arg = arg.substring(2)).indexOf(61);
                    if (equalsPos > -1) {
                        value = arg.substring(equalsPos + 1);
                        arg = arg.substring(0, equalsPos);
                    }
                    option = this.stringToValues.get(arg);
                } else {
                    if (arg.length() > 2) {
                        value = arg.substring(2);
                    }
                    arg = arg.substring(1);
                    option = this.charToValues.get(Character.valueOf(arg.charAt(0)));
                }
                boolean tookExtraArgument = false;
                if (value == null) {
                    String string = value = i < args.length - 1 ? args[i + 1] : null;
                    if (value != null && value.startsWith("-")) {
                        value = null;
                    }
                    if (value != null) {
                        ++i;
                        tookExtraArgument = true;
                    }
                }
                if (option == null) {
                    ++errorCount;
                    System.out.println("#Unknown flag: " + arg);
                    continue;
                }
                MatchResult matches = option.matches(value);
                if (tookExtraArgument && (matches == MatchResult.noValue || matches == MatchResult.noValueError)) {
                    --i;
                }
                if (option != this.help) continue;
                needHelp = true;
            }
            for (Option option : this.stringToValues.values()) {
                if (option.doesOccur || option.defaultArgument == null) continue;
                option.value = option.defaultArgument;
            }
            if (errorCount > 0) {
                System.err.println("Invalid Option - Choices are:");
                System.err.println(this.getHelp());
                System.exit(1);
            } else if (needHelp) {
                System.err.println(this.getHelp());
                System.exit(1);
            } else if (showArguments) {
                System.out.println(Arrays.asList(args));
                for (Option option : this.stringToValues.values()) {
                    if (!option.doesOccur && option.value == null) continue;
                    System.out.println("#-" + option.flag + "\t" + option.tag + (option.doesOccur ? "\t\u2254\t" : "\t\u225d\t") + option.value);
                }
            }
            return this.results;
        }

        private String getHelp() {
            StringBuilder buffer = new StringBuilder(this.mainMessage);
            boolean first = true;
            for (Option option : this.stringToValues.values()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append('\n');
                }
                buffer.append(option);
            }
            return buffer.toString();
        }

        @Override
        public Iterator<Option> iterator() {
            return this.stringToValues.values().iterator();
        }

        public Option get(String string) {
            Option result = this.stringToValues.get(string);
            if (result == null) {
                throw new IllegalArgumentException("Unknown option: " + string);
            }
            return result;
        }

        public Option get(Enum<?> enumOption) {
            Option result = this.enumToValues.get(enumOption);
            if (result == null) {
                throw new IllegalArgumentException("Unknown option: " + enumOption);
            }
            return result;
        }
    }

    static enum MatchResult {
        noValueError,
        noValue,
        valueError,
        value;

    }

    public static class Params {
        private Object match = null;
        private String defaultArgument = null;
        private String helpString = null;
        private char flag = '\u0000';

        public Params setMatch(Object match) {
            this.match = match;
            return this;
        }

        public Params setDefault(String defaultArgument) {
            this.defaultArgument = defaultArgument;
            return this;
        }

        public Params setHelp(String helpString) {
            this.helpString = helpString;
            return this;
        }

        public Params setFlag(char c) {
            this.flag = c;
            return this;
        }
    }
}

