/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.util.LinkedHashMap;
import java.util.Map;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.XMLFileReader;

public class ReadXMB {
    public static Map<String, String> load(String directory, String file) {
        CasingHandler simpleHandler = new CasingHandler();
        XMLFileReader xfr = new XMLFileReader().setHandler(simpleHandler);
        xfr.read(directory + "/" + file, XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER | XMLFileReader.LEXICAL_HANDLER, true);
        simpleHandler.flush();
        return simpleHandler.info;
    }

    public static void main(String[] args) {
        Map<String, String> info = ReadXMB.load(CLDRPaths.BASE_DIRECTORY + "tools/cldr-code/src/main/resources/org/unicode/cldr/unittest/data/xmb/", "en.xml");
        System.out.println("============");
        for (Map.Entry<String, String> entry : info.entrySet()) {
            System.out.println(entry.getValue() + "\t" + entry.getKey());
        }
    }

    private static class CasingHandler
    extends XMLFileReader.SimpleHandler {
        public Map<String, String> info = new LinkedHashMap<String, String>();
        String path;
        String id;
        String value;

        private CasingHandler() {
        }

        @Override
        public void handlePathValue(String pathx, String value) {
            int pos = pathx.indexOf("[@id=\"");
            int posEnd = pathx.indexOf("\"]", pos + 6);
            this.id = pathx.substring(pos + 6, posEnd);
            if (this.id == null) {
                System.out.println("PATH:\t" + pathx + "\t\t" + value);
            }
            this.value = value;
        }

        @Override
        public void handleComment(String pathx, String comment) {
            if ((comment = comment.trim()).startsWith("//ldml")) {
                this.flush();
                this.path = comment;
            } else if (comment.startsWith("English original:")) {
                this.value = comment.substring(17).trim();
            } else {
                System.out.println("COMMENT:\t" + pathx + "\t\t" + comment);
            }
        }

        private void flush() {
            if (this.path != null) {
                this.info.put(this.path, this.value);
            }
            this.path = null;
            this.value = null;
            this.id = null;
        }
    }
}

