/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.util.VersionInfo;
import java.util.List;
import java.util.Set;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;

public class ToolConstants {
    public static final List<String> CLDR_VERSIONS = ImmutableList.of("1.1.1", "1.2", "1.3", "1.4.1", "1.5.1", "1.6.1", "1.7.2", "1.8.1", "1.9.1", "2.0.1", "21.0", "22.1", new String[]{"23.1", "24.0", "25.0", "26.0", "27.0", "28.0", "29.0", "30.0", "31.0", "32.0", "33.0", "33.1", "34.0", "35.0", "35.1", "36.0", "36.1", "37.0", "38.0", "38.1"});
    public static final String DEV_VERSION = "39";
    public static final Set<String> CLDR_RELEASE_VERSION_SET = ImmutableSet.copyOf(CLDR_VERSIONS);
    public static final Set<String> CLDR_RELEASE_AND_DEV_VERSION_SET = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(CLDR_RELEASE_VERSION_SET)).add("39")).build();
    public static final String CHART_VERSION = CldrUtility.getProperty("CHART_VERSION", "39");
    public static final VersionInfo CHART_VI = VersionInfo.getInstance(CHART_VERSION);
    public static final String PREV_CHART_VERSION = CldrUtility.getProperty("PREV_CHART_VERSION", ToolConstants.previousVersion(CHART_VERSION));
    public static final VersionInfo PREV_CHART_VI = VersionInfo.getInstance(PREV_CHART_VERSION);
    public static final String PREV_CHART_VERSION_WITH0 = PREV_CHART_VI.getVersionString(2, 2);
    public static final ChartStatus CHART_STATUS = ChartStatus.valueOf(CldrUtility.getProperty("CHART_STATUS", CLDR_RELEASE_VERSION_SET.contains(CHART_VERSION) ? "release" : "beta"));
    public static final boolean BETA = CHART_STATUS == ChartStatus.beta;
    public static final String CHART_DISPLAY_VERSION = CHART_VI.getVersionString(2, 2) + (BETA ? "\u03b2" : "");
    public static final String LAST_RELEASE_VERSION = CLDR_VERSIONS.get(CLDR_VERSIONS.size() - 1);
    public static final VersionInfo LAST_RELEASE_VI = VersionInfo.getInstance(LAST_RELEASE_VERSION);
    public static final String LAST_RELEASE_VERSION_WITH0 = LAST_RELEASE_VI.getVersionString(2, 2);
    public static final String CHART_SOURCE = "http://unicode.org/repos/cldr/" + (CHART_STATUS != ChartStatus.release ? "trunk/" : "tags/release-" + CHART_VERSION + "/");

    public static String previousVersion(String version) {
        String last = "";
        for (String current : CLDR_VERSIONS) {
            if (current.equals(version)) break;
            last = current;
        }
        return last;
    }

    public static String getBaseDirectory(String version) {
        if (version.equals(DEV_VERSION) || version.equals("39.0")) {
            return CLDRPaths.BASE_DIRECTORY;
        }
        if (CLDR_RELEASE_VERSION_SET.contains(version)) {
            return CLDRPaths.ARCHIVE_DIRECTORY + "cldr-" + version + "/";
        }
        throw new IllegalArgumentException("not a known version: " + version);
    }

    public static enum ChartStatus {
        beta,
        trunk,
        release;

    }
}

