/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.InputStreamFactory;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.LocaleStringProvider;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.LogicalGrouping;
import org.unicode.cldr.util.MapComparator;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.UnitPathType;
import org.unicode.cldr.util.With;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XMLSource;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CLDRFile
implements Freezable<CLDRFile>,
Iterable<String>,
LocaleStringProvider {
    private static final boolean SEED_ONLY = true;
    private static final ImmutableSet<String> casesNominativeOnly = ImmutableSet.of(GrammarInfo.GrammaticalFeature.grammaticalCase.getDefault(null));
    private static final boolean USE_LOADING_BUFFER = true;
    private static final boolean WRITE_COMMENTS_THAT_NO_LONGER_HAVE_BASE = false;
    private static final boolean DEBUG = false;
    public static final Pattern ALT_PROPOSED_PATTERN = PatternCache.get(".*\\[@alt=\"[^\"]*proposed[^\"]*\"].*");
    private static boolean LOG_PROGRESS = false;
    public static boolean HACK_ORDER = false;
    private static boolean DEBUG_LOGGING = false;
    public static final String SUPPLEMENTAL_NAME = "supplementalData";
    public static final String SUPPLEMENTAL_METADATA = "supplementalMetadata";
    public static final String SUPPLEMENTAL_PREFIX = "supplemental";
    public static final String GEN_VERSION = "39";
    public static final List<String> SUPPLEMENTAL_NAMES = Arrays.asList("characters", "coverageLevels", "dayPeriods", "genderList", "grammaticalFeatures", "languageInfo", "languageGroup", "likelySubtags", "metaZones", "numberingSystems", "ordinals", "pluralRanges", "plurals", "postalCodeData", "rgScope", "supplementalData", "supplementalMetadata", "telephoneCodeData", "units", "windowsZones");
    private Set<String> extraPaths = null;
    private boolean locked;
    private DtdType dtdType;
    private DtdData dtdData;
    XMLSource dataSource;
    private File supplementalDirectory;
    private static final boolean DEBUG_CLDR_FILE = false;
    private String creationTime = null;
    private static final Map<String, Object> nullOptions = Collections.unmodifiableMap(new TreeMap());
    static final Splitter LINE_SPLITTER = Splitter.on('\n');
    public static final int MERGE_KEEP_MINE = 0;
    public static final int MERGE_REPLACE_MINE = 1;
    public static final int MERGE_ADD_ALTERNATE = 2;
    public static final int MERGE_REPLACE_MY_DRAFT = 3;
    public static final Pattern specialsToKeep = PatternCache.get("/(measurementSystemName|codePattern|calendar\\[\\@type\\=\"[^\"]*\"\\]/(?!dateTimeFormats/appendItems)|numbers/symbols/(decimal/group)|timeZoneNames/(hourFormat|gmtFormat|regionFormat)|pattern)");
    public static final Pattern specialsToPushFromRoot = PatternCache.get("/(calendar\\[\\@type\\=\"gregorian\"\\]/(?!fields)(?!dateTimeFormats/appendItems)(?!.*\\[@type=\"format\"].*\\[@type=\"narrow\"])(?!.*\\[@type=\"stand-alone\"].*\\[@type=\"(abbreviated|wide)\"])|numbers/symbols/(decimal/group)|timeZoneNames/(hourFormat|gmtFormat|regionFormat))");
    private static final boolean MINIMIZE_ALT_PROPOSED = false;
    private static Object syncObject = new Object();
    public static final int NO_NAME = -1;
    public static final int LANGUAGE_NAME = 0;
    public static final int SCRIPT_NAME = 1;
    public static final int TERRITORY_NAME = 2;
    public static final int VARIANT_NAME = 3;
    public static final int CURRENCY_NAME = 4;
    public static final int CURRENCY_SYMBOL = 5;
    public static final int TZ_EXEMPLAR = 6;
    public static final int TZ_START = 6;
    public static final int TZ_GENERIC_LONG = 7;
    public static final int TZ_GENERIC_SHORT = 8;
    public static final int TZ_STANDARD_LONG = 9;
    public static final int TZ_STANDARD_SHORT = 10;
    public static final int TZ_DAYLIGHT_LONG = 11;
    public static final int TZ_DAYLIGHT_SHORT = 12;
    public static final int TZ_LIMIT = 13;
    public static final int KEY_NAME = 13;
    public static final int KEY_TYPE_NAME = 14;
    public static final int SUBDIVISION_NAME = 15;
    public static final int LIMIT_TYPES = 15;
    private static final String[][] NameTable = new String[][]{{"//ldml/localeDisplayNames/languages/language[@type=\"", "\"]", "language"}, {"//ldml/localeDisplayNames/scripts/script[@type=\"", "\"]", "script"}, {"//ldml/localeDisplayNames/territories/territory[@type=\"", "\"]", "territory"}, {"//ldml/localeDisplayNames/variants/variant[@type=\"", "\"]", "variant"}, {"//ldml/numbers/currencies/currency[@type=\"", "\"]/displayName", "currency"}, {"//ldml/numbers/currencies/currency[@type=\"", "\"]/symbol", "currency-symbol"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/exemplarCity", "exemplar-city"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/long/generic", "tz-generic-long"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/short/generic", "tz-generic-short"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/long/standard", "tz-standard-long"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/short/standard", "tz-standard-short"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/long/daylight", "tz-daylight-long"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/short/daylight", "tz-daylight-short"}, {"//ldml/localeDisplayNames/keys/key[@type=\"", "\"]", "key"}, {"//ldml/localeDisplayNames/types/type[@key=\"", "\"][@type=\"", "\"]", "key|type"}, {"//ldml/localeDisplayNames/subdivisions/subdivision[@type=\"", "\"]", "subdivision"}};
    static final Relation<Row.R2<String, String>, String> bcp47AliasMap = CLDRConfig.getInstance().getSupplementalDataInfo().getBcp47Aliases();
    static final ImmutableMap<String, String> FIX_KEY_NAME;
    static final Pattern CLEAN_DESCRIPTION;
    static final Splitter DESCRIPTION_SEP;
    static final Joiner JOIN_HYPHEN;
    static final Joiner JOIN_UNDERBAR;
    public static final Transform<String, String> SHORT_ALTS;
    private static Comparator<String> ldmlComparator;
    private static final Map<String, Map<String, String>> defaultSuppressionMap;
    static final UnicodeSet HACK_CASE_CLOSURE_SET;
    private static final DistinguishedXPath distinguishedXPath;
    private Matcher typeValueMatcher = PatternCache.get("\\[@type=\"([^\"]*)\"\\]").matcher("");
    private Set<String> excludedZones;

    public String toString() {
        return "{locked=" + this.locked + " locale=" + this.dataSource.getLocaleID() + " dataSource=" + this.dataSource.toString() + "}";
    }

    public String toString(String regex) {
        return "{locked=" + this.locked + " locale=" + this.dataSource.getLocaleID() + " regex=" + regex + " dataSource=" + this.dataSource.toString(regex) + "}";
    }

    public CLDRFile setNonInheriting(boolean isSupplemental) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.setNonInheriting(isSupplemental);
        return this;
    }

    public boolean isNonInheriting() {
        return this.dataSource.isNonInheriting();
    }

    public CLDRFile(XMLSource dataSource) {
        this.dataSource = dataSource;
    }

    public CLDRFile(String localeId, List<File> dirs, DraftStatus minimalDraftStatus) {
        this.dataSource = XMLSource.getFrozenInstance(localeId, dirs, minimalDraftStatus);
        this.dtdType = this.dataSource.getXMLNormalizingDtdType();
        this.dtdData = DtdData.getInstance(this.dtdType);
    }

    public CLDRFile(XMLSource dataSource, XMLSource ... resolvingParents) {
        ArrayList<XMLSource> sourceList = new ArrayList<XMLSource>();
        sourceList.add(dataSource);
        sourceList.addAll(Arrays.asList(resolvingParents));
        this.dataSource = new XMLSource.ResolvingSource(sourceList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLDRFile loadFromFile(File f, String localeName, DraftStatus minimalDraftStatus, XMLSource source) {
        String fullFileName = f.getAbsolutePath();
        try {
            fullFileName = PathUtilities.getNormalizedPathString(f);
            if (DEBUG_LOGGING) {
                System.out.println("Parsing: " + fullFileName);
                Log.logln(LOG_PROGRESS, "Parsing: " + fullFileName);
            }
            try (InputStream fis = InputStreamFactory.createInputStream(f);){
                CLDRFile cldrFile;
                CLDRFile cLDRFile = cldrFile = CLDRFile.load(fullFileName, localeName, fis, minimalDraftStatus, source);
                return cLDRFile;
            }
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("Cannot read the file '");
            sb.append(fullFileName);
            sb.append("': ");
            sb.append(e.getMessage());
            throw new ICUUncheckedIOException(sb.toString(), e);
        }
    }

    public static CLDRFile loadFromFiles(List<File> dirs, String localeName, DraftStatus minimalDraftStatus, XMLSource source) {
        try {
            if (DEBUG_LOGGING) {
                System.out.println("Parsing: " + dirs);
                Log.logln(LOG_PROGRESS, "Parsing: " + dirs);
            }
            CLDRFile cldrFile = new CLDRFile(source);
            for (File dir : dirs) {
                File f = new File(dir, localeName + ".xml");
                InputStream fis = InputStreamFactory.createInputStream(f);
                Throwable throwable = null;
                try {
                    cldrFile.loadFromInputStream(PathUtilities.getNormalizedPathString(f), localeName, fis, minimalDraftStatus);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fis == null) continue;
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fis.close();
                }
            }
            return cldrFile;
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("Cannot read the file '");
            sb.append(dirs);
            throw new ICUUncheckedIOException(sb.toString(), e);
        }
    }

    public static CLDRFile loadFromFile(File f, String localeName, DraftStatus minimalDraftStatus) {
        return CLDRFile.loadFromFile(f, localeName, minimalDraftStatus, new SimpleXMLSource(localeName));
    }

    public static CLDRFile loadFromFiles(List<File> dirs, String localeName, DraftStatus minimalDraftStatus) {
        return CLDRFile.loadFromFiles(dirs, localeName, minimalDraftStatus, new SimpleXMLSource(localeName));
    }

    static CLDRFile load(String fileName, String localeName, InputStream fis, DraftStatus minimalDraftStatus) {
        return CLDRFile.load(fileName, localeName, fis, minimalDraftStatus, new SimpleXMLSource(localeName));
    }

    private static CLDRFile load(String fileName, String localeName, InputStream fis, DraftStatus minimalDraftStatus, XMLSource source) {
        CLDRFile cldrFile = new CLDRFile(source);
        return cldrFile.loadFromInputStream(fileName, localeName, fis, minimalDraftStatus);
    }

    public CLDRFile loadFromInputStream(String fileName, String localeName, InputStream fis, DraftStatus minimalDraftStatus) {
        CLDRFile cldrFile = this;
        MyDeclHandler DEFAULT_DECLHANDLER = new MyDeclHandler(cldrFile, minimalDraftStatus);
        XMLFileReader.read(fileName, fis, -1, true, (XMLFileReader.AllHandler)DEFAULT_DECLHANDLER);
        if (DEFAULT_DECLHANDLER.isSupplemental < 0) {
            throw new IllegalArgumentException("root of file must be either ldml or supplementalData");
        }
        cldrFile.setNonInheriting(DEFAULT_DECLHANDLER.isSupplemental > 0);
        if (DEFAULT_DECLHANDLER.overrideCount > 0) {
            throw new IllegalArgumentException("Internal problems: either data file has duplicate path, or CLDRFile.isDistinguishing() or CLDRFile.isOrdered() need updating: " + DEFAULT_DECLHANDLER.overrideCount + "; The exact problems are printed on the console above.");
        }
        if (localeName == null) {
            cldrFile.dataSource.setLocaleID(cldrFile.getLocaleIDFromIdentity());
        }
        return cldrFile;
    }

    @Override
    public CLDRFile cloneAsThawed() {
        try {
            CLDRFile result = (CLDRFile)super.clone();
            result.locked = false;
            result.dataSource = result.dataSource.cloneAsThawed();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("should never happen");
        }
    }

    public CLDRFile show() {
        for (String xpath : this) {
            System.out.println(this.getFullXPath(xpath) + " =>\t" + this.getStringValue(xpath));
        }
        return this;
    }

    public void write(PrintWriter pw) {
        this.write(pw, nullOptions);
    }

    public boolean write(PrintWriter pw, Map<String, ?> options) {
        TreeSet<String> orderedSet = new TreeSet<String>(this.getComparator());
        this.dataSource.forEach(orderedSet::add);
        String firstPath = null;
        String firstFullPath = null;
        XPathParts firstFullPathParts = null;
        DtdType dtdType = DtdType.ldml;
        boolean suppressInheritanceMarkers = false;
        if (orderedSet.size() > 0) {
            firstPath = (String)orderedSet.iterator().next();
            firstFullPath = this.getFullXPath(firstPath);
            firstFullPathParts = XPathParts.getFrozenInstance(firstFullPath);
            dtdType = DtdType.valueOf(firstFullPathParts.getElement(0));
        }
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        if (!options.containsKey("DTD_OMIT")) {
            String fixedPath = "../../" + dtdType.dtdPath;
            if (options.containsKey("DTD_DIR")) {
                String dtdDir = options.get("DTD_DIR").toString();
                fixedPath = dtdDir + (Object)((Object)dtdType) + ".dtd";
            }
            pw.println("<!DOCTYPE " + (Object)((Object)dtdType) + " SYSTEM \"" + fixedPath + "\">");
        }
        if (options.containsKey("COMMENT")) {
            pw.println("<!-- " + options.get("COMMENT") + " -->");
        }
        if (options.containsKey("SUPPRESS_IM")) {
            suppressInheritanceMarkers = true;
        }
        TreeSet<String> identitySet = new TreeSet<String>(this.getComparator());
        if (!this.isNonInheriting()) {
            String ldml_identity = "//ldml/identity";
            if (firstFullPath != null) {
                ldml_identity = firstFullPath.indexOf("/identity") >= 0 ? firstFullPathParts.toString(2) : firstFullPathParts.toString(1) + "/identity";
            }
            identitySet.add(ldml_identity + "/version[@number=\"$Revision$\"]");
            LocaleIDParser lip = new LocaleIDParser();
            lip.set(this.dataSource.getLocaleID());
            identitySet.add(ldml_identity + "/language[@type=\"" + lip.getLanguage() + "\"]");
            if (lip.getScript().length() != 0) {
                identitySet.add(ldml_identity + "/script[@type=\"" + lip.getScript() + "\"]");
            }
            if (lip.getRegion().length() != 0) {
                identitySet.add(ldml_identity + "/territory[@type=\"" + lip.getRegion() + "\"]");
            }
            String[] variants = lip.getVariants();
            for (int i = 0; i < variants.length; ++i) {
                identitySet.add(ldml_identity + "/variant[@type=\"" + variants[i] + "\"]");
            }
        }
        String initialComment = this.fixInitialComment(this.dataSource.getXpathComments().getInitialComment());
        XPathParts.writeComment(pw, 0, initialComment, true);
        XPathParts.Comments tempComments = (XPathParts.Comments)this.dataSource.getXpathComments().clone();
        XPathParts last = null;
        boolean isResolved = this.dataSource.isResolving();
        Predicate skipTest = (Predicate)options.get("SKIP_PATH");
        for (String xpath : identitySet) {
            if (isResolved && xpath.contains("/alias")) continue;
            XPathParts current = XPathParts.getFrozenInstance(xpath).cloneAsThawed();
            current.writeDifference(pw, current, last, "", tempComments);
            last = current;
        }
        for (String xpath : orderedSet) {
            XPathParts currentFiltered;
            if (skipTest != null && skipTest.test(xpath) || isResolved && xpath.contains("/alias")) continue;
            String v = this.getStringValue(xpath);
            if (suppressInheritanceMarkers && CldrUtility.INHERITANCE_MARKER.equals(v) || (currentFiltered = XPathParts.getFrozenInstance(xpath).cloneAsThawed()).size() >= 2 && currentFiltered.getElement(1).equals("identity")) continue;
            XPathParts current = XPathParts.getFrozenInstance(this.getFullXPath(xpath)).cloneAsThawed();
            current.writeDifference(pw, currentFiltered, last, v, tempComments);
            last = current;
        }
        last.writeLast(pw);
        String finalComment = this.dataSource.getXpathComments().getFinalComment();
        XPathParts.writeComment(pw, 0, finalComment, true);
        return true;
    }

    private String fixInitialComment(String initialComment) {
        if (initialComment == null || initialComment.isEmpty()) {
            return CldrUtility.getCopyrightString();
        }
        StringBuilder sb = new StringBuilder(CldrUtility.getCopyrightString()).append("\n");
        for (String line : LINE_SPLITTER.split(initialComment)) {
            if (line.contains("Copyright") || line.contains("\u00a9") || line.contains("trademark") || line.startsWith("CLDR data files are interpreted") || line.startsWith("For terms of use")) continue;
            sb.append("\n").append(line);
        }
        return sb.toString();
    }

    @Override
    public String getStringValue(String xpath) {
        try {
            String fallbackPath;
            String result = this.dataSource.getValueAtPath(xpath);
            if (result == null && this.dataSource.isResolving() && (fallbackPath = this.getFallbackPath(xpath, false, true)) != null) {
                result = this.dataSource.getValueAtPath(fallbackPath);
            }
            return result;
        }
        catch (Exception e) {
            throw new UncheckedExecutionException("Bad path: " + xpath, e);
        }
    }

    public String getBaileyValue(String xpath, Output<String> pathWhereFound, Output<String> localeWhereFound) {
        String result = this.dataSource.getBaileyValue(xpath, pathWhereFound, localeWhereFound);
        if ((result == null || result.equals(CldrUtility.INHERITANCE_MARKER)) && this.dataSource.isResolving()) {
            String fallbackPath = this.getFallbackPath(xpath, false, false);
            if (xpath.equals(fallbackPath)) {
                this.getFallbackPath(xpath, false, true);
                throw new IllegalArgumentException();
            }
            if (fallbackPath != null && (result = this.dataSource.getValueAtPath(fallbackPath)) != null) {
                Status status = new Status();
                if (localeWhereFound != null) {
                    localeWhereFound.value = this.dataSource.getSourceLocaleID(fallbackPath, status);
                }
                if (pathWhereFound != null) {
                    pathWhereFound.value = status.pathWhereFound;
                }
            }
        }
        return result;
    }

    public String getConstructedBaileyValue(String xpath, Output<String> pathWhereFound, Output<String> localeWhereFound) {
        String constructedValue = this.getConstructedValue(xpath);
        if (constructedValue != null) {
            if (localeWhereFound != null) {
                localeWhereFound.value = this.getLocaleID();
            }
            if (pathWhereFound != null) {
                pathWhereFound.value = null;
            }
            return constructedValue;
        }
        return this.getBaileyValue(xpath, pathWhereFound, localeWhereFound);
    }

    private String getFallbackPath(String xpath, boolean winning, boolean checkExtraPaths) {
        if (GrammarInfo.GrammaticalFeature.pathHasFeature(xpath) != null) {
            return this.getCountPathWithFallback(xpath, SupplementalDataInfo.PluralInfo.Count.other, winning);
        }
        if (checkExtraPaths && this.getRawExtraPaths().contains(xpath)) {
            return xpath;
        }
        return null;
    }

    public String getFullXPath(String xpath) {
        if (xpath == null) {
            throw new NullPointerException("Null distinguishing xpath");
        }
        String result = this.dataSource.getFullPath(xpath);
        return result != null ? result : xpath;
    }

    public Date getLastModifiedDate(String xpath) {
        return this.dataSource.getChangeDateAtDPath(xpath);
    }

    @Override
    public String getSourceLocaleID(String distinguishedXPath, Status status) {
        return this.getSourceLocaleIdExtended(distinguishedXPath, status, true);
    }

    public String getSourceLocaleIdExtended(String distinguishedXPath, Status status, boolean skipInheritanceMarker) {
        String fallbackPath;
        String result = this.dataSource.getSourceLocaleIdExtended(distinguishedXPath, status, skipInheritanceMarker);
        if (result == "code-fallback" && this.dataSource.isResolving() && (fallbackPath = this.getFallbackPath(distinguishedXPath, false, true)) != null && !fallbackPath.equals(distinguishedXPath)) {
            result = this.dataSource.getSourceLocaleIdExtended(fallbackPath, status, skipInheritanceMarker);
        }
        return result;
    }

    public boolean isHere(String path) {
        return this.dataSource.isHere(path);
    }

    public CLDRFile add(String currentFullXPath, String value) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        Log.logln(LOG_PROGRESS, "ADDING: \t" + currentFullXPath + " \t" + value + "\t" + currentFullXPath);
        try {
            this.dataSource.putValueAtPath(currentFullXPath, value);
        }
        catch (RuntimeException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("failed adding " + currentFullXPath + ",\t" + value).initCause(e);
        }
        return this;
    }

    public CLDRFile addComment(String xpath, String comment, XPathParts.Comments.CommentType type) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        Log.logln(LOG_PROGRESS, "ADDING Comment: \t" + (Object)((Object)type) + "\t" + xpath + " \t" + comment);
        if (xpath == null || xpath.length() == 0) {
            this.dataSource.getXpathComments().setFinalComment(CldrUtility.joinWithSeparation(this.dataSource.getXpathComments().getFinalComment(), "\n", comment));
        } else {
            xpath = CLDRFile.getDistinguishingXPath(xpath, null);
            this.dataSource.getXpathComments().addComment(type, xpath, comment);
        }
        return this;
    }

    public CLDRFile putAll(CLDRFile other, int conflict_resolution) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        if (conflict_resolution == 0) {
            this.dataSource.putAll(other.dataSource, 0);
        } else if (conflict_resolution == 1) {
            this.dataSource.putAll(other.dataSource, 1);
        } else if (conflict_resolution == 3) {
            HashSet<String> hasDraftVersion = new HashSet<String>();
            for (String cpath : this.dataSource) {
                String fullpath = this.getFullXPath(cpath);
                if (fullpath.indexOf("[@draft") < 0) continue;
                hasDraftVersion.add(CLDRFile.getNondraftNonaltXPath(cpath));
            }
            for (String cpath : other) {
                cpath = CLDRFile.getNondraftNonaltXPath(cpath);
                String newValue = other.getStringValue(cpath);
                String newFullPath = CLDRFile.getNondraftNonaltXPath(other.getFullXPath(cpath));
                newFullPath = this.addReferencesIfNeeded(newFullPath, this.getFullXPath(cpath));
                if (!hasDraftVersion.contains(cpath)) {
                    if (cpath.startsWith("//ldml/identity/")) continue;
                    String myVersion = this.getStringValue(cpath);
                    if (myVersion == null || !newValue.equals(myVersion)) {
                        Log.logln(this.getLocaleID() + "\tDenied attempt to replace non-draft" + "\n" + "\tcurr: [" + cpath + ",\t" + myVersion + "]" + "\n" + "\twith: [" + newValue + "]");
                        continue;
                    }
                }
                Log.logln(this.getLocaleID() + "\tVETTED: [" + newFullPath + ",\t" + newValue + "]");
                this.dataSource.putValueAtPath(newFullPath, newValue);
            }
        } else if (conflict_resolution == 2) {
            block2: for (String key : other) {
                String otherValue = other.getStringValue(key);
                String myValue = this.dataSource.getValueAtPath(key);
                if (myValue == null) {
                    this.dataSource.putValueAtPath(other.getFullXPath(key), otherValue);
                    continue;
                }
                if (myValue.equals(otherValue) && CLDRFile.equalsIgnoringDraft(this.getFullXPath(key), other.getFullXPath(key)) || key.startsWith("//ldml/identity")) continue;
                int i = 0;
                while (true) {
                    String prop = "proposed" + (i == 0 ? "" : String.valueOf(i));
                    XPathParts parts = XPathParts.getFrozenInstance(other.getFullXPath(key)).cloneAsThawed();
                    String fullPath = parts.addAttribute("alt", prop).toString();
                    String path = CLDRFile.getDistinguishingXPath(fullPath, null);
                    if (this.dataSource.getValueAtPath(path) == null) {
                        this.dataSource.putValueAtPath(fullPath, otherValue);
                        continue block2;
                    }
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Illegal operand: " + conflict_resolution);
        }
        this.dataSource.getXpathComments().setInitialComment(CldrUtility.joinWithSeparation(this.dataSource.getXpathComments().getInitialComment(), "\n", other.dataSource.getXpathComments().getInitialComment()));
        this.dataSource.getXpathComments().setFinalComment(CldrUtility.joinWithSeparation(this.dataSource.getXpathComments().getFinalComment(), "\n", other.dataSource.getXpathComments().getFinalComment()));
        this.dataSource.getXpathComments().joinAll(other.dataSource.getXpathComments());
        return this;
    }

    private String addReferencesIfNeeded(String newFullPath, String fullXPath) {
        String references;
        Map<String, String> attributes;
        if (fullXPath == null || fullXPath.indexOf("[@references=") < 0) {
            return newFullPath;
        }
        XPathParts parts = XPathParts.getFrozenInstance(fullXPath);
        String accummulatedReferences = null;
        for (int i = 0; i < parts.size(); ++i) {
            attributes = parts.getAttributes(i);
            references = attributes.get("references");
            if (references == null) continue;
            accummulatedReferences = accummulatedReferences == null ? references : accummulatedReferences + ", " + references;
        }
        if (accummulatedReferences == null) {
            return newFullPath;
        }
        XPathParts newParts = XPathParts.getFrozenInstance(newFullPath);
        attributes = newParts.getAttributes(newParts.size() - 1);
        references = attributes.get("references");
        references = references == null ? accummulatedReferences : references + ", " + accummulatedReferences;
        attributes.put("references", references);
        System.out.println("Changing " + newFullPath + " plus " + fullXPath + " to " + newParts.toString());
        return newParts.toString();
    }

    public CLDRFile remove(String xpath) {
        this.remove(xpath, false);
        return this;
    }

    public CLDRFile remove(String xpath, boolean butComment) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        if (butComment) {
            this.appendFinalComment(this.dataSource.getFullPath(xpath) + "::<" + this.dataSource.getValueAtPath(xpath) + ">");
        }
        this.dataSource.removeValueAtPath(xpath);
        return this;
    }

    public CLDRFile removeAll(Set<String> xpaths, boolean butComment) {
        if (butComment) {
            this.appendFinalComment("Illegal attributes removed:");
        }
        Iterator<String> it = xpaths.iterator();
        while (it.hasNext()) {
            this.remove(it.next(), butComment);
        }
        return this;
    }

    public CLDRFile removeDuplicates(CLDRFile other, boolean butComment, RetentionTest keepIfMatches, Collection<String> removedItems) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        boolean first = true;
        if (removedItems == null) {
            removedItems = new ArrayList<String>();
        } else {
            removedItems.clear();
        }
        HashSet<String> checked = new HashSet<String>();
        for (String curXpath : this) {
            boolean logicDuplicate = true;
            if (checked.contains(curXpath)) continue;
            Set<String> logicGroups = LogicalGrouping.getPaths(this, curXpath);
            if (logicGroups != null) {
                Iterator<String> iter = logicGroups.iterator();
                while (iter.hasNext() && logicDuplicate) {
                    String xpath = iter.next();
                    switch (keepIfMatches.getRetention(xpath)) {
                        case RETAIN: {
                            logicDuplicate = false;
                            break;
                        }
                        case RETAIN_IF_DIFFERENT: {
                            String otherFullXPath;
                            String currentValue = this.dataSource.getValueAtPath(xpath);
                            if (currentValue == null) {
                                logicDuplicate = false;
                                break;
                            }
                            String otherXpath = xpath;
                            String otherValue = other.dataSource.getValueAtPath(otherXpath);
                            if (!currentValue.equals(otherValue)) {
                                logicDuplicate = false;
                                break;
                            }
                            String keepValue = XMLSource.getPathsAllowingDuplicates().get(xpath);
                            if (keepValue != null && keepValue.equals(currentValue)) {
                                logicDuplicate = false;
                                break;
                            }
                            String currentFullXPath = this.dataSource.getFullPath(xpath);
                            if (CLDRFile.equalsIgnoringDraft(currentFullXPath, otherFullXPath = other.dataSource.getFullPath(otherXpath))) break;
                            logicDuplicate = false;
                            break;
                        }
                    }
                }
                if (first) {
                    first = false;
                    if (butComment) {
                        this.appendFinalComment("Duplicates removed:");
                    }
                }
            }
            checked.addAll(logicGroups);
            if (!logicDuplicate) continue;
            removedItems.addAll(logicGroups);
        }
        for (String xpath : removedItems) {
            this.remove(xpath, butComment);
        }
        return this;
    }

    public String getFinalComment() {
        return this.dataSource.getXpathComments().getFinalComment();
    }

    public String getInitialComment() {
        return this.dataSource.getXpathComments().getInitialComment();
    }

    public XPathParts.Comments getXpath_comments() {
        return (XPathParts.Comments)this.dataSource.getXpathComments().clone();
    }

    @Override
    public String getLocaleID() {
        return this.dataSource.getLocaleID();
    }

    public String getLocaleIDFromIdentity() {
        ULocale.Builder lb = new ULocale.Builder();
        Iterator<String> i = this.iterator("//ldml/identity/");
        while (i.hasNext()) {
            XPathParts xpp = XPathParts.getFrozenInstance(i.next());
            String k = xpp.getElement(-1);
            String v = xpp.getAttributeValue(-1, "type");
            if (k.equals("language")) {
                lb = lb.setLanguage(v);
                continue;
            }
            if (k.equals("script")) {
                lb = lb.setScript(v);
                continue;
            }
            if (k.equals("territory")) {
                lb = lb.setRegion(v);
                continue;
            }
            if (!k.equals("variant")) continue;
            lb = lb.setVariant(v);
        }
        return lb.build().toString();
    }

    @Override
    public synchronized boolean isFrozen() {
        return this.locked;
    }

    @Override
    public synchronized CLDRFile freeze() {
        this.locked = true;
        this.dataSource.freeze();
        return this;
    }

    public CLDRFile clearComments() {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.setXpathComments(new XPathParts.Comments());
        return this;
    }

    public CLDRFile setFinalComment(String comment) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.getXpathComments().setFinalComment(comment);
        return this;
    }

    public CLDRFile appendFinalComment(String comment) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.getXpathComments().setFinalComment(CldrUtility.joinWithSeparation(this.dataSource.getXpathComments().getFinalComment(), "\n", comment));
        return this;
    }

    public CLDRFile setInitialComment(String comment) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.getXpathComments().setInitialComment(comment);
        return this;
    }

    public static Set<String> getMatchingXMLFiles(File[] sourceDirs, Matcher m3) {
        TreeSet<String> s2 = new TreeSet<String>();
        for (File dir : sourceDirs) {
            if (!dir.exists()) {
                throw new IllegalArgumentException("Directory doesn't exist:\t" + dir.getPath());
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("Input isn't a file directory:\t" + dir.getPath());
            }
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String locale;
                String name = files[i].getName();
                if (!name.endsWith(".xml") || name.startsWith(".") || !m3.reset(locale = name.substring(0, name.length() - 4)).matches()) continue;
                s2.add(locale);
            }
        }
        return s2;
    }

    @Override
    public Iterator<String> iterator() {
        return this.dataSource.iterator();
    }

    public synchronized Iterator<String> iterator(String prefix) {
        return this.dataSource.iterator(prefix);
    }

    public Iterator<String> iterator(Matcher pathFilter) {
        return this.dataSource.iterator(pathFilter);
    }

    public Iterator<String> iterator(String prefix, Comparator<String> comparator) {
        Iterator<String> it;
        Iterator<String> iterator = it = prefix == null || prefix.length() == 0 ? this.dataSource.iterator() : this.dataSource.iterator(prefix);
        if (comparator == null) {
            return it;
        }
        TreeSet<String> orderedSet = new TreeSet<String>(comparator);
        it.forEachRemaining(orderedSet::add);
        return orderedSet.iterator();
    }

    public Iterable<String> fullIterable() {
        return new FullIterable(this);
    }

    public static String getDistinguishingXPath(String xpath, String[] normalizedPath) {
        return DistinguishedXPath.getDistinguishingXPath(xpath, normalizedPath);
    }

    private static boolean equalsIgnoringDraft(String path1, String path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        if (path1.indexOf("[@draft=") < 0 && path2.indexOf("[@draft=") < 0) {
            return path1.equals(path2);
        }
        return CLDRFile.getNondraftNonaltXPath(path1).equals(CLDRFile.getNondraftNonaltXPath(path2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNondraftNonaltXPath(String xpath) {
        if (xpath.indexOf("draft=\"") < 0 && xpath.indexOf("alt=\"") < 0) {
            return xpath;
        }
        Object object = syncObject;
        synchronized (object) {
            XPathParts parts = XPathParts.getFrozenInstance(xpath).cloneAsThawed();
            HashSet<String> toRemove = new HashSet<String>();
            for (int i = 0; i < parts.size(); ++i) {
                if (parts.getAttributeCount(i) == 0) continue;
                Map<String, String> attributes = parts.getAttributes(i);
                toRemove.clear();
                String restore = null;
                for (String attribute : attributes.keySet()) {
                    String value;
                    int proposedPos;
                    if (attribute.equals("draft")) {
                        toRemove.add(attribute);
                        continue;
                    }
                    if (!attribute.equals("alt") || (proposedPos = (value = attributes.get(attribute)).indexOf("proposed")) < 0) continue;
                    toRemove.add(attribute);
                    if (proposedPos <= 0) continue;
                    restore = value.substring(0, proposedPos - 1);
                }
                parts.removeAttributes(i, toRemove);
                if (restore == null) continue;
                attributes.put("alt", restore);
            }
            return parts.toString();
        }
    }

    public static boolean isDistinguishing(DtdType type, String elementName, String attribute) {
        return DtdData.getInstance(type).isDistinguishing(elementName, attribute);
    }

    public static XMLReader createXMLReader(boolean validating) {
        String[] testList = new String[]{"org.apache.xerces.parsers.SAXParser", "org.apache.crimson.parser.XMLReaderImpl", "gnu.xml.aelfred2.XmlReader", "com.bluecast.xml.Piccolo", "oracle.xml.parser.v2.SAXParser", ""};
        XMLReader result = null;
        for (int i = 0; i < testList.length; ++i) {
            try {
                result = testList[i].length() != 0 ? XMLReaderFactory.createXMLReader(testList[i]) : XMLReaderFactory.createXMLReader();
                result.setFeature("http://xml.org/sax/features/validation", validating);
                break;
            }
            catch (SAXException sAXException) {
                continue;
            }
        }
        if (result == null) {
            throw new NoClassDefFoundError("No SAX parser is available, or unable to set validation correctly");
        }
        return result;
    }

    public File getSupplementalDirectory() {
        if (this.supplementalDirectory == null) {
            this.supplementalDirectory = CLDRConfig.getInstance().getSupplementalDataInfo().getDirectory();
        }
        return this.supplementalDirectory;
    }

    public CLDRFile setSupplementalDirectory(File supplementalDirectory) {
        this.supplementalDirectory = supplementalDirectory;
        return this;
    }

    public File[] getSupplementalXMLFiles() {
        return this.getSupplementalDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
    }

    public File getSupplementalFile(String filename) {
        return new File(this.getSupplementalDirectory(), filename);
    }

    public static boolean isSupplementalName(String localeName) {
        return SUPPLEMENTAL_NAMES.contains(localeName);
    }

    public static String showSAX(SAXParseException exception) {
        return exception.getMessage() + ";\t SystemID: " + exception.getSystemId() + ";\t PublicID: " + exception.getPublicId() + ";\t LineNumber: " + exception.getLineNumber() + ";\t ColumnNumber: " + exception.getColumnNumber();
    }

    public boolean isDraft() {
        String item = this.iterator().next();
        return item.startsWith("//ldml[@draft=\"unconfirmed\"]");
    }

    public static int getNameType(String xpath) {
        for (int i = 0; i < NameTable.length; ++i) {
            if (!xpath.startsWith(NameTable[i][0]) || xpath.indexOf(NameTable[i][1], NameTable[i][0].length()) < 0) continue;
            return i;
        }
        return -1;
    }

    public static String getNameTypeName(int index) {
        try {
            return CLDRFile.getNameName(index);
        }
        catch (Exception e) {
            return "Illegal Type Name: " + index;
        }
    }

    public Iterator<String> getAvailableIterator(int type) {
        return this.iterator(NameTable[type][0]);
    }

    public static String getKey(int type, String code) {
        switch (type) {
            case 3: {
                code = code.toUpperCase(Locale.ROOT);
                break;
            }
            case 13: {
                code = CLDRFile.fixKeyName(code);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                code = CLDRFile.getLongTzid(code);
            }
        }
        String[] nameTableRow = NameTable[type];
        if (code.contains("|")) {
            String[] codes = code.split("\\|");
            return nameTableRow[0] + CLDRFile.fixKeyName(codes[0]) + nameTableRow[1] + codes[1] + nameTableRow[2];
        }
        return nameTableRow[0] + code + nameTableRow[1];
    }

    public static String getLongTzid(String code) {
        Set<String> codes;
        if (!code.contains("/") && (codes = bcp47AliasMap.get(Row.of("tz", code))) != null && !codes.isEmpty()) {
            code = codes.iterator().next();
        }
        return code;
    }

    private static String fixKeyName(String code) {
        String result = FIX_KEY_NAME.get(code);
        return result == null ? code : result;
    }

    public static String getCode(String path) {
        int type = CLDRFile.getNameType(path);
        if (type < 0) {
            throw new IllegalArgumentException("Illegal type in path: " + path);
        }
        String[] nameTableRow = NameTable[type];
        int start = nameTableRow[0].length();
        int end = path.indexOf(nameTableRow[1], start);
        return path.substring(start, end);
    }

    public String getName(int type, String code) {
        return this.getName(type, code, null);
    }

    public String getName(int type, String code, Transform<String, String> codeToAlt) {
        String alt;
        String path = CLDRFile.getKey(type, code);
        String result = null;
        if (codeToAlt != null && (alt = codeToAlt.transform(code)) != null) {
            result = this.getStringValueWithBailey(path + "[@alt=\"" + alt + "\"]");
        }
        if (result == null) {
            result = this.getStringValueWithBailey(path);
        }
        if (this.getLocaleID().equals("en")) {
            Status status = new Status();
            String sourceLocale = this.getSourceLocaleID(path, status);
            if (result == null || !sourceLocale.equals("en")) {
                if (type == 0) {
                    Set<String> set = Iso639Data.getNames(code);
                    if (set != null) {
                        return set.iterator().next();
                    }
                    Map<String, Map<String, String>> map = StandardCodes.getLStreg().get("language");
                    Map<String, String> info = map.get(code);
                    if (info != null) {
                        result = info.get("Description");
                    }
                } else if (type == 2) {
                    result = this.getLstrFallback("region", code);
                } else if (type == 1) {
                    result = this.getLstrFallback("script", code);
                }
            }
        }
        return result;
    }

    private String getLstrFallback(String codeType, String code) {
        String temp;
        Map<String, String> info = StandardCodes.getLStreg().get(codeType).get(code);
        if (info != null && !(temp = info.get("Description")).equalsIgnoreCase("Private use")) {
            List<String> temp2 = DESCRIPTION_SEP.splitToList(temp);
            Matcher matcher = CLEAN_DESCRIPTION.matcher(temp = temp2.get(0));
            if (matcher.lookingAt()) {
                return matcher.group(1).trim();
            }
            return temp;
        }
        return null;
    }

    public String getName(String type, String code) {
        return this.getName(CLDRFile.typeNameToCode(type), code);
    }

    public static int typeNameToCode(String type) {
        if (type.equalsIgnoreCase("region")) {
            type = "territory";
        }
        for (int i = 0; i < 15; ++i) {
            if (!type.equalsIgnoreCase(CLDRFile.getNameName(i))) continue;
            return i;
        }
        return -1;
    }

    public synchronized String getName(String localeOrTZID) {
        return this.getName(localeOrTZID, false);
    }

    public synchronized String getName(String localeOrTZID, boolean onlyConstructCompound, String localeKeyTypePattern, String localePattern, String localeSeparator) {
        return this.getName(localeOrTZID, onlyConstructCompound, localeKeyTypePattern, localePattern, localeSeparator, null);
    }

    public synchronized String getName(String localeOrTZID, boolean onlyConstructCompound, String localeKeyTypePattern, String localePattern, String localeSeparator, Transform<String, String> altPicker) {
        boolean isCompound;
        String name;
        if (localePattern == null) {
            localePattern = "{0} ({1})";
        }
        String string = name = (isCompound = localeOrTZID.contains("_")) && onlyConstructCompound ? null : this.getName(0, localeOrTZID, altPicker);
        if (name != null && !name.contains("_") && !name.contains("-")) {
            name = name.replace('(', '[').replace(')', ']').replace('\uff08', '\uff3b').replace('\uff09', '\uff3d');
            return name;
        }
        LanguageTagParser lparser = new LanguageTagParser().set(localeOrTZID);
        return this.getName(lparser, onlyConstructCompound, altPicker, localeKeyTypePattern, localePattern, localeSeparator);
    }

    public String getName(LanguageTagParser lparser, boolean onlyConstructCompound, Transform<String, String> altPicker, String localeKeyTypePattern, String localePattern, String localeSeparator) {
        String name;
        String original;
        boolean haveScript = false;
        boolean haveRegion = false;
        if (onlyConstructCompound) {
            original = lparser.getLanguage();
            name = this.getName(0, original, altPicker);
            if (name == null) {
                name = original;
            }
        } else {
            name = this.getName(0, lparser.toString(LanguageTagParser.LANGUAGE_SCRIPT_REGION), altPicker);
            if (name != null) {
                haveRegion = true;
                haveScript = true;
            } else {
                name = this.getName(0, lparser.toString(LanguageTagParser.LANGUAGE_SCRIPT), altPicker);
                if (name != null) {
                    haveScript = true;
                } else {
                    name = this.getName(0, lparser.toString(LanguageTagParser.LANGUAGE_REGION), altPicker);
                    if (name != null) {
                        haveRegion = true;
                    } else {
                        original = lparser.getLanguage();
                        name = this.getName(0, original, altPicker);
                        if (name == null) {
                            name = original;
                        }
                    }
                }
            }
        }
        name = name.replace('(', '[').replace(')', ']').replace('\uff08', '\uff3b').replace('\uff09', '\uff3d');
        String extras = "";
        if (!haveScript) {
            extras = this.addDisplayName(lparser.getScript(), 1, localeSeparator, extras, altPicker);
        }
        if (!haveRegion) {
            extras = this.addDisplayName(lparser.getRegion(), 2, localeSeparator, extras, altPicker);
        }
        List<String> variants = lparser.getVariants();
        for (String string : variants) {
            extras = this.addDisplayName(string, 3, localeSeparator, extras, altPicker);
        }
        block18: for (Map.Entry entry : lparser.getLocaleExtensionsDetailed().entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("h0")) continue;
            List keyValue = (List)entry.getValue();
            String oldFormatType = (key.equals("ca") ? JOIN_HYPHEN : JOIN_UNDERBAR).join(keyValue);
            String value = this.getKeyValueName(key, oldFormatType);
            if (value != null) {
                value = value.replace('(', '[').replace(')', ']').replace('\uff08', '\uff3b').replace('\uff09', '\uff3d');
            } else {
                String kname = this.getKeyName(key);
                if (kname == null) {
                    kname = key;
                }
                switch (key) {
                    case "t": {
                        List<String> hybrid = lparser.getLocaleExtensionsDetailed().get("h0");
                        if (hybrid != null) {
                            kname = this.getKeyValueName("h0", JOIN_UNDERBAR.join(hybrid));
                        }
                        oldFormatType = this.getName(oldFormatType);
                        break;
                    }
                    case "h0": {
                        continue block18;
                    }
                    case "cu": {
                        oldFormatType = this.getName(5, oldFormatType.toUpperCase(Locale.ROOT));
                        break;
                    }
                    case "tz": {
                        oldFormatType = this.getTZName(oldFormatType, "VVVV");
                        break;
                    }
                    case "kr": {
                        oldFormatType = this.getReorderName(localeSeparator, keyValue);
                        break;
                    }
                    case "rg": 
                    case "sd": {
                        oldFormatType = this.getName(15, oldFormatType);
                        break;
                    }
                    default: {
                        oldFormatType = JOIN_HYPHEN.join(keyValue);
                    }
                }
                value = MessageFormat.format(localeKeyTypePattern, kname, oldFormatType);
                value = value.replace('(', '[').replace(')', ']').replace('\uff08', '\uff3b').replace('\uff09', '\uff3d');
            }
            extras = extras.isEmpty() ? value : MessageFormat.format(localeSeparator, extras, value);
        }
        for (Map.Entry entry : lparser.getExtensionsDetailed().entrySet()) {
            String value = MessageFormat.format(localeKeyTypePattern, entry.getKey(), JOIN_HYPHEN.join((Iterable)entry.getValue()));
            extras = extras.isEmpty() ? value : MessageFormat.format(localeSeparator, extras, value);
        }
        if (extras.length() == 0) {
            return name;
        }
        return MessageFormat.format(localePattern, name, extras);
    }

    private String getTZName(String tzcode, String format) {
        String longid = CLDRFile.getLongTzid(tzcode);
        TimezoneFormatter tzf = new TimezoneFormatter(this);
        return tzf.getFormattedZone(longid, format, 0L);
    }

    private String getReorderName(String localeSeparator, List<String> keyValues) {
        String result = null;
        for (String value : keyValues) {
            String name = this.getName(1, Character.toUpperCase(value.charAt(0)) + value.substring(1));
            if (name == null && (name = this.getKeyValueName("kr", value)) == null) {
                name = value;
            }
            result = result == null ? name : MessageFormat.format(localeSeparator, result, name);
        }
        return result;
    }

    public String getName(LanguageTagParser lparser, boolean onlyConstructCompound, Transform<String, String> altPicker) {
        return this.getName(lparser, onlyConstructCompound, altPicker, this.getWinningValueWithBailey("//ldml/localeDisplayNames/localeDisplayPattern/localeKeyTypePattern"), this.getWinningValueWithBailey("//ldml/localeDisplayNames/localeDisplayPattern/localePattern"), this.getWinningValueWithBailey("//ldml/localeDisplayNames/localeDisplayPattern/localeSeparator"));
    }

    public String getKeyName(String key) {
        Relation<Row.R2<String, String>, String> toAliases;
        Set<String> aliases;
        String result = this.getStringValue("//ldml/localeDisplayNames/keys/key[@type=\"" + key + "\"]");
        if (result == null && (aliases = (toAliases = SupplementalDataInfo.getInstance().getBcp47Aliases()).get(Row.of(key, ""))) != null) {
            for (String alias : aliases) {
                result = this.getStringValue("//ldml/localeDisplayNames/keys/key[@type=\"" + alias + "\"]");
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    public String getKeyValueName(String key, String value) {
        String result = this.getStringValue("//ldml/localeDisplayNames/types/type[@key=\"" + key + "\"][@type=\"" + value + "\"]");
        if (result == null) {
            Relation<Row.R2<String, String>, String> toAliases = SupplementalDataInfo.getInstance().getBcp47Aliases();
            Set<String> keyAliases = toAliases.get(Row.of(key, ""));
            Set<String> valueAliases = toAliases.get(Row.of(key, value));
            if (keyAliases != null || valueAliases != null) {
                if (keyAliases == null) {
                    keyAliases = Collections.singleton(key);
                }
                if (valueAliases == null) {
                    valueAliases = Collections.singleton(value);
                }
                block0: for (String keyAlias : keyAliases) {
                    for (String valueAlias : valueAliases) {
                        result = this.getStringValue("//ldml/localeDisplayNames/types/type[@key=\"" + keyAlias + "\"][@type=\"" + valueAlias + "\"]");
                        if (result == null) continue;
                        continue block0;
                    }
                }
            }
        }
        return result;
    }

    public synchronized String getName(String localeOrTZID, boolean onlyConstructCompound) {
        return this.getName(localeOrTZID, onlyConstructCompound, null);
    }

    public synchronized String getName(String localeOrTZID, boolean onlyConstructCompound, Transform<String, String> altPicker) {
        return this.getName(localeOrTZID, onlyConstructCompound, this.getWinningValueWithBailey("//ldml/localeDisplayNames/localeDisplayPattern/localeKeyTypePattern"), this.getWinningValueWithBailey("//ldml/localeDisplayNames/localeDisplayPattern/localePattern"), this.getWinningValueWithBailey("//ldml/localeDisplayNames/localeDisplayPattern/localeSeparator"), altPicker);
    }

    private String addDisplayName(String subtag, int type, String separatorPattern, String extras, Transform<String, String> altPicker) {
        if (subtag.length() == 0) {
            return extras;
        }
        String sname = this.getName(type, subtag, altPicker);
        if (sname == null) {
            sname = subtag;
        }
        sname = sname.replace('(', '[').replace(')', ']').replace('\uff08', '\uff3b').replace('\uff09', '\uff3d');
        extras = extras.length() == 0 ? extras + sname : MessageFormat.format(separatorPattern, extras, sname);
        return extras;
    }

    public static String getNameName(int choice) {
        String[] nameTableRow = NameTable[choice];
        return nameTableRow[nameTableRow.length - 1];
    }

    @Deprecated
    public static List<String> getElementOrder() {
        return Collections.emptyList();
    }

    public static List<String> getAttributeOrder() {
        return CLDRFile.getAttributeOrdering().getOrder();
    }

    public static boolean isOrdered(String element, DtdType type) {
        return DtdData.getInstance(type).isOrdered(element);
    }

    public static Map<String, Map<String, String>> getDefaultSuppressionMap() {
        return defaultSuppressionMap;
    }

    private static Map asMap(String[][] data, boolean tree) {
        AbstractMap tempmain = tree ? new TreeMap() : new HashMap();
        int len = data[0].length;
        for (int i = 0; i < data.length; ++i) {
            AbstractMap temp = tempmain;
            if (len != data[i].length) {
                throw new IllegalArgumentException("Must be square array: fails row " + i);
            }
            for (int j = 0; j < len - 2; ++j) {
                AbstractMap newTemp = (AbstractMap)temp.get(data[i][j]);
                if (newTemp == null) {
                    newTemp = tree ? new TreeMap() : new HashMap();
                    temp.put(data[i][j], newTemp);
                }
                temp = newTemp;
            }
            temp.put(data[i][len - 2], data[i][len - 1]);
        }
        return tempmain;
    }

    public CLDRFile removeComment(String string) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.getXpathComments().removeComment(string);
        return this;
    }

    public CLDRFile makeDraft(DraftStatus draftStatus) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        for (String path : this.dataSource) {
            XPathParts parts = XPathParts.getFrozenInstance(this.dataSource.getFullPath(path)).cloneAsThawed();
            parts.addAttribute("draft", draftStatus.toString());
            this.dataSource.putValueAtPath(parts.toString(), this.dataSource.getValueAtPath(path));
        }
        return this;
    }

    public UnicodeSet getExemplarSet(String type, WinningChoice winningChoice) {
        return this.getExemplarSet(type, winningChoice, 2);
    }

    public UnicodeSet getExemplarSet(ExemplarType type, WinningChoice winningChoice) {
        return this.getExemplarSet(type, winningChoice, 2);
    }

    public UnicodeSet getExemplarSet(String type, WinningChoice winningChoice, int option) {
        return this.getExemplarSet(ExemplarType.fromString(type), winningChoice, option);
    }

    public UnicodeSet getExemplarSet(ExemplarType type, WinningChoice winningChoice, int option) {
        String v;
        String path = CLDRFile.getExemplarPath(type);
        if (winningChoice == WinningChoice.WINNING) {
            path = this.getWinningPath(path);
        }
        if ((v = this.getStringValueWithBailey(path)) == null) {
            return UnicodeSet.EMPTY;
        }
        UnicodeSet result = new UnicodeSet(v);
        UnicodeSet toNuke = new UnicodeSet(HACK_CASE_CLOSURE_SET).removeAll(result);
        result.closeOver(2);
        result.removeAll(toNuke);
        result.remove(32);
        return result;
    }

    public static String getExemplarPath(ExemplarType type) {
        return "//ldml/characters/exemplarCharacters" + (type == ExemplarType.main ? "" : "[@type=\"" + (Object)((Object)type) + "\"]");
    }

    public UnicodeSet getExemplarsNumeric(NumberingSystem system) {
        String numberingSystem;
        String string = numberingSystem = system.path == null ? "latn" : this.getStringValue(system.path);
        if (numberingSystem == null) {
            return UnicodeSet.EMPTY;
        }
        return this.getExemplarsNumeric(numberingSystem);
    }

    public UnicodeSet getExemplarsNumeric(String numberingSystem) {
        UnicodeSet result = new UnicodeSet();
        SupplementalDataInfo sdi = CLDRConfig.getInstance().getSupplementalDataInfo();
        String[] symbolPaths = new String[]{"decimal", "group", "percentSign", "perMille", "plusSign", "minusSign"};
        String digits = sdi.getDigits(numberingSystem);
        if (digits != null) {
            result.addAll(digits);
        }
        for (String path : symbolPaths) {
            String fullPath = "//ldml/numbers/symbols[@numberSystem=\"" + numberingSystem + "\"]/" + path;
            String value = this.getStringValue(fullPath);
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    public String getCurrentMetazone(String zone) {
        for (String xpath : this) {
            XPathParts parts;
            if (!xpath.startsWith("//ldml/dates/timeZoneNames/zone[@type=\"" + zone + "\"]/usesMetazone") || (parts = XPathParts.getFrozenInstance(xpath)).containsAttribute("to")) continue;
            return parts.getAttributeValue(4, "mzone");
        }
        return null;
    }

    public boolean isResolved() {
        return this.dataSource.isResolving();
    }

    public static final String distinguishedXPathStats() {
        return DistinguishedXPath.stats();
    }

    public static boolean isLOG_PROGRESS() {
        return LOG_PROGRESS;
    }

    public static void setLOG_PROGRESS(boolean log_progress) {
        LOG_PROGRESS = log_progress;
    }

    public boolean isEmpty() {
        return !this.dataSource.iterator().hasNext();
    }

    public Map<String, String> getNonDistinguishingAttributes(String fullPath, Map<String, String> result, Set<String> skipList) {
        return distinguishedXPath.getNonDistinguishingAttributes(fullPath, result, skipList);
    }

    public String getDtdVersion() {
        return this.dataSource.getDtdVersionInfo().toString();
    }

    public VersionInfo getDtdVersionInfo() {
        VersionInfo result = this.dataSource.getDtdVersionInfo();
        if (result != null || this.isEmpty()) {
            return result;
        }
        String path = this.dataSource.iterator().next();
        String full = this.getFullXPath(path);
        XPathParts parts = XPathParts.getFrozenInstance(full);
        String versionString = parts.findFirstAttributeValue("version");
        return versionString == null ? null : VersionInfo.getInstance(versionString);
    }

    private boolean contains(Map<String, String> a, Map<String, String> b) {
        for (String key : b.keySet()) {
            String otherValue = a.get(key);
            if (otherValue == null) {
                return false;
            }
            String value = b.get(key);
            if (otherValue.equals(value)) continue;
            return false;
        }
        return true;
    }

    public String getFullXPath(String path, boolean ignoreOtherLeafAttributes) {
        String result = this.getFullXPath(path);
        if (result != null) {
            return result;
        }
        XPathParts parts = XPathParts.getFrozenInstance(path);
        Map<String, String> lastAttributes = parts.getAttributes(parts.size() - 1);
        String base = parts.toString(parts.size() - 1) + "/" + parts.getElement(parts.size() - 1);
        Iterator<String> it = this.iterator(base);
        while (it.hasNext()) {
            Map<String, String> lastOtherAttributes;
            String otherPath = it.next();
            XPathParts other = XPathParts.getFrozenInstance(otherPath);
            if (other.size() != parts.size() || !this.contains(lastOtherAttributes = other.getAttributes(other.size() - 1), lastAttributes)) continue;
            if (result == null) {
                result = this.getFullXPath(otherPath);
                continue;
            }
            throw new IllegalArgumentException("Multiple values for path: " + path);
        }
        return result;
    }

    public boolean isWinningPath(String path) {
        return this.dataSource.isWinningPath(path);
    }

    public String getWinningPath(String path) {
        return this.dataSource.getWinningPath(path);
    }

    public String getWinningValue(String path) {
        String winningPath = this.getWinningPath(path);
        return winningPath == null ? null : this.getStringValue(winningPath);
    }

    public String getWinningValueWithBailey(String path) {
        String winningValue = this.getWinningValue(path);
        if (CldrUtility.INHERITANCE_MARKER.equals(winningValue)) {
            Output<String> localeWhereFound = new Output<String>();
            Output<String> pathWhereFound = new Output<String>();
            winningValue = this.getBaileyValue(path, pathWhereFound, localeWhereFound);
        }
        return winningValue;
    }

    public String getStringValueWithBailey(String path) {
        String value = this.getStringValue(path);
        if (CldrUtility.INHERITANCE_MARKER.equals(value)) {
            Output<String> localeWhereFound = new Output<String>();
            Output<String> pathWhereFound = new Output<String>();
            value = this.getBaileyValue(path, pathWhereFound, localeWhereFound);
        }
        return value;
    }

    public String getStringValueWithBailey(String path, Output<String> pathWhereFound, Output<String> localeWhereFound) {
        String value = this.getStringValue(path);
        if (CldrUtility.INHERITANCE_MARKER.equals(value)) {
            value = this.getBaileyValue(path, pathWhereFound, localeWhereFound);
        } else {
            Status status = new Status();
            String localeWhereFound2 = this.getSourceLocaleID(path, status);
            if (localeWhereFound != null) {
                localeWhereFound.value = localeWhereFound2;
            }
            if (pathWhereFound != null) {
                pathWhereFound.value = status.pathWhereFound;
            }
        }
        return value;
    }

    public Set<String> getPathsWithValue(String valueToMatch, String pathPrefix, Matcher pathMatcher, Set<String> result) {
        if (result == null) {
            result = new HashSet<String>();
        }
        this.dataSource.getPathsWithValue(valueToMatch, pathPrefix, result);
        if (pathMatcher == null) {
            return result;
        }
        Iterator<String> it = result.iterator();
        while (it.hasNext()) {
            String path = it.next();
            if (pathMatcher.reset(path).matches()) continue;
            it.remove();
        }
        return result;
    }

    public Set<String> getPaths(String pathPrefix, Matcher pathMatcher, Set<String> result) {
        if (result == null) {
            result = new HashSet<String>();
        }
        Iterator<String> it = this.dataSource.iterator(pathPrefix);
        while (it.hasNext()) {
            String path = it.next();
            if (pathMatcher != null && !pathMatcher.reset(path).matches()) continue;
            result.add(path);
        }
        return result;
    }

    public Collection<String> getExtraPaths() {
        HashSet<String> toAddTo = new HashSet<String>();
        toAddTo.addAll(this.getRawExtraPaths());
        for (String path : this) {
            toAddTo.remove(path);
        }
        return toAddTo;
    }

    public Collection<String> getExtraPaths(String prefix, Collection<String> toAddTo) {
        for (String item : this.getRawExtraPaths()) {
            if (!item.startsWith(prefix) || this.dataSource.getValueAtPath(item) != null) continue;
            toAddTo.add(item);
        }
        return toAddTo;
    }

    public Set<String> getRawExtraPaths() {
        if (this.extraPaths == null) {
            this.extraPaths = ImmutableSet.copyOf(this.getRawExtraPathsPrivate(new LinkedHashSet<String>()));
        }
        return this.extraPaths;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<String> getRawExtraPathsPrivate(Collection<String> toAddTo) {
        String[] overrides;
        String locale;
        DayPeriodInfo dayPeriods;
        SupplementalDataInfo supplementalData = CLDRConfig.getInstance().getSupplementalDataInfo();
        SupplementalDataInfo.PluralInfo plurals = supplementalData.getPlurals(SupplementalDataInfo.PluralType.cardinal, this.getLocaleID());
        if (plurals == null) {
            // empty if block
        }
        Set<Object> pluralCounts = Collections.emptySet();
        if (plurals != null && (pluralCounts = plurals.getCounts()).size() != 1) {
            this.addPluralCounts(toAddTo, pluralCounts, this);
        }
        if ((dayPeriods = supplementalData.getDayPeriods(DayPeriodInfo.Type.format, locale = this.getLocaleID())) != null) {
            LinkedHashSet<DayPeriodInfo.DayPeriod> items = new LinkedHashSet<DayPeriodInfo.DayPeriod>(dayPeriods.getPeriods());
            items.add(DayPeriodInfo.DayPeriod.am);
            items.add(DayPeriodInfo.DayPeriod.pm);
            for (String context : new String[]{"format", "stand-alone"}) {
                for (String width : new String[]{"narrow", "abbreviated", "wide"}) {
                    for (DayPeriodInfo.DayPeriod dayPeriod : items) {
                        toAddTo.add("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/dayPeriodContext[@type=\"" + context + "\"]/dayPeriodWidth[@type=\"" + width + "\"]/dayPeriod[@type=\"" + (Object)((Object)dayPeriod) + "\"]");
                    }
                }
            }
        }
        Set<String> zones = supplementalData.getAllMetazones();
        for (String zone : zones) {
            for (String width : new String[]{"long", "short"}) {
                for (String type : new String[]{"generic", "standard", "daylight"}) {
                    toAddTo.add("//ldml/dates/timeZoneNames/metazone[@type=\"" + zone + "\"]/" + width + "/" + type);
                }
            }
        }
        for (String override : overrides = new String[]{"Pacific/Honolulu\"]/short/generic", "Pacific/Honolulu\"]/short/standard", "Pacific/Honolulu\"]/short/daylight", "Europe/Dublin\"]/long/daylight", "Europe/London\"]/long/daylight", "Etc/UTC\"]/long/standard", "Etc/UTC\"]/short/standard"}) {
            toAddTo.add("//ldml/dates/timeZoneNames/zone[@type=\"" + override);
        }
        Set<String> codes = supplementalData.getBcp47Keys().getAll("cu");
        for (String code : codes) {
            String currencyCode = code.toUpperCase();
            toAddTo.add("//ldml/numbers/currencies/currency[@type=\"" + currencyCode + "\"]/symbol");
            toAddTo.add("//ldml/numbers/currencies/currency[@type=\"" + currencyCode + "\"]/displayName");
            if (pluralCounts.isEmpty()) continue;
            for (SupplementalDataInfo.PluralInfo.Count count : pluralCounts) {
                toAddTo.add("//ldml/numbers/currencies/currency[@type=\"" + currencyCode + "\"]/displayName[@count=\"" + count.toString() + "\"]");
            }
        }
        GrammarInfo grammarInfo = supplementalData.getGrammarInfo(this.getLocaleID(), true);
        if ("de".equals(this.getLocaleID())) {
            boolean code = false;
        }
        if (grammarInfo != null && grammarInfo.hasInfo(GrammarInfo.GrammaticalTarget.nominal)) {
            void var14_36;
            Collection<String> genders = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalGender, GrammarInfo.GrammaticalScope.units);
            Collection<String> rawCases = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalCase, GrammarInfo.GrammaticalScope.units);
            Collection<String> nomCases = rawCases.isEmpty() ? casesNominativeOnly : rawCases;
            Collection collection = GrammarInfo.NON_COMPUTABLE_PLURALS.get((Object)locale);
            if (collection.isEmpty()) {
                Set<Object> set = pluralCounts;
            } else {
                boolean bl = false;
            }
            if (!genders.isEmpty()) {
                for (String string : GrammarInfo.SPECIAL_TRANSLATION_UNITS) {
                    toAddTo.add("//ldml/units/unitLength[@type=\"long\"]/unit[@type=\"" + string + "\"]/gender");
                }
                for (SupplementalDataInfo.PluralInfo.Count count : var14_36) {
                    for (String string : genders) {
                        for (String case1 : nomCases) {
                            String grammaticalAttributes = GrammarInfo.getGrammaticalInfoAttributes(grammarInfo, UnitPathType.power, count.toString(), string, case1);
                            toAddTo.add("//ldml/units/unitLength[@type=\"long\"]/compoundUnit[@type=\"power2\"]/compoundUnitPattern1" + grammaticalAttributes);
                            toAddTo.add("//ldml/units/unitLength[@type=\"long\"]/compoundUnit[@type=\"power3\"]/compoundUnitPattern1" + grammaticalAttributes);
                        }
                    }
                }
                for (String string : genders) {
                    toAddTo.add("//ldml/numbers/minimalPairs/genderMinimalPairs[@gender=\"" + string + "\"]");
                }
            }
            if (!rawCases.isEmpty()) {
                for (String string : rawCases) {
                    toAddTo.add("//ldml/numbers/minimalPairs/caseMinimalPairs[@case=\"" + string + "\"]");
                    for (SupplementalDataInfo.PluralInfo.Count count : var14_36) {
                        for (String unit : GrammarInfo.SPECIAL_TRANSLATION_UNITS) {
                            toAddTo.add("//ldml/units/unitLength[@type=\"long\"]/unit[@type=\"" + unit + "\"]/unitPattern" + GrammarInfo.getGrammaticalInfoAttributes(grammarInfo, UnitPathType.unit, count.toString(), null, string));
                        }
                    }
                }
            }
        }
        return toAddTo;
    }

    private void addPluralCounts(Collection<String> toAddTo, Set<SupplementalDataInfo.PluralInfo.Count> pluralCounts, Iterable<String> file) {
        for (String path : file) {
            String countAttr;
            int countPos = path.indexOf(countAttr = "[@count=\"other\"]");
            if (countPos < 0) continue;
            String start = path.substring(0, countPos) + "[@count=\"";
            String end = "\"]" + path.substring(countPos + countAttr.length());
            for (SupplementalDataInfo.PluralInfo.Count count : pluralCounts) {
                if (count == SupplementalDataInfo.PluralInfo.Count.other) continue;
                toAddTo.add(start + (Object)((Object)count) + end);
            }
        }
    }

    public boolean isPathExcludedForSurvey(String distinguishedPath) {
        if (distinguishedPath.contains("/exemplarCity")) {
            this.excludedZones = this.getExcludedZones();
            this.typeValueMatcher.reset(distinguishedPath).find();
            if (this.excludedZones.contains(this.typeValueMatcher.group(1))) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getExcludedZones() {
        CLDRFile cLDRFile = this;
        synchronized (cLDRFile) {
            if (this.excludedZones == null) {
                SupplementalDataInfo supplementalData = CLDRConfig.getInstance().getSupplementalDataInfo();
                this.excludedZones = new HashSet<String>(supplementalData.getSingleRegionZones());
                this.excludedZones = Collections.unmodifiableSet(this.excludedZones);
            }
            return this.excludedZones;
        }
    }

    public String getCountPathWithFallback(String xpath, SupplementalDataInfo.PluralInfo.Count count, boolean winning) {
        Output<String> newPath;
        XPathParts parts = XPathParts.getFrozenInstance(xpath).cloneAsThawed();
        if (this.tryDefault(parts, "gender", null, newPath = new Output<String>())) {
            return (String)newPath.value;
        }
        if (this.tryDefault(parts, "case", null, newPath)) {
            return (String)newPath.value;
        }
        boolean isDisplayName = parts.contains("displayName");
        String actualCount = parts.getAttributeValue(-1, "count");
        if (actualCount != null) {
            String result;
            if (CldrUtility.DIGITS.containsAll(actualCount)) {
                try {
                    int item = Integer.parseInt(actualCount);
                    String locale = this.getLocaleID();
                    PluralRules rules = PluralRules.forLocale(new ULocale(locale));
                    String keyword = rules.select(item);
                    SupplementalDataInfo.PluralInfo.Count itemCount = SupplementalDataInfo.PluralInfo.Count.valueOf(keyword);
                    result = this.getCountPathWithFallback2(parts, xpath, itemCount, winning);
                    if (result != null && this.isNotRoot(result)) {
                        return result;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((result = this.getCountPathWithFallback2(parts, xpath, count, winning)) != null && this.isNotRoot(result)) {
                return result;
            }
            if (count != SupplementalDataInfo.PluralInfo.Count.other && (result = this.getCountPathWithFallback2(parts, xpath, SupplementalDataInfo.PluralInfo.Count.other, winning)) != null && this.isNotRoot(result)) {
                return result;
            }
            if (isDisplayName) {
                result = this.getCountPathWithFallback2(parts, xpath, null, winning);
            }
            return result;
        }
        return null;
    }

    public boolean tryDefault(XPathParts parts, String attribute, String defaultValue, Output<String> newPath) {
        String oldValue = parts.getAttributeValue(-1, attribute);
        if (oldValue != null) {
            parts.setAttribute(-1, attribute, null);
            newPath.value = parts.toString();
            if (this.dataSource.getValueAtPath((String)newPath.value) != null) {
                return true;
            }
        }
        return false;
    }

    private String getCountPathWithFallback2(XPathParts parts, String xpathWithNoCount, SupplementalDataInfo.PluralInfo.Count count, boolean winning) {
        parts.addAttribute("count", count == null ? null : count.toString());
        String newPath = parts.toString();
        if (!newPath.equals(xpathWithNoCount)) {
            String temp;
            if (winning && (temp = this.getWinningPath(newPath)) != null) {
                newPath = temp;
            }
            if (this.dataSource.getValueAtPath(newPath) != null) {
                return newPath;
            }
        }
        return null;
    }

    public String getFillInValue(String distinguishedPath) {
        String value;
        String winningPath = this.getWinningPath(distinguishedPath);
        if (this.isNotRoot(winningPath)) {
            return this.getStringValue(winningPath);
        }
        String fallbackPath = this.getFallbackPath(winningPath, true, true);
        if (fallbackPath != null && (value = this.getWinningValue(fallbackPath)) != null) {
            return value;
        }
        return this.getStringValue(winningPath);
    }

    public boolean isNotRoot(String distinguishedPath) {
        String source = this.getSourceLocaleID(distinguishedPath, null);
        return source != null && !source.equals("root") && !source.equals("code-fallback");
    }

    public boolean isAliasedAtTopLevel() {
        return this.iterator("//ldml/alias").hasNext();
    }

    public static Comparator<String> getComparator(DtdType dtdType) {
        if (dtdType == null) {
            return ldmlComparator;
        }
        switch (dtdType) {
            case ldml: 
            case ldmlICU: {
                return ldmlComparator;
            }
        }
        return DtdData.getInstance(dtdType).getDtdComparator(null);
    }

    public Comparator<String> getComparator() {
        return CLDRFile.getComparator(this.dtdType);
    }

    public DtdType getDtdType() {
        return this.dtdType != null ? this.dtdType : this.dataSource.getDtdType();
    }

    public DtdData getDtdData() {
        return this.dtdData != null ? this.dtdData : DtdData.getInstance(this.getDtdType());
    }

    public static Comparator<String> getPathComparator(String path) {
        DtdType fileDtdType = DtdType.fromPath(path);
        return CLDRFile.getComparator(fileDtdType);
    }

    public static MapComparator<String> getAttributeOrdering() {
        return DtdData.getInstance(DtdType.ldmlICU).getAttributeComparator();
    }

    public CLDRFile getUnresolved() {
        if (!this.isResolved()) {
            return this;
        }
        XMLSource source = this.dataSource.getUnresolving();
        return new CLDRFile(source);
    }

    public static Comparator<String> getAttributeValueComparator(String element, String attribute) {
        return DtdData.getAttributeValueComparator(DtdType.ldml, element, attribute);
    }

    public void setDtdType(DtdType dtdType) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dtdType = dtdType;
    }

    public void valueChanged(String xpath) {
        if (this.isResolved()) {
            XMLSource.ResolvingSource resSource = (XMLSource.ResolvingSource)this.dataSource;
            resSource.valueChanged(xpath, resSource);
        }
    }

    public void disableCaching() {
        this.dataSource.disableCaching();
    }

    public String getConstructedValue(String xpath) {
        XPathParts parts;
        String type;
        if (xpath.startsWith("//ldml/localeDisplayNames/languages/language[@type=\"") && xpath.contains("_") && (type = (parts = XPathParts.getFrozenInstance(xpath)).getAttributeValue(-1, "type")).contains("_")) {
            String alt = parts.getAttributeValue(-1, "alt");
            if (alt == null) {
                return this.getName(type, true);
            }
            return this.getName(type, true, (Transform<String, String>)new SimpleAltPicker(alt));
        }
        return null;
    }

    public String getWinningValueForVettingViewer(String path) {
        String winningPath = this.getWinningPath(path);
        return winningPath == null ? null : this.getStringValueForVettingViewer(winningPath);
    }

    private String getStringValueForVettingViewer(String xpath) {
        try {
            String fallbackPath;
            String value;
            String constructedValue = this.getConstructedValue(xpath);
            if (constructedValue != null && ((value = this.getStringValueUnresolved(xpath)) == null || CldrUtility.INHERITANCE_MARKER.equals(value))) {
                return constructedValue;
            }
            String result = this.dataSource.getValueAtPath(xpath);
            if (result == null && this.dataSource.isResolving() && (fallbackPath = this.getFallbackPath(xpath, false, true)) != null) {
                result = this.dataSource.getValueAtPath(fallbackPath);
            }
            return result;
        }
        catch (Exception e) {
            throw new UncheckedExecutionException("Bad path: " + xpath, e);
        }
    }

    private String getStringValueUnresolved(String xpath) {
        CLDRFile sourceFileUnresolved = this.getUnresolved();
        return sourceFileUnresolved.getStringValue(xpath);
    }

    public LocaleStringProvider makeOverridingStringProvider(Map<String, String> pathAndValueOverrides) {
        return new OverridingStringProvider(pathAndValueOverrides);
    }

    static {
        ImmutableMap.Builder<String, String> temp = ImmutableMap.builder();
        for (String s2 : Arrays.asList("colAlternate", "colBackwards", "colCaseFirst", "colCaseLevel", "colNormalization", "colNumeric", "colReorder", "colStrength")) {
            temp.put(s2.toLowerCase(Locale.ROOT), s2);
        }
        FIX_KEY_NAME = temp.build();
        CLEAN_DESCRIPTION = Pattern.compile("([^\\(\\[]*)[\\(\\[].*");
        DESCRIPTION_SEP = Splitter.on('\u25aa');
        JOIN_HYPHEN = Joiner.on('-');
        JOIN_UNDERBAR = Joiner.on('_');
        SHORT_ALTS = new Transform<String, String>(){

            @Override
            public String transform(String source) {
                return "short";
            }
        };
        ldmlComparator = DtdData.getInstance(DtdType.ldmlICU).getDtdComparator(null);
        String[][] data = new String[][]{{"ldml", "version", GEN_VERSION}, {"version", "cldrVersion", "*"}, {"orientation", "characters", "left-to-right"}, {"orientation", "lines", "top-to-bottom"}, {"weekendStart", "time", "00:00"}, {"weekendEnd", "time", "24:00"}, {"dateFormat", "type", "standard"}, {"timeFormat", "type", "standard"}, {"dateTimeFormat", "type", "standard"}, {"decimalFormat", "type", "standard"}, {"scientificFormat", "type", "standard"}, {"percentFormat", "type", "standard"}, {"pattern", "type", "standard"}, {"currency", "type", "standard"}, {"transform", "visibility", "external"}, {"*", "_q", "*"}};
        Map tempmain = CLDRFile.asMap(data, true);
        defaultSuppressionMap = Collections.unmodifiableMap(tempmain);
        HACK_CASE_CLOSURE_SET = new UnicodeSet("[\u017f\u1e9b\ufb00\u1e9e{i\u0307}\u1f71\u1f73\u1f75\u1f77\u1f79\u1f7b\u1f7d\u1fbb\u1fbe\u1fc9\u1fcb\u1fd3\u1fdb\u1fe3\u1feb\u1ff9\u1ffb\u2126\u212a\u212b]").freeze();
        distinguishedXPath = new DistinguishedXPath();
    }

    public class OverridingStringProvider
    implements LocaleStringProvider {
        private final Map<String, String> pathAndValueOverrides;

        public OverridingStringProvider(Map<String, String> pathAndValueOverrides) {
            this.pathAndValueOverrides = pathAndValueOverrides;
        }

        @Override
        public String getStringValue(String xpath) {
            String value = this.pathAndValueOverrides.get(xpath);
            return value != null ? value : CLDRFile.this.getStringValue(xpath);
        }

        @Override
        public String getLocaleID() {
            return CLDRFile.this.getLocaleID();
        }

        @Override
        public String getSourceLocaleID(String xpath, Status status) {
            if (this.pathAndValueOverrides.containsKey(xpath)) {
                if (status != null) {
                    status.pathWhereFound = xpath;
                }
                return this.getLocaleID() + "-override";
            }
            return CLDRFile.this.getSourceLocaleID(xpath, status);
        }
    }

    public static class TestUser
    extends CLDRFile {
        Map<String, String> userOverrides = new HashMap<String, String>();

        public TestUser(CLDRFile baseFile, String user, boolean resolved) {
            super(resolved ? baseFile.dataSource : baseFile.dataSource.getUnresolving());
            if (!baseFile.isResolved()) {
                throw new IllegalArgumentException("baseFile must be resolved");
            }
            Relation<String, String> pathMap = Relation.of(new HashMap(), TreeSet.class, new WinningComparator(user));
            for (String path : baseFile) {
                String newPath = TestUser.getNondraftNonaltXPath(path);
                pathMap.put(newPath, path);
            }
            for (String path : pathMap.keySet()) {
                String winner = null;
                for (String rowPath : pathMap.getAll(path)) {
                    if (winner == null) {
                        winner = rowPath;
                        continue;
                    }
                    this.userOverrides.put(rowPath, winner);
                }
            }
        }

        @Override
        public String getWinningPath(String path) {
            String trial = this.userOverrides.get(path);
            if (trial != null) {
                return trial;
            }
            return path;
        }
    }

    static class WinningComparator
    implements Comparator<String> {
        String user;

        public WinningComparator(String user) {
            this.user = user;
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.contains(this.user)) {
                if (!o2.contains(this.user)) {
                    return -1;
                }
            } else if (o2.contains(this.user)) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    public static enum WinningChoice {
        NORMAL,
        WINNING;

    }

    public static class Status {
        public String pathWhereFound;

        public String toString() {
            return this.pathWhereFound;
        }
    }

    private static class DistinguishedXPath {
        private static Map<String, String> distinguishingMap = new ConcurrentHashMap<String, String>();
        private static Map<String, String> normalizedPathMap = new ConcurrentHashMap<String, String>();

        private DistinguishedXPath() {
        }

        public static final String stats() {
            return "distinguishingMap:" + distinguishingMap.size() + " normalizedPathMap:" + normalizedPathMap.size();
        }

        public static String getDistinguishingXPath(String xpath, String[] normalizedPath) {
            String result = distinguishingMap.get(xpath);
            if (result == null) {
                String element;
                int i;
                XPathParts distinguishingParts = XPathParts.getFrozenInstance(xpath).cloneAsThawed();
                DtdType type = distinguishingParts.getDtdData().dtdType;
                HashSet<String> toRemove = new HashSet<String>();
                String draft = null;
                String alt = null;
                String references = "";
                for (i = 0; i < distinguishingParts.size() - 1; ++i) {
                    if (distinguishingParts.getAttributeCount(i) == 0) continue;
                    toRemove.clear();
                    Map<String, String> attributes = distinguishingParts.getAttributes(i);
                    for (String attribute : attributes.keySet()) {
                        if (attribute.equals("draft")) {
                            draft = attributes.get(attribute);
                            toRemove.add(attribute);
                            continue;
                        }
                        if (attribute.equals("alt")) {
                            alt = attributes.get(attribute);
                            toRemove.add(attribute);
                            continue;
                        }
                        if (!attribute.equals("references")) continue;
                        if (references.length() != 0) {
                            references = references + " ";
                        }
                        references = references + attributes.get("references");
                        toRemove.add(attribute);
                    }
                    distinguishingParts.removeAttributes(i, toRemove);
                }
                if (draft != null || alt != null || references.length() != 0) {
                    String newXPath;
                    int placementIndex = distinguishingParts.size() - 1;
                    while (true) {
                        element = distinguishingParts.getElement(placementIndex);
                        if (!DtdData.getInstance(type).isOrdered(element)) break;
                        --placementIndex;
                    }
                    if (draft != null) {
                        distinguishingParts.putAttributeValue(placementIndex, "draft", draft);
                    }
                    if (alt != null) {
                        distinguishingParts.putAttributeValue(placementIndex, "alt", alt);
                    }
                    if (references.length() != 0) {
                        distinguishingParts.putAttributeValue(placementIndex, "references", references);
                    }
                    if (!(newXPath = distinguishingParts.toString()).equals(xpath)) {
                        normalizedPathMap.put(xpath, newXPath);
                    }
                }
                for (i = 0; i < distinguishingParts.size(); ++i) {
                    if (distinguishingParts.getAttributeCount(i) == 0) continue;
                    element = distinguishingParts.getElement(i);
                    toRemove.clear();
                    for (String attribute : distinguishingParts.getAttributeKeys(i)) {
                        if (CLDRFile.isDistinguishing(type, element, attribute)) continue;
                        toRemove.add(attribute);
                    }
                    distinguishingParts.removeAttributes(i, toRemove);
                }
                result = distinguishingParts.toString();
                if (result.equals(xpath)) {
                    result = xpath;
                }
                distinguishingMap.put(xpath, result);
            }
            if (normalizedPath != null) {
                normalizedPath[0] = normalizedPathMap.get(xpath);
                if (normalizedPath[0] == null) {
                    normalizedPath[0] = xpath;
                }
            }
            return result;
        }

        public Map<String, String> getNonDistinguishingAttributes(String fullPath, Map<String, String> result, Set<String> skipList) {
            if (result == null) {
                result = new LinkedHashMap<String, String>();
            } else {
                result.clear();
            }
            XPathParts distinguishingParts = XPathParts.getFrozenInstance(fullPath);
            DtdType type = distinguishingParts.getDtdData().dtdType;
            for (int i = 0; i < distinguishingParts.size(); ++i) {
                String element = distinguishingParts.getElement(i);
                Map<String, String> attributes = distinguishingParts.getAttributes(i);
                for (String attribute : attributes.keySet()) {
                    if (CLDRFile.isDistinguishing(type, element, attribute) || skipList.contains(attribute)) continue;
                    result.put(attribute, attributes.get(attribute));
                }
            }
            return result;
        }

        static {
            distinguishingMap.put("", "");
        }
    }

    public static enum NumberingSystem {
        latin(null),
        defaultSystem("//ldml/numbers/defaultNumberingSystem"),
        nativeSystem("//ldml/numbers/otherNumberingSystems/native"),
        traditional("//ldml/numbers/otherNumberingSystems/traditional"),
        finance("//ldml/numbers/otherNumberingSystems/finance");

        public final String path;

        private NumberingSystem(String path) {
            this.path = path;
        }
    }

    public static enum ExemplarType {
        main,
        auxiliary,
        index,
        punctuation,
        numbers;


        public static ExemplarType fromString(String type) {
            return type.isEmpty() ? main : ExemplarType.valueOf(type);
        }
    }

    private static class MyDeclHandler
    implements XMLFileReader.AllHandler {
        private static UnicodeSet whitespace = new UnicodeSet("[:whitespace:]");
        private DraftStatus minimalDraftStatus;
        private static final boolean SHOW_START_END = false;
        private int commentStack;
        private boolean justPopped = false;
        private String lastChars = "";
        private String currentFullXPath = "/";
        private String comment = null;
        private Map<String, String> attributeOrder;
        private DtdData dtdData;
        private CLDRFile target;
        private String lastActiveLeafNode;
        private String lastLeafNode;
        private int isSupplemental = -1;
        private int[] orderedCounter = new int[30];
        private String[] orderedString = new String[30];
        private int level = 0;
        private int overrideCount = 0;
        private static Set<String> changedTypes = new HashSet<String>(Arrays.asList("abbreviationFallback", "default", "mapping", "measurementSystem", "preferenceOrdering"));
        static final Pattern draftPattern = PatternCache.get("\\[@draft=\"([^\"]*)\"\\]");
        Matcher draftMatcher = draftPattern.matcher("");
        static Pattern WHITESPACE_WITH_LF = PatternCache.get("\\s*\\u000a\\s*");
        Matcher whitespaceWithLf = WHITESPACE_WITH_LF.matcher("");
        static final UnicodeSet CONTROLS = new UnicodeSet("[:cc:]");

        MyDeclHandler(CLDRFile target, DraftStatus minimalDraftStatus) {
            this.target = target;
            this.minimalDraftStatus = minimalDraftStatus;
        }

        private String show(Attributes attributes) {
            if (attributes == null) {
                return "null";
            }
            String result = "";
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attribute = attributes.getQName(i);
                String value = attributes.getValue(i);
                result = result + "[@" + attribute + "=\"" + value + "\"]";
            }
            return result;
        }

        private void push(String qName, Attributes attributes) {
            Log.logln(LOG_PROGRESS, "push\t" + qName + "\t" + this.show(attributes));
            ++this.level;
            if (!qName.equals(this.orderedString[this.level])) {
                this.orderedString[this.level] = qName;
            }
            if (this.lastChars.length() != 0) {
                if (whitespace.containsAll(this.lastChars)) {
                    this.lastChars = "";
                } else {
                    throw new IllegalArgumentException("Must not have mixed content: " + qName + ", " + this.show(attributes) + ", Content: " + this.lastChars);
                }
            }
            this.currentFullXPath = this.currentFullXPath + "/" + qName;
            if (this.dtdData.isOrdered(qName)) {
                this.currentFullXPath = this.currentFullXPath + this.orderingAttribute();
            }
            if (attributes.getLength() > 0) {
                String value;
                this.attributeOrder.clear();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attribute = attributes.getQName(i);
                    value = attributes.getValue(i);
                    if (attribute.equals("cldrVersion") && qName.equals("version")) {
                        ((SimpleXMLSource)this.target.dataSource).setDtdVersionInfo(VersionInfo.getInstance(value));
                        continue;
                    }
                    this.putAndFixDeprecatedAttribute(qName, attribute, value);
                }
                for (String attribute : this.attributeOrder.keySet()) {
                    value = this.attributeOrder.get(attribute);
                    String both = "[@" + attribute + "=\"" + value + "\"]";
                    this.currentFullXPath = this.currentFullXPath + both;
                }
            }
            if (this.comment != null) {
                if (this.currentFullXPath.equals("//ldml") || this.currentFullXPath.equals("//supplementalData")) {
                    this.target.setInitialComment(this.comment);
                } else {
                    this.target.addComment(this.currentFullXPath, this.comment, XPathParts.Comments.CommentType.PREBLOCK);
                }
                this.comment = null;
            }
            this.justPopped = false;
            this.lastActiveLeafNode = null;
            Log.logln(LOG_PROGRESS, "currentFullXPath\t" + this.currentFullXPath);
        }

        private String orderingAttribute() {
            int n = this.level;
            int n2 = this.orderedCounter[n];
            this.orderedCounter[n] = n2 + 1;
            return "[@_q=\"" + n2 + "\"]";
        }

        private void putAndFixDeprecatedAttribute(String element, String attribute, String value) {
            if (attribute.equals("draft")) {
                if (value.equals("true")) {
                    value = "approved";
                } else if (value.equals("false")) {
                    value = "unconfirmed";
                }
            } else if (attribute.equals("type") && changedTypes.contains(element) && this.isSupplemental < 1) {
                attribute = "choice";
            }
            this.attributeOrder.put(attribute, value);
        }

        private void addPath(String fullXPath, String value) {
            String former = this.target.getStringValue(fullXPath);
            if (former != null) {
                String formerPath = this.target.getFullXPath(fullXPath);
                if (!(former.equals(value) && fullXPath.equals(formerPath) || fullXPath.startsWith("//ldml/identity/version") || fullXPath.startsWith("//ldml/identity/generation"))) {
                    this.warnOnOverride(former, formerPath);
                }
            }
            value = this.trimWhitespaceSpecial(value);
            this.target.add(fullXPath, value);
        }

        private void pop(String qName) {
            Log.logln(LOG_PROGRESS, "pop\t" + qName);
            --this.level;
            if (this.lastChars.length() != 0 || !this.justPopped) {
                boolean acceptItem;
                boolean bl = acceptItem = this.minimalDraftStatus == DraftStatus.unconfirmed;
                if (!acceptItem) {
                    if (this.draftMatcher.reset(this.currentFullXPath).find()) {
                        DraftStatus foundStatus = DraftStatus.valueOf(this.draftMatcher.group(1));
                        if (this.minimalDraftStatus.compareTo(foundStatus) <= 0) {
                            acceptItem = true;
                        }
                    } else {
                        acceptItem = true;
                    }
                }
                if (acceptItem) {
                    boolean skipAdd = false;
                    if (this.currentFullXPath.startsWith("//ldml/layout/orientation")) {
                        XPathParts parts = XPathParts.getFrozenInstance(this.currentFullXPath);
                        String value = parts.getAttributeValue(-1, "characters");
                        if (value != null) {
                            this.addPath("//ldml/layout/orientation/characterOrder", value);
                            skipAdd = true;
                        }
                        if ((value = parts.getAttributeValue(-1, "lines")) != null) {
                            this.addPath("//ldml/layout/orientation/lineOrder", value);
                            skipAdd = true;
                        }
                    }
                    if (!skipAdd) {
                        this.addPath(this.currentFullXPath, this.lastChars);
                    }
                    this.lastLeafNode = this.lastActiveLeafNode = this.currentFullXPath;
                }
                this.lastChars = "";
            } else {
                Log.logln(LOG_PROGRESS && this.lastActiveLeafNode != null, "pop: zeroing last leafNode: " + this.lastActiveLeafNode);
                this.lastActiveLeafNode = null;
                if (this.comment != null) {
                    this.target.addComment(this.lastLeafNode, this.comment, XPathParts.Comments.CommentType.POSTBLOCK);
                    this.comment = null;
                }
            }
            this.currentFullXPath = MyDeclHandler.stripAfter(this.currentFullXPath, qName);
            this.justPopped = true;
        }

        private String trimWhitespaceSpecial(String source) {
            if (!source.contains("\n")) {
                return source;
            }
            source = this.whitespaceWithLf.reset(source).replaceAll("\n");
            return source;
        }

        private void warnOnOverride(String former, String formerPath) {
            String distinguishing = CLDRFile.getDistinguishingXPath(formerPath, null);
            System.out.println("\tERROR in " + this.target.getLocaleID() + ";\toverriding old value <" + former + "> at path " + distinguishing + "\twith\t<" + this.lastChars + ">" + "\n" + "\told fullpath: " + formerPath + "\n" + "\tnew fullpath: " + this.currentFullXPath);
            ++this.overrideCount;
        }

        private static String stripAfter(String input, String qName) {
            int pos = MyDeclHandler.findLastSlash(input);
            if (qName != null && !input.substring(pos + 1).startsWith(qName)) {
                throw new IllegalArgumentException("Internal Error: should never get here.");
            }
            return input.substring(0, pos);
        }

        private static int findLastSlash(String input) {
            int braceStack = 0;
            char inQuote = '\u0000';
            block6: for (int i = input.length() - 1; i >= 0; --i) {
                char ch = input.charAt(i);
                switch (ch) {
                    case '\"': 
                    case '\'': {
                        if (inQuote == '\u0000') {
                            inQuote = ch;
                            continue block6;
                        }
                        if (inQuote != ch) continue block6;
                        inQuote = '\u0000';
                        continue block6;
                    }
                    case '/': {
                        if (inQuote != '\u0000' || braceStack != 0) continue block6;
                        return i;
                    }
                    case '[': {
                        if (inQuote != '\u0000') continue block6;
                        --braceStack;
                        continue block6;
                    }
                    case ']': {
                        if (inQuote != '\u0000') continue block6;
                        ++braceStack;
                    }
                }
            }
            return -1;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Log.logln(LOG_PROGRESS, "startElement uri\t" + uri + "\tlocalName " + localName + "\tqName " + qName + "\tattributes " + this.show(attributes));
            try {
                if (this.isSupplemental < 0) {
                    this.attributeOrder = new TreeMap<String, String>(this.dtdData.dtdType == DtdType.ldml ? CLDRFile.getAttributeOrdering() : this.dtdData.getAttributeComparator());
                    this.isSupplemental = this.target.dtdType == DtdType.ldml ? 0 : 1;
                }
                this.push(qName, attributes);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Log.logln(LOG_PROGRESS, "endElement uri\t" + uri + "\tlocalName " + localName + "\tqName " + qName);
            this.pop(qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                String value = new String(ch, start, length);
                Log.logln(LOG_PROGRESS, "characters:\t" + value);
                this.lastChars = this.lastChars + value;
                this.justPopped = false;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            Log.logln(LOG_PROGRESS, "startDTD name: " + name + ", publicId: " + publicId + ", systemId: " + systemId);
            ++this.commentStack;
            this.target.dtdType = DtdType.valueOf(name);
            this.dtdData = DtdData.getInstance(this.target.dtdType);
            this.target.dtdData = this.dtdData;
        }

        @Override
        public void endDTD() throws SAXException {
            Log.logln(LOG_PROGRESS, "endDTD");
            --this.commentStack;
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            String string = new String(ch, start, length);
            Log.logln(LOG_PROGRESS, this.commentStack + " comment " + string);
            try {
                if (this.commentStack != 0) {
                    return;
                }
                String comment0 = this.trimWhitespaceSpecial(string).trim();
                if (this.lastActiveLeafNode != null) {
                    this.target.addComment(this.lastActiveLeafNode, comment0, XPathParts.Comments.CommentType.LINE);
                } else {
                    this.comment = this.comment == null ? comment0 : this.comment + "\n" + comment0;
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (LOG_PROGRESS) {
                Log.logln(LOG_PROGRESS, "ignorableWhitespace length: " + length + ": " + Utility.hex(new String(ch, start, length)));
            }
            for (int i = start; i < start + length; ++i) {
                if (ch[i] != '\n') continue;
                Log.logln(LOG_PROGRESS && this.lastActiveLeafNode != null, "\\n: zeroing last leafNode: " + this.lastActiveLeafNode);
                this.lastActiveLeafNode = null;
                break;
            }
        }

        @Override
        public void startDocument() throws SAXException {
            Log.logln(LOG_PROGRESS, "startDocument");
            this.commentStack = 0;
        }

        @Override
        public void endDocument() throws SAXException {
            Log.logln(LOG_PROGRESS, "endDocument");
            try {
                if (this.comment != null) {
                    this.target.addComment(null, this.comment, XPathParts.Comments.CommentType.LINE);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void elementDecl(String name, String model) throws SAXException {
            Log.logln(LOG_PROGRESS, "Attribute\t" + name + "\t" + model);
        }

        @Override
        public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
            Log.logln(LOG_PROGRESS, "Attribute\t" + eName + "\t" + aName + "\t" + type + "\t" + mode + "\t" + value);
        }

        @Override
        public void internalEntityDecl(String name, String value) throws SAXException {
            Log.logln(LOG_PROGRESS, "Internal Entity\t" + name + "\t" + value);
        }

        @Override
        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
            Log.logln(LOG_PROGRESS, "Internal Entity\t" + name + "\t" + publicId + "\t" + systemId);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            Log.logln(LOG_PROGRESS, "processingInstruction: " + target + ", " + data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            Log.logln(LOG_PROGRESS, "skippedEntity: " + name);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            Log.logln(LOG_PROGRESS, "setDocumentLocator Locator " + locator);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            Log.logln(LOG_PROGRESS, "startPrefixMapping prefix: " + prefix + ", uri: " + uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            Log.logln(LOG_PROGRESS, "endPrefixMapping prefix: " + prefix);
        }

        @Override
        public void startEntity(String name) throws SAXException {
            Log.logln(LOG_PROGRESS, "startEntity name: " + name);
        }

        @Override
        public void endEntity(String name) throws SAXException {
            Log.logln(LOG_PROGRESS, "endEntity name: " + name);
        }

        @Override
        public void startCDATA() throws SAXException {
            Log.logln(LOG_PROGRESS, "startCDATA");
        }

        @Override
        public void endCDATA() throws SAXException {
            Log.logln(LOG_PROGRESS, "endCDATA");
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (!LOG_PROGRESS) {
                // empty if block
            }
            Log.logln(true, "error: " + CLDRFile.showSAX(exception));
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            Log.logln(LOG_PROGRESS, "fatalError: " + CLDRFile.showSAX(exception));
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            Log.logln(LOG_PROGRESS, "warning: " + CLDRFile.showSAX(exception));
            throw exception;
        }
    }

    public static class FullIterable
    implements Iterable<String>,
    With.SimpleIterator<String> {
        private final CLDRFile file;
        private final Iterator<String> fileIterator;
        private Iterator<String> extraPaths;

        FullIterable(CLDRFile file) {
            this.file = file;
            this.fileIterator = file.iterator();
        }

        @Override
        public Iterator<String> iterator() {
            return With.toIterator(this);
        }

        @Override
        public String next() {
            if (this.fileIterator.hasNext()) {
                return this.fileIterator.next();
            }
            if (this.extraPaths == null) {
                this.extraPaths = this.file.getExtraPaths().iterator();
            }
            if (this.extraPaths.hasNext()) {
                return this.extraPaths.next();
            }
            return null;
        }
    }

    public static interface RetentionTest {
        public Retention getRetention(String var1);

        public static enum Retention {
            RETAIN,
            REMOVE,
            RETAIN_IF_DIFFERENT;

        }
    }

    static final class SimpleAltPicker
    implements Transform<String, String> {
        public final String alt;

        public SimpleAltPicker(String alt) {
            this.alt = alt;
        }

        @Override
        public String transform(String source) {
            return this.alt;
        }
    }

    public static enum DraftStatus {
        unconfirmed,
        provisional,
        contributed,
        approved;


        public static DraftStatus forString(String string) {
            return string == null ? approved : DraftStatus.valueOf(string.toLowerCase(Locale.ENGLISH));
        }
    }
}

