/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.Output;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.EnumComparator;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnitPathType;

public class GrammarInfo
implements Freezable<GrammarInfo> {
    private Map<GrammaticalTarget, Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>> targetToFeatureToUsageToValues = new TreeMap<GrammaticalTarget, Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>>();
    private boolean frozen = false;
    public static final ImmutableMultimap<String, SupplementalDataInfo.PluralInfo.Count> NON_COMPUTABLE_PLURALS = ImmutableListMultimap.of("pl", SupplementalDataInfo.PluralInfo.Count.one, "pl", SupplementalDataInfo.PluralInfo.Count.other, "ru", SupplementalDataInfo.PluralInfo.Count.one, "ru", SupplementalDataInfo.PluralInfo.Count.other);
    public static final Set<String> SEED_LOCALES = ImmutableSet.of("pl", "ru", "da", "de", "no", "sv", new String[]{"hi", "id", "es", "fr", "it", "nl", "pt", "en", "ja", "th", "vi", "zh", "zh_TW", "ko", "yue"});
    public static final Set<String> SPECIAL_TRANSLATION_UNITS = ImmutableSet.of("mass-grain", "volume-dessert-spoon", "volume-dessert-spoon-imperial", "volume-drop", "volume-dram", "volume-jigger", new String[]{"volume-pinch", "volume-quart-imperial", "acceleration-meter-per-square-second", "area-acre", "area-hectare", "area-square-centimeter", "area-square-foot", "area-square-kilometer", "area-square-mile", "concentr-percent", "consumption-mile-per-gallon", "consumption-mile-per-gallon-imperial", "duration-day", "duration-hour", "duration-minute", "duration-month", "duration-second", "duration-week", "duration-year", "energy-foodcalorie", "energy-kilocalorie", "length-centimeter", "length-foot", "length-inch", "length-kilometer", "length-meter", "length-mile", "length-millimeter", "length-parsec", "length-picometer", "length-solar-radius", "length-yard", "light-solar-luminosity", "mass-dalton", "mass-earth-mass", "mass-milligram", "mass-solar-mass", "pressure-kilopascal", "speed-kilometer-per-hour", "speed-meter-per-second", "speed-mile-per-hour", "temperature-celsius", "temperature-fahrenheit", "temperature-generic", "temperature-kelvin", "acceleration-g-force", "consumption-liter-per-100-kilometer", "mass-gram", "mass-kilogram", "mass-ounce", "mass-pound", "volume-centiliter", "volume-cubic-centimeter", "volume-cubic-foot", "volume-cubic-mile", "volume-cup", "volume-deciliter", "volume-fluid-ounce", "volume-fluid-ounce-imperial", "volume-gallon", "volume-gallon", "volume-gallon-imperial", "volume-liter", "volume-milliliter", "volume-pint", "volume-quart", "volume-tablespoon", "volume-teaspoon"});

    public void add(GrammaticalTarget target, GrammaticalFeature feature, GrammaticalScope usage, String value) {
        Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> featureToUsageToValues = this.targetToFeatureToUsageToValues.get((Object)target);
        if (featureToUsageToValues == null) {
            featureToUsageToValues = new TreeMap<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>();
            this.targetToFeatureToUsageToValues.put(target, featureToUsageToValues);
        }
        if (feature != null) {
            Set<String> values;
            Map<GrammaticalScope, Set<String>> usageToValues = featureToUsageToValues.get((Object)feature);
            if (usageToValues == null) {
                usageToValues = new TreeMap<GrammaticalScope, Set<String>>();
                featureToUsageToValues.put(feature, usageToValues);
            }
            if ((values = usageToValues.get((Object)usage)) == null) {
                values = new TreeSet<String>();
                usageToValues.put(usage, values);
            }
            if (value != null) {
                values.add(value);
            } else {
                boolean bl = false;
            }
        }
    }

    public void add(GrammaticalTarget target, GrammaticalFeature feature, GrammaticalScope usage, Collection<String> valueSet) {
        Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> featureToUsageToValues = this.targetToFeatureToUsageToValues.get((Object)target);
        if (featureToUsageToValues == null) {
            featureToUsageToValues = new TreeMap<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>();
            this.targetToFeatureToUsageToValues.put(target, featureToUsageToValues);
        }
        if (feature != null) {
            Set<String> values;
            Map<GrammaticalScope, Set<String>> usageToValues = featureToUsageToValues.get((Object)feature);
            if (usageToValues == null) {
                usageToValues = new TreeMap<GrammaticalScope, Set<String>>();
                featureToUsageToValues.put(feature, usageToValues);
            }
            if ((values = usageToValues.get((Object)usage)) == null) {
                values = new TreeSet<String>();
                usageToValues.put(usage, values);
            }
            values.addAll(valueSet);
        }
    }

    public void add(String targetsRaw, String featureRaw, String usagesRaw, String valuesRaw) {
        for (String targetString : SupplementalDataInfo.split_space.split(targetsRaw)) {
            GrammaticalTarget target = GrammaticalTarget.valueOf(targetString);
            if (featureRaw == null) {
                this.add(target, null, null, (String)null);
                continue;
            }
            GrammaticalFeature feature = GrammaticalFeature.valueOf(featureRaw);
            List<String> usages = usagesRaw == null ? Collections.singletonList(GrammaticalScope.general.toString()) : SupplementalDataInfo.split_space.splitToList(usagesRaw);
            List<String> values = valuesRaw == null ? Collections.emptyList() : SupplementalDataInfo.split_space.splitToList(valuesRaw);
            for (String usageRaw : usages) {
                GrammaticalScope usage = GrammaticalScope.valueOf(usageRaw);
                this.add(target, feature, usage, values);
            }
        }
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public GrammarInfo freeze() {
        if (!this.frozen) {
            Map<GrammaticalTarget, Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>> temp = CldrUtility.protectCollection(this.targetToFeatureToUsageToValues);
            if (!temp.equals(this.targetToFeatureToUsageToValues)) {
                throw new IllegalArgumentException();
            }
            this.targetToFeatureToUsageToValues = temp;
            this.frozen = true;
        }
        return this;
    }

    @Override
    public GrammarInfo cloneAsThawed() {
        GrammarInfo result = new GrammarInfo();
        this.forEach3((t, f, u, v) -> result.add((GrammaticalTarget)((Object)t), (GrammaticalFeature)((Object)f), (GrammaticalScope)((Object)u), (Collection<String>)v));
        return result;
    }

    public void forEach(Handler4<GrammaticalTarget, GrammaticalFeature, GrammaticalScope, String> handler) {
        for (Map.Entry<GrammaticalTarget, Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>> entry1 : this.targetToFeatureToUsageToValues.entrySet()) {
            GrammaticalTarget target = entry1.getKey();
            Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> featureToUsageToValues = entry1.getValue();
            if (featureToUsageToValues.isEmpty()) {
                handler.apply(target, null, null, null);
                continue;
            }
            for (Map.Entry<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> entry2 : featureToUsageToValues.entrySet()) {
                GrammaticalFeature feature = entry2.getKey();
                for (Map.Entry<GrammaticalScope, Set<String>> entry3 : entry2.getValue().entrySet()) {
                    GrammaticalScope usage = entry3.getKey();
                    for (String value : entry3.getValue()) {
                        handler.apply(target, feature, usage, value);
                    }
                }
            }
        }
    }

    public void forEach3(Handler3<GrammaticalTarget, GrammaticalFeature, GrammaticalScope, Collection<String>> handler) {
        for (Map.Entry<GrammaticalTarget, Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>> entry1 : this.targetToFeatureToUsageToValues.entrySet()) {
            GrammaticalTarget target = entry1.getKey();
            Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> featureToUsageToValues = entry1.getValue();
            if (featureToUsageToValues.isEmpty()) {
                handler.apply(target, null, null, null);
                continue;
            }
            for (Map.Entry<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> entry2 : featureToUsageToValues.entrySet()) {
                GrammaticalFeature feature = entry2.getKey();
                for (Map.Entry<GrammaticalScope, Set<String>> entry3 : entry2.getValue().entrySet()) {
                    GrammaticalScope usage = entry3.getKey();
                    Collection values = entry3.getValue();
                    handler.apply(target, feature, usage, values);
                }
            }
        }
    }

    public Collection<String> get(GrammaticalTarget target, GrammaticalFeature feature, GrammaticalScope usage) {
        Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> featureToUsageToValues = this.targetToFeatureToUsageToValues.get((Object)target);
        if (featureToUsageToValues == null) {
            return Collections.emptySet();
        }
        Map<GrammaticalScope, Set<String>> usageToValues = featureToUsageToValues.get((Object)feature);
        if (usageToValues == null) {
            return Collections.emptySet();
        }
        Collection result = usageToValues.get((Object)usage);
        return result == null ? (Collection)usageToValues.get((Object)GrammaticalScope.general) : result;
    }

    public Map<GrammaticalScope, Set<String>> get(GrammaticalTarget target, GrammaticalFeature feature) {
        Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> featureToUsageToValues = this.targetToFeatureToUsageToValues.get((Object)target);
        if (featureToUsageToValues == null) {
            return Collections.emptyMap();
        }
        Map<GrammaticalScope, Set<String>> usageToValues = featureToUsageToValues.get((Object)feature);
        if (usageToValues == null) {
            return Collections.emptyMap();
        }
        return usageToValues;
    }

    public boolean hasInfo(GrammaticalTarget target) {
        return this.targetToFeatureToUsageToValues.containsKey((Object)target);
    }

    public String toString() {
        return this.toString("\n");
    }

    public String toString(String lineSep) {
        StringBuilder result = new StringBuilder();
        this.forEach3((t, f, u, v) -> {
            result.append(lineSep);
            result.append("{" + (t == null ? "" : t.toString()) + "}\t{" + (f == null ? "" : f.toString()) + "}\t{" + (u == null ? "" : u.toString()) + "}\t{" + (v == null ? "" : Joiner.on(' ').join((Iterable<?>)v)) + "}");
        });
        return result.toString();
    }

    public static String getGrammaticalInfoAttributes(GrammarInfo grammarInfo, UnitPathType pathType, String plural, String gender, String caseVariant) {
        Collection<String> genders;
        String grammaticalAttributes = "";
        if (pathType.features.contains((Object)GrammaticalFeature.grammaticalNumber)) {
            grammaticalAttributes = grammaticalAttributes + "[@count=\"" + (plural == null ? "other" : plural) + "\"]";
        }
        if (grammarInfo != null && gender != null && pathType.features.contains((Object)GrammaticalFeature.grammaticalGender) && !gender.equals(GrammaticalFeature.grammaticalGender.getDefault(genders = grammarInfo.get(GrammaticalTarget.nominal, GrammaticalFeature.grammaticalGender, GrammaticalScope.units)))) {
            grammaticalAttributes = grammaticalAttributes + "[@gender=\"" + gender + "\"]";
        }
        if (grammarInfo != null && caseVariant != null && pathType.features.contains((Object)GrammaticalFeature.grammaticalCase) && !caseVariant.equals(GrammaticalFeature.grammaticalCase.getDefault(null))) {
            grammaticalAttributes = grammaticalAttributes + "[@case=\"" + caseVariant + "\"]";
        }
        return grammaticalAttributes;
    }

    public void getSourceCaseAndPlural(String locale, String gender, String value, String desiredCase, String desiredPlural, Output<String> sourceCase, Output<String> sourcePlural) {
        switch (locale) {
            case "pl": {
                this.getSourceCaseAndPluralPolish(gender, value, desiredCase, desiredPlural, sourceCase, sourcePlural);
                break;
            }
            case "ru": {
                this.getSourceCaseAndPluralRussian(gender, value, desiredCase, desiredPlural, sourceCase, sourcePlural);
                break;
            }
            default: {
                throw new UnsupportedOperationException(locale);
            }
        }
    }

    private void getSourceCaseAndPluralRussian(String gender, String value, String desiredCase, String desiredPlural, Output<String> sourceCase, Output<String> sourcePlural) {
        switch (desiredPlural) {
            case "few": {
                sourceCase.value = desiredCase;
                sourcePlural.value = "many";
                switch (desiredCase) {
                    case "nominative": {
                        sourceCase.value = "genitive";
                        sourcePlural.value = "one";
                        break;
                    }
                    case "accusative": {
                        switch (gender) {
                            case "masculine": {
                                sourceCase.value = "genitive";
                                sourcePlural.value = "one";
                            }
                        }
                    }
                }
            }
            case "other": {
                sourceCase.value = "genitive";
                sourcePlural.value = "one";
                return;
            }
        }
    }

    private void getSourceCaseAndPluralPolish(String gender, String value, String desiredCase, String desiredPlural, Output<String> sourceCase, Output<String> sourcePlural) {
        switch (desiredPlural) {
            case "few": {
                sourceCase.value = desiredCase;
                sourcePlural.value = "many";
                boolean isNominative = false;
                block13 : switch (desiredCase) {
                    case "nominative": {
                        isNominative = true;
                    }
                    case "vocative": 
                    case "accusative": {
                        switch (gender) {
                            case "neuter": {
                                if (value.endsWith("um")) {
                                    sourceCase.value = "vocative";
                                    break block13;
                                }
                            }
                            case "feminine": {
                                sourceCase.value = "nominative";
                                sourcePlural.value = "few";
                                break block13;
                            }
                            case "animate": 
                            case "inanimate": {
                                sourceCase.value = "vocative";
                                break block13;
                            }
                            case "personal": {
                                sourceCase.value = isNominative ? "vocative" : "genitive";
                            }
                        }
                    }
                }
                return;
            }
            case "other": {
                sourceCase.value = "genitive";
                sourcePlural.value = "one";
                return;
            }
        }
    }

    static interface Handler3<T, F, U, V> {
        public void apply(T var1, F var2, U var3, V var4);
    }

    static interface Handler4<T, F, U, V> {
        public void apply(T var1, F var2, U var3, V var4);
    }

    public static enum GrammaticalScope {
        general,
        units;

    }

    public static enum GrammaticalFeature {
        grammaticalNumber("plural", "\u24c5", "other", PluralValues.COMPARATOR),
        grammaticalCase("case", "\u24b8", "nominative", CaseValues.COMPARATOR),
        grammaticalDefiniteness("definiteness", "\u24b9", "indefinite", DefinitenessValues.COMPARATOR),
        grammaticalGender("gender", "\u24bc", "neuter", GenderValues.COMPARATOR);

        private final String shortName;
        private final String symbol;
        private final String defaultValue;
        private final Comparator<String> comparator;
        public static final Pattern PATH_HAS_FEATURE;
        static final Map<String, GrammaticalFeature> shortNameToEnum;

        private GrammaticalFeature(String shortName, String symbol, String defaultValue, Comparator<String> comparator) {
            this.shortName = shortName;
            this.symbol = symbol;
            this.defaultValue = defaultValue;
            this.comparator = comparator;
        }

        public String getShortName() {
            return this.shortName;
        }

        public CharSequence getSymbol() {
            return this.symbol;
        }

        public String getDefault(Collection<String> values) {
            return this == grammaticalGender && values != null && !values.contains("neuter") ? "masculine" : this.defaultValue;
        }

        public static Matcher pathHasFeature(String path) {
            Matcher result = PATH_HAS_FEATURE.matcher(path);
            return result.find() ? result : null;
        }

        public static GrammaticalFeature fromName(String name) {
            GrammaticalFeature result = shortNameToEnum.get(name);
            return result != null ? result : GrammaticalFeature.valueOf(name);
        }

        public Comparator getValueComparator() {
            return this.comparator;
        }

        static {
            PATH_HAS_FEATURE = Pattern.compile("\\[@(count|case|gender|definiteness)=");
            shortNameToEnum = ImmutableMap.copyOf(Arrays.asList(GrammaticalFeature.values()).stream().collect(Collectors.toMap(e -> e.shortName, e -> e)));
        }
    }

    public static enum PluralValues {
        zero,
        one,
        two,
        few,
        many,
        other;

        public static Comparator<String> COMPARATOR;

        static {
            COMPARATOR = EnumComparator.create(PluralValues.class);
        }
    }

    public static enum DefinitenessValues {
        indefinite,
        definite,
        construct;

        public static Comparator<String> COMPARATOR;

        static {
            COMPARATOR = EnumComparator.create(DefinitenessValues.class);
        }
    }

    public static enum GenderValues {
        neuter,
        masculine,
        inanimate,
        animate,
        common,
        personal,
        feminine;

        public static Comparator<String> COMPARATOR;

        static {
            COMPARATOR = EnumComparator.create(GenderValues.class);
        }
    }

    public static enum CaseValues {
        nominative,
        vocative,
        accusative,
        oblique,
        genitive,
        dative,
        locative,
        instrumental,
        prepositional,
        ablative,
        adessive,
        allative,
        causal,
        delative,
        elative,
        essive,
        illative,
        inessive,
        sublative,
        superessive,
        terminative,
        translative;

        public static Comparator<String> COMPARATOR;

        static {
            COMPARATOR = EnumComparator.create(CaseValues.class);
        }
    }

    public static enum GrammaticalTarget {
        nominal;

    }
}

