/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.util.Freezable;
import java.util.Objects;

public final class Pair<T extends Comparable<T>, U extends Comparable<U>>
implements Comparable<Pair<T, U>>,
Cloneable,
Freezable<Object> {
    private T first;
    private U second;
    private boolean frozen;

    public static <T extends Comparable<T>, U extends Comparable<U>> Pair<T, U> of(T arg0, U arg1) {
        return new Pair<T, U>(arg0, arg1);
    }

    public static <T extends Comparable<T>, U extends Comparable<U>> Pair<T, U> ofFrozen(T arg0, U arg1) {
        return Pair.of(arg0, arg1).freeze();
    }

    public Pair<T, U> setFirst(T first) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        this.first = first;
        return this;
    }

    public T getFirst() {
        return this.first;
    }

    public Pair<T, U> setSecond(U second) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        this.second = second;
        return this;
    }

    public U getSecond() {
        return this.second;
    }

    public Pair<T, U> set(Pair<T, U> name) {
        this.setFirst(name.getFirst());
        this.setSecond(name.getSecond());
        return this;
    }

    public Pair(T first, U second) {
        this.first = first;
        this.second = second;
    }

    public Pair() {
    }

    public int hashCode() {
        return Utility.checkHash(this.first) * 37 + Utility.checkHash(this.second);
    }

    public boolean equals(Object other) {
        try {
            Pair that = (Pair)other;
            return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int compareTo(Pair<T, U> that) {
        int trial = Utility.checkCompare(this.first, that.first);
        if (trial != 0) {
            return trial;
        }
        return Utility.checkCompare(this.second, that.second);
    }

    public Object clone() {
        if (this.frozen) {
            return this;
        }
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return '(' + (this.first == null ? "null" : this.first.toString()) + ',' + (this.second == null ? "null" : this.second.toString()) + ')';
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public Pair<T, U> freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    public Object cloneAsThawed() {
        try {
            Pair result = (Pair)super.clone();
            result.frozen = false;
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

