/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.Transliterator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.PatternCache;

@Deprecated
public class PrettyPath {
    private Transliterator prettyPathZoneTransform = CheckCLDR.getTransliteratorFromFile("prettyPathZone", "prettyPathZone.txt");
    private Transliterator prettyPathTransform;
    private Map<String, String> prettyPath_path;
    private Map<String, String> path_prettyPath_sortable;
    private boolean showErrors;
    private static Matcher sortingGorpRemoval = PatternCache.get("(?<=(^|[|]))([0-9]+-)?").matcher("");

    public PrettyPath() {
        Transliterator.registerInstance(this.prettyPathZoneTransform);
        this.prettyPathTransform = CheckCLDR.getTransliteratorFromFile("ID", "prettyPath.txt");
        this.prettyPath_path = new HashMap<String, String>();
        this.path_prettyPath_sortable = new HashMap<String, String>();
    }

    public String getPrettyPath(String path) {
        return this.getPrettyPath(path, true);
    }

    public String getPrettyPath(String path, boolean sortable) {
        String prettyString = this.path_prettyPath_sortable.get(path);
        if (this.path_prettyPath_sortable.get(path) == null) {
            prettyString = this.prettyPathTransform.transliterate(path);
            if (prettyString.indexOf("%%") >= 0) {
                if (this.showErrors) {
                    System.out.println("Warning:\tIncomplete translit:\t" + prettyString + "\t " + path);
                }
            } else if (CldrUtility.countInstances(prettyString, "|") != 2 && this.showErrors) {
                System.out.println("Warning:\tpath length != 3: " + prettyString);
            }
            this.path_prettyPath_sortable.put(path, prettyString);
            this.addBackmap(prettyString, path, this.prettyPath_path);
        }
        if (!sortable) {
            return this.getOutputForm(prettyString);
        }
        return prettyString;
    }

    private void addBackmap(String prettyString, String path, Map<String, String> prettyPath_path_map) {
        String old = prettyPath_path_map.get(prettyString);
        if (old != null) {
            if (this.showErrors) {
                System.out.println("Warning:\tFailed bijection, " + prettyString);
            }
            if (this.showErrors) {
                System.out.println("Warning:\tPath1: " + path);
            }
            if (this.showErrors) {
                System.out.println("Warning:\tPath2: " + old);
            }
        } else {
            prettyPath_path_map.put(prettyString, path);
        }
    }

    public String getOriginal(String prettyPath) {
        return this.prettyPath_path.get(prettyPath);
    }

    public String getOutputForm(String prettyPath) {
        try {
            return sortingGorpRemoval.reset(prettyPath).replaceAll("");
        }
        catch (Exception e) {
            return prettyPath;
        }
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public PrettyPath setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
        return this;
    }
}

