/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.RecursiveAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CheckCoverage;
import org.unicode.cldr.test.CheckNew;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.test.OutdatedPaths;
import org.unicode.cldr.test.SubmissionLocales;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRURLS;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.Predicate;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Timer;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.ValuePathStatus;

public class VettingViewer<T> {
    private static boolean SHOW_SUBTYPES = true;
    private static final String CONNECT_PREFIX = "\u208d_";
    private static final String CONNECT_SUFFIX = "\u208e";
    private static final String TH_AND_STYLES = "<th class='tv-th' style='text-align:left'>";
    private static final String SPLIT_CHAR = "\ufffe";
    private static final String TEST_PATH = "//ldml/localeDisplayNames/territories/territory[@type=\"SX\"]";
    private static final double NANOSECS = 1.0E9;
    private static final boolean TESTING = CldrUtility.getProperty("TEST", false);
    public static final Pattern ALT_PROPOSED = PatternCache.get("\\[@alt=\"[^\"]*proposed");
    private static final boolean DEBUG_THREADS = false;
    public static Set<CheckCLDR.CheckStatus.Subtype> OK_IF_VOTED = EnumSet.of(CheckCLDR.CheckStatus.Subtype.sameAsEnglish);
    private static PathHeader.Factory pathTransform;
    static final Pattern breaks;
    static final OutdatedPaths outdatedPaths;
    private final Factory cldrFactory;
    private final CLDRFile englishFile;
    private final UsersChoice<T> userVoteStatus;
    private final SupplementalDataInfo supplementalDataInfo;
    private final String baselineTitle = "Baseline";
    private final String currentWinningTitle;
    private final Set<String> defaultContentLocales;
    private final boolean USE_FORKJOIN = false;
    LanguageTagParser ltp = new LanguageTagParser();
    public static final UnicodeSet LATIN;
    static final NumberFormat nf;
    private Relation<String, String> reasonsToPaths;
    private CLDRURLS urls = CLDRConfig.getInstance().urls();
    private ProgressCallback progressCallback = new ProgressCallback();
    static final Option.Options myOptions;

    public static OutdatedPaths getOutdatedPaths() {
        return outdatedPaths;
    }

    public VettingViewer(SupplementalDataInfo supplementalDataInfo, Factory cldrFactory, UsersChoice<T> userVoteStatus, String currentWinningTitle) {
        this.cldrFactory = cldrFactory;
        this.englishFile = cldrFactory.make("en", true);
        if (pathTransform == null) {
            pathTransform = PathHeader.getFactory(this.englishFile);
        }
        this.userVoteStatus = userVoteStatus;
        this.supplementalDataInfo = supplementalDataInfo;
        this.defaultContentLocales = supplementalDataInfo.getDefaultContentLocales();
        this.currentWinningTitle = currentWinningTitle;
        this.reasonsToPaths = Relation.of(new HashMap(), HashSet.class);
    }

    public void generateHtmlErrorTables(Appendable output, EnumSet<Choice> choices, String localeID, T user, Level usersLevel, boolean quick) {
        Relation<Row.R2<PathHeader.SectionId, PathHeader.PageId>, WritingInfo> sorted = Relation.of(new TreeMap(), TreeSet.class);
        CLDRFile sourceFile = this.cldrFactory.make(localeID, true);
        CLDRFile baselineFile = null;
        if (!quick) {
            try {
                Factory baselineFactory = CLDRConfig.getInstance().getCommonAndSeedAndMainAndAnnotationsFactory();
                baselineFile = baselineFactory.make(localeID, true);
            }
            catch (Exception baselineFactory) {
                // empty catch block
            }
        }
        FileInfo fileInfo = new FileInfo().getFileInfo(sourceFile, baselineFile, sorted, choices, localeID, user, usersLevel, quick);
        this.writeTables(output, sourceFile, baselineFile, sorted, choices, fileInfo, quick);
    }

    public Relation<Row.R2<PathHeader.SectionId, PathHeader.PageId>, WritingInfo> generateFileInfoReview(EnumSet<Choice> choices, String localeID, T user, Level usersLevel, boolean quick, CLDRFile sourceFile, CLDRFile baselineFile) {
        Relation<Row.R2<PathHeader.SectionId, PathHeader.PageId>, WritingInfo> sorted = Relation.of(new TreeMap(), TreeSet.class);
        new FileInfo().getFileInfo(sourceFile, baselineFile, sorted, choices, localeID, user, usersLevel, quick);
        return sorted;
    }

    public void generateSummaryHtmlErrorTables(Appendable output, EnumSet<Choice> choices, T organization) {
        String helpUrl = "http://cldr.unicode.org/translation/getting-started/vetting-view#TOC-Priority-Items";
        try {
            output.append("<p>The following summarizes the Priority Items across locales, using the default coverage levels for your organization for each locale. Before using, please read the instructions at <a target='CLDR_ST_DOCS' href='" + helpUrl + "'>Priority Items Summary</a>.</p>\n");
            StringBuilder headerRow = new StringBuilder();
            headerRow.append("<tr class='tvs-tr'>").append(TH_AND_STYLES).append("Locale</th>").append(TH_AND_STYLES).append("Codes</th>");
            for (Choice choice : choices) {
                headerRow.append("<th class='tv-th'>");
                choice.appendDisplay("", headerRow);
                headerRow.append("</th>");
            }
            headerRow.append("</tr>\n");
            String header = headerRow.toString();
            if (organization.equals((Object)Organization.surveytool)) {
                this.writeSummaryTable(output, header, Level.COMPREHENSIVE, choices, organization);
            } else {
                for (Level level : Level.values()) {
                    this.writeSummaryTable(output, header, level, choices, organization);
                }
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private void writeSummaryTable(Appendable output, String header, Level desiredLevel, EnumSet<Choice> choices, T organization) throws IOException {
        TreeMap<Object, String> sortedNames = new TreeMap<Object, String>(CLDRConfig.getInstance().getCollator());
        LocalesWithExplicitLevel includeLocale = new LocalesWithExplicitLevel((Organization)((Object)organization), desiredLevel);
        for (String localeID : this.cldrFactory.getAvailable()) {
            if (this.defaultContentLocales.contains(localeID) || localeID.equals("en") || !includeLocale.is(localeID)) continue;
            sortedNames.put(this.getName(localeID), localeID);
        }
        if (sortedNames.isEmpty()) {
            return;
        }
        output.append("<h2>Level: ").append(desiredLevel.toString()).append("</h2>");
        output.append("<table class='tvs-table'>\n");
        TreeMap<String, FileInfo> localeNameToFileInfo = new TreeMap<String, FileInfo>();
        FileInfo totals = new FileInfo();
        Set<Map.Entry<String, String>> entrySet = sortedNames.entrySet();
        WriteContext context = new WriteContext(entrySet, choices, organization, totals, localeNameToFileInfo, header);
        WriteAction writeAction = new WriteAction(context);
        System.err.println("WARNING: calling writeAction.computeAll(), as the ForkJoinPool is disabled.");
        writeAction.computeAll();
        context.appendTo(output);
        output.append(header);
        this.writeSummaryRow(output, choices, totals.problemCounter, "Total", null);
        output.append("</table>");
        if (SHOW_SUBTYPES) {
            this.showSubtypes(output, sortedNames, localeNameToFileInfo, totals, true);
            this.showSubtypes(output, sortedNames, localeNameToFileInfo, totals, false);
        }
    }

    private void showSubtypes(Appendable output, Map<String, String> sortedNames, Map<String, FileInfo> localeNameToFileInfo, FileInfo totals, boolean errors) throws IOException {
        output.append("<h3>Details: ").append(errors ? "Error Types" : "Warning Types").append("</h3>");
        output.append("<table class='tvs-table'>");
        Counter<CheckCLDR.CheckStatus.Subtype> subtypeCounterTotals = errors ? totals.errorSubtypeCounter : totals.warningSubtypeCounter;
        Set<CheckCLDR.CheckStatus.Subtype> sortedBySize = subtypeCounterTotals.getKeysetSortedByCount(false);
        this.writeDetailHeader(sortedBySize, output);
        for (Map.Entry<String, FileInfo> entry : localeNameToFileInfo.entrySet()) {
            Counter<CheckCLDR.CheckStatus.Subtype> counter;
            Counter<CheckCLDR.CheckStatus.Subtype> counter2 = counter = errors ? entry.getValue().errorSubtypeCounter : entry.getValue().warningSubtypeCounter;
            if (counter.getTotal() == 0L) continue;
            String name = entry.getKey();
            String localeID = sortedNames.get(name);
            output.append("<tr>").append(TH_AND_STYLES);
            this.appendNameAndCode(name, localeID, output);
            output.append("</th>");
            for (CheckCLDR.CheckStatus.Subtype subtype : sortedBySize) {
                long count = counter.get(subtype);
                output.append("<td class='tvs-count'>");
                if (count != 0L) {
                    output.append(nf.format(count));
                }
                output.append("</td>");
            }
        }
        this.writeDetailHeader(sortedBySize, output);
        output.append("<tr>").append(TH_AND_STYLES).append("<i>Total</i>").append("</th>").append(TH_AND_STYLES).append("</th>");
        for (CheckCLDR.CheckStatus.Subtype subtype : sortedBySize) {
            long count = subtypeCounterTotals.get(subtype);
            output.append("<td class='tvs-count'>");
            if (count != 0L) {
                output.append("<b>").append(nf.format(count)).append("</b>");
            }
            output.append("</td>");
        }
        output.append("</table>");
    }

    private void writeDetailHeader(Set<CheckCLDR.CheckStatus.Subtype> sortedBySize, Appendable output) throws IOException {
        output.append("<tr>").append(TH_AND_STYLES).append("Name").append("</th>").append(TH_AND_STYLES).append("ID").append("</th>");
        for (CheckCLDR.CheckStatus.Subtype subtype : sortedBySize) {
            output.append(TH_AND_STYLES).append(subtype.toString()).append("</th>");
        }
    }

    private void writeSummaryRow(Appendable output, EnumSet<Choice> choices, Counter<Choice> problemCounter, String name, String localeID) throws IOException {
        output.append("<tr>").append(TH_AND_STYLES);
        if (localeID == null) {
            output.append("<i>").append(name).append("</i>").append("</th>").append(TH_AND_STYLES);
        } else {
            this.appendNameAndCode(name, localeID, output);
        }
        output.append("</th>\n");
        for (Choice choice : choices) {
            long count = problemCounter.get(choice);
            output.append("<td class='tvs-count'>");
            if (localeID == null) {
                output.append("<b>");
            }
            output.append(nf.format(count));
            if (localeID == null) {
                output.append("</b>");
            }
            output.append("</td>\n");
        }
        output.append("</tr>\n");
    }

    private void appendNameAndCode(String name, String localeID, Appendable output) throws IOException {
        String[] names = name.split(SPLIT_CHAR);
        output.append("<a href='" + this.urls.forSpecial(CLDRURLS.Special.Vetting, CLDRLocale.getInstance(localeID))).append("'>").append(TransliteratorUtilities.toHTML.transform(names[0])).append("</a>").append("</th>").append(TH_AND_STYLES).append("<code>").append(names[1]).append("</code>");
    }

    private String getName(String localeID) {
        Set<String> contents = this.supplementalDataInfo.getEquivalentsForLocale(localeID);
        String name = this.englishFile.getName(localeID, true, CLDRFile.SHORT_ALTS) + SPLIT_CHAR + VettingViewer.gatherCodes(contents);
        return name;
    }

    public static String gatherCodes(Set<String> contents) {
        LinkedHashSet<Set<String>> source = new LinkedHashSet<Set<String>>();
        for (String s2 : contents) {
            source.add(new LinkedHashSet<String>(Arrays.asList(s2.split("_"))));
        }
        LinkedHashSet<Set<String>> oldSource = new LinkedHashSet<Set<String>>();
        do {
            oldSource.clear();
            oldSource.addAll(source);
            source.clear();
            Set<String> last = null;
            for (Set<String> set : oldSource) {
                if (last == null) {
                    last = set;
                    continue;
                }
                if (set.containsAll(last)) {
                    last = VettingViewer.combine(last, set);
                    continue;
                }
                source.add(last);
                last = set;
            }
            source.add(last);
        } while (oldSource.size() != source.size());
        StringBuilder b = new StringBuilder();
        for (Set set : source) {
            if (b.length() != 0) {
                b.append(", ");
            }
            String sep = "";
            for (String string : set) {
                if (string.startsWith(CONNECT_PREFIX)) {
                    b.append(string + CONNECT_SUFFIX);
                } else {
                    b.append(sep + string);
                }
                sep = "_";
            }
        }
        return b.toString();
    }

    private static Set<String> combine(Set<String> last, Set<String> ss) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String s2 : ss) {
            if (last.contains(s2)) {
                result.add(s2);
                continue;
            }
            result.add(CONNECT_PREFIX + s2);
        }
        return result;
    }

    public static MissingStatus getMissingStatus(CLDRFile sourceFile, String path, boolean latin) {
        String localeFound;
        boolean isAliased;
        if (sourceFile == null) {
            return MissingStatus.ABSENT;
        }
        if ("root".equals(sourceFile.getLocaleID()) || path.startsWith("//ldml/layout/orientation/")) {
            return MissingStatus.MISSING_OK;
        }
        if (path.equals(TEST_PATH)) {
            boolean bl = true;
        }
        String value = sourceFile.getStringValue(path);
        CLDRFile.Status status = new CLDRFile.Status();
        sourceFile.getSourceLocaleID(path, status);
        boolean bl = isAliased = !path.equals(status.pathWhereFound);
        MissingStatus result = value == null ? (ValuePathStatus.isMissingOk(sourceFile, path, latin, isAliased) ? MissingStatus.MISSING_OK : MissingStatus.ABSENT) : ((localeFound = sourceFile.getSourceLocaleIdExtended(path, status, false)).equals("root") || localeFound.equals("code-fallback") ? (ValuePathStatus.isMissingOk(sourceFile, path, latin, isAliased) || sourceFile.getLocaleID().equals("en") ? MissingStatus.ROOT_OK : MissingStatus.ABSENT) : (isAliased ? MissingStatus.ALIASED : MissingStatus.PRESENT));
        return result;
    }

    public static boolean isLatinScriptLocale(CLDRFile sourceFile) {
        return ValuePathStatus.isLatinScriptLocale(sourceFile);
    }

    private static StringBuilder appendToMessage(CharSequence usersValue, CheckCLDR.CheckStatus.Subtype subtype, StringBuilder testMessage) {
        if (subtype != null) {
            usersValue = "&lt;" + (Object)((Object)subtype) + "&gt; " + usersValue;
        }
        return VettingViewer.appendToMessage(usersValue, testMessage);
    }

    private static StringBuilder appendToMessage(CharSequence usersValue, StringBuilder testMessage) {
        if (usersValue.length() == 0) {
            return testMessage;
        }
        if (testMessage.length() != 0) {
            testMessage.append("<br>");
        }
        return testMessage.append(usersValue);
    }

    public VettingViewer<T> setProgressCallback(ProgressCallback newCallback) {
        this.progressCallback = newCallback;
        return this;
    }

    public static String getHeaderStyles() {
        return "<style>\n.hide {display:none}\n.vve {}\n.vvn {}\n.vvp {}\n.vvl {}\n.vvm {}\n.vvu {}\n.vvw {}\n.vvd {}\n.vvo {}\n</style>";
    }

    private void writeTables(Appendable output, CLDRFile sourceFile, CLDRFile baselineFile, Relation<Row.R2<PathHeader.SectionId, PathHeader.PageId>, WritingInfo> sorted, EnumSet<Choice> choices, FileInfo outputFileInfo, boolean quick) {
        try {
            boolean latin = VettingViewer.isLatinScriptLocale(sourceFile);
            output.append("<h2>Summary</h2>\n").append("<p><i>It is important that you read <a target='CLDR-ST-DOCS' href='http://cldr.unicode.org/translation/vetting-view'>Priority Items</a> before starting!</i></p>").append("<form name='checkboxes' action='#'>\n").append("<table class='tvs-table'>\n").append("<tr class='tvs-tr'><th class='tv-th'>Count</th><th class='tv-th'>Issue</th><th class='tv-th'>Description</th></tr>\n");
            Choice checkedItem = null;
            for (Choice choice : choices) {
                if (quick && choice != Choice.error && choice != Choice.warning) continue;
                long count = outputFileInfo.problemCounter.get(choice);
                output.append("<tr><td class='tvs-count'>").append(nf.format(count)).append("</td>\n\t<td nowrap class='tvs-abb'>").append("<input type='checkbox' name='").append(Character.toLowerCase(choice.abbreviation)).append("' onclick='setStyles()'");
                if (checkedItem == choice || checkedItem == null && count != 0L) {
                    output.append(" checked");
                    checkedItem = choice;
                }
                output.append(">");
                choice.appendDisplay("", output);
                output.append("</td>\n\t<td class='tvs-desc'>").append(choice.description).append("</td></tr>\n");
            }
            output.append("</table>\n</form>\n<script>\n<!-- \nsetStyles()\n-->\n</script>");
            Relation<Row.R3<PathHeader.SectionId, PathHeader.PageId, String>, Choice> choicesForHeader = Relation.of(new HashMap(), HashSet.class);
            Relation<Row.R2<PathHeader.SectionId, PathHeader.PageId>, Choice> choicesForSection = Relation.of(new HashMap(), HashSet.class);
            for (Map.Entry<Row.R2<PathHeader.SectionId, PathHeader.PageId>, Set<WritingInfo>> entry0 : sorted.keyValuesSet()) {
                PathHeader.SectionId section = (PathHeader.SectionId)((Object)entry0.getKey().get0());
                PathHeader.PageId subsection = (PathHeader.PageId)((Object)entry0.getKey().get1());
                Set<WritingInfo> rows = entry0.getValue();
                for (WritingInfo pathInfo : rows) {
                    String header = pathInfo.codeOutput.getHeader();
                    Set<Choice> choicesForPath = pathInfo.problems;
                    choicesForSection.putAll(Row.of(section, subsection), choicesForPath);
                    choicesForHeader.putAll(Row.of(section, subsection, header), choicesForPath);
                }
            }
            String localeId = sourceFile.getLocaleID();
            CLDRLocale locale = CLDRLocale.getInstance(localeId);
            int count = 0;
            for (Map.Entry<Row.R2<PathHeader.SectionId, PathHeader.PageId>, Set<WritingInfo>> entry0 : sorted.keyValuesSet()) {
                PathHeader.SectionId section = (PathHeader.SectionId)((Object)entry0.getKey().get0());
                PathHeader.PageId subsection = (PathHeader.PageId)((Object)entry0.getKey().get1());
                Set<WritingInfo> rows = entry0.getValue();
                rows.iterator().next();
                output.append("\n<h2 class='tv-s'>Section: ").append(section.toString()).append(" \u2014 <i><a href='").append(this.urls.forPage(locale, subsection)).append("'>Page: ").append(subsection.toString()).append("</a></i> (" + rows.size() + ")</h2>\n");
                this.startTable(choicesForSection.get(Row.of(section, subsection)), output);
                String oldHeader = "";
                for (WritingInfo pathInfo : rows) {
                    String header = pathInfo.codeOutput.getHeader();
                    String code = pathInfo.codeOutput.getCode();
                    String path = pathInfo.codeOutput.getOriginalPath();
                    Set<Choice> choicesForPath = pathInfo.problems;
                    if (!header.equals(oldHeader)) {
                        Set<Choice> headerChoices = choicesForHeader.get(Row.of(section, subsection, header));
                        output.append("<tr class='");
                        Choice.appendRowStyles(headerChoices, output);
                        output.append("'>\n");
                        output.append(" <th class='partsection' colSpan='6'>");
                        output.append(header);
                        output.append("</th>\n</tr>\n");
                        oldHeader = header;
                    }
                    output.append("<tr class='");
                    Choice.appendRowStyles(choicesForPath, output);
                    output.append("'>\n");
                    this.addCell(output, nf.format(++count), null, "tv-num", HTMLType.plain);
                    this.addCell(output, code, null, "tv-code", HTMLType.plain);
                    if (choicesForPath.contains((Object)Choice.englishChanged)) {
                        String winning = this.englishFile.getWinningValue(path);
                        String cellValue = winning == null ? "<i>missing</i>" : TransliteratorUtilities.toHTML.transform(winning);
                        String previous = outdatedPaths.getPreviousEnglish(path);
                        cellValue = previous != null ? cellValue + "<br><span style='color:#900'><b>OLD: </b>" + TransliteratorUtilities.toHTML.transform(previous) + "</span>" : cellValue + "<br><b><i>missing</i></b>";
                        this.addCell(output, cellValue, null, "tv-eng", HTMLType.markup);
                    } else {
                        this.addCell(output, this.englishFile.getWinningValue(path), null, "tv-eng", HTMLType.plain);
                    }
                    String oldStringValue = baselineFile == null ? null : baselineFile.getWinningValue(path);
                    MissingStatus oldValueMissing = VettingViewer.getMissingStatus(baselineFile, path, latin);
                    this.addCell(output, oldStringValue, null, oldValueMissing != MissingStatus.PRESENT ? "tv-miss" : "tv-last", HTMLType.plain);
                    String newWinningValue = sourceFile.getWinningValue(path);
                    if (Objects.equals(newWinningValue, oldStringValue)) {
                        newWinningValue = "=";
                    }
                    this.addCell(output, newWinningValue, null, choicesForPath.contains((Object)Choice.missingCoverage) ? "tv-miss" : "tv-win", HTMLType.plain);
                    output.append(" <td class='tv-fix'><a target='_blank' href='").append(pathInfo.getUrl(locale)).append("'>");
                    Choice.appendDisplay(choicesForPath, "", output);
                    output.append("</a></td>");
                    if (!pathInfo.htmlMessage.isEmpty()) {
                        this.addCell(output, pathInfo.htmlMessage, null, "tv-test", HTMLType.markup);
                    }
                    output.append("</tr>\n");
                }
                output.append("</table>\n");
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public ArrayList<String> getErrorOnPath(EnumSet<Choice> choices, String localeID, T user, Level usersLevel, String path) {
        Relation sorted = Relation.of(new TreeMap(), TreeSet.class);
        CLDRFile sourceFile = this.cldrFactory.make(localeID, true);
        CLDRFile baselineFile = null;
        try {
            Factory baselineFactory = CLDRConfig.getInstance().getCommonAndSeedAndMainAndAnnotationsFactory();
            baselineFile = baselineFactory.make(localeID, true);
        }
        catch (Exception baselineFactory) {
            // empty catch block
        }
        EnumSet<Choice> errors = ((FileInfo)(VettingViewer)this.new FileInfo()).getFileInfo((CLDRFile)sourceFile, (CLDRFile)baselineFile, sorted, choices, (String)localeID, user, (Level)usersLevel, (boolean)false, (String)path).problems;
        ArrayList<String> out = new ArrayList<String>();
        for (Object error : errors.toArray()) {
            out.add(((Choice)((Object)error)).buttonLabel);
        }
        return out;
    }

    private void startTable(Set<Choice> choices, Appendable output) throws IOException {
        output.append("<table class='tv-table'>\n");
        output.append("<tr class='");
        Choice.appendRowStyles(choices, output);
        output.append("'><th class='tv-th'>No.</th><th class='tv-th'>Code</th><th class='tv-th'>English</th><th class='tv-th'>Baseline</th><th class='tv-th'>" + this.currentWinningTitle + "</th><th class='tv-th'>Fix?</th><th class='tv-th'>Comment</th></tr>\n");
    }

    private void addCell(Appendable output, String value, String title, String classValue, HTMLType htmlType) throws IOException {
        output.append(" <td class='").append(classValue);
        if (value == null) {
            output.append(" tv-null'><i>missing</i></td>");
        } else {
            if (title != null && !title.equals(value)) {
                output.append("title='").append(TransliteratorUtilities.toHTML.transform(title)).append('\'');
            }
            output.append("'>").append(htmlType == HTMLType.markup ? value : TransliteratorUtilities.toHTML.transform(value)).append("</td>\n");
        }
    }

    public static void getStatus(CLDRFile file, PathHeader.Factory pathHeaderFactory, Counter<Level> foundCounter, Counter<Level> unconfirmedCounter, Counter<Level> missingCounter, Relation<MissingStatus, String> missingPaths, Set<String> unconfirmedPaths) {
        VettingViewer.getStatus(file.fullIterable(), file, pathHeaderFactory, foundCounter, unconfirmedCounter, missingCounter, missingPaths, unconfirmedPaths);
    }

    public static void getStatus(Iterable<String> allPaths, CLDRFile file, PathHeader.Factory pathHeaderFactory, Counter<Level> foundCounter, Counter<Level> unconfirmedCounter, Counter<Level> missingCounter, Relation<MissingStatus, String> missingPaths, Set<String> unconfirmedPaths) {
        if (!file.isResolved()) {
            throw new IllegalArgumentException("File must be resolved, no minimal draft status");
        }
        foundCounter.clear();
        unconfirmedCounter.clear();
        missingCounter.clear();
        boolean latin = VettingViewer.isLatinScriptLocale(file);
        CoverageLevel2 coverageLevel2 = CoverageLevel2.getInstance(SupplementalDataInfo.getInstance(), file.getLocaleID());
        block5: for (String path : allPaths) {
            PathHeader ph = pathHeaderFactory.fromPath(path);
            if (ph.getSectionId() == PathHeader.SectionId.Special) continue;
            Level level = coverageLevel2.getLevel(path);
            MissingStatus missingStatus = VettingViewer.getMissingStatus(file, path, latin);
            switch (missingStatus) {
                case ABSENT: {
                    missingCounter.add(level, 1L);
                    if (missingPaths == null || level.compareTo(Level.MODERN) > 0) continue block5;
                    missingPaths.put(missingStatus, path);
                    continue block5;
                }
                case ALIASED: 
                case PRESENT: {
                    String fullPath = file.getFullXPath(path);
                    if (fullPath.contains("unconfirmed") || fullPath.contains("provisional")) {
                        unconfirmedCounter.add(level, 1L);
                        if (unconfirmedPaths == null || level.compareTo(Level.MODERN) > 0) continue block5;
                        unconfirmedPaths.add(path);
                        continue block5;
                    }
                    foundCounter.add(level, 1L);
                    continue block5;
                }
                case MISSING_OK: 
                case ROOT_OK: {
                    continue block5;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static void main(String[] args) throws IOException {
        SHOW_SUBTYPES = true;
        myOptions.parse(MyOptions.source, args, true);
        boolean repeat = MyOptions.repeat.option.doesOccur();
        String fileFilter = MyOptions.filter.option.getValue();
        String myOutputDir = repeat ? null : MyOptions.output.option.getValue();
        String LOCALE = MyOptions.locale.option.getValue();
        String[] DIRECTORIES2 = MyOptions.source.option.getValue().split(",\\s*");
        File[] fileDirectories = new File[DIRECTORIES2.length];
        int i = 0;
        for (String s2 : DIRECTORIES2) {
            fileDirectories[i++] = new File(s2);
        }
        do {
            Timer timer = new Timer();
            timer.start();
            Factory cldrFactory = SimpleFactory.make(fileDirectories, fileFilter);
            cldrFactory.setSupplementalDirectory(new File(CLDRPaths.SUPPLEMENTAL_DIRECTORY));
            SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
            CheckCLDR.setDisplayInformation(cldrFactory.make("en", true));
            UsersChoice<Organization> usersChoice = new UsersChoice<Organization>(){

                @Override
                public String getWinningValueForUsersOrganization(CLDRFile cldrFile, String path, Organization user) {
                    if (path.contains("USD")) {
                        return "&dummy \u2018losing\u2019 value";
                    }
                    return null;
                }

                @Override
                public VoteStatus getStatusForUsersOrganization(CLDRFile cldrFile, String path, Organization user) {
                    String usersValue = this.getWinningValueForUsersOrganization(cldrFile, path, user);
                    String winningValue = cldrFile.getWinningValue(path);
                    if (usersValue != null && !Objects.equals(usersValue, winningValue)) {
                        return VoteStatus.losing;
                    }
                    String fullPath = cldrFile.getFullXPath(path);
                    if (fullPath.contains("AMD") || fullPath.contains("unconfirmed") || fullPath.contains("provisional")) {
                        return VoteStatus.provisionalOrWorse;
                    }
                    if (fullPath.contains("AED")) {
                        return VoteStatus.disputed;
                    }
                    if (fullPath.contains("AED")) {
                        return VoteStatus.ok_novotes;
                    }
                    return VoteStatus.ok;
                }
            };
            VettingViewer<Organization> tableView = new VettingViewer<Organization>(supplementalDataInfo, cldrFactory, usersChoice, "Winning Proposed");
            EnumSet<Choice> choiceSet = EnumSet.allOf(Choice.class);
            String localeStringID = LOCALE;
            int userNumericID = 666;
            Level usersLevel = Level.MODERN;
            if (!repeat) {
                FileCopier.ensureDirectoryExists(myOutputDir);
                FileCopier.copy(VettingViewer.class, "vettingView.css", myOutputDir);
                FileCopier.copy(VettingViewer.class, "vettingView.js", myOutputDir);
            }
            System.out.println("Creation: " + (double)timer.getDuration() / 1.0E9 + " secs");
            timer.start();
            VettingViewer.writeFile(myOutputDir, tableView, choiceSet, "", localeStringID, userNumericID, usersLevel, CodeChoice.newCode, null);
            System.out.println("Code: " + (double)timer.getDuration() / 1.0E9 + " secs");
            timer.start();
            VettingViewer.writeFile(myOutputDir, tableView, choiceSet, "", localeStringID, userNumericID, usersLevel, CodeChoice.summary, Organization.google);
            System.out.println("Summary: " + (double)timer.getDuration() / 1.0E9 + " secs");
        } while (repeat);
    }

    public static void writeFile(String myOutputDir, VettingViewer<Organization> tableView, EnumSet<Choice> choiceSet, String name, String localeStringID, int userNumericID, Level usersLevel, CodeChoice newCode, Organization organization) throws IOException {
        PrintWriter out = myOutputDir == null ? new PrintWriter(new StringWriter()) : FileUtilities.openUTF8Writer(myOutputDir, "vettingView" + name + (newCode == CodeChoice.newCode ? "" : (newCode == CodeChoice.summary ? "-summary" : "")) + (organization == null ? "" : "-" + organization.toString()) + ".html");
        FileCopier.copy(VettingViewer.class, "vettingViewerHead.txt", out);
        out.append(VettingViewer.getHeaderStyles());
        out.append("</head><body>\n");
        out.println("<p>Note: this is just a sample run. The user, locale, user's coverage level, and choices of tests will change the output. In a real ST page using these, the first three would come from context, and the choices of tests would be set with radio buttons. Demo settings are: </p>\n<ol><li>choices: " + choiceSet + "</li><li>localeStringID: " + localeStringID + "</li><li>userNumericID: " + userNumericID + "</li><li>usersLevel: " + (Object)((Object)usersLevel) + "</ol><p>Notes: This is a static version, using old values and faked values (L) just for testing." + (TESTING ? "Also, the white cell after the Fix column is just for testing." : "") + "</p><hr>\n");
        switch (newCode) {
            case newCode: {
                tableView.generateHtmlErrorTables(out, choiceSet, localeStringID, organization, usersLevel, false);
                break;
            }
            case summary: {
                tableView.generateSummaryHtmlErrorTables(out, choiceSet, organization);
            }
        }
        out.println("</body>\n</html>\n");
        out.close();
    }

    static {
        breaks = PatternCache.get("\\|");
        outdatedPaths = new OutdatedPaths();
        LATIN = ValuePathStatus.LATIN;
        nf = NumberFormat.getIntegerInstance(ULocale.ENGLISH);
        nf.setGroupingUsed(true);
        myOptions = new Option.Options();
    }

    private static enum CodeChoice {
        newCode,
        summary;

    }

    static enum MyOptions {
        repeat(null, null, "Repeat indefinitely"),
        filter(".*", ".*", "Filter files"),
        locale(".*", "af", "Single locale for testing"),
        source(".*", CLDRPaths.MAIN_DIRECTORY + "," + CLDRPaths.ANNOTATIONS_DIRECTORY, "if summary, creates filtered version (eg -d main): does a find in the name, which is of the form dir/file"),
        verbose(null, null, "verbose debugging messages"),
        output(".*", CLDRPaths.GEN_DIRECTORY + "vetting/", "filter the raw files (non-summary, mostly for debugging)");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }

    static enum HTMLType {
        plain,
        markup;

    }

    public static class ProgressCallback {
        public void nudge() {
        }

        public void done() {
        }

        public boolean isStopped() {
            return false;
        }
    }

    public static enum MissingStatus {
        PRESENT,
        ALIASED,
        MISSING_OK,
        ROOT_OK,
        ABSENT;

    }

    private class WriteAction
    extends RecursiveAction {
        private int length;
        private int start;
        private WriteContext context;
        private static final long serialVersionUID = 1L;

        public WriteAction(WriteContext context) {
            this(context, 0, context.size());
        }

        public WriteAction(WriteContext context, int start, int length) {
            this.context = context;
            this.start = start;
            this.length = length;
        }

        @Override
        protected void compute() {
            if (this.length == 0) {
                return;
            }
            if (this.length <= this.context.configChunkSize) {
                this.computeAll();
            } else {
                int split = this.length / 2;
                WriteAction.invokeAll(new WriteAction(this.context, this.start, split), new WriteAction(this.context, this.start + split, this.length - split));
            }
        }

        public void computeAll() {
            for (int n = this.start; n < this.start + this.length; ++n) {
                this.computeOne(n);
            }
        }

        void computeOne(int n) {
            if (VettingViewer.this.progressCallback.isStopped()) {
                throw new RuntimeException("Requested to stop");
            }
            String name = (String)this.context.localeNames.get(n);
            String localeID = (String)this.context.localeIds.get(n);
            EnumSet choices = this.context.choices;
            StringBuffer output = this.context.outputs[n];
            if (output == null) {
                throw new NullPointerException("output " + n + " null");
            }
            CLDRFile sourceFile = VettingViewer.this.cldrFactory.make(localeID, true);
            CLDRFile baselineFile = null;
            if (!this.context.ourChoicesThatRequireOldFile.isEmpty()) {
                try {
                    Factory baselineFactory = CLDRConfig.getInstance().getCommonAndSeedAndMainAndAnnotationsFactory();
                    baselineFile = baselineFactory.make(localeID, true);
                }
                catch (Exception baselineFactory) {
                    // empty catch block
                }
            }
            Level level = Level.MODERN;
            if (this.context.organization != null) {
                level = StandardCodes.make().getLocaleCoverageLevel(this.context.organization.toString(), localeID);
            }
            FileInfo fileInfo = new FileInfo().getFileInfo(sourceFile, baselineFile, null, choices, localeID, this.context.organization, level, false);
            this.context.localeNameToFileInfo.put(name, fileInfo);
            this.context.totals.addAll(fileInfo);
            try {
                VettingViewer.this.writeSummaryRow(output, choices, fileInfo.problemCounter, name, localeID);
            }
            catch (IOException e) {
                System.err.println("writeAction.compute(" + n + ") - writeexc " + name + ": " + localeID);
                this.completeExceptionally(new RuntimeException("While writing " + localeID, e));
            }
            System.err.println("writeAction.compute(" + n + ") - DONE " + name + ": " + localeID);
        }
    }

    private class WriteContext {
        private List<String> localeNames = new ArrayList<String>();
        private List<String> localeIds = new ArrayList<String>();
        private StringBuffer[] outputs;
        private EnumSet<Choice> choices;
        private EnumSet<Choice> thingsThatRequireOldFile;
        private EnumSet<Choice> ourChoicesThatRequireOldFile;
        private T organization;
        private FileInfo totals;
        private Map<String, FileInfo> localeNameToFileInfo;
        private String header;
        private int configParallel;
        private int configChunkSize;

        public WriteContext(Set<Map.Entry<String, String>> entrySet, EnumSet<Choice> choices, T organization, FileInfo totals, Map<String, FileInfo> localeNameToFileInfo, String header) {
            for (Map.Entry<String, String> e : entrySet) {
                this.localeNames.add(e.getKey());
                this.localeIds.add(e.getValue());
            }
            int count = this.localeNames.size();
            this.outputs = new StringBuffer[count];
            for (int i = 0; i < count; ++i) {
                this.outputs[i] = new StringBuffer();
            }
            this.choices = choices;
            this.thingsThatRequireOldFile = EnumSet.of(Choice.englishChanged, Choice.missingCoverage, Choice.changedOldValue);
            this.ourChoicesThatRequireOldFile = choices.clone();
            this.ourChoicesThatRequireOldFile.retainAll(this.thingsThatRequireOldFile);
            this.organization = organization;
            this.totals = totals;
            this.localeNameToFileInfo = localeNameToFileInfo;
            this.header = header;
            CLDRConfig config = CLDRConfig.getInstance();
            this.configParallel = Math.max(config.getProperty("CLDR_VETTINGVIEWER_PARALLEL", 0), 0);
            if (this.configParallel < 1) {
                this.configParallel = Runtime.getRuntime().availableProcessors();
            }
            this.configChunkSize = Math.max(config.getProperty("CLDR_VETTINGVIEWER_CHUNKSIZE", 1), 1);
            System.err.println("vv: CLDR_VETTINGVIEWER_PARALLEL=" + this.configParallel + ", CLDR_VETTINGVIEWER_CHUNKSIZE=" + this.configChunkSize);
        }

        public void appendTo(Appendable output) throws IOException {
            char lastChar = ' ';
            for (int n = 0; n < this.outputs.length; ++n) {
                String name = this.localeNames.get(n);
                output.append(this.outputs[n]);
                char nextChar = name.charAt(0);
                if (lastChar == nextChar) continue;
                output.append(this.header);
                lastChar = nextChar;
            }
        }

        public int size() {
            return this.localeNames.size();
        }
    }

    public static final class LocalesWithExplicitLevel
    implements Predicate<String> {
        private final Organization org;
        private final Level desiredLevel;

        public LocalesWithExplicitLevel(Organization org, Level level) {
            this.org = org;
            this.desiredLevel = level;
        }

        @Override
        public boolean is(String localeId) {
            Output<StandardCodes.LocaleCoverageType> output = new Output<StandardCodes.LocaleCoverageType>();
            if (this.org.equals((Object)Organization.surveytool)) {
                for (Organization checkorg : Organization.values()) {
                    StandardCodes.make().getLocaleCoverageLevel(checkorg, localeId, output);
                    if (output.value != StandardCodes.LocaleCoverageType.explicit) continue;
                    return true;
                }
                return false;
            }
            Level level = StandardCodes.make().getLocaleCoverageLevel(this.org, localeId, output);
            return this.desiredLevel == level && output.value == StandardCodes.LocaleCoverageType.explicit;
        }
    }

    class FileInfo {
        Counter<Choice> problemCounter = new Counter();
        Counter<CheckCLDR.CheckStatus.Subtype> errorSubtypeCounter = new Counter();
        Counter<CheckCLDR.CheckStatus.Subtype> warningSubtypeCounter = new Counter();
        EnumSet<Choice> problems = EnumSet.noneOf(Choice.class);

        FileInfo() {
        }

        public void addAll(FileInfo other) {
            this.problemCounter.addAll(other.problemCounter);
            this.errorSubtypeCounter.addAll(other.errorSubtypeCounter);
            this.warningSubtypeCounter.addAll(other.warningSubtypeCounter);
        }

        private FileInfo getFileInfo(CLDRFile sourceFile, CLDRFile baselineFile, Relation<Row.R2<PathHeader.SectionId, PathHeader.PageId>, WritingInfo> sorted, EnumSet<Choice> choices, String localeID, T user, Level usersLevel, boolean quick) {
            return this.getFileInfo(sourceFile, baselineFile, sorted, choices, localeID, user, usersLevel, quick, null);
        }

        private FileInfo getFileInfo(CLDRFile sourceFile, CLDRFile baselineFile, Relation<Row.R2<PathHeader.SectionId, PathHeader.PageId>, WritingInfo> sorted, EnumSet<Choice> choices, String localeID, T user, Level usersLevel, boolean quick, String xpath) {
            if (VettingViewer.this.progressCallback.isStopped()) {
                throw new RuntimeException("Requested to stop");
            }
            DefaultErrorStatus errorChecker = new DefaultErrorStatus(VettingViewer.this.cldrFactory);
            errorChecker.initErrorStatus(sourceFile);
            Matcher altProposed = ALT_PROPOSED.matcher("");
            this.problems = EnumSet.noneOf(Choice.class);
            StringBuilder htmlMessage = new StringBuilder();
            StringBuilder statusMessage = new StringBuilder();
            EnumSet<CheckCLDR.CheckStatus.Subtype> subtypes = EnumSet.noneOf(CheckCLDR.CheckStatus.Subtype.class);
            HashSet<String> seenSoFar = new HashSet<String>();
            boolean latin = VettingViewer.isLatinScriptLocale(sourceFile);
            CLDRFile baselineFileUnresolved = baselineFile == null ? null : baselineFile.getUnresolved();
            for (String path : sourceFile.fullIterable()) {
                Choice choice;
                VoteStatus voteStatus;
                String oldValue;
                if (xpath != null && !xpath.equals(path)) continue;
                String value = sourceFile.getWinningValueForVettingViewer(path);
                statusMessage.setLength(0);
                subtypes.clear();
                ErrorChecker.Status errorStatus = errorChecker.getErrorStatus(path, value, statusMessage, subtypes);
                if (quick && errorStatus != ErrorChecker.Status.error && errorStatus != ErrorChecker.Status.warning || seenSoFar.contains(path)) continue;
                seenSoFar.add(path);
                VettingViewer.this.progressCallback.nudge();
                PathHeader pretty = pathTransform.fromPath(path);
                if (pretty.getSurveyToolStatus() == PathHeader.SurveyToolStatus.HIDE || altProposed.reset(path).find() || path.contains("/references")) continue;
                Level level = VettingViewer.this.supplementalDataInfo.getCoverageLevel(path, sourceFile.getLocaleID());
                boolean onlyRecordErrors = false;
                if (level.compareTo(usersLevel) > 0) {
                    onlyRecordErrors = true;
                }
                this.problems.clear();
                htmlMessage.setLength(0);
                String string = oldValue = baselineFileUnresolved == null ? null : baselineFileUnresolved.getWinningValue(path);
                if (!onlyRecordErrors && choices.contains((Object)Choice.changedOldValue) && oldValue != null && !oldValue.equals(value)) {
                    this.problems.add(Choice.changedOldValue);
                    this.problemCounter.increment(Choice.changedOldValue);
                }
                boolean itemsOkIfVoted = (voteStatus = VettingViewer.this.userVoteStatus.getStatusForUsersOrganization(sourceFile, path, user)) == VoteStatus.ok;
                MissingStatus missingStatus = null;
                if (!onlyRecordErrors) {
                    missingStatus = VettingViewer.getMissingStatus(sourceFile, path, latin);
                    if (choices.contains((Object)Choice.missingCoverage) && missingStatus == MissingStatus.ABSENT) {
                        this.problems.add(Choice.missingCoverage);
                        this.problemCounter.increment(Choice.missingCoverage);
                    }
                    if (SubmissionLocales.pathAllowedInLimitedSubmission(path)) {
                        this.problems.add(Choice.englishChanged);
                        this.problemCounter.increment(Choice.englishChanged);
                    }
                    if (!itemsOkIfVoted && outdatedPaths.isOutdated(localeID, path) && Objects.equals(value, oldValue) && choices.contains((Object)Choice.englishChanged)) {
                        this.problems.add(Choice.englishChanged);
                        this.problemCounter.increment(Choice.englishChanged);
                    }
                }
                Choice choice2 = errorStatus == ErrorChecker.Status.error ? Choice.error : (choice = errorStatus == ErrorChecker.Status.warning ? Choice.warning : null);
                if (!(choice != Choice.error || !choices.contains((Object)Choice.error) || itemsOkIfVoted && OK_IF_VOTED.containsAll(subtypes))) {
                    this.problems.add(choice);
                    VettingViewer.appendToMessage(statusMessage, htmlMessage);
                    this.problemCounter.increment(choice);
                    for (CheckCLDR.CheckStatus.Subtype subtype : subtypes) {
                        this.errorSubtypeCounter.increment(subtype);
                    }
                } else if (!(onlyRecordErrors || choice != Choice.warning || !choices.contains((Object)Choice.warning) || itemsOkIfVoted && OK_IF_VOTED.containsAll(subtypes))) {
                    this.problems.add(choice);
                    VettingViewer.appendToMessage(statusMessage, htmlMessage);
                    this.problemCounter.increment(choice);
                    for (CheckCLDR.CheckStatus.Subtype subtype : subtypes) {
                        this.warningSubtypeCounter.increment(subtype);
                    }
                }
                if (!onlyRecordErrors) {
                    switch (voteStatus) {
                        case losing: {
                            String usersValue;
                            if (choices.contains((Object)Choice.weLost)) {
                                this.problems.add(Choice.weLost);
                                this.problemCounter.increment(Choice.weLost);
                            }
                            if ((usersValue = VettingViewer.this.userVoteStatus.getWinningValueForUsersOrganization(sourceFile, path, user)) == null) break;
                            usersValue = "Losing value: <" + TransliteratorUtilities.toHTML.transform(usersValue) + ">";
                            VettingViewer.appendToMessage(usersValue, htmlMessage);
                            break;
                        }
                        case disputed: {
                            if (!choices.contains((Object)Choice.hasDispute)) break;
                            this.problems.add(Choice.hasDispute);
                            this.problemCounter.increment(Choice.hasDispute);
                            break;
                        }
                        case provisionalOrWorse: {
                            if (missingStatus != MissingStatus.PRESENT || !choices.contains((Object)Choice.notApproved)) break;
                            this.problems.add(Choice.notApproved);
                            this.problemCounter.increment(Choice.notApproved);
                            break;
                        }
                    }
                }
                if (xpath != null) {
                    return this;
                }
                if (this.problems.isEmpty() || sorted == null) continue;
                VettingViewer.this.reasonsToPaths.clear();
                Row.R2<PathHeader.SectionId, PathHeader.PageId> group = Row.of(pretty.getSectionId(), pretty.getPageId());
                sorted.put(group, new WritingInfo(pretty, this.problems, htmlMessage));
            }
            return this;
        }
    }

    public class WritingInfo
    implements Comparable<WritingInfo> {
        public final PathHeader codeOutput;
        public final Set<Choice> problems;
        public final String htmlMessage;

        public WritingInfo(PathHeader pretty, EnumSet<Choice> problems, CharSequence htmlMessage) {
            this.codeOutput = pretty;
            this.problems = Collections.unmodifiableSet(problems.clone());
            this.htmlMessage = htmlMessage.toString();
        }

        @Override
        public int compareTo(WritingInfo other) {
            return this.codeOutput.compareTo(other.codeOutput);
        }

        public String getUrl(CLDRLocale locale) {
            return VettingViewer.this.urls.forPathHeader(locale, this.codeOutput);
        }
    }

    public static class DefaultErrorStatus
    implements ErrorChecker {
        private CheckCLDR checkCldr;
        private HashMap<String, String> options = new HashMap();
        private ArrayList<CheckCLDR.CheckStatus> result = new ArrayList();
        private CLDRFile cldrFile;
        private Factory factory;

        public DefaultErrorStatus(Factory cldrFactory) {
            this.factory = cldrFactory;
        }

        @Override
        public ErrorChecker.Status initErrorStatus(CLDRFile cldrFile) {
            this.cldrFile = cldrFile;
            this.options = new HashMap();
            this.result = new ArrayList();
            this.checkCldr = CheckCLDR.getCheckAll(this.factory, ".*");
            this.checkCldr.setCldrFileToCheck(cldrFile, this.options, this.result);
            return ErrorChecker.Status.ok;
        }

        @Override
        public List<CheckCLDR.CheckStatus> getErrorCheckStatus(String path, String value) {
            String fullPath = this.cldrFile.getFullXPath(path);
            ArrayList<CheckCLDR.CheckStatus> result2 = new ArrayList<CheckCLDR.CheckStatus>();
            this.checkCldr.check(path, fullPath, value, new CheckCLDR.Options(this.options), result2);
            return result2;
        }

        @Override
        public ErrorChecker.Status getErrorStatus(String path, String value, StringBuilder statusMessage) {
            return this.getErrorStatus(path, value, statusMessage, null);
        }

        @Override
        public ErrorChecker.Status getErrorStatus(String path, String value, StringBuilder statusMessage, EnumSet<CheckCLDR.CheckStatus.Subtype> outputSubtypes) {
            ErrorChecker.Status result0 = ErrorChecker.Status.ok;
            StringBuilder errorMessage = new StringBuilder();
            String fullPath = this.cldrFile.getFullXPath(path);
            this.checkCldr.check(path, fullPath, value, new CheckCLDR.Options(this.options), this.result);
            for (CheckCLDR.CheckStatus checkStatus : this.result) {
                CheckCLDR cause = checkStatus.getCause();
                if (cause instanceof CheckCoverage || cause instanceof CheckNew) continue;
                CheckCLDR.CheckStatus.Type statusType = checkStatus.getType();
                if (statusType.equals((Object)CheckCLDR.CheckStatus.errorType)) {
                    if (result0 == ErrorChecker.Status.warning) {
                        errorMessage.setLength(0);
                        if (outputSubtypes != null) {
                            outputSubtypes.clear();
                        }
                    }
                    result0 = ErrorChecker.Status.error;
                    if (outputSubtypes != null) {
                        outputSubtypes.add(checkStatus.getSubtype());
                    }
                    VettingViewer.appendToMessage(checkStatus.getMessage(), checkStatus.getSubtype(), errorMessage);
                    continue;
                }
                if (result0 == ErrorChecker.Status.error || !statusType.equals((Object)CheckCLDR.CheckStatus.warningType)) continue;
                result0 = ErrorChecker.Status.warning;
                if (outputSubtypes != null) {
                    outputSubtypes.add(checkStatus.getSubtype());
                }
                VettingViewer.appendToMessage(checkStatus.getMessage(), checkStatus.getSubtype(), errorMessage);
            }
            if (result0 != ErrorChecker.Status.ok) {
                VettingViewer.appendToMessage(errorMessage, statusMessage);
            }
            return result0;
        }
    }

    public static class NoErrorStatus
    implements ErrorChecker {
        @Override
        public ErrorChecker.Status initErrorStatus(CLDRFile cldrFile) {
            return ErrorChecker.Status.ok;
        }

        @Override
        public List<CheckCLDR.CheckStatus> getErrorCheckStatus(String path, String value) {
            return Collections.emptyList();
        }

        @Override
        public ErrorChecker.Status getErrorStatus(String path, String value, StringBuilder statusMessage) {
            return ErrorChecker.Status.ok;
        }

        @Override
        public ErrorChecker.Status getErrorStatus(String path, String value, StringBuilder statusMessage, EnumSet<CheckCLDR.CheckStatus.Subtype> outputSubtypes) {
            return ErrorChecker.Status.ok;
        }
    }

    public static interface ErrorChecker {
        public Status initErrorStatus(CLDRFile var1);

        public List<CheckCLDR.CheckStatus> getErrorCheckStatus(String var1, String var2);

        public Status getErrorStatus(String var1, String var2, StringBuilder var3);

        public Status getErrorStatus(String var1, String var2, StringBuilder var3, EnumSet<CheckCLDR.CheckStatus.Subtype> var4);

        public static enum Status {
            ok,
            error,
            warning;

        }
    }

    public static interface UsersChoice<T> {
        public String getWinningValueForUsersOrganization(CLDRFile var1, String var2, T var3);

        public VoteStatus getStatusForUsersOrganization(CLDRFile var1, String var2, T var3);
    }

    public static enum VoteStatus {
        ok_novotes,
        ok,
        provisionalOrWorse,
        losing,
        disputed;

    }

    public static enum Choice {
        error('E', "Error", "The Survey Tool detected an error in the winning value.", 1),
        weLost('L', "Losing", "The value that your organization chose (overall) is either not the winning value, or doesn\u2019t have enough votes to be approved. This might be due to a dispute between members of your organization.", 2),
        notApproved('P', "Provisional", "There are not enough votes for this item to be approved (and used).", 3),
        hasDispute('D', "Disputed", "Different organizations are choosing different values. Please review to approve or reach consensus.", 4),
        warning('W', "Warning", "The Survey Tool detected a warning about the winning value.", 5),
        englishChanged('U', "English Changed", "The English value has changed in CLDR, but the corresponding value for your language has not. Check if any changes are needed in your language.", 6),
        changedOldValue('C', "Changed", "The winning value was altered from the baseline value. (Informational)", 7),
        missingCoverage('M', "Missing", "Your current coverage level requires the item to be present. (During the vetting phase, this is informational: you can\u2019t add new values.)", 8);

        public final char abbreviation;
        public final String buttonLabel;
        public final String description;
        public final int order;

        private Choice(char abbreviation, String buttonLabel, String description, int order) {
            this.abbreviation = abbreviation;
            this.buttonLabel = TransliteratorUtilities.toHTML.transform(buttonLabel);
            this.description = TransliteratorUtilities.toHTML.transform(description);
            this.order = order;
        }

        public static <T extends Appendable> T appendDisplay(Set<Choice> choices, String htmlMessage, T target) {
            try {
                boolean first = true;
                for (Choice item : choices) {
                    if (first) {
                        first = false;
                    } else {
                        target.append(", ");
                    }
                    item.appendDisplay(htmlMessage, target);
                }
                return target;
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }

        private <T extends Appendable> void appendDisplay(String htmlMessage, T target) throws IOException {
            target.append("<span title='").append(this.description);
            if (!htmlMessage.isEmpty()) {
                target.append(": ").append(htmlMessage);
            }
            target.append("'>").append(this.buttonLabel).append("*</span>");
        }

        public static Choice fromString(String i) {
            try {
                return Choice.valueOf(i);
            }
            catch (NullPointerException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (i.isEmpty()) {
                    throw e;
                }
                int cp = i.codePointAt(0);
                for (Choice choice : Choice.values()) {
                    if (cp != choice.abbreviation) continue;
                    return choice;
                }
                throw e;
            }
        }

        public static Appendable appendRowStyles(Set<Choice> choices, Appendable target) {
            try {
                target.append("hide");
                for (Choice item : choices) {
                    target.append(' ').append("vv").append(Character.toLowerCase(item.abbreviation));
                }
                return target;
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }
    }
}

