/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.unicode.cldr.api.CldrData;
import org.unicode.cldr.api.CldrDataType;
import org.unicode.cldr.api.CldrDraftStatus;
import org.unicode.cldr.api.CldrFileDataSource;
import org.unicode.cldr.api.CldrPath;
import org.unicode.cldr.api.CldrValue;
import org.unicode.cldr.api.InMemoryData;
import org.unicode.cldr.api.LocaleIds;
import org.unicode.cldr.api.XmlDataSource;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SimpleFactory;

public abstract class CldrDataSupplier {
    private static final CldrData NO_DATA = new CldrData(){

        @Override
        public void accept(CldrData.PathOrder order, CldrData.ValueVisitor visitor) {
        }

        @Override
        public void accept(CldrData.PathOrder order, CldrData.PrefixVisitor visitor) {
        }

        @Override
        public CldrValue get(CldrPath path) {
            return null;
        }
    };

    public static String getCldrVersionString() {
        return "41";
    }

    public static CldrDataSupplier forCldrFilesIn(Path cldrRootDir) {
        ImmutableSet<String> rootDirs = ImmutableSet.of("common");
        return new FileBasedDataSupplier(CldrDataSupplier.createCldrDirectoryMap(cldrRootDir, rootDirs), CldrDraftStatus.UNCONFIRMED);
    }

    public static CldrData forCldrFiles(CldrDataType type, CldrDraftStatus draftStatus, Set<Path> xmlFiles) {
        return new XmlDataSource(type, ImmutableSet.copyOf(xmlFiles), draftStatus);
    }

    private static Multimap<CldrDataType, Path> createCldrDirectoryMap(Path cldrRootDir, Set<String> rootDirs) {
        LinkedHashMultimap<CldrDataType, Path> multimap = LinkedHashMultimap.create();
        for (CldrDataType type : CldrDataType.values()) {
            type.getSourceDirectories().flatMap(d -> rootDirs.stream().map(r -> cldrRootDir.resolve((String)r).resolve((Path)d))).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(p -> multimap.put((Object)type, p));
        }
        return multimap;
    }

    public static CldrData forValues(Iterable<CldrValue> values) {
        return new InMemoryData(values);
    }

    public abstract CldrDataSupplier withDraftStatusAtLeast(CldrDraftStatus var1);

    public abstract CldrData getDataForLocale(String var1, CldrResolution var2);

    public abstract Set<String> getAvailableLocaleIds();

    public abstract CldrData getDataForType(CldrDataType var1);

    private static final class FileBasedDataSupplier
    extends CldrDataSupplier {
        private final ImmutableSetMultimap<CldrDataType, Path> directoryMap;
        private final CldrDraftStatus draftStatus;
        private Factory factory = null;
        private static final Predicate<Path> IS_XML_FILE = p -> Files.isRegularFile(p, new LinkOption[0]) && p.getFileName().toString().endsWith(".xml");

        private FileBasedDataSupplier(Multimap<CldrDataType, Path> directoryMap, CldrDraftStatus draftStatus) {
            this.directoryMap = ImmutableSetMultimap.copyOf(directoryMap);
            this.draftStatus = Preconditions.checkNotNull(draftStatus);
        }

        private synchronized Factory getFactory() {
            if (this.factory == null) {
                File[] dirArray = (File[])this.getDirectoriesForType(CldrDataType.LDML).map(Path::toFile).toArray(File[]::new);
                Preconditions.checkArgument(dirArray.length > 0, "no LDML directories exist: %s", (Object)this.directoryMap.get((Object)CldrDataType.LDML));
                this.factory = SimpleFactory.make(dirArray, ".*", this.draftStatus.getRawStatus());
            }
            return this.factory;
        }

        @Override
        public CldrDataSupplier withDraftStatusAtLeast(CldrDraftStatus draftStatus) {
            return new FileBasedDataSupplier(this.directoryMap, draftStatus);
        }

        @Override
        public CldrData getDataForLocale(String localeId, CldrResolution resolution) {
            LocaleIds.checkCldrLocaleId(localeId);
            Factory factory = this.getFactory();
            if (factory.getAvailable().contains(localeId)) {
                return new CldrFileDataSource(factory.make(localeId, resolution == CldrResolution.RESOLVED));
            }
            return NO_DATA;
        }

        @Override
        public Set<String> getAvailableLocaleIds() {
            return this.getFactory().getAvailable();
        }

        @Override
        public CldrData getDataForType(CldrDataType type) {
            ImmutableSet<Path> xmlFiles = this.listXmlFilesForType(type);
            if (!xmlFiles.isEmpty()) {
                return new XmlDataSource(type, xmlFiles, this.draftStatus);
            }
            return NO_DATA;
        }

        private Stream<Path> getDirectoriesForType(CldrDataType type) {
            return this.directoryMap.get((Object)type).stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
        }

        private ImmutableSet<Path> listXmlFilesForType(CldrDataType type) {
            ImmutableSet<Path> xmlFiles = this.getDirectoriesForType(type).flatMap(FileBasedDataSupplier::listXmlFiles).collect(ImmutableSet.toImmutableSet());
            Preconditions.checkArgument(!xmlFiles.isEmpty(), "no XML files exist within directories: %s", (Object)this.directoryMap.get((Object)type));
            return xmlFiles;
        }

        private static Stream<Path> listXmlFiles(Path dir) {
            try {
                return Files.walk(dir, new FileVisitOption[0]).filter(IS_XML_FILE);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static enum CldrResolution {
        RESOLVED,
        UNRESOLVED;

    }
}

