/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import org.unicode.cldr.draft.keyboard.CharacterMap;
import org.unicode.cldr.draft.keyboard.IsoLayoutPosition;
import org.unicode.cldr.draft.keyboard.ModifierKeyCombinationSet;

public final class KeyMap
implements Comparable<KeyMap> {
    private final ModifierKeyCombinationSet modifierKeyCombinationSet;
    private final ImmutableSortedMap<IsoLayoutPosition, CharacterMap> isoLayoutToCharacterMap;

    private KeyMap(ModifierKeyCombinationSet modifierKeyCombinationSet, ImmutableSortedMap<IsoLayoutPosition, CharacterMap> isoLayoutToCharacterMap) {
        this.modifierKeyCombinationSet = Preconditions.checkNotNull(modifierKeyCombinationSet);
        this.isoLayoutToCharacterMap = Preconditions.checkNotNull(isoLayoutToCharacterMap);
    }

    public static KeyMap of(ModifierKeyCombinationSet modifierKeyCombinationSet, ImmutableSet<CharacterMap> characterMaps) {
        return new KeyMap(modifierKeyCombinationSet, ImmutableSortedMap.copyOf(Maps.uniqueIndex(characterMaps, CharacterMap.isoLayoutPositionFunction())));
    }

    public ModifierKeyCombinationSet modifierKeyCombinationSet() {
        return this.modifierKeyCombinationSet;
    }

    public ImmutableSortedMap<IsoLayoutPosition, CharacterMap> isoLayoutToCharacterMap() {
        return this.isoLayoutToCharacterMap;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("modifierKeyCombinationSet", this.modifierKeyCombinationSet).add("isoLayoutToCharacterMap", this.isoLayoutToCharacterMap).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof KeyMap) {
            KeyMap other = (KeyMap)o;
            return this.modifierKeyCombinationSet.equals(other.modifierKeyCombinationSet) && this.isoLayoutToCharacterMap.equals(other.isoLayoutToCharacterMap);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.modifierKeyCombinationSet, this.isoLayoutToCharacterMap);
    }

    @Override
    public int compareTo(KeyMap o) {
        return this.modifierKeyCombinationSet.compareTo(o.modifierKeyCombinationSet);
    }
}

