/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Iterator;
import java.util.Set;
import org.unicode.cldr.draft.keyboard.ModifierKeyCombination;
import org.unicode.cldr.draft.keyboard.ModifierKeySimplifier;

public final class ModifierKeyCombinationSet
implements Comparable<ModifierKeyCombinationSet> {
    private final ImmutableSortedSet<ModifierKeyCombination> combinations;
    private static final Joiner SPACE_JOINER = Joiner.on(" ");

    private ModifierKeyCombinationSet(ImmutableSortedSet<ModifierKeyCombination> combinations) {
        this.combinations = Preconditions.checkNotNull(combinations);
    }

    public static ModifierKeyCombinationSet of(Set<ModifierKeyCombination> combinations) {
        ImmutableSet<ModifierKeyCombination> simplifiedSet = ModifierKeySimplifier.simplifySet(combinations);
        return new ModifierKeyCombinationSet(ImmutableSortedSet.copyOf(simplifiedSet));
    }

    public static ModifierKeyCombinationSet combine(Iterable<ModifierKeyCombinationSet> sets) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ModifierKeyCombinationSet combinationSet : sets) {
            builder.addAll(combinationSet.combinations);
        }
        return ModifierKeyCombinationSet.of((Set<ModifierKeyCombination>)((Object)builder.build()));
    }

    public ImmutableSortedSet<ModifierKeyCombination> combinations() {
        return this.combinations;
    }

    public boolean isBase() {
        for (ModifierKeyCombination combination : this.combinations) {
            if (!combination.isBase()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return SPACE_JOINER.join(this.combinations);
    }

    @Override
    public int compareTo(ModifierKeyCombinationSet o) {
        Iterator iterator1 = this.combinations.iterator();
        Iterator iterator2 = o.combinations.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            ModifierKeyCombination combination2;
            ModifierKeyCombination combination1 = (ModifierKeyCombination)iterator1.next();
            if (combination1.compareTo(combination2 = (ModifierKeyCombination)iterator2.next()) < 0) {
                return -1;
            }
            if (combination1.compareTo(combination2) <= 0) continue;
            return 1;
        }
        return this.combinations.size() - o.combinations.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ModifierKeyCombinationSet) {
            ModifierKeyCombinationSet other = (ModifierKeyCombinationSet)o;
            return this.combinations.equals(other.combinations);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.combinations);
    }
}

