/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard.test;

import com.google.common.collect.ImmutableSet;
import com.ibm.icu.dev.test.TestFmwk;
import org.unicode.cldr.draft.keyboard.ModifierKey;
import org.unicode.cldr.draft.keyboard.ModifierKeyCombination;

public class ModifierKeyCombinationTest
extends TestFmwk {
    public void testOfOnKeysForSimpleCombination() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT));
        ImmutableSet<ModifierKey> onKeys = ImmutableSet.of(ModifierKey.SHIFT);
        this.assertEquals("", onKeys, combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.OPTION, ModifierKey.ALT, ModifierKey.COMMAND, ModifierKey.CAPSLOCK);
        this.assertEquals("", offKeys, combination.offKeys());
        this.assertEquals("", "shift", combination.toString());
    }

    public void testOfOnKeysForComplexCombination() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.CONTROL, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK));
        ImmutableSet<ModifierKey> onKeys = ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK, ModifierKey.CONTROL);
        this.assertEquals("", onKeys, combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.ALT_LEFT, ModifierKey.OPTION, ModifierKey.COMMAND);
        this.assertEquals("", offKeys, combination.offKeys());
        this.assertEquals("", "ctrl+altR+caps+shift", combination.toString());
    }

    public void testOfOnKeysForComplexCombinationWithVariant() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.SHIFT_RIGHT, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK));
        ImmutableSet<ModifierKey> onKeys = ImmutableSet.of(ModifierKey.SHIFT_RIGHT, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK);
        this.assertEquals("", onKeys, combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.ALT_LEFT, ModifierKey.OPTION, ModifierKey.COMMAND);
        this.assertEquals("", offKeys, combination.offKeys());
        this.assertEquals("", "altR+caps+shiftR+shiftL?", combination.toString());
    }

    public void testOfOnAndDontCareKeysForSimpleCombination() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.COMMAND), ImmutableSet.of(ModifierKey.OPTION_LEFT));
        ImmutableSet<ModifierKey> onKeys = ImmutableSet.of(ModifierKey.COMMAND);
        this.assertEquals("", onKeys, combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.ALT, ModifierKey.CONTROL, ModifierKey.OPTION_RIGHT, ModifierKey.SHIFT, ModifierKey.CAPSLOCK, new ModifierKey[0]);
        this.assertEquals("", offKeys, combination.offKeys());
        this.assertEquals("", "cmd+optL?", combination.toString());
    }

    public void testOfOnAndDontCareKeys_complex() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.SHIFT, ModifierKey.CAPSLOCK), ImmutableSet.of(ModifierKey.ALT, ModifierKey.COMMAND));
        ImmutableSet<ModifierKey> onKeys = ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.SHIFT, ModifierKey.CAPSLOCK);
        this.assertEquals("", onKeys, combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.OPTION);
        this.assertEquals("", offKeys, combination.offKeys());
        this.assertEquals("", "ctrl+caps+shift+cmd?+alt?", combination.toString());
    }

    public void testOfOnAndDontCareKeysForComplexCombinationWithVariant() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.SHIFT, ModifierKey.CAPSLOCK), ImmutableSet.of(ModifierKey.ALT, ModifierKey.ALT_RIGHT, ModifierKey.COMMAND));
        ImmutableSet<ModifierKey> onKeys = ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.SHIFT, ModifierKey.CAPSLOCK);
        this.assertEquals("", onKeys, combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.OPTION, ModifierKey.ALT_LEFT);
        this.assertEquals("", offKeys, combination.offKeys());
        this.assertEquals("", "ctrl+caps+shift+cmd?+altR?", combination.toString());
    }

    public void testOfOnAndDontCareKeys_empty() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(), ImmutableSet.of());
        this.assertEquals("", ImmutableSet.of(), combination.onKeys());
        ImmutableSet<ModifierKey> offKeys = ImmutableSet.of(ModifierKey.OPTION, ModifierKey.SHIFT, ModifierKey.CONTROL, ModifierKey.ALT, ModifierKey.CAPSLOCK, ModifierKey.COMMAND, new ModifierKey[0]);
        this.assertEquals("", offKeys, combination.offKeys());
        this.assertEquals("", "", combination.toString());
    }

    public void testEqualsTrue() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK));
        this.assertTrue("", combination1.equals(combination2));
        this.assertTrue("", combination1.hashCode() == combination2.hashCode());
    }

    public void testEqualsWithDontCareTrue() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK), ImmutableSet.of(ModifierKey.COMMAND));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK), ImmutableSet.of(ModifierKey.COMMAND));
        this.assertTrue("", combination1.equals(combination2));
        this.assertTrue("", combination1.hashCode() == combination2.hashCode());
    }

    public void testEqualsFalse() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.ALT_RIGHT));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.COMMAND));
        this.assertFalse("", combination1.equals(combination2));
        this.assertTrue("", combination1.hashCode() != combination2.hashCode());
    }

    public void testEqualsWithDontCareFalse() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.SHIFT), ImmutableSet.of(ModifierKey.ALT_RIGHT));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.COMMAND));
        this.assertFalse("", combination1.equals(combination2));
        this.assertTrue("", combination1.hashCode() != combination2.hashCode());
    }

    public void testCompareToForOnKeys() {
        ModifierKeyCombination combination2;
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.CAPSLOCK));
        this.assertTrue("", combination1.compareTo(combination2 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.OPTION))) < 0);
    }

    public void testCompareToForCloseOnKeys() {
        ModifierKeyCombination combination2;
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK));
        this.assertTrue("", combination1.compareTo(combination2 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK))) < 0);
    }

    public void testCompareToForComplexOnKeys() {
        ModifierKeyCombination combination2;
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.CONTROL_LEFT, ModifierKey.OPTION));
        this.assertTrue("", combination1.compareTo(combination2 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.SHIFT, ModifierKey.OPTION))) < 0);
    }

    public void testCompareToForLeftAndRightVariants() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.CONTROL_LEFT));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.CONTROL_RIGHT));
        ModifierKeyCombination combination3 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.CONTROL));
        this.assertTrue("", combination1.compareTo(combination2) > 0);
        this.assertTrue("", combination1.compareTo(combination3) < 0);
        this.assertTrue("", combination2.compareTo(combination3) < 0);
    }

    public void testCompareToForEqualCombinations() {
        ModifierKeyCombination combination2;
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK));
        this.assertTrue("", combination1.compareTo(combination2 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK))) == 0);
    }

    public void testCompareToWithDontCares() {
        ModifierKeyCombination combination2;
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.OPTION), ImmutableSet.of(ModifierKey.CONTROL));
        this.assertTrue("", combination1.compareTo(combination2 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.OPTION), ImmutableSet.of(ModifierKey.COMMAND))) < 0);
    }

    public void testCompareToWithCloseDontCares() {
        ModifierKeyCombination combination2;
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.ALT_RIGHT), ImmutableSet.of(ModifierKey.CAPSLOCK));
        this.assertTrue("", combination1.compareTo(combination2 = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.ALT_RIGHT))) > 0);
    }

    public void testCompareToWithComplexDontCares() {
        ModifierKeyCombination combination2;
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.ALT_RIGHT), ImmutableSet.of(ModifierKey.CONTROL_LEFT, ModifierKey.OPTION));
        this.assertTrue("", combination1.compareTo(combination2 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.ALT_RIGHT), ImmutableSet.of(ModifierKey.CONTROL, ModifierKey.SHIFT, ModifierKey.OPTION))) < 0);
    }

    public void testCompareToWithLeftRightVariantDontCares() {
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.SHIFT), ImmutableSet.of(ModifierKey.CONTROL_LEFT));
        ModifierKeyCombination combination2 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.SHIFT), ImmutableSet.of(ModifierKey.CONTROL_RIGHT));
        ModifierKeyCombination combination3 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.SHIFT), ImmutableSet.of(ModifierKey.CONTROL));
        this.assertTrue("", combination1.compareTo(combination2) > 0);
        this.assertTrue("", combination1.compareTo(combination3) < 0);
        this.assertTrue("", combination2.compareTo(combination3) < 0);
    }

    public void testCompareToWithEqualDontCares() {
        ModifierKeyCombination combination2;
        ModifierKeyCombination combination1 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.COMMAND), ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK));
        this.assertTrue("", combination1.compareTo(combination2 = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(ModifierKey.COMMAND), ImmutableSet.of(ModifierKey.SHIFT, ModifierKey.ALT_RIGHT, ModifierKey.CAPSLOCK))) == 0);
    }

    public void testIsBaseCombinationTrue() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.of(), ImmutableSet.of(ModifierKey.COMMAND, ModifierKey.ALT_LEFT, ModifierKey.CONTROL));
        this.assertTrue("", combination.isBase());
    }

    public void testIsBaseCombinationFalse() {
        ModifierKeyCombination combination = ModifierKeyCombination.ofOnKeys(ImmutableSet.of(ModifierKey.SHIFT));
        this.assertFalse("", combination.isBase());
    }
}

