/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.json;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.TreeSet;
import org.unicode.cldr.json.CldrNode;
import org.unicode.cldr.json.LdmlConvertRules;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.XPathParts;
import org.unicode.cldr.util.ZoneParser;

public class CldrItem
implements Comparable<CldrItem> {
    private static boolean DEBUG = false;
    private String fullPath;
    private String path;
    private String untransformedFullPath;
    private String untransformedPath;
    private String value;

    private static String[] splitPathToSegments(String path) {
        if (path.startsWith("//")) {
            path = path.substring(2);
        }
        int start = 0;
        ArrayList<String> segments = new ArrayList<String>();
        boolean inBracket = false;
        boolean inBracketQuote = false;
        for (int pos = start; pos < path.length(); ++pos) {
            char ch = path.charAt(pos);
            if (inBracketQuote) {
                if (ch != '\"') continue;
                inBracketQuote = false;
                continue;
            }
            if (inBracket) {
                if (ch == ']') {
                    inBracket = false;
                    continue;
                }
                if (ch != '\"') continue;
                inBracketQuote = true;
                continue;
            }
            if (ch == '[') {
                inBracket = true;
                continue;
            }
            if (ch != '/') continue;
            segments.add(path.substring(start, pos));
            start = pos + 1;
        }
        segments.add(path.substring(start, path.length()));
        return segments.toArray(new String[segments.size()]);
    }

    protected String getUntransformedPath() {
        return this.untransformedPath;
    }

    public String toString() {
        return "[CldrItem " + this.getUntransformedPath() + "]";
    }

    CldrItem(String path, String fullPath, String untransformedPath, String untransformedFullPath, String value) {
        if (DEBUG) {
            System.out.println("---");
            System.out.println("    PATH => " + path);
            System.out.println("FULLPATH => " + fullPath);
            System.out.println("   VALUE => " + value);
            System.out.println("---");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("empty path with " + fullPath + "|" + untransformedPath + "|" + untransformedFullPath + " = " + value);
        }
        this.path = path;
        this.fullPath = fullPath;
        this.untransformedPath = untransformedPath;
        this.untransformedFullPath = untransformedFullPath;
        this.value = value == null ? "" : value;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public ArrayList<CldrNode> getNodesInPath() throws ParseException {
        String[] pathSegments = CldrItem.splitPathToSegments(this.path);
        String[] fullPathSegments = CldrItem.splitPathToSegments(this.fullPath);
        assert (pathSegments.length == fullPathSegments.length);
        ArrayList<CldrNode> nodesInPath = new ArrayList<CldrNode>();
        String parent = "";
        for (int i = 0; i < pathSegments.length; ++i) {
            CldrNode node = CldrNode.createNode(parent, pathSegments[i], fullPathSegments[i], this);
            String nodeName = node.getName();
            if (node.isTimezoneType()) {
                nodesInPath.add(CldrNode.createNode(parent, node.getName(), node.getName(), this));
                String typeValue = node.getDistinguishingAttributes().get("type");
                typeValue = typeValue.replaceAll("Asia:Taipei", "Asia/Taipei");
                String[] segments = typeValue.split("/");
                for (int j = 0; j < segments.length; ++j) {
                    CldrNode newNode = CldrNode.createNode(parent, node.getName(), node.getName(), this);
                    if (j == segments.length - 1) {
                        newNode.getDistinguishingAttributes().putAll(node.getDistinguishingAttributes());
                        newNode.getDistinguishingAttributes().remove("type");
                    }
                    newNode.getDistinguishingAttributes().put("type", segments[j]);
                    nodesInPath.add(newNode);
                }
            } else {
                nodesInPath.add(node);
            }
            parent = nodeName;
        }
        return nodesInPath;
    }

    public void setPath(String path) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("empty path");
        }
        this.path = path;
    }

    public CldrItem[] split() {
        XPathParts xpp = XPathParts.getFrozenInstance(this.path);
        XPathParts fullxpp = XPathParts.getFrozenInstance(this.fullPath);
        XPathParts untransformedxpp = XPathParts.getFrozenInstance(this.untransformedPath);
        XPathParts untransformedfullxpp = XPathParts.getFrozenInstance(this.untransformedFullPath);
        for (LdmlConvertRules.SplittableAttributeSpec s2 : LdmlConvertRules.getSplittableAttrs()) {
            if (!fullxpp.containsElement(s2.element) || !fullxpp.containsAttribute(s2.attribute)) continue;
            ArrayList<CldrItem> list = new ArrayList<CldrItem>();
            String wordString = fullxpp.findAttributeValue(s2.element, s2.attribute);
            String[] words = wordString.trim().split("\\s+");
            TreeSet<String> hadWords = new TreeSet<String>();
            for (String word : words) {
                if (!hadWords.add(word)) {
                    System.err.println("Warning: Duplicate attribute " + word + " in " + this.fullPath);
                    continue;
                }
                XPathParts newxpp = xpp.cloneAsThawed();
                XPathParts newfullxpp = fullxpp.cloneAsThawed();
                XPathParts untransformednewxpp = untransformedxpp.cloneAsThawed();
                XPathParts untransformednewfullxpp = untransformedfullxpp.cloneAsThawed();
                newxpp.setAttribute(s2.element, s2.attribute, word);
                newfullxpp.setAttribute(s2.element, s2.attribute, word);
                untransformednewxpp.setAttribute(s2.element, s2.attribute, word);
                untransformednewfullxpp.setAttribute(s2.element, s2.attribute, word);
                if (s2.attrAsValueAfterSplit != null) {
                    String newValue = fullxpp.findAttributeValue(s2.element, s2.attrAsValueAfterSplit);
                    newxpp.removeAttribute(s2.element, s2.attrAsValueAfterSplit);
                    newxpp.removeAttribute(s2.element, s2.attribute);
                    newxpp.addElement(word);
                    newfullxpp.removeAttribute(s2.element, s2.attrAsValueAfterSplit);
                    newfullxpp.removeAttribute(s2.element, s2.attribute);
                    newfullxpp.addElement(word);
                    list.add(new CldrItem(newxpp.toString(), newfullxpp.toString(), untransformednewxpp.toString(), untransformednewfullxpp.toString(), newValue));
                    continue;
                }
                list.add(new CldrItem(newxpp.toString(), newfullxpp.toString(), untransformednewxpp.toString(), untransformednewfullxpp.toString(), this.value));
            }
            return list.toArray(new CldrItem[list.size()]);
        }
        return null;
    }

    public boolean needsSort() {
        for (String item : LdmlConvertRules.ELEMENT_NEED_SORT) {
            XPathParts xpp = XPathParts.getFrozenInstance(this.path);
            if (!xpp.containsElement(item)) continue;
            return true;
        }
        return false;
    }

    public boolean isAliasItem() {
        return this.path.endsWith("/alias");
    }

    @Override
    public int compareTo(CldrItem otherItem) {
        XPathParts thisxpp = XPathParts.getFrozenInstance(this.untransformedPath);
        XPathParts otherxpp = XPathParts.getFrozenInstance(otherItem.untransformedFullPath);
        if (thisxpp.containsElement("zone") && otherxpp.containsElement("zone")) {
            String[] otherZonePieces;
            String[] thisZonePieces = thisxpp.findAttributeValue("zone", "type").split("/");
            int result = ZoneParser.regionalCompare.compare(thisZonePieces[0], (otherZonePieces = otherxpp.findAttributeValue("zone", "type").split("/"))[0]);
            if (result != 0) {
                return result;
            }
            result = thisZonePieces[1].compareTo(otherZonePieces[1]);
            if (result != 0) {
                return result;
            }
        }
        DtdType fileDtdType = thisxpp.getElement(0).equals("supplementalData") ? DtdType.supplementalData : DtdType.ldml;
        int result = 0;
        if (thisxpp.getElement(1).equals("weekData") && thisxpp.getElement(2).equals(otherxpp.getElement(2))) {
            String thisTerritory = thisxpp.findFirstAttributeValue("territories");
            String otherTerritory = otherxpp.findFirstAttributeValue("territories");
            if (thisTerritory != null && otherTerritory != null) {
                result = thisTerritory.compareTo(otherTerritory);
            }
            if (result != 0) {
                return result;
            }
        }
        if (thisxpp.getElement(1).equals("measurementData") && thisxpp.getElement(2).equals(otherxpp.getElement(2))) {
            String otherCategory;
            String thisCategory = thisxpp.findAttributeValue("measurementSystem", "category");
            if (thisCategory == null) {
                thisCategory = "";
            }
            if ((otherCategory = otherxpp.findAttributeValue("measurementSystem", "category")) == null) {
                otherCategory = "";
            }
            if (!thisCategory.equals(otherCategory)) {
                result = thisCategory.compareTo(otherCategory);
                return result;
            }
            String thisTerritory = thisxpp.findFirstAttributeValue("territories");
            String otherTerritory = otherxpp.findFirstAttributeValue("territories");
            if (thisTerritory != null && otherTerritory != null) {
                result = thisTerritory.compareTo(otherTerritory);
            }
            if (result != 0) {
                return result;
            }
        }
        result = DtdData.getInstance(fileDtdType).getDtdComparator(null).compare(this.untransformedPath, otherItem.untransformedPath);
        return result;
    }

    void adjustRbnfPath() {
        String fullpath;
        XPathParts xpp = XPathParts.getFrozenInstance(this.getFullPath());
        String sub = xpp.findAttributeValue("rbnfrule", "value");
        if (sub != null) {
            xpp = xpp.cloneAsThawed();
            String value = this.getValue();
            xpp.removeAttribute(-1, "value");
            xpp.addAttribute(sub, value);
            this.setFullPath(xpp.toString());
            this.setValue("");
        }
        if ((fullpath = this.getFullPath()).contains("/ruleset")) {
            int ruleStartIndex = fullpath.indexOf("/ruleset[");
            String checkString = fullpath.substring(ruleStartIndex);
            int ruleEndIndex = 0;
            if (checkString.contains("/")) {
                ruleEndIndex = fullpath.indexOf("/", ruleStartIndex + 1);
            }
            if (ruleEndIndex > ruleStartIndex) {
                String oldRulePath = fullpath.substring(ruleStartIndex, ruleEndIndex);
                String newRulePath = oldRulePath;
                if (newRulePath.contains("@type")) {
                    int typeIndexStart = newRulePath.indexOf("\"", newRulePath.indexOf("@type"));
                    int typeIndexEnd = newRulePath.indexOf("\"", typeIndexStart + 1);
                    String type = newRulePath.substring(typeIndexStart + 1, typeIndexEnd);
                    String newType = "";
                    newType = newRulePath.contains("@access") ? "%%" + type : "%" + type;
                    newRulePath = newRulePath.replace(type, newType);
                    this.setPath(this.getPath().replace(type, newType));
                }
                fullpath = fullpath.replace(oldRulePath, newRulePath);
                this.setFullPath(fullpath);
            }
        }
    }
}

