/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.StandardCodes;

public final class SubmissionLocales {
    public static final Set<String> CLDR_LOCALES = StandardCodes.make().getLocaleToLevel(Organization.cldr).keySet();
    public static Set<String> HIGH_LEVEL_LOCALES = ImmutableSet.of("chr", "gd", "fo", "kok", "pcm", "ha", new String[]{"hsb", "dsb", "yue_Hans", "to"});
    public static final Set<String> CLDR_OR_HIGH_LEVEL_LOCALES = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(CLDR_LOCALES)).addAll(HIGH_LEVEL_LOCALES)).build();
    public static final Set<String> LOCALES_FOR_LIMITED;
    public static Set<String> ALLOW_ALL_PATHS;
    public static Set<String> LOCALES_ALLOWED_IN_LIMITED;
    public static final Pattern PATHS_ALLOWED_IN_LIMITED;
    private static final boolean DEBUG_REGEX = false;

    public static boolean allowEvenIfLimited(String localeString, String path, boolean isError, boolean isMissing) {
        if (ALLOW_ALL_PATHS.contains(localeString) || isError) {
            return true;
        }
        boolean bl = false;
        if (!LOCALES_ALLOWED_IN_LIMITED.contains(localeString)) {
            return false;
        }
        bl = false;
        if (isMissing) {
            return true;
        }
        bl = false;
        if (SubmissionLocales.pathAllowedInLimitedSubmission(path)) {
            return true;
        }
        bl = false;
        return false;
    }

    public static boolean pathAllowedInLimitedSubmission(String path) {
        if (PATHS_ALLOWED_IN_LIMITED == null) {
            return false;
        }
        Matcher matcher = PATHS_ALLOWED_IN_LIMITED.matcher(path);
        boolean result = matcher.lookingAt();
        return result;
    }

    static {
        HashSet<String> temp = new HashSet<String>(CLDR_OR_HIGH_LEVEL_LOCALES);
        temp.retainAll(GrammarInfo.getGrammarLocales());
        LOCALES_FOR_LIMITED = ImmutableSortedSet.copyOf(temp);
        ALLOW_ALL_PATHS = ImmutableSet.of("brx", "ks", "ks_Deva", "rhg");
        LOCALES_ALLOWED_IN_LIMITED = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(LOCALES_FOR_LIMITED)).addAll(ALLOW_ALL_PATHS)).build();
        PATHS_ALLOWED_IN_LIMITED = Pattern.compile("//ldml/units/unitLength\\[@type=\"long\"]");
    }
}

