/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.Collator;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.StandardCodes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestCLDRTests
extends TestFmwk {
    static final boolean DEBUG = false;
    ULocale uLocale = ULocale.ENGLISH;
    Locale oLocale = Locale.ENGLISH;
    PrintWriter log;
    SAXParser SAX;
    TreeMap<String, MutableInteger> results = new TreeMap();
    Set<String> languagesToTest;
    Map<String, Handler> RegisteredHandlers = new HashMap<String, Handler>();
    static TimeZone utc = TimeZone.getTimeZone("GMT");
    static DateFormat iso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    static int[] DateFormatValues = new int[]{-1, 3, 2, 1, 0};
    static String[] DateFormatNames = new String[]{"none", "short", "medium", "long", "full"};
    static String[] NumberNames = new String[]{"standard", "integer", "decimal", "percent", "scientific"};
    DefaultHandler DEFAULT_HANDLER;

    public static void main(String[] args) throws Exception {
        double deltaTime = System.currentTimeMillis();
        TestCLDRTests me = new TestCLDRTests();
        me.run(args);
        me.closeLog();
        deltaTime = (double)System.currentTimeMillis() - deltaTime;
        System.out.println("Seconds: " + deltaTime / 1000.0);
    }

    private void closeLog() {
        this.log.close();
    }

    TestCLDRTests() throws IOException {
        iso.setTimeZone(utc);
        this.addHandler("collation", new Handler(){

            @Override
            public void handleResult(String value) {
                Collator col = Collator.getInstance(TestCLDRTests.this.uLocale.toLocale());
                boolean showedAttributes = false;
                String lastLine = "";
                int pos = 0;
                while (pos < value.length()) {
                    int comp;
                    String line;
                    int nextPos = value.indexOf(10, pos);
                    if (nextPos < 0) {
                        nextPos = value.length();
                    }
                    if ((line = value.substring(pos, nextPos).trim()).length() != 0 && (comp = col.compare(lastLine, line)) > 0) {
                        this.myerrln("<" + lastLine + "> should be leq <" + line + ">" + (showedAttributes ? "" : " " + this.attributes));
                        showedAttributes = true;
                    }
                    pos = nextPos + 1;
                    lastLine = line;
                }
            }
        });
        this.addHandler("number", new Handler(){

            @Override
            public void handleResult(String result) {
                NumberFormat nf = null;
                double v = Double.NaN;
                for (String attributeName : this.settings.keySet()) {
                    String temp;
                    String attributeValue = (String)this.settings.get(attributeName);
                    if (attributeName.equals("input")) {
                        v = Double.parseDouble(attributeValue);
                        continue;
                    }
                    int index = this.lookupValue(attributeValue, NumberNames);
                    switch (index) {
                        case 0: {
                            nf = NumberFormat.getInstance(TestCLDRTests.this.oLocale);
                            break;
                        }
                        case 1: {
                            nf = NumberFormat.getIntegerInstance(TestCLDRTests.this.oLocale);
                            break;
                        }
                        case 2: {
                            nf = NumberFormat.getNumberInstance(TestCLDRTests.this.oLocale);
                            break;
                        }
                        case 3: {
                            nf = NumberFormat.getPercentInstance(TestCLDRTests.this.oLocale);
                            break;
                        }
                        case 4: {
                            nf = NumberFormat.getScientificInstance(TestCLDRTests.this.oLocale);
                        }
                    }
                    if ((temp = nf.format(v).trim()).equals(result = result.trim())) continue;
                    this.myerrln("Mismatched Number: CLDR: <" + result + ">, Host: <" + temp + ">");
                }
            }
        });
        this.addHandler("date", new Handler(){

            @Override
            public void handleResult(String result) throws ParseException {
                int dateFormat = 2;
                int timeFormat = 2;
                Date date = new Date();
                for (String attributeName : this.settings.keySet()) {
                    String attributeValue = (String)this.settings.get(attributeName);
                    if (attributeName.equals("input")) {
                        date = iso.parse(attributeValue);
                        continue;
                    }
                    int index = this.lookupValue(attributeValue, DateFormatNames);
                    int value = DateFormatValues[index];
                    if (attributeName.equals("dateType")) {
                        dateFormat = value;
                        continue;
                    }
                    timeFormat = value;
                }
                DateFormat dt = dateFormat == -1 ? DateFormat.getTimeInstance(timeFormat, TestCLDRTests.this.oLocale) : (timeFormat == -1 ? DateFormat.getDateInstance(dateFormat, TestCLDRTests.this.oLocale) : DateFormat.getDateTimeInstance(dateFormat, timeFormat, TestCLDRTests.this.oLocale));
                dt.setTimeZone(utc);
                String temp = dt.format(date).trim();
                result = result.trim();
                if (!temp.equals(result)) {
                    this.myerrln("Mismatched DateTime: CLDR: <" + result + ">, Host: <" + temp + ">");
                }
            }
        });
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            this.SAX = factory.newSAXParser();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't start");
        }
        this.DEFAULT_HANDLER = new DefaultHandler(){
            static final boolean DEBUG = false;
            StringBuffer lastChars = new StringBuffer();
            Handler handler;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                try {
                    if (!qName.equals("cldrTest")) {
                        if (qName.equals("result")) {
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                this.handler.set(attributes.getQName(i), attributes.getValue(i));
                            }
                        } else {
                            this.handler = TestCLDRTests.this.getHandler(qName);
                            this.handler.attributes = TestCLDRTests.show(attributes);
                        }
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                try {
                    if (qName.equals("result")) {
                        this.handler.checkResult(this.lastChars.toString());
                    } else if (qName.length() != 0) {
                        // empty if block
                    }
                    this.lastChars.setLength(0);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                try {
                    String value = new String(ch, start, length);
                    this.lastChars.append(value);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }

            @Override
            public void notationDecl(String name, String publicId, String systemId) throws SAXException {
                System.out.println("notationDecl: " + name + ", " + publicId + ", " + systemId);
            }

            @Override
            public void processingInstruction(String target, String data) throws SAXException {
                System.out.println("processingInstruction: " + target + ", " + data);
            }

            @Override
            public void skippedEntity(String name) throws SAXException {
                System.out.println("skippedEntity: " + name);
            }

            @Override
            public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
                System.out.println("unparsedEntityDecl: " + name + ", " + publicId + ", " + systemId + ", " + notationName);
            }
        };
        this.log = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "collationTestLog.txt");
        this.log.write(65279);
    }

    public void TestAll() throws Exception {
        Map<String, Level> onlyLocales = StandardCodes.make().getLocaleToLevel(Organization.cldr);
        Set<String> locales = onlyLocales.keySet();
        this.languagesToTest = (Set)new CldrUtility.CollectionTransform(){
            LocaleIDParser lip = new LocaleIDParser();

            @Override
            public Object transform(Object source) {
                return this.lip.set(source.toString()).getLanguageScript();
            }
        }.transform(locales, new TreeSet());
        this.languagesToTest.remove("th");
        File[] list = new File(CLDRPaths.TEST_DIR).listFiles();
        for (int i = 0; i < list.length; ++i) {
            String name = list[i].getName();
            if (!name.endsWith(".xml")) continue;
            this.doSingle(name.substring(0, name.length() - 4));
        }
        this.logln("Testing done");
        if (this.results.size() != 0) {
            this.errln("Cummulative errors: " + this.results);
        }
    }

    public void doSingle(String localeName) throws Exception {
        if (!this.languagesToTest.contains(localeName)) {
            this.logln("Skipping " + localeName);
            return;
        }
        this.logln("Testing " + localeName);
        this.uLocale = new ULocale(localeName);
        this.oLocale = this.uLocale.toLocale();
        File f = new File(CLDRPaths.TEST_DIR, localeName + ".xml");
        this.SAX.parse(f, this.DEFAULT_HANDLER);
    }

    private static String show(Attributes attributes) {
        String result = "{";
        for (int i = 0; i < attributes.getLength(); ++i) {
            result = result + attributes.getQName(i) + "=\"" + attributes.getValue(i) + ";";
        }
        return result + "}";
    }

    public Handler getHandler(String name) {
        Handler result = this.RegisteredHandlers.get(name);
        if (result == null) {
            System.out.println("Unexpected test type: " + name);
        }
        return result;
    }

    public void addHandler(String name, Handler handler) {
        handler.setName(name);
        this.RegisteredHandlers.put(name, handler);
    }

    static class MutableInteger {
        int value;

        MutableInteger() {
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public abstract class Handler {
        Map<String, String> settings = new TreeMap<String, String>();
        String name;
        String attributes;

        void setName(String name) {
            this.name = name;
        }

        void set(String attributeName, String attributeValue) {
            this.settings.put(attributeName, attributeValue);
        }

        void checkResult(String value) {
            try {
                this.handleResult(value);
            }
            catch (Exception e) {
                this.myerrln("Exception with result: <" + value + ">");
                e.printStackTrace();
            }
        }

        public void myerrln(String message) {
            MutableInteger foo;
            String temp = TestCLDRTests.this.uLocale + "\t" + message + "\t[" + this.name;
            for (String attributeName : this.settings.keySet()) {
                String attributeValue = this.settings.get(attributeName);
                temp = temp + " " + attributeName + "=<" + attributeValue + ">";
            }
            temp = temp + "]";
            TestCLDRTests.this.errln(temp);
            if (TestCLDRTests.this.log != null) {
                TestCLDRTests.this.log.println(temp);
            }
            if ((foo = TestCLDRTests.this.results.get(TestCLDRTests.this.uLocale.getDisplayName())) == null) {
                foo = new MutableInteger();
                TestCLDRTests.this.results.put(TestCLDRTests.this.uLocale.getDisplayName(), foo);
            }
            ++foo.value;
        }

        int lookupValue(Object x, Object[] list) {
            for (int i = 0; i < list.length; ++i) {
                if (!x.equals(list[i])) continue;
                return i;
            }
            this.myerrln("Unknown String: " + x);
            return -1;
        }

        abstract void handleResult(String var1) throws Exception;
    }
}

