/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.util.VersionInfo;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.FileCopier;

public class GenerateScriptMetadata {
    public static void main(String[] args) throws IOException {
        PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.COMMON_DIRECTORY + "/properties", "scriptMetadata.txt");
        FileCopier.copy(GenerateScriptMetadata.class, "GenerateScriptMetadata.txt", out);
        TreeSet<Row.R3<Integer, String, ScriptMetadata.Info>> sorted = new TreeSet<Row.R3<Integer, String, ScriptMetadata.Info>>();
        for (String script : ScriptMetadata.getScripts()) {
            ScriptMetadata.Info info = ScriptMetadata.getInfo(script);
            Row.R3<Integer, String, ScriptMetadata.Info> r = Row.of(info.rank, script, info);
            sorted.add(r);
        }
        if (ScriptMetadata.errors.size() > 0) {
            System.err.println(Joiner.on("\n\t").join(ScriptMetadata.errors));
        }
        VersionInfo currentUnicodeVersion = UCharacter.getUnicodeVersion();
        for (Row.R3 r3 : sorted) {
            String script = (String)r3.get1();
            ScriptMetadata.Info i = (ScriptMetadata.Info)r3.get2();
            String comment = i.age.compareTo(currentUnicodeVersion) > 0 ? "  # provisional data for future Unicode " + i.age.getVersionString(2, 2) + " script" : "";
            out.println(script + "; " + i.rank + "; " + Utility.hex(i.sampleChar) + "; " + i.originCountry + "; " + i.density + "; " + (Object)((Object)i.idUsage) + "; " + (Object)((Object)i.rtl) + "; " + (Object)((Object)i.lbLetters) + "; " + (Object)((Object)i.shapingReq) + "; " + (Object)((Object)i.ime) + "; " + (Object)((Object)i.hasCase) + comment);
        }
        out.println();
        out.println("# EOF");
        out.close();
    }
}

