/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Splitter;
import com.ibm.icu.text.UnicodeSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Timer;
import org.unicode.cldr.util.XPathParts;

public class ListUnits {
    private static final UnicodeSet BIDI_CONTROL = new UnicodeSet("[:bidi_control:]").freeze();
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    private static final SupplementalDataInfo SUPP = CONFIG.getSupplementalDataInfo();
    private static final Task TASK = Task.listSimpleUnits;

    public static void main(String[] args) {
        Factory cldrFactory = CONFIG.getCldrFactory();
        Set<String> defaultContent = SUPP.getDefaultContentLocales();
        HashSet<String> seen = new HashSet<String>();
        LinkedHashSet<String> items = new LinkedHashSet<String>();
        items.add("root");
        items.add("en");
        items.addAll(cldrFactory.getAvailableLanguages());
        HashMap<String, Data> rootMap = new HashMap<String, Data>();
        HashMap enMap = new HashMap();
        Timer timer = new Timer();
        int count = 0;
        Splitter SEMI = Splitter.on(";").trimResults();
        Matcher currencyMatcher = PatternCache.get("([^0#]*).*[0#]([^0#]*)").matcher("");
        block9: for (String locale : items) {
            Type type = Type.fromString(locale);
            if (type == Type.root || type == Type.en || defaultContent.contains(locale)) continue;
            CLDRFile cldrFile = cldrFactory.make(locale, true);
            switch (TASK) {
                case showDecimals: {
                    String compactPathPrefix = "//ldml/numbers/decimalFormats[@numberSystem=\"latn\"]/decimalFormatLength[@type=\"short\"]";
                    String currencyPattern = cldrFile.getStringValue("//ldml/numbers/currencyFormats[@numberSystem=\"latn\"]/currencyFormatLength/currencyFormat[@type=\"standard\"]/pattern[@type=\"standard\"]");
                    String firstPart = SEMI.split(currencyPattern).iterator().next();
                    if (!currencyMatcher.reset(firstPart).matches()) {
                        throw new IllegalArgumentException("bad matcher");
                    }
                    String prefix = currencyMatcher.group(1);
                    String suffix = currencyMatcher.group(2);
                    System.out.println("\n#" + locale + "\t\u00ab" + prefix + "\u00bb\t\u00ab" + suffix + "\u00bb\t\u00ab" + currencyPattern + "\u00bb");
                    TreeMap<String, String> data = new TreeMap<String, String>();
                    for (String string : cldrFile.fullIterable()) {
                        if (!string.startsWith(compactPathPrefix)) continue;
                        String value = cldrFile.getStringValue(string);
                        String mod = string.replace("decimal", "currency") + "[@draft=\"provisional\"]";
                        data.put(mod, "locale=" + locale + " ; action=add ; new_value=" + prefix + value + suffix + " ; new_path=" + mod);
                    }
                    for (Map.Entry entry : data.entrySet()) {
                        System.out.println((String)entry.getValue());
                    }
                    data.clear();
                    break;
                }
                case listSimpleUnits: 
                case listUnits: {
                    Set<String> units = ListUnits.getUnits(cldrFile, TASK, type == Type.root ? rootMap : (type == Type.en ? enMap : null));
                    if (type == Type.en) {
                        TreeSet missing = new TreeSet(seen);
                        missing.removeAll(units);
                        for (String unit : missing) {
                            Data data = (Data)rootMap.get(unit);
                            if (data == null) continue;
                            System.out.println(data);
                        }
                    }
                    Splitter HYPHEN = Splitter.on('-');
                    String oldBase = "";
                    for (String unit : units) {
                        if (seen.contains(unit)) continue;
                        switch (TASK) {
                            case listSimpleUnits: {
                                String base = HYPHEN.split(unit).iterator().next();
                                if (!base.equals(oldBase)) {
                                    oldBase = base;
                                    System.out.println();
                                } else {
                                    System.out.print(' ');
                                }
                                System.out.print(unit);
                                break;
                            }
                            case listUnits: {
                                System.out.println("\t" + unit.replace("/", "\t").replaceFirst("-", "\t") + "\t" + locale);
                            }
                        }
                        seen.add(unit);
                    }
                    continue block9;
                }
                case getDigits: {
                    ListUnits.getDigits(cldrFile);
                }
            }
        }
        System.out.println();
        System.out.println("#Done: " + count + ", " + timer);
    }

    static void getDigits(CLDRFile cldrFile) {
        System.out.println(cldrFile.getLocaleID());
        String numberSystem = cldrFile.getWinningValue("//ldml/numbers/defaultNumberingSystem");
        HashSet<String> seen = new HashSet<String>();
        seen.add(numberSystem);
        Pair<UnicodeSet, UnicodeSet> main = ListUnits.getCharacters(cldrFile, numberSystem);
        System.out.println("\tdefault: " + numberSystem + ", " + main.getFirst().toPattern(false) + ", " + main.getSecond().toPattern(false));
        Iterator<String> it = cldrFile.iterator("//ldml/numbers/otherNumberingSystems");
        while (it.hasNext()) {
            String path = it.next();
            String otherNumberingSystem = cldrFile.getWinningValue(path);
            if (seen.contains(otherNumberingSystem)) continue;
            seen.add(otherNumberingSystem);
            main = ListUnits.getCharacters(cldrFile, otherNumberingSystem);
            System.out.println("\tother: " + otherNumberingSystem + ", " + main.getFirst().toPattern(false) + "\t" + main.getSecond().toPattern(false));
        }
    }

    private static Pair<UnicodeSet, UnicodeSet> getCharacters(CLDRFile cldrFileToCheck, String numberSystem) {
        String digitString = SUPP.getDigits(numberSystem);
        UnicodeSet digits = digitString == null ? UnicodeSet.EMPTY : new UnicodeSet().addAll(digitString);
        UnicodeSet punctuation = new UnicodeSet();
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        ListUnits.add(cldrFileToCheck, "decimal", numberSystem, punctuation, errors);
        ListUnits.add(cldrFileToCheck, "group", numberSystem, punctuation, errors);
        ListUnits.add(cldrFileToCheck, "minusSign", numberSystem, punctuation, errors);
        ListUnits.add(cldrFileToCheck, "list", numberSystem, punctuation, errors);
        ListUnits.add(cldrFileToCheck, "percentSign", numberSystem, punctuation, errors);
        ListUnits.add(cldrFileToCheck, "perMille", numberSystem, punctuation, errors);
        ListUnits.add(cldrFileToCheck, "plusSign", numberSystem, punctuation, errors);
        if (!errors.isEmpty() && digitString != null) {
            System.out.println("Missing: " + numberSystem + "\t" + errors);
        }
        punctuation.removeAll(BIDI_CONTROL);
        return Pair.of(digits, punctuation);
    }

    private static void add(CLDRFile cldrFileToCheck, String subtype, String numberSystem, UnicodeSet punctuation, Set<String> errors) {
        String result = ListUnits.getSymbolString(cldrFileToCheck, subtype, numberSystem);
        if (result == null) {
            errors.add(subtype);
        } else {
            punctuation.addAll(result);
        }
    }

    private static String getSymbolString(CLDRFile cldrFile, String key, String numsys) {
        return cldrFile.getWinningValue("//ldml/numbers/symbols[@numberSystem=\"" + numsys + "\"]/" + key);
    }

    private static Set<String> getUnits(CLDRFile cldrFile, Task task, Map<String, Data> extra) {
        TreeSet<String> seen = new TreeSet<String>();
        for (String path : cldrFile) {
            XPathParts parts;
            String unit;
            if (!path.contains("/unit") || (unit = (parts = XPathParts.getFrozenInstance(path)).findAttributeValue("unit", "type")) == null) continue;
            String key = unit;
            if (task == Task.listUnits) {
                String length = parts.findAttributeValue("unitLength", "type");
                String per = "perUnitPattern".equals(parts.getElement(-1)) ? "per" : "";
                key = unit + "/" + length + "/" + per;
            }
            seen.add(key);
            if (extra == null || path.endsWith("/alias")) continue;
            extra.put(key, new Data(path, cldrFile.getStringValue(path)));
        }
        return seen;
    }

    static final class Data {
        final String path;
        final String value;

        public Data(String path2, String stringValue) {
            this.path = path2;
            this.value = stringValue;
        }

        public String toString() {
            return "locale=en ; action=add ; new_path=" + this.path + " ; new_value=" + this.value;
        }
    }

    static enum Type {
        root,
        en,
        other;


        static Type fromString(String type) {
            return type.equals("en") ? en : (type.equals("root") ? root : other);
        }
    }

    private static enum Task {
        listUnits,
        listSimpleUnits,
        showDecimals,
        getDigits;

    }
}

